/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.web.LocaleCharsetInfo;
import org.netbeans.modules.j2ee.sun.dd.api.web.LocaleCharsetMap;
import org.netbeans.modules.j2ee.sun.share.CharsetMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.StorageBeanFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.LocaleCharsetMapEntryPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.LocaleMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppRootCustomizer;
import org.openide.util.NbBundle;

public class WebAppLocalePanel
extends JPanel
implements TableModelListener {
    private final ResourceBundle webappBundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");
    private final ResourceBundle commonBundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private WebAppRootCustomizer masterPanel;
    private String defaultCharset;
    private String formHintField;
    private DefaultComboBoxModel defaultCharsetCbxModel;
    private DefaultComboBoxModel defaultLocaleCbxModel;
    private GenericTableModel localeCharsetMapModel;
    private GenericTablePanel localeCharsetMapPanel;
    private PropertyChangeListener charsetChangeListener;
    private ButtonGroup jBtnGrpCharsetAliases;
    private JComboBox jCbxDefaultCharset;
    private JComboBox jCbxDefaultLocale;
    private JLabel jLabel1;
    private JLabel jLblDefaultCharset;
    private JLabel jLblDefaultLocale;
    private JLabel jLblFormHintField;
    private JLabel jLblParameterEncoding;
    private JPanel jPnlLocaleSettings;
    private JPanel jPnlParameterEncoding;
    private JTextField jTxtFormHintField;
    private ActionListener defaultLocaleActionListener;
    private ActionListener defaultCharsetActionListener;
    static GenericTableModel.ParentPropertyFactory localeCharsetMapFactory = new GenericTableModel.ParentPropertyFactory(){

        public CommonDDBean newParentProperty(ASDDVersion aSDDVersion) {
            return StorageBeanFactory.getStorageBeanFactory(aSDDVersion).createLocaleCharsetMap();
        }
    };

    public WebAppLocalePanel(WebAppRootCustomizer webAppRootCustomizer) {
        this.masterPanel = webAppRootCustomizer;
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jBtnGrpCharsetAliases = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jPnlLocaleSettings = new JPanel();
        this.jLblDefaultLocale = new JLabel();
        this.jCbxDefaultLocale = new JComboBox();
        this.jLblParameterEncoding = new JLabel();
        this.jPnlParameterEncoding = new JPanel();
        this.jLblDefaultCharset = new JLabel();
        this.jCbxDefaultCharset = new JComboBox();
        this.jLblFormHintField = new JLabel();
        this.jTxtFormHintField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(this.webappBundle.getString("ACSN_WebAppLocaleTab"));
        this.getAccessibleContext().setAccessibleDescription(this.webappBundle.getString("ACSD_WebAppLocaleTab"));
        this.jLabel1.setText(this.webappBundle.getString("LBL_LocaleInfoPanelDescription"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jPnlLocaleSettings.setLayout(new GridBagLayout());
        this.jLblDefaultLocale.setLabelFor(this.jCbxDefaultLocale);
        this.jLblDefaultLocale.setText(this.webappBundle.getString("LBL_DefaultLocaleMapping_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPnlLocaleSettings.add((Component)this.jLblDefaultLocale, gridBagConstraints);
        this.jCbxDefaultLocale.setPrototypeDisplayValue("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPnlLocaleSettings.add((Component)this.jCbxDefaultLocale, gridBagConstraints);
        this.jCbxDefaultLocale.getAccessibleContext().setAccessibleName(this.webappBundle.getString("ACSN_DefaultLocaleMapping"));
        this.jCbxDefaultLocale.getAccessibleContext().setAccessibleDescription(this.webappBundle.getString("ACSD_DefaultLocaleMapping"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jPnlLocaleSettings, gridBagConstraints);
        this.jLblParameterEncoding.setLabelFor(this.jPnlParameterEncoding);
        this.jLblParameterEncoding.setText(this.webappBundle.getString("LBL_ParameterEncoding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblParameterEncoding, gridBagConstraints);
        this.jPnlParameterEncoding.setLayout(new GridBagLayout());
        this.jPnlParameterEncoding.setBorder(BorderFactory.createEtchedBorder());
        this.jLblDefaultCharset.setLabelFor(this.jCbxDefaultCharset);
        this.jLblDefaultCharset.setText(this.webappBundle.getString("LBL_DefaultCharset_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPnlParameterEncoding.add((Component)this.jLblDefaultCharset, gridBagConstraints);
        this.jCbxDefaultCharset.setPrototypeDisplayValue("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.jPnlParameterEncoding.add((Component)this.jCbxDefaultCharset, gridBagConstraints);
        this.jCbxDefaultCharset.getAccessibleContext().setAccessibleName(this.webappBundle.getString("ACSN_DefaultCharset"));
        this.jCbxDefaultCharset.getAccessibleContext().setAccessibleDescription(this.webappBundle.getString("ACSD_DefaultCharset"));
        this.jLblFormHintField.setLabelFor(this.jTxtFormHintField);
        this.jLblFormHintField.setText(this.webappBundle.getString("LBL_FormHintField_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.jPnlParameterEncoding.add((Component)this.jLblFormHintField, gridBagConstraints);
        this.jTxtFormHintField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                WebAppLocalePanel.this.jTxtFormHintFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.jPnlParameterEncoding.add((Component)this.jTxtFormHintField, gridBagConstraints);
        this.jTxtFormHintField.getAccessibleContext().setAccessibleName(this.webappBundle.getString("ACSN_FormHintField"));
        this.jTxtFormHintField.getAccessibleContext().setAccessibleDescription(this.webappBundle.getString("ACSD_FormHintField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 5);
        this.add((Component)this.jPnlParameterEncoding, gridBagConstraints);
    }

    private void jTxtFormHintFieldKeyReleased(KeyEvent keyEvent) {
        WebAppRoot webAppRoot = this.masterPanel.getBean();
        if (webAppRoot != null) {
            LocaleCharsetInfo localeCharsetInfo = webAppRoot.getLocaleCharsetInfo();
            this.formHintField = this.jTxtFormHintField.getText();
            localeCharsetInfo.setParameterEncodingFormHintField(this.formHintField);
            localeCharsetInfo.setParameterEncoding(this.hasParameterEncoding());
            webAppRoot.setDirty();
            this.masterPanel.validateField("locale-charset-info/parameter-encoding/form-hint-field");
        }
    }

    private void jCbxDefaultCharsetActionPerformed(ActionEvent actionEvent) {
        WebAppRoot webAppRoot = this.masterPanel.getBean();
        if (webAppRoot != null) {
            LocaleCharsetInfo localeCharsetInfo = webAppRoot.getLocaleCharsetInfo();
            Object object = this.defaultCharsetCbxModel.getSelectedItem();
            if (object instanceof CharsetMapping) {
                this.defaultCharset = ((CharsetMapping)object).getAlias();
                localeCharsetInfo.setParameterEncodingDefaultCharset(this.defaultCharset);
            } else {
                this.defaultCharset = null;
                localeCharsetInfo.setParameterEncodingDefaultCharset(null);
            }
            localeCharsetInfo.setParameterEncoding(this.hasParameterEncoding());
            webAppRoot.setDirty();
        }
    }

    private void jCbxDefaultLocaleActionPerformed(ActionEvent actionEvent) {
        WebAppRoot webAppRoot = this.masterPanel.getBean();
        if (webAppRoot != null) {
            LocaleCharsetInfo localeCharsetInfo = webAppRoot.getLocaleCharsetInfo();
            Object object = this.defaultLocaleCbxModel.getSelectedItem();
            if (object instanceof LocaleMapping) {
                localeCharsetInfo.setDefaultLocale(((LocaleMapping)object).getLocale().toString());
            } else {
                localeCharsetInfo.setDefaultLocale(null);
            }
            webAppRoot.setDirty();
        }
    }

    private void initUserComponents() {
        Object object;
        this.defaultLocaleActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebAppLocalePanel.this.jCbxDefaultLocaleActionPerformed(actionEvent);
            }
        };
        this.defaultCharsetCbxModel = new DefaultComboBoxModel();
        this.defaultCharsetCbxModel.addElement("");
        SortedMap sortedMap = CharsetMapping.getSortedAvailableCharsetMappings();
        Object object2 = sortedMap.entrySet().iterator();
        while (object2.hasNext()) {
            object = (CharsetMapping)object2.next().getValue();
            this.defaultCharsetCbxModel.addElement(object);
        }
        this.jCbxDefaultCharset.setModel(this.defaultCharsetCbxModel);
        this.defaultCharsetActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebAppLocalePanel.this.jCbxDefaultCharsetActionPerformed(actionEvent);
            }
        };
        object2 = new ArrayList(4);
        ((ArrayList)object2).add(new GenericTableModel.AttributeEntry("Locale", this.webappBundle.getString("LBL_Locale"), true));
        ((ArrayList)object2).add(new GenericTableModel.AttributeEntry("Charset", this.webappBundle.getString("LBL_CharacterSet"), true));
        ((ArrayList)object2).add(new GenericTableModel.AttributeEntry("Agent", this.webappBundle.getString("LBL_Agent")));
        ((ArrayList)object2).add(new GenericTableModel.ValueEntry("Description", this.webappBundle.getString("LBL_LocaleDescription")));
        this.localeCharsetMapModel = new LocaleCharsetTableModel((List)object2);
        this.localeCharsetMapPanel = new GenericTablePanel(this.localeCharsetMapModel, this.webappBundle, "LocaleCharsetMapping", LocaleCharsetMapEntryPanel.class, "AS_CFG_WebAppLocaleCharsetMapping");
        object = new GridBagConstraints();
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).insets = new Insets(0, 6, 0, 5);
        this.add((Component)this.localeCharsetMapPanel, object);
        this.charsetChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebAppLocalePanel.this.updateDefaultCharsetModel();
            }
        };
    }

    public void addListeners() {
        this.localeCharsetMapModel.addTableModelListener(this);
        this.jCbxDefaultLocale.addActionListener(this.defaultLocaleActionListener);
        this.jCbxDefaultCharset.addActionListener(this.defaultCharsetActionListener);
        CharsetMapping.addPropertyChangeListener(this.charsetChangeListener);
    }

    public void removeListeners() {
        this.localeCharsetMapModel.removeTableModelListener(this);
        this.jCbxDefaultLocale.removeActionListener(this.defaultLocaleActionListener);
        this.jCbxDefaultCharset.removeActionListener(this.defaultCharsetActionListener);
        CharsetMapping.removePropertyChangeListener(this.charsetChangeListener);
    }

    public void initFields(WebAppRoot webAppRoot) {
        LocaleCharsetInfo localeCharsetInfo = webAppRoot.getLocaleCharsetInfo();
        if (this.enableDefaultFields(localeCharsetInfo.sizeLocaleCharsetMap() > 0)) {
            this.defaultLocaleCbxModel = this.getDefaultLocales(localeCharsetInfo);
            this.jCbxDefaultLocale.setModel(this.defaultLocaleCbxModel);
            this.defaultLocaleCbxModel.setSelectedItem(LocaleMapping.getLocaleMapping(localeCharsetInfo.getDefaultLocale()));
            if (localeCharsetInfo.isParameterEncoding()) {
                this.defaultCharset = localeCharsetInfo.getParameterEncodingDefaultCharset();
                this.formHintField = localeCharsetInfo.getParameterEncodingFormHintField();
                this.defaultCharsetCbxModel.setSelectedItem(CharsetMapping.getCharsetMapping(this.defaultCharset));
            } else {
                this.defaultCharset = null;
                this.formHintField = "";
                this.defaultCharsetCbxModel.setSelectedItem(this.defaultCharset);
            }
            this.jTxtFormHintField.setText(this.formHintField);
        } else {
            this.jCbxDefaultLocale.setSelectedItem(null);
            this.jCbxDefaultCharset.setSelectedItem(null);
            this.jTxtFormHintField.setText("");
        }
        this.localeCharsetMapPanel.setModel((CommonDDBean)localeCharsetInfo, webAppRoot.getAppServerVersion());
    }

    private boolean enableDefaultFields(boolean bl) {
        this.jLblDefaultLocale.setEnabled(bl);
        this.jCbxDefaultLocale.setEnabled(bl);
        this.jLblParameterEncoding.setEnabled(bl);
        this.jLblDefaultCharset.setEnabled(bl);
        this.jCbxDefaultCharset.setEnabled(bl);
        this.jLblFormHintField.setEnabled(bl);
        this.jTxtFormHintField.setEnabled(bl);
        this.jTxtFormHintField.setEditable(bl);
        return bl;
    }

    private boolean hasParameterEncoding() {
        return Utils.notEmpty(this.defaultCharset) || Utils.notEmpty(this.formHintField);
    }

    private DefaultComboBoxModel getDefaultLocales(LocaleCharsetInfo localeCharsetInfo) {
        DefaultComboBoxModel<LocaleMapping> defaultComboBoxModel = new DefaultComboBoxModel<LocaleMapping>();
        if (localeCharsetInfo.sizeLocaleCharsetMap() > 0) {
            LocaleCharsetMap[] localeCharsetMapArray = localeCharsetInfo.getLocaleCharsetMap();
            for (int i = 0; i < localeCharsetMapArray.length; ++i) {
                LocaleMapping localeMapping = LocaleMapping.getLocaleMapping(localeCharsetMapArray[i].getLocale());
                if (localeMapping == null) continue;
                defaultComboBoxModel.addElement(localeMapping);
            }
        }
        return defaultComboBoxModel;
    }

    private void updateDefaultLocale(LocaleCharsetInfo localeCharsetInfo) {
        int n = this.defaultLocaleCbxModel != null ? this.defaultLocaleCbxModel.getSize() : 0;
        this.defaultLocaleCbxModel = this.getDefaultLocales(localeCharsetInfo);
        this.jCbxDefaultLocale.setModel(this.defaultLocaleCbxModel);
        int n2 = this.defaultLocaleCbxModel.getSize();
        if (n == 0 && n2 > 0) {
            LocaleMapping localeMapping = (LocaleMapping)this.defaultLocaleCbxModel.getElementAt(0);
            localeCharsetInfo.setDefaultLocale(localeMapping.getLocale().toString());
            this.defaultLocaleCbxModel.setSelectedItem(localeMapping);
        } else {
            LocaleMapping localeMapping = LocaleMapping.getLocaleMapping(localeCharsetInfo.getDefaultLocale());
            if (this.defaultLocaleCbxModel.getIndexOf(localeMapping) >= 0) {
                localeCharsetInfo.setDefaultLocale(localeMapping.getLocale().toString());
                this.defaultLocaleCbxModel.setSelectedItem(localeMapping);
            } else {
                localeCharsetInfo.setDefaultLocale(null);
                this.defaultCharset = null;
                localeCharsetInfo.setParameterEncodingDefaultCharset(null);
                this.defaultCharsetCbxModel.setSelectedItem(null);
                this.formHintField = null;
                localeCharsetInfo.setParameterEncodingFormHintField(null);
                this.jTxtFormHintField.setText(null);
                this.masterPanel.validateField("locale-charset-info/parameter-encoding/form-hint-field");
            }
        }
        this.enableDefaultFields(localeCharsetInfo.sizeLocaleCharsetMap() > 0);
    }

    private void updateDefaultCharsetModel() {
        Object object = this.defaultCharsetCbxModel.getSelectedItem();
        CharsetMapping charsetMapping = object instanceof CharsetMapping ? (CharsetMapping)object : null;
        this.defaultCharsetCbxModel = new DefaultComboBoxModel();
        this.defaultCharsetCbxModel.addElement("");
        SortedMap sortedMap = CharsetMapping.getSortedAvailableCharsetMappings();
        Iterator iterator = sortedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            CharsetMapping charsetMapping2 = (CharsetMapping)iterator.next().getValue();
            this.defaultCharsetCbxModel.addElement(charsetMapping2);
        }
        this.jCbxDefaultCharset.setModel(this.defaultCharsetCbxModel);
        if (charsetMapping != null) {
            charsetMapping = CharsetMapping.getCharsetMapping(charsetMapping.getCharset());
        }
        this.defaultCharsetCbxModel.setSelectedItem(charsetMapping);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        WebAppRoot webAppRoot = this.masterPanel.getBean();
        if (webAppRoot != null) {
            if (tableModelEvent.getSource() == this.localeCharsetMapModel) {
                this.updateDefaultLocale(webAppRoot.getLocaleCharsetInfo());
            }
            webAppRoot.setDirty();
        }
    }

    private static class LocaleCharsetTableModel
    extends GenericTableModel {
        public LocaleCharsetTableModel(List list) {
            super("LocaleCharsetMap", localeCharsetMapFactory, list);
        }

        public boolean alreadyExists(Object[] objectArray) {
            boolean bl = false;
            List list = this.getChildren();
            for (LocaleCharsetMap localeCharsetMap : list) {
                if (!this.match((String)objectArray[0], localeCharsetMap.getLocale()) || !this.match((String)objectArray[1], localeCharsetMap.getCharset()) || !this.match((String)objectArray[2], localeCharsetMap.getAgent())) continue;
                bl = true;
                break;
            }
            return bl;
        }

        private final boolean match(String string, String string2) {
            boolean bl = false;
            if (string == string2) {
                bl = true;
            } else if (string != null && string2 != null && string.equals(string2)) {
                bl = true;
            }
            return bl;
        }

        public boolean alreadyExists(String string) {
            return false;
        }
    }
}

