/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.data;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.DynamicProperties;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyList;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.Validator;

public class PropertyListMapping
implements Comparable {
    public static final String WEBAPP_JSPCONFIG_PROPERTIES = "WebAppJspConfigProperties";
    public static final String WEBAPP_PROPERTIES = "WebAppProperties";
    public static final String WEBAPP_CLASSLOADER_PROPERTIES = "WebAppClassloaderProperties";
    public static final String CACHE_PROPERTIES = "CacheProperties";
    public static final String CACHE_DEFAULT_HELPER_PROPERTIES = "CacheDefaultHelperProperties";
    public static final String CACHE_HELPER_PROPERTIES = "CacheHelperProperties";
    public static final String CONFIG_MANAGER_PROPERTIES = "ConfigManagerProperties";
    public static final String CONFIG_STORE_PROPERTIES = "ConfigStoreProperties";
    public static final String CONFIG_SESSION_PROPERTIES = "ConfigSessionProperties";
    public static final String CONFIG_COOKIE_PROPERTIES = "ConfigCookieProperties";
    public static final String SERVICE_REF_CALL_PROPERTIES = "ServiceRefCallProperties";
    public static final String SERVICE_REF_STUB_PROPERTIES = "ServiceRefStubProperties";
    public static final String EJBJAR_CMP_PROPERTIES = "EjbJarCmpProperties";
    public static final String EJBJAR_CMP_SCHEMA_PROPERTIES = "EjbJarCmpSchemaProperties";
    private final PropertyList propList;
    private static final String PROPERTYDATA_FILENAME = "org/netbeans/modules/j2ee/sun/share/configbean/customizers/data/propertydata.xml";
    private static Map propertyLists;
    private static Map validatorList;

    private PropertyListMapping(PropertyList propertyList) {
        this.propList = propertyList;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof PropertyListMapping) {
            if (this == object) {
                bl = true;
            } else {
                PropertyListMapping propertyListMapping = (PropertyListMapping)object;
                PropertyList propertyList = propertyListMapping.getPropertyList();
                bl = this.propList.getPropertyName().equals(propertyList.getPropertyName());
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.propList.getPropertyName().hashCode();
    }

    public String toString() {
        return this.propList.getPropertyName();
    }

    public PropertyList getPropertyList() {
        return this.propList;
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object instanceof PropertyListMapping) {
            if (this == object) {
                n = 0;
            } else {
                PropertyListMapping propertyListMapping = (PropertyListMapping)object;
                PropertyList propertyList = propertyListMapping.getPropertyList();
                n = this.propList.getPropertyName().compareTo(propertyList.getPropertyName());
            }
        }
        return n;
    }

    public static PropertyList getPropertyList(String string) {
        return (PropertyList)propertyLists.get(string);
    }

    public static Pattern getValidator(String string) {
        return (Pattern)validatorList.get(string);
    }

    private static void loadPropertyLists() {
        propertyLists = new HashMap(37);
        validatorList = new HashMap(19);
        try {
            Object object;
            URL uRL = Utils.getResourceURL(PROPERTYDATA_FILENAME, PropertyListMapping.class);
            InputStream inputStream = uRL.openStream();
            DynamicProperties dynamicProperties = DynamicProperties.read(inputStream);
            for (Object object2 : dynamicProperties.fetchPropertyListList()) {
                object = ((PropertyList)object2).getPropertyName();
                propertyLists.put(object, object2);
            }
            for (Object object2 : dynamicProperties.fetchValidatorList()) {
                object = Pattern.compile(((Validator)object2).getValidatorPattern());
                validatorList.put(((Validator)object2).getValidatorName(), object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        PropertyListMapping.loadPropertyLists();
    }
}

