/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.ErrorMessageDB;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BaseCustomizer;

public class CustomizerErrorPanel
extends JPanel {
    private final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private ErrorClient errorClient;

    public CustomizerErrorPanel(ErrorClient errorClient) {
        this.errorClient = errorClient;
        this.initComponents();
        this.initUserComponents();
    }

    public GridBagConstraints getConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 11, 11);
        return gridBagConstraints;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(this.bundle.getString("ACSN_ErrorTextArea"));
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_ErrorTextArea"));
    }

    private void initUserComponents() {
    }

    public void showErrors(Base base) {
        Object object;
        Object[] objectArray;
        ArrayList arrayList = null;
        this.removeAll();
        ErrorMessageDB errorMessageDB = ErrorMessageDB.getMessageDB(base);
        if (errorMessageDB != null) {
            objectArray = this.errorClient.getGlobalPartition();
            ArrayList arrayList2 = errorMessageDB.getErrors((ValidationError.Partition)objectArray);
            Comparable comparable = this.errorClient.getPartition();
            object = errorMessageDB.getErrors((ValidationError.Partition)comparable);
            if (arrayList2 != null && object != null) {
                arrayList = new ArrayList(arrayList2);
                arrayList.addAll(object);
            } else {
                ArrayList arrayList3 = arrayList = arrayList2 != null ? arrayList2 : object;
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            objectArray = new Object[2];
            for (Comparable comparable : arrayList) {
                objectArray[0] = ((ValidationError)comparable).getFieldId();
                objectArray[1] = ((ValidationError)comparable).getMessage();
                object = MessageFormat.format(this.bundle.getString("MSG_ErrorDisplayFormat"), objectArray);
                JLabel jLabel = new JLabel();
                jLabel.setIcon(BaseCustomizer.errorMessageIcon);
                jLabel.setText((String)object);
                jLabel.getAccessibleContext().setAccessibleName(this.bundle.getString("ASCN_ErrorMessage"));
                jLabel.getAccessibleContext().setAccessibleDescription((String)object);
                jLabel.setForeground(this.errorClient.getErrorMessageForegroundColor());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                this.add((Component)jLabel, gridBagConstraints);
            }
        }
        if ((objectArray = this.getParent()) != null) {
            objectArray.validate();
        }
    }

    public static interface ErrorClient {
        public Color getErrorMessageForegroundColor();

        public ValidationError.Partition getPartition();

        public ValidationError.Partition getGlobalPartition();
    }
}

