/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;
import org.openide.cookies.OpenCookie;
import org.openide.util.NbBundle;

public class ChangeDocTypePanel
extends JPanel {
    protected final ResourceBundle commonBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private final JPanel customizerPanel;
    private final Base theBean;
    private final SunONEDeploymentConfiguration config;
    private ASDDVersion currentVersion;
    private DefaultComboBoxModel versionModel;
    private JComboBox jCbxAppServerVersion;
    private JLabel jLblAppServerVersion;
    private JLabel jLblDocType;
    private JScrollPane jScrollPane1;
    private JTextArea jTxtDocType;

    public ChangeDocTypePanel(JPanel jPanel, Base base) {
        this.customizerPanel = jPanel;
        this.theBean = base;
        this.config = this.theBean.getConfig();
        this.currentVersion = this.config.getAppServerVersion();
        this.initComponents();
        this.initFields();
    }

    public ASDDVersion getOriginalVersion() {
        return this.config.getAppServerVersion();
    }

    public ASDDVersion getCurrentVersion() {
        return this.currentVersion;
    }

    private void initComponents() {
        this.jLblAppServerVersion = new JLabel();
        this.jCbxAppServerVersion = new JComboBox();
        this.jLblDocType = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTxtDocType = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.jLblAppServerVersion.setLabelFor(this.jCbxAppServerVersion);
        this.jLblAppServerVersion.setText(this.commonBundle.getString("LBL_ServerVersion_1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.jLblAppServerVersion, gridBagConstraints);
        this.jCbxAppServerVersion.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ChangeDocTypePanel.this.jCbxAppServerVersionItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 11, 11);
        this.add((Component)this.jCbxAppServerVersion, gridBagConstraints);
        this.jCbxAppServerVersion.getAccessibleContext().setAccessibleName(this.commonBundle.getString("ACSN_ServerVersion"));
        this.jCbxAppServerVersion.getAccessibleContext().setAccessibleDescription(this.commonBundle.getString("ACSD_ServerVersion"));
        this.jLblDocType.setLabelFor(this.jTxtDocType);
        this.jLblDocType.setText(this.commonBundle.getString("LBL_DocTypeTag_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 12, 1, 5);
        this.add((Component)this.jLblDocType, gridBagConstraints);
        this.jLblDocType.getAccessibleContext().setAccessibleName(this.commonBundle.getString("ACSN_DocTypeTag"));
        this.jTxtDocType.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.jTxtDocType.setColumns(20);
        this.jTxtDocType.setEditable(false);
        this.jTxtDocType.setRows(3);
        this.jTxtDocType.setTabSize(4);
        this.jScrollPane1.setViewportView(this.jTxtDocType);
        this.jTxtDocType.getAccessibleContext().setAccessibleName(this.commonBundle.getString("ACSN_DocTypeTag"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void jCbxAppServerVersionItemStateChanged(ItemEvent itemEvent) {
        this.currentVersion = (ASDDVersion)this.versionModel.getSelectedItem();
        this.setDocTypeText(this.getDocType());
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void initFields() {
        this.versionModel = new DefaultComboBoxModel();
        ASDDVersion aSDDVersion = this.config.getMinASVersion();
        ASDDVersion aSDDVersion2 = this.config.getMaxASVersion();
        for (int i = 0; i < ASDDVersion.asDDVersions.length; ++i) {
            if (ASDDVersion.asDDVersions[i].compareTo((Object)aSDDVersion) < 0) continue;
            if (ASDDVersion.asDDVersions[i].compareTo((Object)aSDDVersion2) > 0) break;
            this.versionModel.addElement(ASDDVersion.asDDVersions[i]);
        }
        this.jCbxAppServerVersion.setModel(this.versionModel);
        this.jCbxAppServerVersion.setSelectedItem(this.currentVersion);
        this.setDocTypeText(this.getDocType());
    }

    private void setDocTypeText(String string) {
        this.jTxtDocType.setText(string);
        this.jTxtDocType.getAccessibleContext().setAccessibleDescription(string);
        this.jTxtDocType.setRows(Math.min(10, Math.max(3, this.countLines(string))));
    }

    private int countLines(String string) {
        int n = 1;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    private String getDocType() {
        Base base = this.theBean;
        while (base.getParent() != null) {
            base = base.getParent();
        }
        BaseRoot baseRoot = (BaseRoot)base;
        return baseRoot.generateDocType(this.currentVersion);
    }

    private Collection getErrors() {
        return Collections.EMPTY_SET;
    }

    private Collection getWarnings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ASDDVersion aSDDVersion = this.getCurrentVersion();
        ASDDVersion aSDDVersion2 = this.getOriginalVersion();
        if (this.hasUnsavedChanges()) {
            arrayList.add(this.commonBundle.getString("WARN_WillSaveChanges"));
        }
        if (aSDDVersion.compareTo((Object)aSDDVersion2) < 0) {
            arrayList.add(this.commonBundle.getString("WARN_PossibleDataLoss"));
        }
        return arrayList;
    }

    private boolean hasUnsavedChanges() {
        boolean bl = false;
        ConfigurationStorage configurationStorage = this.config.getStorage();
        if (configurationStorage != null) {
            ConfigDataObject configDataObject = configurationStorage.getPrimaryDataObject();
            bl = configDataObject != null && configDataObject.areModified();
        }
        return bl;
    }

    private boolean changeVersion(ASDDVersion aSDDVersion) {
        ConfigDataObject configDataObject = null;
        ConfigurationStorage configurationStorage = this.config.getStorage();
        if (configurationStorage != null) {
            configDataObject = configurationStorage.getPrimaryDataObject();
        }
        if (configDataObject == null) {
            return false;
        }
        if (!configDataObject.closeConfigEditors()) {
            return false;
        }
        this.config.setAppServerVersion(aSDDVersion);
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        final ConfigDataObject configDataObject2 = configDataObject;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OpenCookie openCookie = configDataObject2.getCookie(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                }
            }
        });
        return true;
    }

    public static void editASVersion(JPanel jPanel, Base base) {
        ChangeDocTypePanel changeDocTypePanel = new ChangeDocTypePanel(jPanel, base);
        changeDocTypePanel.displayDialog(jPanel, NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle").getString("TITLE_ChangeDocType"), "AS_CFG_ChangeDocTypePanelHelp");
    }

    private void displayDialog(JPanel jPanel, String string, String string2) {
        ASDDVersion aSDDVersion;
        ASDDVersion aSDDVersion2;
        BetterInputDialog betterInputDialog = new BetterInputDialog(jPanel, string, string2, this);
        int n = betterInputDialog.display();
        if (n == 1 && (aSDDVersion2 = this.getCurrentVersion()).compareTo((Object)(aSDDVersion = this.getOriginalVersion())) != 0) {
            this.changeVersion(aSDDVersion2);
        }
    }

    private static class BetterInputDialog
    extends InputDialog {
        private final ChangeDocTypePanel dialogPanel;
        private final String panelHelpId;

        public BetterInputDialog(JPanel jPanel, String string, String string2, ChangeDocTypePanel changeDocTypePanel) {
            super(jPanel, string, false, true);
            this.dialogPanel = changeDocTypePanel;
            this.panelHelpId = string2;
            this.dialogPanel.setPreferredSize(new Dimension(jPanel.getWidth() * 3 / 4, this.dialogPanel.getPreferredSize().height));
            this.getAccessibleContext().setAccessibleName(this.dialogPanel.getAccessibleContext().getAccessibleName());
            this.getAccessibleContext().setAccessibleDescription(this.dialogPanel.getAccessibleContext().getAccessibleDescription());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.getContentPane().add(changeDocTypePanel, gridBagConstraints, 0);
            this.addListeners();
            this.pack();
            this.setLocationInside(jPanel);
            this.handleErrorDisplay();
        }

        private void addListeners() {
            this.dialogPanel.addPropertyChangeListener("UserDataChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BetterInputDialog.this.handleErrorDisplay();
                }
            });
        }

        private void handleErrorDisplay() {
            this.setErrors(this.dialogPanel.getErrors(), this.dialogPanel.getWarnings());
        }

        protected String getHelpId() {
            return this.panelHelpId;
        }
    }
}

