/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;
import org.openide.ErrorManager;

public class EntityEjb
extends BaseEjb {
    private String isReadOnlyBean;
    private String refreshPeriodInSeconds;
    private String commitOption;
    public static final String FIELD_ENTITY_READONLY = "is-read-only-bean";
    public static final String FIELD_ENTITY_REFRESHPERIOD = "refresh-period-in-seconds";
    public static final String FIELD_ENTITY_COMMITOPTION = "commit-option";

    protected void init(DDBean dDBean, Base base) throws ConfigurationException {
        super.init(dDBean, base);
        this.addVetoableChangeListener(new VetoRefreshPeriodChange());
        this.addPropertyChangeListener(new KeepRefreshPeriodValid());
    }

    protected void updateValidationFieldList() {
        super.updateValidationFieldList();
        this.validationFieldList.add(FIELD_ENTITY_READONLY);
        this.validationFieldList.add(FIELD_ENTITY_REFRESHPERIOD);
        this.validationFieldList.add(FIELD_ENTITY_COMMITOPTION);
    }

    public boolean validateField(String string) {
        boolean bl = super.validateField(string);
        ArrayList<ValidationError> arrayList = new ArrayList<ValidationError>();
        String string2 = this.getAbsoluteXpath(string);
        if (string.equals(FIELD_ENTITY_READONLY)) {
            arrayList.add(this.executeValidator(ValidationError.PARTITION_EJB_GLOBAL, this.isReadOnlyBean, string2, this.bundle.getString("LBL_Is_Read_Only_Bean")));
        } else if (string.equals(FIELD_ENTITY_REFRESHPERIOD)) {
            arrayList.add(this.executeValidator(ValidationError.PARTITION_EJB_GLOBAL, this.refreshPeriodInSeconds, string2, this.bundle.getString("LBL_Refresh_Period_In_Seconds")));
        } else if (string.equals(FIELD_ENTITY_COMMITOPTION)) {
            arrayList.add(this.executeValidator(ValidationError.PARTITION_EJB_GLOBAL, this.commitOption, string2, this.bundle.getString("LBL_Commit_Option")));
        }
        boolean bl2 = true;
        for (ValidationError validationError : arrayList) {
            this.getMessageDB().updateError(validationError);
            if (!Utils.notEmpty(validationError.getMessage())) continue;
            bl2 = false;
        }
        return bl2 || bl;
    }

    Collection getSnippets() {
        ArrayList<EntityEjbSnippet> arrayList = new ArrayList<EntityEjbSnippet>();
        arrayList.add(new EntityEjbSnippet());
        return arrayList;
    }

    protected void loadEjbProperties(Ejb ejb) {
        super.loadEjbProperties(ejb);
        this.isReadOnlyBean = ejb.getIsReadOnlyBean();
        this.refreshPeriodInSeconds = ejb.getRefreshPeriodInSeconds();
        this.commitOption = ejb.getCommitOption();
    }

    protected void clearProperties() {
        super.clearProperties();
        this.isReadOnlyBean = null;
        this.refreshPeriodInSeconds = null;
        this.commitOption = null;
    }

    public void fireXpathEvent(XpathEvent xpathEvent) {
        super.fireXpathEvent(xpathEvent);
        DDBean dDBean = xpathEvent.getBean();
        String string = dDBean.getXpath();
        if ("/ejb-jar/enterprise-beans/entity/remote".equals(string)) {
            try {
                if (xpathEvent.isAddEvent()) {
                    this.setJndiName(this.getDefaultJndiName());
                } else if (xpathEvent.isRemoveEvent()) {
                    this.setJndiName(null);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
            }
        }
    }

    public String getIsReadOnlyBean() {
        return this.isReadOnlyBean;
    }

    public void setIsReadOnlyBean(String string) throws PropertyVetoException {
        String string2 = this.isReadOnlyBean;
        this.getVCS().fireVetoableChange("isReadOnlyBean", string2, string);
        this.isReadOnlyBean = string;
        this.getPCS().firePropertyChange("isReadOnlyBean", string2, string);
    }

    public String getRefreshPeriodInSeconds() {
        return this.refreshPeriodInSeconds;
    }

    public void setRefreshPeriodInSeconds(String string) throws PropertyVetoException {
        String string2 = this.refreshPeriodInSeconds;
        this.getVCS().fireVetoableChange("refreshPeriodInSeconds", string2, string);
        this.refreshPeriodInSeconds = string;
        this.getPCS().firePropertyChange("refreshPeriodInSeconds", string2, string);
    }

    public String getCommitOption() {
        return this.commitOption;
    }

    public void setCommitOption(String string) throws PropertyVetoException {
        String string2 = this.commitOption;
        this.getVCS().fireVetoableChange("commitOption", string2, string);
        this.commitOption = string;
        this.getPCS().firePropertyChange("commitOption", string2, string);
    }

    public String getHelpId() {
        return "AS_CFG_EntityEjb";
    }

    public class KeepRefreshPeriodValid
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            try {
                String string = propertyChangeEvent.getPropertyName();
                if (string.indexOf("isReadOnlyBean") > -1) {
                    Object object = propertyChangeEvent.getOldValue();
                    Object object2 = propertyChangeEvent.getNewValue();
                    if (object2.equals(Boolean.TRUE)) {
                        EntityEjb.this.setRefreshPeriodInSeconds("60");
                    }
                    if (object2.equals(Boolean.FALSE)) {
                        EntityEjb.this.setRefreshPeriodInSeconds(null);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class VetoRefreshPeriodChange
    implements VetoableChangeListener {
        VetoRefreshPeriodChange() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            boolean bl = true;
            String string = "bad things happen";
            try {
                String string2 = propertyChangeEvent.getPropertyName();
                if (string2.indexOf("refreshPeriodInSeconds") > -1 && (null == EntityEjb.this.isReadOnlyBean || EntityEjb.this.isReadOnlyBean.equals("false")) && propertyChangeEvent.getNewValue() != null) {
                    string = "property only valid for read-only beans";
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            if (!bl) {
                throw new PropertyVetoException(string, propertyChangeEvent);
            }
        }
    }

    protected class EntityEjbSnippet
    extends BaseEjb.BaseEjbSnippet {
        protected EntityEjbSnippet() {
        }

        public CommonDDBean getDDSnippet() {
            Ejb ejb = (Ejb)super.getDDSnippet();
            if (Utils.notEmpty(EntityEjb.this.isReadOnlyBean)) {
                ejb.setIsReadOnlyBean(EntityEjb.this.isReadOnlyBean);
            }
            if (Utils.notEmpty(EntityEjb.this.refreshPeriodInSeconds)) {
                ejb.setRefreshPeriodInSeconds(EntityEjb.this.refreshPeriodInSeconds);
            }
            if (Utils.notEmpty(EntityEjb.this.commitOption)) {
                ejb.setCommitOption(EntityEjb.this.commitOption);
            }
            return ejb;
        }

        public boolean hasDDSnippet() {
            if (super.hasDDSnippet()) {
                return true;
            }
            if (Utils.notEmpty(EntityEjb.this.isReadOnlyBean)) {
                return true;
            }
            if (Utils.notEmpty(EntityEjb.this.refreshPeriodInSeconds)) {
                return true;
            }
            return Utils.notEmpty(EntityEjb.this.commitOption);
        }
    }
}

