/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.ui.ComponentPanel;
import org.netbeans.modules.j2ee.sun.share.config.ui.ConfigBeanPanelView;
import org.netbeans.modules.j2ee.sun.share.config.ui.PanelView;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.explorer.view.TreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public class ConfigBeanTopComponent
extends CloneableTopComponent {
    private ConfigurationStorage storage = null;
    private Node rootNode = null;
    private TwoPanelComponentPanel componentPanel;
    public static final String APPLICATION_ICON_NORMAL = "org/netbeans/modules/j2ee/sun/share/config/ui/resources/application.gif";
    public static final String EJBMODULE_ICON_NORMAL = "org/netbeans/modules/j2ee/sun/share/config/ui/resources/ejbmodule.gif";
    public static final String WEBMODULE_ICON_NORMAL = "org/netbeans/modules/j2ee/sun/share/config/ui/resources/webmodule.gif";
    private boolean appConfig = false;

    public ConfigBeanTopComponent() {
        this.putClientProperty("PersistenceType", "Never");
    }

    public ConfigBeanTopComponent(ConfigurationStorage configurationStorage) {
        this();
        this.storage = configurationStorage;
        this.initialize();
    }

    public ConfigDataObject getConfigDataObject() {
        return this.storage.getPrimaryDataObject();
    }

    public void setName(String string) {
        if (string != null && string.startsWith("sun-ejb-jar")) {
            string = "sun-ejb-jar.xml / sun-cmp-mappings.xml";
        }
        super.setName(string);
    }

    public boolean isFor(FileObject fileObject) {
        boolean bl = false;
        ConfigDataObject configDataObject = this.getConfigDataObject();
        if (configDataObject != null) {
            bl = configDataObject.getPrimaryFile().equals(fileObject);
        }
        return bl;
    }

    public boolean isFor(ConfigurationStorage configurationStorage) {
        return this.getConfigStorage() == configurationStorage;
    }

    private ConfigurationStorage getConfigStorage() {
        return this.storage;
    }

    public static ConfigBeanTopComponent findByConfigStorage(ConfigurationStorage configurationStorage) {
        for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
            ConfigBeanTopComponent configBeanTopComponent;
            if (!(topComponent instanceof ConfigBeanTopComponent) || configurationStorage != (configBeanTopComponent = (ConfigBeanTopComponent)topComponent).getConfigStorage()) continue;
            return configBeanTopComponent;
        }
        return null;
    }

    public void refresh() {
        try {
            this.rootNode = this.buildTree();
            Node[] nodeArray = this.rootNode.getChildren().getNodes();
            if (nodeArray.length > 0) {
                Node node = nodeArray[0];
                this.componentPanel.refresh(this.rootNode, node);
            } else {
                ErrorManager.getDefault().log(1, "ConfigBeanTopComponent: empty top level node list.  Root: " + this.rootNode + ", topNodes: " + nodeArray);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        String string = "";
        ConfigDataObject configDataObject = this.getConfigDataObject();
        if (configDataObject != null) {
            string = configDataObject.getPrimaryFile().getPath();
        }
        return string;
    }

    public void initialize() {
        ConfigDataObject configDataObject = this.getConfigDataObject();
        Node node = configDataObject.getNodeDelegate();
        try {
            if (this.getConfigStorage() == null) {
                throw new IllegalArgumentException("ConfigDataObject without ConfigurationStorage cookie!");
            }
        }
        catch (RuntimeException runtimeException) {
            ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
            return;
        }
        this.initComponents();
        this.setName(node.getDisplayName());
        String string = "";
        FileObject fileObject = configDataObject.getPrimaryFile();
        try {
            string = fileObject.getFileSystem().getDisplayName() + "/" + fileObject.getPath();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            string = fileObject.getPath();
        }
        char c = File.separatorChar;
        char c2 = c == '/' ? (char)'\\' : '/';
        string = string.replace(c2, c);
        this.setToolTipText(string);
        Node[] nodeArray = this.rootNode.getChildren().getNodes();
        Node[] nodeArray2 = new Node[]{nodeArray.length > 0 ? nodeArray[0] : node};
        this.setActivatedNodes(nodeArray2);
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/j2ee/sun/share/config/ui/resources/ConfigFile.gif"));
    }

    public synchronized void reset() {
        this.rootNode = null;
        this.componentPanel = null;
        this.appConfig = false;
    }

    private void initComponents() {
        try {
            this.rootNode = this.buildTree();
            Node[] nodeArray = this.rootNode.getChildren().getNodes();
            Node node = null;
            if (nodeArray.length > 0) {
                node = nodeArray[0];
            }
            this.setLayout(new BorderLayout());
            ConfigBeanPanelView configBeanPanelView = new ConfigBeanPanelView(this.rootNode);
            this.componentPanel = new TwoPanelComponentPanel(configBeanPanelView, this.appConfig);
            this.add("Center", (Component)((Object)this.componentPanel));
            this.componentPanel.getExplorerManager().setSelectedNodes(new Node[]{node});
            ((PanelView)configBeanPanelView).showSelection(new Node[]{node});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().log(illegalArgumentException.getMessage());
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    private Node getMainNode() {
        return this.getConfigStorage().getMainNode();
    }

    private Node buildTree() {
        ConfigDataObject configDataObject = this.getConfigDataObject();
        Node node = configDataObject.getNodeDelegate();
        AbstractNode abstractNode = null;
        Children.Array array = new Children.Array();
        Node[] nodeArray = this.getConfigStorage().getMainNodes();
        array.add(nodeArray);
        abstractNode = new AbstractNode((Children)array);
        return abstractNode;
    }

    private Node[] createModuleNode(J2eeModule j2eeModule) {
        Children.Array array = new Children.Array();
        Node[] nodeArray = this.getConfigStorage().getNodes(j2eeModule);
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i] == null) continue;
            array.add(new Node[]{nodeArray[i]});
        }
        AbstractNode abstractNode = new AbstractNode((Children)array);
        abstractNode.setName(j2eeModule.getUrl());
        if (j2eeModule.getModuleType() == ModuleType.EJB) {
            abstractNode.setIconBaseWithExtension(EJBMODULE_ICON_NORMAL);
        } else if (j2eeModule.getModuleType() == ModuleType.WAR) {
            abstractNode.setIconBaseWithExtension(WEBMODULE_ICON_NORMAL);
        }
        return new Node[]{abstractNode};
    }

    protected void componentClosed() {
        super.componentClosed();
        ConfigDataObject configDataObject = this.getConfigDataObject();
        if (configDataObject != null) {
            configDataObject.editorClosed(this);
        }
    }

    public void open() {
        super.open();
    }

    /*
     * Unable to fully structure code
     */
    public boolean closeLast() {
        super.closeLast();
        var1_1 = this.getConfigDataObject();
        if (var1_1 != null && var1_1.isModified()) {
            var2_2 = NbBundle.getBundle(ConfigBeanTopComponent.class);
            var3_3 = NbBundle.getMessage(ConfigBeanTopComponent.class, (String)"MSG_ConfirmSave", (Object)var1_1.getName());
            var4_4 = new JButton(var2_2.getString("CTL_Save"));
            var4_4.getAccessibleContext().setAccessibleDescription(var2_2.getString("ACSD_CTL_Save"));
            var4_4.getAccessibleContext().setAccessibleName(var2_2.getString("ACSN_CTL_Save"));
            var5_6 = new JButton(var2_2.getString("CTL_Discard"));
            var5_6.getAccessibleContext().setAccessibleDescription(var2_2.getString("ACSD_CTL_Discard"));
            var5_6.getAccessibleContext().setAccessibleName(var2_2.getString("ACSN_CTL_Discard"));
            var5_6.setMnemonic(var2_2.getString("CTL_Discard_Mnemonic").charAt(0));
            var6_7 = new NotifyDescriptor((Object)var3_3, var2_2.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{var4_4, var5_6, NotifyDescriptor.CANCEL_OPTION}, (Object)var4_4);
            var7_8 = DialogDisplayer.getDefault().notify((NotifyDescriptor)var6_7);
            if (var4_4.equals(var7_8)) {
                try {
                    var8_9 = var1_1.getCookie(SaveCookie.class);
                    if (var8_9 == null) ** GOTO lbl36
                    var8_9.save();
                }
                catch (IOException var8_10) {
                    return false;
                }
            } else if (var5_6.equals(var7_8)) {
                try {
                    var1_1.setModified(false);
                    var1_1.resetAllChanged();
                    this.getConfigStorage().load();
                }
                catch (Exception var8_11) {
                    ErrorManager.getDefault().notify(1, (Throwable)var8_11);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)var8_11.getMessage(), 0));
                }
            } else {
                return false;
            }
        }
lbl36:
        // 6 sources

        if (this.appConfig = this.rootNode != null) {
            var2_2 = this.rootNode.getChildren();
            var3_3 = var2_2.getNodes();
            for (var4_5 = 0; var4_5 < var3_3.length; ++var4_5) {
                if (!(var3_3[var4_5] instanceof AbstractNode)) continue;
                var5_6 = (AbstractNode)var3_3[var4_5];
                var6_7 = var5_6.getChildren();
                var6_7.remove(var6_7.getNodes());
            }
            var2_2.remove(var2_2.getNodes());
        }
        return true;
    }

    protected CloneableTopComponent createClonedObject() {
        return new ConfigBeanTopComponent(this.storage);
    }

    private class TwoPanelComponentPanel
    extends ComponentPanel {
        protected TwoPanelComponentPanel() {
        }

        public TwoPanelComponentPanel(PanelView panelView) {
            super(panelView);
        }

        public TwoPanelComponentPanel(PanelView panelView, boolean bl) {
            super(panelView);
            JComponent jComponent = this.getStructureView();
            if (jComponent instanceof TreeView) {
                TreeView treeView = (TreeView)jComponent;
                treeView.setRootVisible(bl);
            }
        }

        public HelpCtx getHelpCtx() {
            Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
            if (nodeArray.length > 0) {
                return nodeArray[0].getHelpCtx();
            }
            if (ConfigBeanTopComponent.this.rootNode != null) {
                return ConfigBeanTopComponent.this.rootNode.getHelpCtx();
            }
            ConfigDataObject configDataObject = ConfigBeanTopComponent.this.getConfigDataObject();
            if (configDataObject != null) {
                return configDataObject.getHelpCtx();
            }
            return HelpCtx.DEFAULT_HELP;
        }

        protected void createHorizontalSplit() {
            this.split1 = this.panelOrientation == 1 ? new JSplitPane(1, this.getContentView(), this.getStructureView()) : new JSplitPane(1, this.getStructureView(), this.getContentView());
            this.split1.setDividerSize(4);
        }

        protected void createVerticalSplit() {
        }

        protected PanelView getPanelView() {
            return (PanelView)((Object)this.contentView);
        }

        public void refresh(Node node, Node node2) throws PropertyVetoException {
            this.getPanelView().setRoot(node);
            this.setRootContext(node);
            this.getExplorerManager().setSelectedNodes(new Node[]{node2});
            this.getPanelView().showSelection(new Node[]{node2});
        }
    }
}

