/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config.ui;

import java.awt.Component;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.sun.share.config.ConfigBeanStorage;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.ui.ConfigUtils;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.DConfigBeanProperties;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigBeanNode
extends AbstractNode
implements PropertyChangeListener {
    final ConfigBeanStorage bean;
    final BeanInfo info;
    final DConfigBeanProperties extraProps;
    private static final Action[] EMPTY_ACTIONS = new Action[0];

    public ConfigBeanNode(ConfigBeanStorage configBeanStorage) {
        super((Children)new ConfigChildren(configBeanStorage));
        this.bean = configBeanStorage;
        this.info = ConfigUtils.createBeanInfo(configBeanStorage.getConfigBean());
        DConfigBean dConfigBean = configBeanStorage.getConfigBean();
        this.extraProps = dConfigBean instanceof Base ? ((Base)dConfigBean).getUICustomization(dConfigBean) : null;
        ConfigurationStorage configurationStorage = configBeanStorage.getStorage();
        configurationStorage.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)configurationStorage));
    }

    public String getDisplayName() {
        if (this.extraProps != null) {
            return this.extraProps.getDisplayName();
        }
        if (this.info == null) {
            return this.bean.getClass().toString();
        }
        return this.info.getBeanDescriptor().getDisplayName();
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (SaveCookie.class.isAssignableFrom(clazz)) {
            return this.bean.getStorage().getPrimaryDataObject().getCookie(clazz);
        }
        return (T)super.getCookie(clazz);
    }

    public Action[] getActions(boolean bl) {
        return EMPTY_ACTIONS;
    }

    public HelpCtx getHelpCtx() {
        String string;
        if (this.extraProps != null && (string = this.extraProps.getHelpId()) != null) {
            return new HelpCtx(string);
        }
        return HelpCtx.DEFAULT_HELP;
    }

    public Image getIcon(int n) {
        Image image;
        if (this.info != null && (image = this.info.getIcon(n)) != null) {
            return image;
        }
        return super.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        Image image;
        if (this.info != null && (image = this.info.getIcon(n)) != null) {
            return image;
        }
        return super.getOpenedIcon(n);
    }

    public Sheet createSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = ConfigUtils.createSheet(this.bean);
        set.setName(this.getDisplayName());
        sheet.put(set);
        return sheet;
    }

    public DConfigBean getBean() {
        return this.bean.getConfigBean();
    }

    public Component getCustomizer() {
        Component component = null;
        if (!this.hasCustomizer()) {
            return null;
        }
        try {
            return (Component)this.info.getBeanDescriptor().getCustomizerClass().newInstance();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return component;
        }
    }

    public boolean hasCustomizer() {
        return this.info.getBeanDescriptor().getCustomizerClass() != null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("cookie".equals(propertyChangeEvent.getPropertyName())) {
            this.fireCookieChange();
        }
    }

    public static class ConfigChildren
    extends Children.Keys
    implements ConfigBeanStorage.ChildrenChangeListener {
        ConfigBeanStorage bean;

        ConfigChildren(ConfigBeanStorage configBeanStorage) {
            this.bean = configBeanStorage;
        }

        protected void addNotify() {
            this.updateKeys();
            this.bean.addChildrenChangeListener(this);
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.bean.removeChildrenChangeListener(this);
        }

        void updateKeys() {
            this.setKeys(this.bean.getChildMap().keySet());
        }

        void updateKey(Object object) {
            this.refreshKey(object);
        }

        protected Node[] createNodes(Object object) {
            Collection collection = (Collection)this.bean.getChildMap().get(object);
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ConfigBeanStorage configBeanStorage = (ConfigBeanStorage)iterator.next();
                Node node = configBeanStorage.getNode();
                if (node != null) {
                    arrayList.add(node);
                }
                ++n;
            }
            return arrayList.toArray(new Node[arrayList.size()]);
        }

        public void childBeanAdded(final ConfigBeanStorage configBeanStorage) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigChildren.this.updateKeys();
                    ConfigChildren.this.refreshKey(configBeanStorage.getConfigBean().getDDBean().getXpath());
                }
            });
        }

        public void childBeanRemoved(final ConfigBeanStorage configBeanStorage) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigChildren.this.updateKey(configBeanStorage.getConfigBean().getDDBean().getXpath());
                }
            });
        }
    }
}

