/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class LogSupport {
    private Map links = Collections.synchronizedMap(new HashMap());
    private Annotation errAnnot;

    public Link getLink(String string, String string2, int n) {
        Link link = new Link(string, string2, n);
        Link link2 = (Link)this.links.get(link);
        if (link2 != null) {
            return link2;
        }
        this.links.put(link, link);
        return link;
    }

    public void detachAnnotation() {
        if (this.errAnnot != null) {
            this.errAnnot.detach();
        }
    }

    public class Link
    implements OutputListener {
        private String msg;
        private String path;
        private int line;
        private int hashCode = 0;

        Link(String string, String string2, int n) {
            this.msg = string;
            this.path = string2;
            this.line = n;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int n = 17;
                n = 37 * n + this.line;
                n = 37 * n + (this.path != null ? this.path.hashCode() : 0);
                this.hashCode = n = 37 * n + (this.msg != null ? this.msg.hashCode() : 0);
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Link) {
                Link link = (Link)object;
                if ((this.msg != null && this.msg.equals(link.msg) || this.msg == link.msg) && (this.path != null && this.path.equals(link.path) || this.path == link.path) && this.line == link.line) {
                    return true;
                }
            }
            return false;
        }

        public void outputLineAction(OutputEvent outputEvent) {
            FileObject fileObject = GlobalPathRegistry.getDefault().findResource(this.path);
            if (fileObject == null) {
                fileObject = FileUtil.toFileObject((File)new File(this.path));
            }
            DataObject dataObject = null;
            if (fileObject != null) {
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Logger.getLogger(LogSupport.class.getName()).log(Level.INFO, null, dataObjectNotFoundException);
                }
            }
            if (dataObject != null) {
                String string;
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie == null) {
                    return;
                }
                editorCookie.open();
                Line line = null;
                try {
                    line = editorCookie.getLineSet().getCurrent(this.line - 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return;
                }
                if (LogSupport.this.errAnnot != null) {
                    LogSupport.this.errAnnot.detach();
                }
                if ((string = this.msg) == null || string.equals("")) {
                    string = NbBundle.getMessage(Link.class, (String)"MSG_ExceptionOccurred");
                }
                LogSupport.this.errAnnot = new ErrorAnnotation(string);
                LogSupport.this.errAnnot.attach((Annotatable)line);
                LogSupport.this.errAnnot.moveToFront();
                line.show(0);
            }
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            if (LogSupport.this.errAnnot != null) {
                LogSupport.this.errAnnot.detach();
            }
            if (!LogSupport.this.links.isEmpty()) {
                LogSupport.this.links.clear();
            }
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }
    }

    static class ErrorAnnotation
    extends Annotation {
        private String shortDesc = null;

        public ErrorAnnotation(String string) {
            this.shortDesc = string;
        }

        public String getAnnotationType() {
            return "org-netbeans-modules-tomcat5-error";
        }

        public String getShortDescription() {
            return this.shortDesc;
        }
    }

    public static class LineInfo {
        private String path;
        private int line;
        private String message;
        private boolean error;
        private boolean accessible;

        public LineInfo(String string, int n, String string2, boolean bl, boolean bl2) {
            this.path = string;
            this.line = n;
            this.message = string2;
            this.error = bl;
            this.accessible = bl2;
        }

        public String path() {
            return this.path;
        }

        public int line() {
            return this.line;
        }

        public String message() {
            return this.message;
        }

        public boolean isError() {
            return this.error;
        }

        public boolean isAccessible() {
            return this.accessible;
        }

        public String toString() {
            return "path=" + this.path + " line=" + this.line + " message=" + this.message + " isError=" + this.error + " isAccessible=" + this.accessible;
        }
    }
}

