/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.layoutsupport.delegates.GridBagControlCenter;
import org.netbeans.modules.form.layoutsupport.delegates.GridBagLayoutSupport;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class GridBagCustomizer
extends JPanel
implements Customizer {
    PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    static final int TOP = 1;
    static final int BOTTOM = 2;
    static final int LEFT = 4;
    static final int RIGHT = 8;
    static final int HORIZONTAL = 12;
    static final int VERTICAL = 3;
    static final int PLUS = 1;
    static final int MINUS = -1;
    private static final ImageIcon REMAINDER_ICON = new ImageIcon(GridBagCustomizer.class.getResource("/org/netbeans/modules/form/layoutsupport/resources/remainder.gif"));
    private GridBagLayoutSupport layoutSupport;
    private FormModel formModel;
    private FormModelListener formListener;
    private RADVisualContainer radContainer;
    private RADVisualComponent[] radComponents;
    private GBComponentProxy[] gbcProxies;
    private JSplitPane splitPane;
    private JPanel designPanel;
    private GridBagControlCenter controlCenter;
    private GBContainerProxy containerProxy;
    private PropertySheet propertySheet;
    private JScrollPane designScrollPane;
    private JLayeredPane designLayeredPane;
    private GBComponentProxy.DragLabel dragLabel = null;
    private boolean firstPaint = false;
    static final long serialVersionUID = -632768048562391785L;

    public GridBagCustomizer() {
        this.initComponents();
    }

    private void initialize() {
        this.radContainer = ((LayoutSupportManager)this.layoutSupport.getLayoutSupportHack()).getMetaContainer();
        this.formModel = this.radContainer.getFormModel();
        this.radComponents = this.radContainer.getSubComponents();
        this.gbcProxies = new GBComponentProxy[this.radComponents.length];
        for (int i = 0; i < this.radComponents.length; ++i) {
            this.gbcProxies[i] = new GBComponentProxy(this.radComponents[i], this.containerProxy);
        }
        this.containerProxy.removeAll();
        FormDesigner formDesigner = FormEditor.getFormDesigner(this.formModel);
        if (!formDesigner.isInDesigner(this.radContainer)) {
            formDesigner.setTopDesignComponent(this.radContainer, true);
            this.invokeLater(2, new Runnable(){

                public void run() {
                    GridBagCustomizer.this.containerProxy.addAllProxies();
                }
            });
        } else {
            this.containerProxy.addAllProxies();
        }
        this.formListener = new FormListener();
        this.formModel.addFormModelListener(this.formListener);
    }

    void customizerClosed() {
        this.formModel.removeFormModelListener(this.formListener);
    }

    private void initComponents() {
        this.setBorder(new EmptyBorder(4, 0, 8, 0));
        this.setLayout(new BorderLayout());
        this.propertySheet = new PropertySheet();
        try {
            this.propertySheet.setSortingMode(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.propertySheet.setPreferredSize(new Dimension(300, 380));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.propertySheet, "Center");
        this.controlCenter = new GridBagControlCenter(this);
        jPanel.add((Component)this.controlCenter, "South");
        this.designScrollPane = new JScrollPane();
        this.designPanel = new JPanel(){

            public Dimension getPreferredSize() {
                return GridBagCustomizer.this.containerProxy.getPreferredSize();
            }
        };
        this.designPanel.setLayout(new GridBagLayout());
        this.designPanel.setBackground((Color)UIManager.getDefaults().get("desktop"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.containerProxy = new GBContainerProxy();
        this.designPanel.add((Component)this.containerProxy, gridBagConstraints);
        this.designLayeredPane = new JLayeredPane(){

            public Dimension getPreferredSize() {
                Dimension dimension = GridBagCustomizer.this.designPanel.getPreferredSize();
                Dimension dimension2 = GridBagCustomizer.this.designScrollPane.getViewport().getExtentSize();
                int n = Math.max(dimension.width + 40, dimension2.width);
                int n2 = Math.max(dimension.height + 40, dimension2.height);
                return new Dimension(Math.max(500, n), Math.max(300, n2));
            }
        };
        this.designLayeredPane.add((Component)this.designPanel, JLayeredPane.DEFAULT_LAYER);
        this.designPanel.setBounds(20, 20, this.designPanel.getPreferredSize().width, this.designPanel.getPreferredSize().height);
        this.designLayeredPane.setOpaque(true);
        this.designLayeredPane.setBackground((Color)UIManager.getDefaults().get("desktop"));
        this.designScrollPane.setViewportView(this.designLayeredPane);
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(jPanel);
        this.splitPane.setRightComponent(this.designScrollPane);
        this.splitPane.setUI(new BasicSplitPaneUI());
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setContinuousLayout(true);
        this.add((Component)this.splitPane, "Center");
        this.getAccessibleContext().setAccessibleDescription(GridBagLayoutSupport.getBundleHack().getString("ACSD_GridBagCustomizer"));
        HelpCtx.setHelpIDString((JComponent)this, (String)"gui.layouts.gbcustomizer");
    }

    void setAnchor(int n) {
        List<GBComponentProxy> list = this.containerProxy.getSelectedProxies();
        Iterator<GBComponentProxy> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.setProperty(iterator.next(), "anchor", new Integer(n));
        }
    }

    void setFill(int n) {
        List<GBComponentProxy> list = this.containerProxy.getSelectedProxies();
        Iterator<GBComponentProxy> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.setProperty(iterator.next(), "fill", new Integer(n));
        }
    }

    void modifyIPad(int n, int n2) {
        List<GBComponentProxy> list = this.containerProxy.getSelectedProxies();
        for (GBComponentProxy gBComponentProxy : list) {
            int n3;
            int n4 = n3 = n2 == 12 ? gBComponentProxy.getRealConstraints().ipadx : gBComponentProxy.getRealConstraints().ipady;
            if ((n3 += n) < 0) continue;
            this.setProperty(gBComponentProxy, n2 == 12 ? "ipadx" : "ipady", new Integer(n3));
        }
    }

    void modifyInsets(int n, int n2) {
        List<GBComponentProxy> list = this.containerProxy.getSelectedProxies();
        for (GBComponentProxy gBComponentProxy : list) {
            Insets insets = gBComponentProxy.getRealConstraints().insets;
            Insets insets2 = (Insets)insets.clone();
            if ((n2 & 1) != 0) {
                insets2.top += n;
                if (insets2.top < 0) {
                    insets2.top = 0;
                }
            }
            if ((n2 & 2) != 0) {
                insets2.bottom += n;
                if (insets2.bottom < 0) {
                    insets2.bottom = 0;
                }
            }
            if ((n2 & 4) != 0) {
                insets2.left += n;
                if (insets2.left < 0) {
                    insets2.left = 0;
                }
            }
            if ((n2 & 8) != 0) {
                insets2.right += n;
                if (insets2.right < 0) {
                    insets2.right = 0;
                }
            }
            this.setProperty(gBComponentProxy, "insets", insets2);
        }
    }

    void modifyGridSize(int n, int n2) {
        List<GBComponentProxy> list = this.containerProxy.getSelectedProxies();
        for (GBComponentProxy gBComponentProxy : list) {
            int n3;
            int n4 = n3 = n2 == 12 ? gBComponentProxy.getRealConstraints().gridwidth : gBComponentProxy.getRealConstraints().gridheight;
            if (n == 0) {
                n3 = n3 == 0 ? 1 : 0;
            } else if ((n3 += n) < 1) {
                n3 = 1;
            }
            this.setProperty(gBComponentProxy, n2 == 12 ? "gridwidth" : "gridheight", new Integer(n3));
        }
    }

    private void setProperty(GBComponentProxy gBComponentProxy, String string, Object object) {
        Node.Property property = gBComponentProxy.getComponent().getPropertyByName("GridBagLayoutConstraints " + string);
        if (property != null) {
            try {
                property.setValue(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setObject(Object object) {
        this.layoutSupport = (GridBagLayoutSupport)object;
        this.initialize();
        this.firstPaint = true;
    }

    void waitForDesignerUpdate(int n) {
        try {
            while (n > 0) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                    }
                });
                --n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void invokeLater(final int n, final Runnable runnable) {
        if (n == 0) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GridBagCustomizer.this.invokeLater(n - 1, runnable);
                }
            });
        }
    }

    void innerLayoutChanged() {
        this.containerProxy.widenEmpty();
        this.designPanel.setBounds(20, 20, this.designPanel.getPreferredSize().width, this.designPanel.getPreferredSize().height);
        this.containerProxy.revalidate();
        this.designLayeredPane.revalidate();
    }

    public static class Window
    extends JDialog
    implements Customizer,
    ActionListener {
        private final GridBagCustomizer customizerPanel;
        private boolean packCalled;

        public Window() {
            super(WindowManager.getDefault().getMainWindow());
            ResourceBundle resourceBundle = GridBagLayoutSupport.getBundleHack();
            this.setTitle(resourceBundle.getString("CTL_CustomizerTitle"));
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            this.customizerPanel = new GridBagCustomizer();
            this.getContentPane().add((Component)this.customizerPanel, "Center");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(2, 6, 6));
            JButton jButton = new JButton();
            jButton.setText(resourceBundle.getString("CTL_CloseButton"));
            jButton.setActionCommand("close");
            jButton.addActionListener(this);
            jPanel.add(jButton);
            JButton jButton2 = new JButton();
            jButton2.setText(resourceBundle.getString("CTL_HelpButton"));
            jButton2.setActionCommand("help");
            jButton2.addActionListener(this);
            jPanel.add(jButton2);
            this.getContentPane().add((Component)jPanel, "South");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    Window.this.customizerPanel.customizerClosed();
                }
            });
            this.setDefaultCloseOperation(2);
        }

        public void pack() {
            if (this.packCalled) {
                return;
            }
            this.packCalled = true;
            super.pack();
            Dimension dimension = this.getSize();
            Rectangle rectangle = Utilities.getUsableScreenBounds();
            if (dimension.width > rectangle.width - 80) {
                dimension.width = rectangle.width * 4 / 5;
            }
            if (dimension.height > rectangle.height - 80) {
                dimension.height = rectangle.height * 4 / 5;
            }
            this.setBounds(Utilities.findCenterBounds((Dimension)dimension));
        }

        public void setObject(Object object) {
            this.customizerPanel.setObject(object);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Help help;
            if (actionEvent.getActionCommand().equals("close")) {
                this.dispose();
            } else if (actionEvent.getActionCommand().equals("help") && (help = (Help)Lookup.getDefault().lookup(Help.class)) != null) {
                help.showHelp(HelpCtx.findHelp((Component)this.customizerPanel));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GBContainerProxy
    extends JPanel {
        private GridBagLayout layout = new GridBagLayout();
        private boolean[][] empties;
        static final long serialVersionUID = 5113122235848232590L;

        GBContainerProxy() {
            this.setLayout(this.layout);
            this.setBorder(new BevelBorder(0));
            this.setOpaque(true);
        }

        void addAllProxies() {
            for (int i = 0; i < GridBagCustomizer.this.gbcProxies.length; ++i) {
                this.add((Component)GridBagCustomizer.this.gbcProxies[i], GridBagCustomizer.this.gbcProxies[i].getProxyConstraints());
            }
            this.invalidate();
            this.validate();
            GridBagCustomizer.this.innerLayoutChanged();
            this.widenEmpty();
            if (GridBagCustomizer.this.gbcProxies.length > 0) {
                this.select(GridBagCustomizer.this.gbcProxies[0]);
            }
        }

        void widenEmpty() {
            this.layout.columnWidths = null;
            this.layout.rowHeights = null;
            this.layout.layoutContainer(this);
            this.validate();
            int[][] nArray = this.layout.getLayoutDimensions();
            this.empties = new boolean[2][];
            int[] nArray2 = new int[nArray[0].length];
            this.empties[0] = new boolean[nArray[0].length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = 25;
                this.empties[0][i] = nArray[0][i] == 0;
            }
            this.layout.columnWidths = nArray2;
            int[] nArray3 = new int[nArray[1].length];
            this.empties[1] = new boolean[nArray[1].length];
            for (int i = 0; i < nArray3.length; ++i) {
                nArray3[i] = 25;
                this.empties[1][i] = nArray[1][i] == 0;
            }
            this.layout.rowHeights = nArray3;
        }

        @Override
        public void paint(Graphics graphics) {
            if (GridBagCustomizer.this.firstPaint) {
                GridBagCustomizer.this.innerLayoutChanged();
                GridBagCustomizer.this.firstPaint = false;
            }
            super.paint(graphics);
            if (GridBagCustomizer.this.gbcProxies.length > 0) {
                int n;
                int n2;
                int n3;
                int n4;
                Color color = new Color(255, 173, 173);
                Point point = this.layout.getLayoutOrigin();
                int[][] nArray = this.layout.getLayoutDimensions();
                int n5 = 0;
                for (n4 = 0; n4 < nArray[0].length; ++n4) {
                    n5 += nArray[0][n4];
                }
                n4 = 0;
                for (n3 = 0; n3 < nArray[1].length; ++n3) {
                    n4 += nArray[1][n3];
                }
                n3 = point.y;
                graphics.setColor(color);
                for (n2 = 0; n2 < nArray[1].length; ++n2) {
                    if (this.empties[1][n2]) {
                        graphics.setColor(color);
                        graphics.fillRect(point.x, n3, n5, nArray[1][n2]);
                    }
                    n3 += nArray[1][n2];
                }
                n2 = point.x;
                for (n = 0; n < nArray[0].length; ++n) {
                    if (this.empties[0][n]) {
                        graphics.setColor(color);
                        graphics.fillRect(n2, point.y, nArray[0][n], n4);
                    }
                    n2 += nArray[0][n];
                }
                graphics.setColor(Color.black);
                n3 = nArray[1][0] + point.y - 1;
                for (n = 1; n < nArray[1].length; ++n) {
                    graphics.drawLine(point.x, n3, point.x + n5 - 1, n3);
                    graphics.drawLine(point.x, n3 + 1, point.x + n5 - 1, n3 + 1);
                    n3 += nArray[1][n];
                }
                n2 = nArray[0][0] + point.x - 1;
                for (n = 1; n < nArray[0].length; ++n) {
                    graphics.drawLine(n2, point.y, n2, point.y + n4 - 1);
                    graphics.drawLine(n2 + 1, point.y, n2 + 1, point.y + n4 - 1);
                    n2 += nArray[0][n];
                }
            }
            this.paintChildren(graphics);
        }

        Point getLayoutLocation(Point point) {
            return this.layout.location(point.x, point.y);
        }

        void updateAllProxies() {
            for (int i = 0; i < GridBagCustomizer.this.gbcProxies.length; ++i) {
                this.updateProxy(GridBagCustomizer.this.gbcProxies[i]);
            }
            GridBagCustomizer.this.innerLayoutChanged();
            GridBagCustomizer.this.controlCenter.newSelection(this.getSelectedProxies());
        }

        void updateProxy(GBComponentProxy gBComponentProxy) {
            gBComponentProxy.updateByComponent();
            gBComponentProxy.getProxyConstraints();
            this.layout.setConstraints(gBComponentProxy, gBComponentProxy.getProxyConstraints());
            gBComponentProxy.invalidate();
            gBComponentProxy.validate();
        }

        void invalidateAllProxies() {
            for (int i = 0; i < GridBagCustomizer.this.gbcProxies.length; ++i) {
                GridBagCustomizer.this.gbcProxies[i].invalidate();
            }
            this.doLayout();
        }

        List<GBComponentProxy> getSelectedProxies() {
            ArrayList<GBComponentProxy> arrayList = new ArrayList<GBComponentProxy>(GridBagCustomizer.this.gbcProxies.length);
            for (int i = 0; i < GridBagCustomizer.this.gbcProxies.length; ++i) {
                if (!GridBagCustomizer.this.gbcProxies[i].isSelected) continue;
                arrayList.add(GridBagCustomizer.this.gbcProxies[i]);
            }
            return arrayList;
        }

        Node[] getSelectedNodes() {
            List<GBComponentProxy> list = this.getSelectedProxies();
            Node[] nodeArray = new Node[list.size()];
            Iterator<GBComponentProxy> iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                nodeArray[n] = iterator.next().getNode();
                ++n;
            }
            return nodeArray;
        }

        void select(GBComponentProxy gBComponentProxy) {
            this.select(gBComponentProxy, false);
        }

        void shiftSelect(GBComponentProxy gBComponentProxy) {
            this.select(gBComponentProxy, true);
        }

        void select(GBComponentProxy gBComponentProxy, boolean bl) {
            List<GBComponentProxy> list = this.getSelectedProxies();
            if (gBComponentProxy.isSelected()) {
                if (list.size() == 1) {
                    return;
                }
                if (bl) {
                    gBComponentProxy.setSelected(false);
                } else {
                    Iterator<GBComponentProxy> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().setSelected(false);
                    }
                    gBComponentProxy.setSelected(true);
                }
            } else {
                if (!bl) {
                    Iterator<GBComponentProxy> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().setSelected(false);
                    }
                }
                gBComponentProxy.setSelected(true);
            }
            GridBagCustomizer.this.propertySheet.setNodes(this.getSelectedNodes());
            GridBagCustomizer.this.controlCenter.newSelection(this.getSelectedProxies());
        }
    }

    static class ComponentProxyNode
    extends FilterNode {
        ComponentProxyNode(Node node) {
            super(node);
        }

        public Node.PropertySet[] getPropertySets() {
            Node.PropertySet[] propertySetArray = super.getPropertySets();
            for (int i = 0; i < propertySetArray.length; ++i) {
                if (!"layout".equals(propertySetArray[i].getName())) continue;
                return new Node.PropertySet[]{propertySetArray[i]};
            }
            return new Node.PropertySet[0];
        }
    }

    class GBComponentProxy
    extends JPanel {
        private GBContainerProxy parentProxy;
        private RADVisualComponent component;
        private ComponentProxyNode node;
        private CompoundBorder compoundBorder;
        private MatteBorder insetsBorder;
        private MatteBorder remainderBorder;
        private JLabel componentLabel;
        private GridBagLayout layout;
        private Color INSETS_COLOR = new Color(255, 255, 204);
        private Color CELL_COLOR = new Color(153, 153, 255);
        private boolean isSelected = false;
        static final long serialVersionUID = -6552012922564179923L;

        GBComponentProxy(final RADVisualComponent rADVisualComponent, GBContainerProxy gBContainerProxy) {
            this.component = rADVisualComponent;
            this.parentProxy = gBContainerProxy;
            this.componentLabel = new JLabel(){

                public void paint(Graphics graphics) {
                    int n = 5;
                    Color color = Color.blue;
                    super.paint(graphics);
                    if (GBComponentProxy.this.isSelected()) {
                        Dimension dimension = this.getSize();
                        graphics.setColor(color);
                        graphics.fillRect(0, 0, n, n);
                        graphics.fillRect(dimension.width - n, 0, n, n);
                        graphics.fillRect(0, dimension.height - n, n, n);
                        graphics.fillRect(dimension.width - n, dimension.height - n, n, n);
                    }
                }

                public Dimension getPreferredSize() {
                    Dimension dimension;
                    FormDesigner formDesigner = FormEditor.getFormDesigner(GridBagCustomizer.this.formModel);
                    Component component = (Component)formDesigner.getComponent(rADVisualComponent);
                    if (component == null) {
                        component = (Component)rADVisualComponent.getBeanInstance();
                        dimension = component.getPreferredSize();
                    } else if (formDesigner.isOpened()) {
                        dimension = component.getSize();
                        if (dimension.width > 4096) {
                            dimension.width = component.getPreferredSize().width;
                        }
                    } else {
                        dimension = component.getPreferredSize();
                    }
                    dimension = new Dimension(dimension);
                    if (component instanceof JComponent && !(component instanceof JPanel)) {
                        Border border;
                        Insets insets = this.getInsets();
                        if (component instanceof JComponent && (border = ((JComponent)component).getBorder()) != null) {
                            Insets insets2 = border.getBorderInsets(component);
                            insets.top -= insets2.top;
                            insets.left -= insets2.left;
                            insets.bottom -= insets2.bottom;
                            insets.right -= insets2.right;
                        }
                        if (insets.top > 0) {
                            dimension.height += insets.top;
                        }
                        if (insets.bottom > 0) {
                            dimension.height += insets.bottom;
                        }
                        if (insets.left > 0) {
                            dimension.width += insets.left;
                        }
                        if (insets.right > 0) {
                            dimension.width += insets.right;
                        }
                    }
                    if (dimension.width < 6) {
                        dimension.width = 6;
                    }
                    if (dimension.height < 6) {
                        dimension.height = 6;
                    }
                    return dimension;
                }

                public Dimension getMinimumSize() {
                    Component component = (Component)FormEditor.getFormDesigner(GridBagCustomizer.this.formModel).getComponent(rADVisualComponent);
                    if (component == null) {
                        component = (Component)rADVisualComponent.getBeanInstance();
                    }
                    return component.getMinimumSize();
                }

                public Dimension getMaximumSize() {
                    Component component = (Component)FormEditor.getFormDesigner(GridBagCustomizer.this.formModel).getComponent(rADVisualComponent);
                    if (component == null) {
                        component = (Component)rADVisualComponent.getBeanInstance();
                    }
                    return component.getMaximumSize();
                }
            };
            this.componentLabel.setOpaque(true);
            this.componentLabel.setBorder(new EtchedBorder());
            this.componentLabel.setText(rADVisualComponent.getName());
            this.componentLabel.setHorizontalAlignment(0);
            this.componentLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    GBComponentProxy.this.mouseClicked(mouseEvent);
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    GBComponentProxy.this.mousePressed(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    GBComponentProxy.this.mouseReleased(mouseEvent);
                }
            });
            this.componentLabel.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    GBComponentProxy.this.mouseDragged(mouseEvent);
                }
            });
            this.layout = new GridBagLayout();
            this.setLayout(this.layout);
            this.setBackground(this.CELL_COLOR);
            this.setOpaque(true);
            this.updateByComponent();
            this.add((Component)this.componentLabel, this.getInnerComponentConstraints());
            this.node = new ComponentProxyNode((Node)rADVisualComponent.getNodeReference());
        }

        RADVisualComponent getComponent() {
            return this.component;
        }

        GridBagConstraints getRealConstraints() {
            return (GridBagConstraints)this.component.getParentContainer().getLayoutSupport().getConstraints(this.component).getConstraintsObject();
        }

        ComponentProxyNode getNode() {
            return this.node;
        }

        void updateByComponent() {
            this.layout.setConstraints(this.componentLabel, this.getInnerComponentConstraints());
        }

        GridBagConstraints getInnerComponentConstraints() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = this.getRealConstraints().anchor;
            gridBagConstraints.fill = this.getRealConstraints().fill;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.ipadx = this.getRealConstraints().ipadx;
            gridBagConstraints.ipady = this.getRealConstraints().ipady;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            return gridBagConstraints;
        }

        GridBagConstraints getProxyConstraints() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridheight = this.getRealConstraints().gridheight;
            gridBagConstraints.gridwidth = this.getRealConstraints().gridwidth;
            gridBagConstraints.gridx = this.getRealConstraints().gridx;
            gridBagConstraints.gridy = this.getRealConstraints().gridy;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            Insets insets = this.getRealConstraints().insets;
            this.insetsBorder = new MatteBorder(insets.top, insets.left, insets.bottom, insets.right, this.INSETS_COLOR);
            this.remainderBorder = new MatteBorder(0, 0, gridBagConstraints.gridheight == 0 ? 4 : 0, gridBagConstraints.gridwidth == 0 ? 4 : 0, REMAINDER_ICON);
            this.compoundBorder = new CompoundBorder(this.remainderBorder, this.insetsBorder);
            this.setBorder(this.compoundBorder);
            return gridBagConstraints;
        }

        boolean isSelected() {
            return this.isSelected;
        }

        void setSelected(boolean bl) {
            if (this.isSelected == bl) {
                return;
            }
            this.isSelected = bl;
            this.componentLabel.repaint();
        }

        void mouseClicked(MouseEvent mouseEvent) {
        }

        void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isControlDown()) {
                this.parentProxy.shiftSelect(this);
            } else {
                this.parentProxy.select(this);
            }
        }

        void mouseReleased(MouseEvent mouseEvent) {
            if (GridBagCustomizer.this.dragLabel != null) {
                if (!GridBagCustomizer.this.dragLabel.getLastIndex().equals(GridBagCustomizer.this.dragLabel.getOriginalIndex())) {
                    GridBagCustomizer.this.setProperty(this, "gridx", new Integer(((GridBagCustomizer)GridBagCustomizer.this).dragLabel.getLastIndex().x));
                    GridBagCustomizer.this.setProperty(this, "gridy", new Integer(((GridBagCustomizer)GridBagCustomizer.this).dragLabel.getLastIndex().y));
                }
                GridBagCustomizer.this.designLayeredPane.remove(GridBagCustomizer.this.dragLabel);
                GridBagCustomizer.this.dragLabel = null;
                this.componentLabel.setCursor(Cursor.getDefaultCursor());
                GridBagCustomizer.this.designLayeredPane.repaint();
            }
        }

        void mouseDragged(MouseEvent mouseEvent) {
            if (GridBagCustomizer.this.dragLabel == null) {
                if (this.isSelected()) {
                    GridBagCustomizer.this.dragLabel = new DragLabel();
                    GridBagCustomizer.this.dragLabel.setHotSpot(mouseEvent.getPoint());
                    GridBagCustomizer.this.dragLabel.resolveOrigin();
                    GridBagCustomizer.this.dragLabel.setLastIndex(GridBagCustomizer.this.dragLabel.getIndex(mouseEvent.getPoint()));
                    GridBagCustomizer.this.dragLabel.setOriginalIndex(GridBagCustomizer.this.dragLabel.getIndex(mouseEvent.getPoint()));
                    GridBagCustomizer.this.designLayeredPane.setLayer(GridBagCustomizer.this.dragLabel, JLayeredPane.DRAG_LAYER);
                    GridBagCustomizer.this.designLayeredPane.add((Component)GridBagCustomizer.this.dragLabel, "Center");
                    GridBagCustomizer.this.dragLabel.setBounds(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    this.componentLabel.setCursor(Cursor.getPredefinedCursor(13));
                }
            } else {
                Point point = GridBagCustomizer.this.dragLabel.getIndex(mouseEvent.getPoint());
                if (!GridBagCustomizer.this.dragLabel.getLastIndex().equals(point)) {
                    Point point2 = SwingUtilities.convertPoint(GridBagCustomizer.this.dragLabel, mouseEvent.getPoint(), GridBagCustomizer.this.designLayeredPane);
                    GridBagConstraints gridBagConstraints = this.getProxyConstraints();
                    gridBagConstraints.gridx = point.x;
                    gridBagConstraints.gridy = point.y;
                    this.parentProxy.layout.setConstraints(this, gridBagConstraints);
                    GridBagCustomizer.this.dragLabel.resolveOrigin();
                    SwingUtilities.convertPoint(GridBagCustomizer.this.designLayeredPane, point2, GridBagCustomizer.this.dragLabel);
                    Rectangle rectangle = GridBagCustomizer.this.dragLabel.getBounds();
                    Point point3 = rectangle.getLocation();
                    point3.x += rectangle.width + 20;
                    point3.y += rectangle.height + 20;
                    GridBagCustomizer.this.innerLayoutChanged();
                    GridBagCustomizer.this.dragLabel.repaint();
                    GridBagCustomizer.this.dragLabel.setLastIndex(point);
                } else {
                    GridBagCustomizer.this.dragLabel.setBounds(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                }
            }
        }

        class DragLabel
        extends JLabel {
            Point origin;
            Point hotSpot;
            Point lastIndex;
            Point originalIndex;
            private Dimension preferredSize;
            static final long serialVersionUID = 992490305277357953L;

            DragLabel() {
                this.setOpaque(false);
                this.setEnabled(false);
                this.setBorder(new EtchedBorder());
                this.setText(GBComponentProxy.this.component.getName());
                this.setHorizontalAlignment(0);
                this.preferredSize = (Dimension)GBComponentProxy.this.componentLabel.getPreferredSize().clone();
            }

            public Dimension getPreferredSize() {
                this.preferredSize.height = ((GBComponentProxy)GBComponentProxy.this).componentLabel.getPreferredSize().height + GBComponentProxy.this.getRealConstraints().ipady;
                this.preferredSize.width = ((GBComponentProxy)GBComponentProxy.this).componentLabel.getPreferredSize().width + GBComponentProxy.this.getRealConstraints().ipadx;
                return this.preferredSize;
            }

            public Dimension getMinimumSize() {
                return GBComponentProxy.this.componentLabel.getMinimumSize();
            }

            public Dimension getMaximumSize() {
                return GBComponentProxy.this.componentLabel.getMaximumSize();
            }

            void setHotSpot(Point point) {
                this.hotSpot = point;
            }

            void resolveOrigin() {
                this.origin = SwingUtilities.convertPoint(GBComponentProxy.this.componentLabel, 0, 0, GridBagCustomizer.this.designLayeredPane);
            }

            Point getLastIndex() {
                return this.lastIndex;
            }

            void setLastIndex(Point point) {
                this.lastIndex = point;
            }

            Point getOriginalIndex() {
                return this.originalIndex;
            }

            void setOriginalIndex(Point point) {
                this.originalIndex = point;
            }

            Point getIndex(Point point) {
                return GBComponentProxy.this.parentProxy.getLayoutLocation(SwingUtilities.convertPoint(GBComponentProxy.this.componentLabel, point, GBComponentProxy.this.parentProxy));
            }

            public void setBounds(int n, int n2) {
                this.resolveOrigin();
                super.setBounds(this.origin.x + n - this.hotSpot.x, this.origin.y + n2 - this.hotSpot.y, this.getPreferredSize().width, this.getPreferredSize().height);
            }
        }
    }

    class FormListener
    implements FormModelListener {
        FormListener() {
        }

        public void formChanged(FormModelEvent[] formModelEventArray) {
            if (formModelEventArray != null && GridBagCustomizer.this.isShowing()) {
                boolean bl = false;
                for (int i = 0; i < formModelEventArray.length; ++i) {
                    if (!formModelEventArray[i].isModifying()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return;
                }
                GridBagCustomizer.this.invokeLater(3, new Runnable(){

                    public void run() {
                        GridBagCustomizer.this.containerProxy.updateAllProxies();
                    }
                });
            }
        }
    }
}

