/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.FormRefactoringUpdate;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class RefactoringInfo {
    private AbstractRefactoring refactoring;
    private ChangeType changeType;
    private FileObject primaryFile;
    private String oldName;
    private Map<FileObject, FormRefactoringUpdate> fileToUpdateMap = new HashMap<FileObject, FormRefactoringUpdate>();

    RefactoringInfo(AbstractRefactoring abstractRefactoring, ChangeType changeType, FileObject fileObject, String string) {
        this.refactoring = abstractRefactoring;
        this.changeType = changeType;
        this.primaryFile = fileObject;
        this.oldName = string;
    }

    AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public FileObject getPrimaryFile() {
        return this.primaryFile;
    }

    public boolean isForm() {
        return this.primaryFile != null && RefactoringInfo.isJavaFileOfForm(this.primaryFile);
    }

    void setOldName(String string) {
        this.oldName = string;
    }

    String getOldName() {
        return this.oldName;
    }

    String getNewName() {
        FileObject fileObject;
        if (this.refactoring instanceof RenameRefactoring) {
            return ((RenameRefactoring)this.refactoring).getNewName();
        }
        if (this.refactoring instanceof MoveRefactoring && (fileObject = this.getTargetFolder((MoveRefactoring)this.refactoring)) != null) {
            String string = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
            return string != null && string.length() > 0 ? string + "." + this.primaryFile.getName() : this.primaryFile.getName();
        }
        return null;
    }

    FileObject getTargetFolder(MoveRefactoring moveRefactoring) {
        URL uRL = (URL)moveRefactoring.getTarget().lookup(URL.class);
        FileObject fileObject = null;
        try {
            File file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
            fileObject = FileUtil.toFileObject((File)file);
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
        }
        return fileObject != null && fileObject.isFolder() ? fileObject : null;
    }

    public FormRefactoringUpdate getUpdateForFile(FileObject fileObject) {
        FormRefactoringUpdate formRefactoringUpdate = this.fileToUpdateMap.get(fileObject);
        if (formRefactoringUpdate == null) {
            assert (RefactoringInfo.isJavaFileOfForm(fileObject));
            formRefactoringUpdate = new FormRefactoringUpdate(this, fileObject);
            this.fileToUpdateMap.put(fileObject, formRefactoringUpdate);
        }
        return formRefactoringUpdate;
    }

    static boolean isJavaFile(FileObject fileObject) {
        return "text/x-java".equals(fileObject.getMIMEType());
    }

    static boolean isJavaFileOfForm(FileObject fileObject) {
        return RefactoringInfo.isJavaFile(fileObject) && fileObject.existsExt("form");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        VARIABLE_RENAME,
        CLASS_RENAME,
        CLASS_MOVE,
        CLASS_COPY,
        CLASS_DELETE,
        PACKAGE_RENAME,
        FOLDER_RENAME,
        EVENT_HANDLER_RENAME,
        OTHER_FORM_CHANGE;

    }
}

