/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormSettings;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADFormContainer;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.awt.UndoRedo;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormModel {
    private String formName;
    private boolean readOnly = false;
    static final FormVersion LATEST_VERSION = FormVersion.NB61;
    private FormVersion currentVersionLevel;
    private FormVersion lastVersionLevel;
    private FormVersion maxVersionLevel;
    private Class<?> formBaseClass;
    private RADComponent topRADComponent;
    private List<RADComponent> otherComponents = new ArrayList<RADComponent>(10);
    private ComponentContainer modelContainer;
    private LayoutModel layoutModel;
    private Map<String, RADComponent> idToComponents = new HashMap<String, RADComponent>();
    private boolean formLoaded = false;
    private UndoRedo.Manager undoRedoManager;
    private boolean undoRedoRecording = false;
    private CompoundEdit compoundEdit;
    private boolean undoCompoundEdit = false;
    private FormEvents formEvents;
    private ArrayList<FormModelListener> listeners;
    private List<FormModelEvent> eventList;
    private boolean firing;
    private MetaComponentCreator metaCreator;
    private CodeStructure codeStructure = new CodeStructure(false);
    private FormSettings settings = new FormSettings(this);
    private boolean freeDesignDefaultLayout = false;
    private static int traceCount = 0;
    private static final boolean TRACE = false;

    FormModel() {
    }

    public void setFormBaseClass(Class<?> clazz) throws Exception {
        if (this.formBaseClass != null) {
            throw new IllegalStateException("Form type already initialized.");
        }
        RADComponent rADComponent = FormUtils.isVisualizableClass(clazz) ? (FormUtils.isContainer(clazz) ? new RADVisualFormContainer() : new RADVisualComponent(){

            public String getName() {
                return FormUtils.getBundleString("CTL_FormTopContainerName");
            }

            public void setName(String string) {
            }
        }) : (Object.class != clazz ? new RADFormContainer() : null);
        if (rADComponent != null) {
            this.topRADComponent = rADComponent;
            rADComponent.initialize(this);
            rADComponent.initInstance(clazz);
            rADComponent.setInModel(true);
        }
        this.formBaseClass = clazz;
        this.layoutModel = new LayoutModel();
        this.layoutModel.setChangeRecording(false);
    }

    public Class<?> getFormBaseClass() {
        return this.formBaseClass;
    }

    void setName(String string) {
        this.formName = string;
    }

    public void raiseVersionLevel(FormVersion formVersion, FormVersion formVersion2) {
        if (formVersion.ordinal() > this.currentVersionLevel.ordinal() && (this.undoRedoRecording || !this.formLoaded)) {
            assert (formVersion2.ordinal() >= formVersion.ordinal());
            this.setCurrentVersionLevel(formVersion2);
        }
    }

    void setCurrentVersionLevel(FormVersion formVersion) {
        this.lastVersionLevel = this.currentVersionLevel;
        this.currentVersionLevel = formVersion;
    }

    FormVersion getCurrentVersionLevel() {
        return this.currentVersionLevel;
    }

    void revertVersionLevel() {
        this.currentVersionLevel = this.lastVersionLevel;
    }

    void setMaxVersionLevel(FormVersion formVersion) {
        this.maxVersionLevel = formVersion;
    }

    FormVersion getMaxVersionLevel() {
        return this.maxVersionLevel;
    }

    void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public final String getName() {
        return this.formName;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isFormLoaded() {
        return this.formLoaded;
    }

    public final boolean wasCorrected() {
        return this.formLoaded && this.layoutModel != null && this.layoutModel.wasCorrected();
    }

    public final RADComponent getTopRADComponent() {
        return this.topRADComponent;
    }

    public ComponentContainer getModelContainer() {
        if (this.modelContainer == null) {
            this.modelContainer = new ModelContainer();
        }
        return this.modelContainer;
    }

    public Collection<RADComponent> getOtherComponents() {
        return Collections.unmodifiableCollection(this.otherComponents);
    }

    public final LayoutModel getLayoutModel() {
        return this.layoutModel;
    }

    public final RADComponent getMetaComponent(String string) {
        return this.idToComponents.get(string);
    }

    public RADComponent findRADComponent(String string) {
        for (RADComponent rADComponent : this.idToComponents.values()) {
            if (!string.equals(rADComponent.getName())) continue;
            return rADComponent;
        }
        return null;
    }

    public List<RADComponent> getComponentList() {
        return new ArrayList<RADComponent>(this.idToComponents.values());
    }

    public List<RADComponent> getOrderedComponentList() {
        ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>(this.idToComponents.size());
        FormModel.collectMetaComponents(this.getModelContainer(), arrayList);
        return arrayList;
    }

    public Collection<RADComponent> getAllComponents() {
        return Collections.unmodifiableCollection(this.idToComponents.values());
    }

    public List<RADComponent> getNonVisualComponents() {
        ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>(this.otherComponents.size());
        for (RADComponent rADComponent : this.otherComponents) {
            if (rADComponent instanceof RADVisualComponent) continue;
            arrayList.add(rADComponent);
        }
        return arrayList;
    }

    public List<RADComponent> getVisualComponents() {
        ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>(this.idToComponents.size());
        for (Map.Entry<String, RADComponent> entry : this.idToComponents.entrySet()) {
            RADComponent rADComponent = entry.getValue();
            if (!(rADComponent instanceof RADVisualComponent)) continue;
            arrayList.add(rADComponent);
        }
        return arrayList;
    }

    public FormEvents getFormEvents() {
        if (this.formEvents == null) {
            this.formEvents = new FormEvents(this);
        }
        return this.formEvents;
    }

    private static void collectMetaComponents(ComponentContainer componentContainer, List<RADComponent> list) {
        RADComponent[] rADComponentArray = componentContainer.getSubBeans();
        for (int i = 0; i < rADComponentArray.length; ++i) {
            RADComponent rADComponent = rADComponentArray[i];
            list.add(rADComponent);
            if (!(rADComponent instanceof ComponentContainer)) continue;
            FormModel.collectMetaComponents((ComponentContainer)((Object)rADComponent), list);
        }
    }

    private static void collectVisualMetaComponents(RADVisualContainer rADVisualContainer, List<RADComponent> list) {
        RADVisualComponent[] rADVisualComponentArray = rADVisualContainer.getSubComponents();
        for (int i = 0; i < rADVisualComponentArray.length; ++i) {
            RADVisualComponent rADVisualComponent = rADVisualComponentArray[i];
            list.add(rADVisualComponent);
            if (!(rADVisualComponent instanceof RADVisualContainer)) continue;
            FormModel.collectVisualMetaComponents((RADVisualContainer)rADVisualComponent, list);
        }
    }

    public FormSettings getSettings() {
        return this.settings;
    }

    public MetaComponentCreator getComponentCreator() {
        if (this.metaCreator == null) {
            this.metaCreator = new MetaComponentCreator(this);
        }
        return this.metaCreator;
    }

    public void addComponent(RADComponent rADComponent, ComponentContainer componentContainer, boolean bl) {
        if (bl || !rADComponent.isInModel()) {
            FormModel.setInModelRecursively(rADComponent, true);
            bl = true;
        }
        if (componentContainer != null) {
            componentContainer.add(rADComponent);
        } else {
            rADComponent.setParentComponent(null);
            this.otherComponents.add(rADComponent);
        }
        if (!bl && rADComponent instanceof RADVisualComponent) {
            ((RADVisualComponent)rADComponent).resetConstraintsProperties();
        }
        this.fireComponentAdded(rADComponent, bl);
    }

    public void addVisualComponent(RADVisualComponent rADVisualComponent, RADVisualContainer rADVisualContainer, Object object, boolean bl) {
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        if (layoutSupportManager != null) {
            int n;
            RADVisualComponent[] rADVisualComponentArray = new RADVisualComponent[]{rADVisualComponent};
            LayoutConstraints layoutConstraints = object instanceof LayoutConstraints ? (LayoutConstraints)object : null;
            LayoutConstraints[] layoutConstraintsArray = new LayoutConstraints[]{layoutConstraints};
            int n2 = n = object instanceof Integer ? (Integer)object : -1;
            if (bl || !rADVisualComponent.isInModel()) {
                FormModel.setInModelRecursively(rADVisualComponent, true);
                bl = true;
            }
            try {
                layoutSupportManager.acceptNewComponents(rADVisualComponentArray, layoutConstraintsArray, n);
            }
            catch (RuntimeException runtimeException) {
                if (bl) {
                    FormModel.setInModelRecursively(rADVisualComponent, false);
                }
                throw runtimeException;
            }
            rADVisualContainer.add(rADVisualComponent, n);
            layoutSupportManager.addComponents(rADVisualComponentArray, layoutConstraintsArray, n);
            this.fireComponentAdded(rADVisualComponent, bl);
        } else {
            this.addComponent(rADVisualComponent, rADVisualContainer, bl);
        }
    }

    void setContainerLayoutImpl(RADVisualContainer rADVisualContainer, LayoutSupportDelegate layoutSupportDelegate) throws Exception {
        LayoutSupportDelegate layoutSupportDelegate2;
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        LayoutSupportDelegate layoutSupportDelegate3 = layoutSupportDelegate2 = layoutSupportManager != null ? layoutSupportManager.getLayoutDelegate() : null;
        if (layoutSupportManager == null) {
            rADVisualContainer.setOldLayoutSupport(true);
        }
        try {
            rADVisualContainer.setLayoutSupportDelegate(layoutSupportDelegate);
        }
        catch (Exception exception) {
            if (layoutSupportManager == null) {
                rADVisualContainer.setOldLayoutSupport(false);
            }
            throw exception;
        }
        this.fireContainerLayoutExchanged(rADVisualContainer, layoutSupportDelegate2, layoutSupportDelegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainerLayout(RADVisualContainer rADVisualContainer, LayoutSupportDelegate layoutSupportDelegate) throws Exception {
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        this.setContainerLayoutImpl(rADVisualContainer, layoutSupportDelegate);
        if (layoutSupportManager == null) {
            Object object = this.layoutModel.getChangeMark();
            UndoableEdit undoableEdit = this.layoutModel.getUndoableEdit();
            boolean bl = true;
            try {
                this.layoutModel.changeContainerToComponent(rADVisualContainer.getId());
                bl = false;
            }
            finally {
                if (object != null && !object.equals(this.layoutModel.getChangeMark())) {
                    this.addUndoableEdit(undoableEdit);
                }
                if (bl) {
                    this.forceUndoOfCompoundEdit();
                }
            }
        }
    }

    void setNaturalContainerLayoutImpl(RADVisualContainer rADVisualContainer) {
        LayoutSupportDelegate layoutSupportDelegate = rADVisualContainer.getLayoutSupport().getLayoutDelegate();
        rADVisualContainer.setOldLayoutSupport(false);
        this.fireContainerLayoutExchanged(rADVisualContainer, layoutSupportDelegate, null);
        for (RADVisualComponent rADVisualComponent : rADVisualContainer.getSubComponents()) {
            rADVisualComponent.resetConstraintsProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNaturalContainerLayout(RADVisualContainer rADVisualContainer) {
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        if (layoutSupportManager == null) {
            return;
        }
        this.setNaturalContainerLayoutImpl(rADVisualContainer);
        Object object = this.layoutModel.getChangeMark();
        UndoableEdit undoableEdit = this.layoutModel.getUndoableEdit();
        boolean bl = true;
        try {
            if (!this.layoutModel.changeComponentToContainer(rADVisualContainer.getId())) {
                this.layoutModel.addRootComponent(new LayoutComponent(rADVisualContainer.getId(), true));
            }
            bl = false;
        }
        finally {
            if (object != null && !object.equals(this.layoutModel.getChangeMark())) {
                this.addUndoableEdit(undoableEdit);
            }
            if (bl) {
                this.forceUndoOfCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponent(RADComponent rADComponent, boolean bl) {
        Object object = null;
        UndoableEdit undoableEdit = null;
        boolean bl2 = true;
        try {
            if (bl && this.layoutModel != null) {
                object = this.layoutModel.getChangeMark();
                undoableEdit = this.layoutModel.getUndoableEdit();
                this.layoutModel.removeComponent(rADComponent.getId(), true);
                this.removeLayoutComponentsRecursively(rADComponent);
            }
            bl2 = false;
        }
        finally {
            this.removeComponentImpl(rADComponent, bl);
            if (object != null && !object.equals(this.layoutModel.getChangeMark())) {
                this.addUndoableEdit(undoableEdit);
            }
            if (bl2) {
                this.forceUndoOfCompoundEdit();
            }
        }
    }

    void removeComponentImpl(RADComponent rADComponent, boolean bl) {
        RADComponent rADComponent2;
        if (bl && this.formEvents != null) {
            this.removeEventHandlersRecursively(rADComponent);
        }
        ComponentContainer componentContainer = (rADComponent2 = rADComponent.getParentComponent()) instanceof ComponentContainer ? (ComponentContainer)((Object)rADComponent2) : this.getModelContainer();
        int n = componentContainer.getIndexOf(rADComponent);
        componentContainer.remove(rADComponent);
        if (bl) {
            FormModel.setInModelRecursively(rADComponent, false);
        }
        FormModelEvent formModelEvent = this.fireComponentRemoved(rADComponent, componentContainer, n, bl);
    }

    private void removeLayoutComponentsRecursively(RADComponent rADComponent) {
        RADComponent[] rADComponentArray;
        if (rADComponent instanceof ComponentContainer) {
            rADComponentArray = ((ComponentContainer)((Object)rADComponent)).getSubBeans();
            for (int i = 0; i < rADComponentArray.length; ++i) {
                this.removeLayoutComponentsRecursively(rADComponentArray[i]);
            }
        }
        RADComponent[] rADComponentArray2 = rADComponentArray = this.layoutModel == null ? null : this.layoutModel.getLayoutComponent(rADComponent.getId());
        if (rADComponentArray != null && rADComponentArray.getParent() == null) {
            this.layoutModel.removeComponent(rADComponentArray.getId(), true);
        }
    }

    void updateMapping(RADComponent rADComponent, boolean bl) {
        if (bl) {
            this.idToComponents.put(rADComponent.getId(), rADComponent);
        } else {
            this.idToComponents.remove(rADComponent.getId());
        }
    }

    private void removeEventHandlersRecursively(RADComponent rADComponent) {
        int n;
        Object[] objectArray;
        if (rADComponent instanceof ComponentContainer) {
            objectArray = ((ComponentContainer)((Object)rADComponent)).getSubBeans();
            for (n = 0; n < objectArray.length; ++n) {
                this.removeEventHandlersRecursively((RADComponent)objectArray[n]);
            }
        }
        objectArray = rADComponent.getKnownEvents();
        for (n = 0; n < objectArray.length; ++n) {
            if (!((Event)objectArray[n]).hasEventHandlers()) continue;
            this.getFormEvents().detachEvent((Event)objectArray[n]);
        }
    }

    static void setInModelRecursively(RADComponent rADComponent, boolean bl) {
        if (rADComponent instanceof ComponentContainer) {
            RADComponent[] rADComponentArray = ((ComponentContainer)((Object)rADComponent)).getSubBeans();
            for (int i = 0; i < rADComponentArray.length; ++i) {
                FormModel.setInModelRecursively(rADComponentArray[i], bl);
            }
        }
        rADComponent.setInModel(bl);
    }

    public void setUndoRedoRecording(boolean bl) {
        FormModel.t("turning undo/redo recording " + (bl ? "on" : "off"));
        this.undoRedoRecording = bl;
    }

    public boolean isUndoRedoRecording() {
        return this.undoRedoRecording;
    }

    private void startCompoundEdit() {
        if (this.compoundEdit == null) {
            FormModel.t("starting compound edit");
            this.compoundEdit = new CompoundEdit();
        }
    }

    public CompoundEdit endCompoundEdit(boolean bl) {
        if (this.compoundEdit != null) {
            FormModel.t("ending compound edit: " + bl);
            this.compoundEdit.end();
            if (bl && this.undoRedoRecording && this.compoundEdit.isSignificant()) {
                this.getUndoRedoManager().undoableEditHappened(new UndoableEditEvent(this, this.compoundEdit));
            }
            CompoundEdit compoundEdit = this.compoundEdit;
            this.compoundEdit = null;
            return compoundEdit;
        }
        return null;
    }

    public void forceUndoOfCompoundEdit() {
        if (this.compoundEdit != null) {
            this.undoCompoundEdit = true;
        }
    }

    public boolean isCompoundEditInProgress() {
        return this.compoundEdit != null;
    }

    public void addUndoableEdit(UndoableEdit undoableEdit) {
        FormModel.t("adding undoable edit");
        if (!this.isCompoundEditInProgress()) {
            this.startCompoundEdit();
        }
        this.compoundEdit.addEdit(undoableEdit);
    }

    UndoRedo.Manager getUndoRedoManager() {
        return this.undoRedoManager;
    }

    public synchronized void addFormModelListener(FormModelListener formModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(formModelListener);
    }

    public synchronized void removeFormModelListener(FormModelListener formModelListener) {
        if (this.listeners != null) {
            this.listeners.remove(formModelListener);
        }
    }

    public void fireFormLoaded() {
        FormModel.t("firing form loaded");
        this.formLoaded = true;
        if (!this.readOnly && !Boolean.getBoolean("netbeans.form.no_undo")) {
            this.undoRedoManager = new UndoRedoManager();
            this.undoRedoManager.setLimit(50);
            this.setUndoRedoRecording(true);
            if (this.layoutModel != null) {
                this.layoutModel.setChangeRecording(true);
            }
        }
        this.sendEventLater(new FormModelEvent(this, 1));
    }

    public void fireFormToBeSaved() {
        FormModel.t("firing form to be saved");
        this.sendEventImmediately(new FormModelEvent(this, 2));
    }

    public void fireFormToBeClosed() {
        FormModel.t("firing form to be closed");
        if (this.undoRedoManager != null) {
            this.undoRedoManager.discardAllEdits();
        }
        this.sendEventImmediately(new FormModelEvent(this, 3));
    }

    public FormModelEvent fireContainerLayoutExchanged(RADVisualContainer rADVisualContainer, LayoutSupportDelegate layoutSupportDelegate, LayoutSupportDelegate layoutSupportDelegate2) {
        FormModel.t("firing container layout exchange, container: " + (rADVisualContainer != null ? rADVisualContainer.getName() : "null"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 4);
        formModelEvent.setLayout(rADVisualContainer, layoutSupportDelegate, layoutSupportDelegate2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADVisualContainer != null && layoutSupportDelegate != layoutSupportDelegate2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireContainerLayoutChanged(RADVisualContainer rADVisualContainer, String string, Object object, Object object2) {
        FormModel.t("firing container layout change, container: " + (rADVisualContainer != null ? rADVisualContainer.getName() : "null") + ", property: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 5);
        formModelEvent.setComponentAndContainer(rADVisualContainer, rADVisualContainer);
        formModelEvent.setProperty(string, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADVisualContainer != null && (string == null || object != object2)) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentLayoutChanged(RADVisualComponent rADVisualComponent, String string, Object object, Object object2) {
        FormModel.t("firing component layout change: " + (rADVisualComponent != null ? rADVisualComponent.getName() : "null"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 6);
        formModelEvent.setComponentAndContainer(rADVisualComponent, null);
        formModelEvent.setProperty(string, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADVisualComponent != null && string != null && object != object2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentAdded(RADComponent rADComponent, boolean bl) {
        FormModel.t("firing component added: " + (rADComponent != null ? rADComponent.getName() : "null"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 7);
        formModelEvent.setAddData(rADComponent, null, bl);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADComponent != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentRemoved(RADComponent rADComponent, ComponentContainer componentContainer, int n, boolean bl) {
        FormModel.t("firing component removed: " + (rADComponent != null ? rADComponent.getName() : "null"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 8);
        formModelEvent.setRemoveData(rADComponent, componentContainer, n, bl);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADComponent != null && componentContainer != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentsReordered(ComponentContainer componentContainer, int[] nArray) {
        FormModel.t("firing components reorder in container: " + (componentContainer instanceof RADComponent ? ((RADComponent)((Object)componentContainer)).getName() : "<top>"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 9);
        formModelEvent.setComponentAndContainer(null, componentContainer);
        formModelEvent.setReordering(nArray);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && componentContainer != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentPropertyChanged(RADComponent rADComponent, String string, Object object, Object object2) {
        FormModel.t("firing component property change, component: " + (rADComponent != null ? rADComponent.getName() : "<null component>") + ", property: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 10);
        formModelEvent.setComponentAndContainer(rADComponent, null);
        formModelEvent.setProperty(string, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADComponent != null && string != null && object != object2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireBindingChanged(RADComponent rADComponent, String string, String string2, Object object, Object object2) {
        FormModelEvent formModelEvent = new FormModelEvent(this, 16);
        formModelEvent.setComponentAndContainer(rADComponent, null);
        formModelEvent.setProperty(string, object, object2);
        formModelEvent.setSubProperty(string2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && object != object2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireSyntheticPropertyChanged(RADComponent rADComponent, String string, Object object, Object object2) {
        FormModel.t("firing synthetic property change, component: " + (rADComponent != null ? rADComponent.getName() : "null") + ", property: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 11);
        formModelEvent.setComponentAndContainer(rADComponent, null);
        formModelEvent.setProperty(string, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && string != null && object != object2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireEventHandlerAdded(Event event, String string, String string2, String string3, boolean bl) {
        FormModel.t("event handler added: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 12);
        formModelEvent.setEvent(event, string, string2, string3, bl);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && event != null && string != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireEventHandlerRemoved(Event event, String string, boolean bl) {
        FormModel.t("firing event handler removed: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 13);
        formModelEvent.setEvent(event, string, null, null, bl);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && event != null && string != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireEventHandlerRenamed(String string, String string2) {
        FormModel.t("event handler renamed: " + string + " to " + string2);
        FormModelEvent formModelEvent = new FormModelEvent(this, 14);
        formModelEvent.setEvent(string, string2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && string != null && string2 != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireFormChanged(boolean bl) {
        FormModel.t("firing form change");
        FormModelEvent formModelEvent = new FormModelEvent(this, 15);
        if (bl) {
            this.sendEventImmediately(formModelEvent);
        } else {
            this.sendEvent(formModelEvent);
        }
        return formModelEvent;
    }

    private void sendEvent(FormModelEvent formModelEvent) {
        if (this.formLoaded) {
            if (this.eventList != null || formModelEvent.isModifying()) {
                this.sendEventLater(formModelEvent);
            } else {
                this.sendEventImmediately(formModelEvent);
            }
        } else {
            this.fireEvents(formModelEvent);
        }
    }

    private synchronized void sendEventLater(FormModelEvent formModelEvent) {
        if (!EventQueue.isDispatchThread()) {
            this.sendEventImmediately(formModelEvent);
            return;
        }
        if (this.eventList == null) {
            this.eventList = new ArrayList<FormModelEvent>();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FormModel.this.firePendingEvents();
                }
            });
        }
        this.eventList.add(formModelEvent);
    }

    private synchronized void sendEventImmediately(FormModelEvent formModelEvent) {
        if (this.eventList == null) {
            this.eventList = new ArrayList<FormModelEvent>();
        }
        this.eventList.add(formModelEvent);
        this.firePendingEvents();
    }

    private void firePendingEvents() {
        List<FormModelEvent> list = this.pickUpEvents();
        if (list != null && !list.isEmpty()) {
            FormModelEvent[] formModelEventArray = new FormModelEvent[list.size()];
            list.toArray(formModelEventArray);
            this.fireEventBatch(formModelEventArray);
        }
    }

    private synchronized List<FormModelEvent> pickUpEvents() {
        List<FormModelEvent> list = this.eventList;
        this.eventList = null;
        return list;
    }

    boolean hasPendingEvents() {
        return this.eventList != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEventBatch(FormModelEvent ... formModelEventArray) {
        block6: {
            block5: {
                boolean bl;
                if (this.firing) break block5;
                boolean bl2 = false;
                try {
                    this.firing = true;
                    if (!this.undoCompoundEdit) {
                        bl2 = true;
                        this.fireEvents(formModelEventArray);
                        bl2 = false;
                    }
                    this.firing = false;
                    bl = this.undoCompoundEdit || bl2;
                }
                catch (Throwable throwable) {
                    this.firing = false;
                    boolean bl3 = this.undoCompoundEdit || bl2;
                    this.undoCompoundEdit = false;
                    CompoundEdit compoundEdit = this.endCompoundEdit(!bl3);
                    if (compoundEdit != null && bl3) {
                        compoundEdit.undo();
                    }
                    throw throwable;
                }
                this.undoCompoundEdit = false;
                CompoundEdit compoundEdit = this.endCompoundEdit(!bl);
                if (compoundEdit != null && bl) {
                    compoundEdit.undo();
                }
                break block6;
            }
            this.fireEvents(formModelEventArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEvents(FormModelEvent ... formModelEventArray) {
        ArrayList arrayList;
        FormModel formModel = this;
        synchronized (formModel) {
            if (this.listeners == null || this.listeners.size() == 0) {
                return;
            }
            arrayList = (ArrayList)this.listeners.clone();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            FormModelListener formModelListener = (FormModelListener)arrayList.get(i);
            formModelListener.formChanged(formModelEventArray);
        }
    }

    public CodeStructure getCodeStructure() {
        return this.codeStructure;
    }

    public boolean isFreeDesignDefaultLayout() {
        return this.freeDesignDefaultLayout;
    }

    void setFreeDesignDefaultLayout(boolean bl) {
        this.freeDesignDefaultLayout = bl;
    }

    static void t(String string) {
    }

    final class ModelContainer
    implements ComponentContainer {
        ModelContainer() {
        }

        public RADComponent[] getSubBeans() {
            int n = FormModel.this.otherComponents.size();
            if (FormModel.this.topRADComponent != null) {
                ++n;
            }
            RADComponent[] rADComponentArray = new RADComponent[n];
            FormModel.this.otherComponents.toArray(rADComponentArray);
            if (FormModel.this.topRADComponent != null) {
                rADComponentArray[n - 1] = FormModel.this.topRADComponent;
            }
            return rADComponentArray;
        }

        public void initSubComponents(RADComponent[] rADComponentArray) {
            FormModel.this.otherComponents.clear();
            for (int i = 0; i < rADComponentArray.length; ++i) {
                if (rADComponentArray[i] == FormModel.this.topRADComponent) continue;
                FormModel.this.otherComponents.add(rADComponentArray[i]);
            }
        }

        public void reorderSubComponents(int[] nArray) {
            RADComponent[] rADComponentArray = new RADComponent[FormModel.this.otherComponents.size()];
            for (int i = 0; i < nArray.length; ++i) {
                rADComponentArray[nArray[i]] = (RADComponent)FormModel.this.otherComponents.get(i);
            }
            FormModel.this.otherComponents.clear();
            FormModel.this.otherComponents.addAll(Arrays.asList(rADComponentArray));
        }

        public void add(RADComponent rADComponent) {
            rADComponent.setParentComponent(null);
            FormModel.this.otherComponents.add(rADComponent);
        }

        public void remove(RADComponent rADComponent) {
            if (FormModel.this.otherComponents.remove(rADComponent)) {
                rADComponent.setParentComponent(null);
            }
        }

        public int getIndexOf(RADComponent rADComponent) {
            int n = FormModel.this.otherComponents.indexOf(rADComponent);
            if (n < 0 && rADComponent == FormModel.this.topRADComponent) {
                n = FormModel.this.otherComponents.size();
            }
            return n;
        }
    }

    class UndoRedoManager
    extends UndoRedo.Manager {
        private Mutex.ExceptionAction<Object> runUndo = new Mutex.ExceptionAction<Object>(){

            public Object run() throws Exception {
                UndoRedoManager.this.superUndo();
                return null;
            }
        };
        private Mutex.ExceptionAction<Object> runRedo = new Mutex.ExceptionAction<Object>(){

            public Object run() throws Exception {
                UndoRedoManager.this.superRedo();
                return null;
            }
        };

        UndoRedoManager() {
        }

        public void superUndo() throws CannotUndoException {
            super.undo();
        }

        public void superRedo() throws CannotRedoException {
            super.redo();
        }

        public void undo() throws CannotUndoException {
            if (EventQueue.isDispatchThread()) {
                this.superUndo();
            } else {
                try {
                    Mutex.EVENT.readAccess(this.runUndo);
                }
                catch (MutexException mutexException) {
                    Exception exception = mutexException.getException();
                    if (exception instanceof CannotUndoException) {
                        throw (CannotUndoException)exception;
                    }
                    exception.printStackTrace();
                }
            }
        }

        public void redo() throws CannotRedoException {
            if (EventQueue.isDispatchThread()) {
                this.superRedo();
            } else {
                try {
                    Mutex.EVENT.readAccess(this.runRedo);
                }
                catch (MutexException mutexException) {
                    Exception exception = mutexException.getException();
                    if (exception instanceof CannotRedoException) {
                        throw (CannotRedoException)exception;
                    }
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FormVersion {
        BASIC,
        NB50,
        NB60_PRE,
        NB60,
        NB61;

    }
}

