/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.EventProperty;
import org.netbeans.modules.form.FormUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Utilities;

public class EventCustomEditor
extends JPanel {
    static final long serialVersionUID = -4825059521634962952L;
    private JButton addButton;
    private JButton editButton;
    private JList handlersList;
    private JLabel handlersListLabel;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    EventProperty eventProperty;
    DefaultListModel handlersModel = new DefaultListModel();
    EventProperty.Change changes = new EventProperty.Change();

    EventCustomEditor(EventProperty eventProperty) {
        this.eventProperty = eventProperty;
        this.initComponents();
        this.enableButtons();
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)FormUtils.getBundleString("CTL_EE_ADD"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)FormUtils.getBundleString("CTL_EE_REMOVE"));
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)FormUtils.getBundleString("CTL_EE_RENAME"));
        Mnemonics.setLocalizedText((JLabel)this.handlersListLabel, (String)FormUtils.getBundleString("CTL_EE_Handlers"));
        this.handlersList.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_EE_Handlers"));
        this.addButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_EE_ADD"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_EE_REMOVE"));
        this.editButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_EE_RENAME"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_EventCustomEditor"));
    }

    private void initComponents() {
        this.handlersListLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        String[] stringArray = this.eventProperty.getEventHandlers();
        for (int i = 0; i < stringArray.length; ++i) {
            this.handlersModel.addElement(stringArray[i]);
        }
        this.handlersList = new JList();
        this.handlersList.setModel(this.handlersModel);
        if (stringArray.length > 0) {
            this.handlersList.setSelectedIndex(0);
        }
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.editButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(300, 300));
        this.handlersListLabel.setLabelFor(this.handlersList);
        this.handlersListLabel.setText("Handlers");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 2, 0);
        this.add((Component)this.handlersListLabel, gridBagConstraints);
        this.handlersList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EventCustomEditor.this.handlersListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.handlersList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addButton.setText("Add...");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventCustomEditor.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventCustomEditor.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.editButton.setText("Rename...");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventCustomEditor.this.editButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.add((Component)this.editButton, gridBagConstraints);
    }

    private void handlersListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    private void enableButtons() {
        if (this.handlersList.isSelectionEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
        this.editButton.setEnabled(this.handlersList.getSelectedIndices().length == 1);
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.handlersList.getSelectedIndex();
        if (n >= 0) {
            String string = (String)this.handlersModel.get(n);
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(FormUtils.getBundleString("CTL_EE_RENAME_LABEL"), FormUtils.getBundleString("CTL_EE_RENAME_CAPTION"));
            inputLine.setInputText(string);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine).equals(NotifyDescriptor.OK_OPTION)) {
                String string2 = inputLine.getInputText();
                if (string2.equals(string)) {
                    return;
                }
                if (!Utilities.isJavaIdentifier((String)string2)) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)FormUtils.getBundleString("CTL_EE_NOT_IDENTIFIER"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
                if (this.handlersModel.indexOf(string2) >= 0) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)FormUtils.getBundleString("CTL_EE_ALREADY_EXIST"), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
                int n2 = this.changes.getAdded().indexOf(string);
                if (n2 >= 0) {
                    this.changes.getAdded().set(n2, string2);
                } else {
                    n2 = this.changes.getRenamedNewNames().indexOf(string);
                    if (n2 >= 0) {
                        this.changes.getRenamedNewNames().set(n2, string2);
                    } else {
                        this.changes.getRenamedOldNames().add(string);
                        this.changes.getRenamedNewNames().add(string2);
                    }
                }
                this.handlersModel.set(n, string2);
                this.handlersList.setSelectedIndex(n);
                this.enableButtons();
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.handlersList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            int n = this.changes.getAdded().indexOf(objectArray[i]);
            if (n >= 0) {
                this.changes.getAdded().remove(n);
            } else {
                String string;
                n = this.changes.getRenamedNewNames().indexOf(objectArray[i]);
                if (n >= 0) {
                    this.changes.getRenamedNewNames().remove(n);
                    string = this.changes.getRenamedOldNames().get(n);
                    this.changes.getRenamedOldNames().remove(n);
                } else {
                    string = (String)objectArray[i];
                }
                this.changes.getRemoved().add(string);
            }
            this.handlersModel.removeElement(objectArray[i]);
            this.enableButtons();
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(FormUtils.getBundleString("CTL_EE_ADD_LABEL"), FormUtils.getBundleString("CTL_EE_ADD_CAPTION"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine).equals(NotifyDescriptor.OK_OPTION)) {
            String string = inputLine.getInputText();
            if (!Utilities.isJavaIdentifier((String)string)) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)FormUtils.getBundleString("CTL_EE_NOT_IDENTIFIER"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            if (this.handlersModel.indexOf(string) >= 0) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)FormUtils.getBundleString("CTL_EE_ALREADY_EXIST"), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            int n = this.changes.getRemoved().indexOf(string);
            if (n >= 0) {
                this.changes.getRemoved().remove(n);
            } else {
                this.changes.getAdded().add(string);
            }
            this.handlersModel.addElement(string);
            this.handlersList.setSelectedIndex(this.handlersModel.size() - 1);
            this.enableButtons();
        }
    }

    public void doChanges() {
        try {
            this.eventProperty.setValue(this.changes);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

