/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.EventSetDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.RADComponent;

public class Event {
    private static String[] NO_HANDLERS = new String[0];
    private RADComponent component;
    private EventSetDescriptor eventSetDescriptor;
    private Method listenerMethod;
    private boolean inCEDL;
    private List<String> eventHandlers;

    Event(RADComponent rADComponent, EventSetDescriptor eventSetDescriptor, Method method) {
        this.component = rADComponent;
        this.eventSetDescriptor = eventSetDescriptor;
        this.listenerMethod = method;
    }

    public String getName() {
        return this.listenerMethod.getName();
    }

    public String getId() {
        return FormEvents.getEventIdName(this.listenerMethod);
    }

    public final RADComponent getComponent() {
        return this.component;
    }

    public final EventSetDescriptor getEventSetDescriptor() {
        return this.eventSetDescriptor;
    }

    public final Method getListenerMethod() {
        return this.listenerMethod;
    }

    public boolean hasEventHandlers() {
        return this.eventHandlers != null && this.eventHandlers.size() > 0;
    }

    public boolean hasEventHandler(String string) {
        return this.eventHandlers != null ? this.eventHandlers.contains(string) : false;
    }

    public String[] getEventHandlers() {
        if (this.eventHandlers == null || this.eventHandlers.size() == 0) {
            return NO_HANDLERS;
        }
        String[] stringArray = new String[this.eventHandlers.size()];
        this.eventHandlers.toArray(stringArray);
        return stringArray;
    }

    public final boolean isInCEDL() {
        return this.inCEDL;
    }

    void setInCEDL(boolean bl) {
        this.inCEDL = bl;
    }

    boolean addEventHandler(String string) {
        if (this.eventHandlers == null) {
            this.eventHandlers = new ArrayList<String>(1);
        } else if (this.eventHandlers.contains(string)) {
            return false;
        }
        this.eventHandlers.add(string);
        return true;
    }

    boolean removeEventHandler(String string) {
        return this.eventHandlers != null && this.eventHandlers.remove(string);
    }

    boolean renameEventHandler(String string, String string2) {
        if (this.eventHandlers == null) {
            return false;
        }
        int n = this.eventHandlers.indexOf(string);
        if (n < 0 || this.eventHandlers.contains(string2)) {
            return false;
        }
        this.eventHandlers.set(n, string2);
        return true;
    }

    List getEventHandlerList() {
        return this.eventHandlers;
    }
}

