/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.form.BindingDescriptor;
import org.netbeans.modules.form.BindingDesignSupport;
import org.netbeans.modules.form.BindingProperty;
import org.netbeans.modules.form.ComboBoxWithTree;
import org.netbeans.modules.form.DataImporter;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.ListSelector;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class BindingCustomizer
extends JPanel {
    private BindingDesignSupport designSupport;
    private RADComponent bindingComponent;
    private BindingDescriptor bindingDescriptor;
    private MetaBinding binding;
    private RADComponent selectedComponent;
    private List<RADComponent> allComponents;
    private FormProperty nullValueProperty;
    private FormProperty incompletePathValueProperty;
    private FormProperty converterProperty;
    private FormProperty validatorProperty;
    private FormProperty nameProperty;
    private FormProperty.ValueWithEditor oldNullValue;
    private FormProperty.ValueWithEditor oldIncompletePathValue;
    private FormProperty.ValueWithEditor oldConverter;
    private FormProperty.ValueWithEditor oldValidator;
    private FormProperty.ValueWithEditor oldName;
    private ComboBoxWithTree expressionCombo;
    private ComboBoxWithTree displayExpressionCombo;
    private ListSelector columnSelector;
    private DefaultTreeModel expressionModel = new DefaultTreeModel(new DefaultMutableTreeNode(null, false));
    private DefaultTreeModel displayExpressionModel = new DefaultTreeModel(new DefaultMutableTreeNode(null, false));
    private Dialog dialog;
    private ActionListener dialogListener;
    private JButton okButton;
    private JButton cancelButton;
    private PropertyChangeSupport typeChangeSupport = new PropertyChangeSupport(this);
    JPanel advancedPanel;
    JPanel bindingPanel;
    JLabel conversionLabel;
    JLabel converterLabel;
    JLabel converterMessage;
    PropertyPanel converterPanel;
    JPanel detailPanel;
    JLabel displayExpressionLabel;
    JLabel displayValuesLabel;
    JLabel expressionLabel;
    JLabel identificationLabel;
    JCheckBox ignoreAdjustingChoice;
    JButton importDataButton;
    JCheckBox incompletePathValueCheckBox;
    PropertyPanel incompletePathValuePanel;
    JLabel infoLabel;
    JLabel nameLabel;
    PropertyPanel namePanel;
    JCheckBox nullValueCheckBox;
    PropertyPanel nullValuePanel;
    JComboBox sourceCombo;
    JLabel sourceLabel;
    JLabel specialValuesLabel;
    JTabbedPane tabbedPane;
    JComboBox treeCombo;
    JComboBox treeCombo2;
    JLabel updateLabel;
    JComboBox updateModeCombo;
    JLabel updateModeLabel;
    JLabel updatePropertiesLabel;
    JComboBox updateWhenCombo;
    JLabel updateWhenLabel;
    JLabel validationLabel;
    JLabel validatorLabel;
    JLabel validatorMessage;
    PropertyPanel validatorPanel;
    private Map<String, String> columnToType;
    private FormUtils.TypeHelper lastElemType;

    public BindingCustomizer(BindingProperty bindingProperty) {
        this.bindingComponent = bindingProperty.getBindingComponent();
        this.bindingDescriptor = bindingProperty.getBindingDescriptor();
        this.designSupport = FormEditor.getBindingSupport(this.bindingComponent.getFormModel());
        this.initExpressionCombo();
        this.initComponents();
        this.expressionLabel.setLabelFor(this.expressionCombo);
        this.displayExpressionLabel.setLabelFor(this.displayExpressionCombo);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateMode1"));
        defaultComboBoxModel.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateMode2"));
        defaultComboBoxModel.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateMode3"));
        this.updateModeCombo.setModel(defaultComboBoxModel);
        boolean bl = this.showUpdateWhen();
        this.updateWhenLabel.setVisible(bl);
        this.updateWhenCombo.setVisible(bl);
        if (bl) {
            defaultComboBoxModel = new DefaultComboBoxModel();
            defaultComboBoxModel.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateWhen1"));
            defaultComboBoxModel.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateWhen2"));
            defaultComboBoxModel.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateWhen3"));
            this.updateWhenCombo.setModel(defaultComboBoxModel);
        }
        this.ignoreAdjustingChoice.setVisible(this.showIgnoreAdjusting());
        this.importDataButton.setVisible(this.showImportData());
        if (this.showColumnSelector()) {
            this.columnSelector = new ListSelector();
            ((GroupLayout)this.bindingPanel.getLayout()).replace((Component)this.detailPanel, (Component)this.columnSelector);
        }
        boolean bl2 = this.showDisplayExpression();
        this.displayExpressionLabel.setVisible(bl2);
        this.displayExpressionCombo.setVisible(bl2);
        this.nullValueProperty = bindingProperty.getNullValueProperty();
        if (this.nullValueProperty != null) {
            this.nullValuePanel.setProperty((Node.Property)this.nullValueProperty);
        }
        this.incompletePathValueProperty = bindingProperty.getIncompleteValueProperty();
        if (this.incompletePathValueProperty != null) {
            this.incompletePathValuePanel.setProperty((Node.Property)this.incompletePathValueProperty);
        }
        this.converterProperty = bindingProperty.getConverterProperty();
        if (this.converterProperty != null) {
            this.converterPanel.setProperty((Node.Property)this.converterProperty);
        }
        this.validatorProperty = bindingProperty.getValidatorProperty();
        if (this.validatorProperty != null) {
            this.validatorPanel.setProperty((Node.Property)this.validatorProperty);
        }
        this.nameProperty = bindingProperty.getNameProperty();
        if (this.nameProperty != null) {
            this.namePanel.setProperty((Node.Property)this.nameProperty);
        }
        this.updatePropertiesLabel.setMinimumSize(this.updatePropertiesLabel.getPreferredSize());
        this.conversionLabel.setMinimumSize(this.conversionLabel.getPreferredSize());
        this.validatorLabel.setMinimumSize(this.validatorLabel.getPreferredSize());
        this.specialValuesLabel.setMinimumSize(this.specialValuesLabel.getPreferredSize());
        this.updatePropertiesLabel.setMaximumSize(this.updatePropertiesLabel.getPreferredSize());
        this.conversionLabel.setMaximumSize(this.conversionLabel.getPreferredSize());
        this.validatorLabel.setMaximumSize(this.validatorLabel.getPreferredSize());
        this.specialValuesLabel.setMaximumSize(this.specialValuesLabel.getPreferredSize());
    }

    private boolean showUpdateWhen() {
        String string = this.bindingDescriptor.getPath();
        return "text".equals(string) && JTextComponent.class.isAssignableFrom(this.bindingComponent.getBeanClass());
    }

    private boolean showIgnoreAdjusting() {
        String string = this.bindingDescriptor.getPath();
        Class<? extends Object> clazz = this.bindingComponent.getBeanClass();
        return "value".equals(string) && JSlider.class.isAssignableFrom(clazz) || ("selectedElement".equals(string) || "selectedElements".equals(string)) && (JList.class.isAssignableFrom(clazz) || JTable.class.isAssignableFrom(clazz) || JComboBox.class.isAssignableFrom(clazz));
    }

    private boolean showImportData() {
        String string = this.bindingDescriptor.getPath();
        Class<? extends Object> clazz = this.bindingComponent.getBeanClass();
        return "elements".equals(string) && (JList.class.isAssignableFrom(clazz) || JComboBox.class.isAssignableFrom(clazz) || JTable.class.isAssignableFrom(clazz)) && Lookup.getDefault().lookup(DataImporter.class) != null;
    }

    private boolean showDisplayExpression() {
        String string = this.bindingDescriptor.getPath();
        Class<? extends Object> clazz = this.bindingComponent.getBeanClass();
        return "elements".equals(string) && JList.class.isAssignableFrom(clazz);
    }

    private boolean showColumnSelector() {
        return "elements".equals(this.bindingDescriptor.getPath()) && JTable.class.isAssignableFrom(this.bindingComponent.getBeanClass());
    }

    public MetaBinding getBinding() {
        return this.binding;
    }

    public void setBinding(MetaBinding metaBinding) {
        this.binding = metaBinding;
        String string = MessageFormat.format(this.infoLabel.getText(), this.bindingComponent.getName(), this.bindingDescriptor.getPath(), this.bindingDescriptor.getValueType().getName());
        this.infoLabel.setText(string);
        this.setBindingToUI();
    }

    public Dialog getDialog(ActionListener actionListener) {
        if (this.dialog == null) {
            ResourceBundle resourceBundle = NbBundle.getBundle(BindingCustomizer.class);
            this.initButtons(resourceBundle);
            String string = resourceBundle.getString("MSG_BindingCustomizer_Binding");
            String string2 = MessageFormat.format(string, this.bindingComponent.getName(), this.bindingDescriptor.getPath());
            final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, string2, true, (Object[])new JButton[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, new HelpCtx("gui.binding-customizer.basic"), null);
            this.tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    dialogDescriptor.setHelpCtx(new HelpCtx(BindingCustomizer.this.tabbedPane.getSelectedIndex() == 1 ? "gui.binding-customizer.advanced" : "gui.binding-customizer.basic"));
                }
            });
            dialogDescriptor.setClosingOptions((Object[])new JButton[]{this.okButton, this.cancelButton});
            this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    this.restore(BindingCustomizer.this.nullValueProperty, BindingCustomizer.this.oldNullValue);
                    this.restore(BindingCustomizer.this.incompletePathValueProperty, BindingCustomizer.this.oldIncompletePathValue);
                    this.restore(BindingCustomizer.this.converterProperty, BindingCustomizer.this.oldConverter);
                    this.restore(BindingCustomizer.this.validatorProperty, BindingCustomizer.this.oldValidator);
                    this.restore(BindingCustomizer.this.nameProperty, BindingCustomizer.this.oldName);
                }

                private void restore(FormProperty formProperty, Object object) {
                    if (object != null) {
                        try {
                            formProperty.setValue(object);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, illegalAccessException.getMessage(), illegalAccessException);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, invocationTargetException.getMessage(), invocationTargetException);
                        }
                    }
                }
            });
        }
        this.dialogListener = actionListener;
        this.updatePropertyPanels();
        return this.dialog;
    }

    public JComponent getBindingPanel() {
        this.infoLabel.setVisible(false);
        if (this.columnSelector.getParent() != null) {
            this.detailPanel.setVisible(false);
            ((GroupLayout)this.bindingPanel.getLayout()).replace((Component)this.columnSelector, (Component)this.detailPanel);
        }
        return this.bindingPanel;
    }

    public ComboBoxWithTree getSubExpressionCombo() {
        return this.displayExpressionCombo;
    }

    public TreeModel getSubExpressionModel() {
        return this.displayExpressionModel;
    }

    private void initButtons(ResourceBundle resourceBundle) {
        this.okButton = new JButton(resourceBundle.getString("MSG_BindingCustomizer_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BindingCustomizer.this.getBindingFromUI()) {
                    BindingCustomizer.this.oldNullValue = null;
                    BindingCustomizer.this.oldIncompletePathValue = null;
                    BindingCustomizer.this.oldConverter = null;
                    BindingCustomizer.this.oldValidator = null;
                    BindingCustomizer.this.oldName = null;
                    if (BindingCustomizer.this.dialogListener != null) {
                        BindingCustomizer.this.dialogListener.actionPerformed(actionEvent);
                    }
                }
            }
        });
        this.cancelButton = new JButton(resourceBundle.getString("MSG_BindingCustomizer_Cancel"));
    }

    private FormModel getFormModel() {
        return this.bindingComponent.getFormModel();
    }

    private void setBindingToUI() {
        this.fillSourceComponentsCombo();
        if (this.binding != null) {
            Object object;
            Object object2;
            int n = this.allComponents.indexOf(this.binding.getSource());
            if (n >= 0) {
                this.sourceCombo.setSelectedIndex(n + 1);
                this.setSelectedComponent(this.binding.getSource());
                object2 = this.binding.getSourcePath();
                this.expressionCombo.setSelectedItem(object2 == null ? "null" : object2);
            }
            this.updateModeCombo.setSelectedIndex(this.binding.getUpdateStrategy());
            if (this.showUpdateWhen()) {
                int n2 = 2;
                object = this.binding.getParameter("javax.swing.binding.ParameterKeys.TEXT_CHANGE_STRATEGY");
                if ("javax.swing.binding.TextChangeStrategy.ON_ACTION_OR_FOCUS_LOST".equals(object)) {
                    n2 = 0;
                } else if ("javax.swing.binding.TextChangeStrategy.ON_FOCUS_LOST".equals(object)) {
                    n2 = 1;
                } else if ("javax.swing.binding.TextChangeStrategy.ON_TYPE".equals(object)) {
                    n2 = 2;
                }
                this.updateWhenCombo.setSelectedIndex(n2);
            }
            if (this.showIgnoreAdjusting()) {
                object2 = this.binding.getParameter("IGNORE_ADJUSTING");
                boolean bl = "Y".equals(object2);
                this.ignoreAdjustingChoice.setSelected(bl);
            }
            if (this.showDisplayExpression()) {
                object2 = this.binding.getParameter("DISPLAY");
                this.displayExpressionCombo.setSelectedItem(object2 == null ? "null" : object2);
            }
            this.updateColumnSelector();
            if (this.columnSelector != null) {
                if (this.binding.hasSubBindings()) {
                    object2 = new LinkedList(this.columnSelector.getSelectedItems());
                    object = new LinkedList();
                    for (MetaBinding metaBinding : this.binding.getSubBindings()) {
                        String string = metaBinding.getSourcePath();
                        if (!object2.contains(string = BindingDesignSupport.unwrapSimpleExpression(string))) continue;
                        object.add(string);
                        object2.remove(string);
                    }
                    this.columnSelector.setItems((List)object2, (List)object);
                } else {
                    this.columnSelector.setItems(this.columnSelector.getSelectedItems(), Collections.emptyList());
                }
            }
            this.nullValueCheckBox.setSelected(this.binding.isNullValueSpecified());
            this.incompletePathValueCheckBox.setSelected(this.binding.isIncompletePathValueSpecified());
            if (this.binding.isNullValueSpecified()) {
                this.oldNullValue = this.propertyValue(this.nullValueProperty);
            }
            if (this.binding.isIncompletePathValueSpecified()) {
                this.oldIncompletePathValue = this.propertyValue(this.incompletePathValueProperty);
            }
            if (this.binding.isConverterSpecified()) {
                this.oldConverter = this.propertyValue(this.converterProperty);
            }
            if (this.binding.isValidatorSpecified()) {
                this.oldValidator = this.propertyValue(this.validatorProperty);
            }
            if (this.binding.isNameSpecified()) {
                this.oldName = this.propertyValue(this.nameProperty);
            }
        } else {
            this.sourceCombo.setSelectedIndex(0);
            this.updateModeCombo.setSelectedIndex(0);
            if (this.showUpdateWhen()) {
                this.updateWhenCombo.setSelectedIndex(2);
            }
            if (this.showIgnoreAdjusting()) {
                this.ignoreAdjustingChoice.setSelected(false);
            }
            this.nullValueCheckBox.setSelected(false);
            this.incompletePathValueCheckBox.setSelected(false);
            this.oldNullValue = null;
            this.oldIncompletePathValue = null;
            this.oldConverter = null;
            this.oldValidator = null;
            this.oldName = null;
        }
        this.updatePropertyPanels();
    }

    private void updatePropertyPanels() {
        if (this.binding != null) {
            this.nullValuePanel.setEnabled(this.nullValueCheckBox.isSelected());
            this.incompletePathValuePanel.setEnabled(this.incompletePathValueCheckBox.isSelected());
        } else {
            this.nullValuePanel.setEnabled(false);
            this.incompletePathValuePanel.setEnabled(false);
        }
    }

    private FormProperty.ValueWithEditor propertyValue(FormProperty formProperty) {
        FormProperty.ValueWithEditor valueWithEditor = null;
        try {
            valueWithEditor = new FormProperty.ValueWithEditor(formProperty.getValue(), formProperty.getCurrentEditor());
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, invocationTargetException.getMessage(), invocationTargetException);
        }
        return valueWithEditor;
    }

    private void fillSourceComponentsCombo() {
        FormModel formModel = this.getFormModel();
        List<RADComponent> list = formModel.getNonVisualComponents();
        List<RADComponent> list2 = formModel.getVisualComponents();
        RADComponent rADComponent = formModel.getTopRADComponent();
        if (rADComponent != null) {
            list.remove(rADComponent);
            list2.remove(rADComponent);
        }
        RADComponentComparator rADComponentComparator = new RADComponentComparator();
        Collections.sort(list, rADComponentComparator);
        Collections.sort(list2, rADComponentComparator);
        this.allComponents = new ArrayList<RADComponent>(list.size() + list2.size() + 1);
        this.allComponents.addAll(list);
        this.allComponents.addAll(list2);
        if (rADComponent != null) {
            this.allComponents.add(rADComponent);
        }
        this.sourceCombo.removeAllItems();
        String string = NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_None");
        this.sourceCombo.addItem(string);
        for (RADComponent rADComponent2 : this.allComponents) {
            this.sourceCombo.addItem(rADComponent2.getName());
        }
    }

    private void setSelectedComponent(RADComponent rADComponent) {
        if (rADComponent != this.selectedComponent) {
            this.selectedComponent = rADComponent;
        }
    }

    public boolean getBindingFromUI() {
        if (this.selectedComponent != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string = this.expressionCombo.getSelectedItem().toString();
            if ("null".equals(string)) {
                string = null;
            }
            this.binding = new MetaBinding(this.selectedComponent, string, this.bindingComponent, this.bindingDescriptor.getPath());
            this.binding.setNullValueSpecified(this.nullValueCheckBox.isSelected());
            this.binding.setIncompletePathValueSpecified(this.incompletePathValueCheckBox.isSelected());
            this.binding.setUpdateStrategy(this.updateModeCombo.getSelectedIndex());
            if (this.showUpdateWhen()) {
                int n = this.updateWhenCombo.getSelectedIndex();
                String string2 = null;
                switch (n) {
                    case 0: {
                        string2 = "javax.swing.binding.TextChangeStrategy.ON_ACTION_OR_FOCUS_LOST";
                        break;
                    }
                    case 1: {
                        string2 = "javax.swing.binding.TextChangeStrategy.ON_FOCUS_LOST";
                        break;
                    }
                    case 2: {
                        string2 = "javax.swing.binding.TextChangeStrategy.ON_TYPE";
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.binding.setParameter("javax.swing.binding.ParameterKeys.TEXT_CHANGE_STRATEGY", string2);
            }
            if (this.showIgnoreAdjusting()) {
                String string3 = this.ignoreAdjustingChoice.isSelected() ? "Y" : "N";
                this.binding.setParameter("IGNORE_ADJUSTING", string3);
            }
            if (this.showDisplayExpression()) {
                String string4 = this.displayExpressionCombo.getSelectedItem().toString();
                if ("null".equals(string4)) {
                    string4 = null;
                }
                if (string4 != null) {
                    this.binding.setParameter("DISPLAY", string4);
                }
            }
            if (this.columnSelector != null) {
                this.binding.setBindImmediately(true);
                if (this.columnSelector.isVisible()) {
                    List list = this.columnSelector.getSelectedItems();
                    for (int i = 0; i < list.size(); ++i) {
                        object4 = list.get(i).toString();
                        object3 = this.binding.addSubBinding(BindingDesignSupport.elWrap((String)object4), null);
                        object2 = this.columnToType.get(object4);
                        if (object2 == null || ((String)object2).equals("java.lang.Object")) continue;
                        object = FormUtils.autobox((String)object2);
                        if (((String)object).startsWith("java.lang.")) {
                            object = ((String)object).substring(10);
                        }
                        object = (String)object + ".class";
                        ((MetaBinding)object3).setParameter("javax.swing.binding.ParameterKeys.COLUMN_CLASS", (String)object);
                    }
                }
            }
            String string5 = this.bindingDescriptor.getPath();
            FormModel formModel = this.bindingComponent.getFormModel();
            object4 = this.propertyValue(this.nameProperty);
            if (this.oldName == null ? this.nameProperty.isChanged() : ((FormProperty.ValueWithEditor)object4).getValue() != this.oldName.getValue()) {
                formModel.fireBindingChanged(this.bindingComponent, string5, "name", this.oldName, object4);
            }
            object3 = this.propertyValue(this.nullValueProperty);
            if (this.oldNullValue == null ? this.nullValueProperty.isChanged() : ((FormProperty.ValueWithEditor)object3).getValue() != this.oldNullValue.getValue()) {
                formModel.fireBindingChanged(this.bindingComponent, string5, "nullValue", this.oldNullValue, object3);
            }
            object2 = this.propertyValue(this.incompletePathValueProperty);
            if (this.oldIncompletePathValue == null ? this.incompletePathValueProperty.isChanged() : ((FormProperty.ValueWithEditor)object2).getValue() != this.oldIncompletePathValue.getValue()) {
                formModel.fireBindingChanged(this.bindingComponent, string5, "incompleteValue", this.oldIncompletePathValue, object2);
            }
            object = this.propertyValue(this.converterProperty);
            if (this.oldConverter == null ? this.converterProperty.isChanged() : ((FormProperty.ValueWithEditor)object).getValue() != this.oldConverter.getValue()) {
                formModel.fireBindingChanged(this.bindingComponent, string5, "converter", this.oldConverter, object);
            }
            FormProperty.ValueWithEditor valueWithEditor = this.propertyValue(this.validatorProperty);
            if (this.oldValidator == null ? this.validatorProperty.isChanged() : valueWithEditor.getValue() != this.oldValidator.getValue()) {
                formModel.fireBindingChanged(this.bindingComponent, string5, "validator", this.oldValidator, valueWithEditor);
            }
        } else {
            this.binding = null;
        }
        return true;
    }

    private void initExpressionCombo() {
        TreeComboRenderer treeComboRenderer = new TreeComboRenderer(FormUtils.getBundleString("MSG_BindingCustomizer_NullExpression"));
        this.expressionCombo = new ComboBoxWithTree(this.expressionModel, treeComboRenderer, new Converter(this.expressionModel));
        this.expressionCombo.setSelectedItem("null");
        treeComboRenderer = new TreeComboRenderer(FormUtils.getBundleString("MSG_BindingCustomizer_NullDisplayExpression"));
        this.displayExpressionCombo = new ComboBoxWithTree(this.displayExpressionModel, treeComboRenderer, new Converter(this.displayExpressionModel));
        this.displayExpressionCombo.setSelectedItem("null");
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.bindingPanel = new JPanel();
        this.infoLabel = new JLabel();
        this.sourceLabel = new JLabel();
        this.sourceCombo = new JComboBox();
        this.expressionLabel = new JLabel();
        this.treeCombo = this.expressionCombo;
        this.importDataButton = new JButton();
        this.displayExpressionLabel = new JLabel();
        this.treeCombo2 = this.displayExpressionCombo;
        this.detailPanel = new JPanel();
        this.advancedPanel = new JPanel();
        this.updatePropertiesLabel = new JLabel();
        this.updateModeLabel = new JLabel();
        this.updateModeCombo = new JComboBox();
        this.updateWhenLabel = new JLabel();
        this.updateWhenCombo = new JComboBox();
        this.nullValuePanel = new PropertyPanel();
        this.incompletePathValuePanel = new PropertyPanel();
        this.nullValueCheckBox = new JCheckBox();
        this.displayValuesLabel = new JLabel();
        this.incompletePathValueCheckBox = new JCheckBox();
        this.conversionLabel = new JLabel();
        this.validationLabel = new JLabel();
        this.validatorLabel = new JLabel();
        this.converterLabel = new JLabel();
        this.converterPanel = new PropertyPanel();
        this.validatorPanel = new PropertyPanel();
        this.specialValuesLabel = new JLabel();
        this.updateLabel = new JLabel();
        this.converterMessage = new JLabel();
        this.validatorMessage = new JLabel();
        this.identificationLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.namePanel = new PropertyPanel();
        this.ignoreAdjustingChoice = new JCheckBox();
        FormListener formListener = new FormListener();
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Bind"));
        this.sourceLabel.setLabelFor(this.sourceCombo);
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Source"));
        this.sourceCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.expressionLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Expression"));
        this.treeCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.importDataButton, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ImportData"));
        this.importDataButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.displayExpressionLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_DisplayExpression"));
        GroupLayout groupLayout = new GroupLayout((Container)this.detailPanel);
        this.detailPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 452, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 297, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.bindingPanel);
        this.bindingPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.infoLabel, -1, 452, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.displayExpressionLabel).add((Component)this.expressionLabel).add((Component)this.sourceLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.sourceCombo, 0, 204, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.importDataButton)).add((Component)this.treeCombo, 0, 355, Short.MAX_VALUE).add((Component)this.treeCombo2, 0, 355, Short.MAX_VALUE))).add((Component)this.detailPanel, -1, -1, Short.MAX_VALUE)).add(10, 10, 10)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.infoLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.sourceLabel).add((Component)this.sourceCombo, -2, -1, -2).add((Component)this.importDataButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.expressionLabel).add((Component)this.treeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.displayExpressionLabel).add((Component)this.treeCombo2, -2, -1, -2)).addPreferredGap(0).add((Component)this.detailPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.sourceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Source_ACSD"));
        this.sourceCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Source_ACSD"));
        this.expressionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Expression_ACSD"));
        this.treeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Expression_ACSD"));
        this.importDataButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ImportData_ACSD"));
        this.displayExpressionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_DisplayExpression_ACSD"));
        this.treeCombo2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_DisplayExpression_ACSD"));
        this.tabbedPane.addTab(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_BindingTab"), this.bindingPanel);
        Mnemonics.setLocalizedText((JLabel)this.updatePropertiesLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateProperties"));
        this.updateModeLabel.setLabelFor(this.updateModeCombo);
        Mnemonics.setLocalizedText((JLabel)this.updateModeLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateMode"));
        this.updateWhenLabel.setLabelFor(this.updateWhenCombo);
        Mnemonics.setLocalizedText((JLabel)this.updateWhenLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateWhen"));
        this.nullValuePanel.setEnabled(false);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.nullValuePanel);
        this.nullValuePanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(0, 305, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(0, 24, Short.MAX_VALUE));
        this.incompletePathValuePanel.setEnabled(false);
        GroupLayout groupLayout4 = new GroupLayout((Container)this.incompletePathValuePanel);
        this.incompletePathValuePanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(0, 305, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(0, 24, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.nullValueCheckBox, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_NullValue"));
        this.nullValueCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.nullValueCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.nullValueCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.displayValuesLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_DisplayValues"));
        Mnemonics.setLocalizedText((AbstractButton)this.incompletePathValueCheckBox, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_IncompletePathValue"));
        this.incompletePathValueCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.incompletePathValueCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.incompletePathValueCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.conversionLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Conversion"));
        Mnemonics.setLocalizedText((JLabel)this.validationLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Validation"));
        this.validatorLabel.setLabelFor((Component)this.validatorPanel);
        Mnemonics.setLocalizedText((JLabel)this.validatorLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Validator"));
        this.converterLabel.setLabelFor((Component)this.converterPanel);
        Mnemonics.setLocalizedText((JLabel)this.converterLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Converter"));
        GroupLayout groupLayout5 = new GroupLayout((Container)this.converterPanel);
        this.converterPanel.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(0, 342, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(0, 24, Short.MAX_VALUE));
        GroupLayout groupLayout6 = new GroupLayout((Container)this.validatorPanel);
        this.validatorPanel.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add(0, 342, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add(0, 24, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((JLabel)this.specialValuesLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_SpecialValues"));
        Mnemonics.setLocalizedText((JLabel)this.updateLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Update"));
        Mnemonics.setLocalizedText((JLabel)this.converterMessage, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ConversionTxt"));
        Mnemonics.setLocalizedText((JLabel)this.validatorMessage, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ValidationTxt"));
        Mnemonics.setLocalizedText((JLabel)this.identificationLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Identification"));
        this.nameLabel.setLabelFor((Component)this.namePanel);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Name"));
        GroupLayout groupLayout7 = new GroupLayout((Container)this.namePanel);
        this.namePanel.setLayout((LayoutManager)groupLayout7);
        groupLayout7.setHorizontalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(0, 342, Short.MAX_VALUE));
        groupLayout7.setVerticalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(0, 24, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreAdjustingChoice, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_IgnoreAdjusting"));
        GroupLayout groupLayout8 = new GroupLayout((Container)this.advancedPanel);
        this.advancedPanel.setLayout((LayoutManager)groupLayout8);
        groupLayout8.setHorizontalGroup((GroupLayout.Group)groupLayout8.createParallelGroup(1).add((GroupLayout.Group)groupLayout8.createSequentialGroup().add((GroupLayout.Group)groupLayout8.createParallelGroup(1).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout8.createParallelGroup(1).add((Component)this.converterLabel).add((Component)this.validatorLabel).add((Component)this.nameLabel).add((Component)this.updateModeLabel).add((Component)this.updateWhenLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout8.createParallelGroup(1).add((Component)this.namePanel, -1, -1, Short.MAX_VALUE).add((Component)this.updateModeCombo, 0, 342, Short.MAX_VALUE).add((Component)this.updateWhenCombo, 0, 342, Short.MAX_VALUE).add((Component)this.converterPanel, -1, -1, Short.MAX_VALUE).add((Component)this.validatorPanel, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((Component)this.validationLabel)).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((Component)this.validatorMessage)).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((Component)this.converterMessage)).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((Component)this.conversionLabel)).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((Component)this.displayValuesLabel)).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout8.createParallelGroup(1).add((Component)this.nullValueCheckBox).add((Component)this.incompletePathValueCheckBox)).addPreferredGap(0).add((GroupLayout.Group)groupLayout8.createParallelGroup(1).add((Component)this.incompletePathValuePanel, -1, -1, Short.MAX_VALUE).add((Component)this.nullValuePanel, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout8.createSequentialGroup().add(10, 10, 10).add((Component)this.updatePropertiesLabel)).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((Component)this.specialValuesLabel)).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((Component)this.updateLabel)).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((Component)this.identificationLabel)).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((Component)this.ignoreAdjustingChoice))).addContainerGap()));
        groupLayout8.setVerticalGroup((GroupLayout.Group)groupLayout8.createParallelGroup(1).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((Component)this.identificationLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout8.createParallelGroup(4).add((Component)this.namePanel, -2, -1, -2).add((Component)this.nameLabel)).addPreferredGap(0).add((Component)this.updatePropertiesLabel).addPreferredGap(0).add((Component)this.updateLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout8.createParallelGroup(3).add((Component)this.updateModeLabel).add((Component)this.updateModeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout8.createParallelGroup(3).add((Component)this.updateWhenLabel).add((Component)this.updateWhenCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.ignoreAdjustingChoice).addPreferredGap(0).add((Component)this.conversionLabel).addPreferredGap(0).add((Component)this.converterMessage).addPreferredGap(0).add((GroupLayout.Group)groupLayout8.createParallelGroup(4).add((Component)this.converterLabel).add((Component)this.converterPanel, -2, -1, -2)).addPreferredGap(0).add((Component)this.validationLabel).addPreferredGap(0).add((Component)this.validatorMessage).addPreferredGap(0).add((GroupLayout.Group)groupLayout8.createParallelGroup(4).add((Component)this.validatorLabel).add((Component)this.validatorPanel, -2, -1, -2)).addPreferredGap(0).add((Component)this.specialValuesLabel).addPreferredGap(0).add((Component)this.displayValuesLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout8.createParallelGroup(1).add(4, (Component)this.nullValueCheckBox).add(4, (Component)this.nullValuePanel, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)groupLayout8.createParallelGroup(1).add(4, (Component)this.incompletePathValueCheckBox).add(4, (Component)this.incompletePathValuePanel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.updateModeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateMode_ACSD"));
        this.updateWhenCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateWhen_ACSD"));
        this.nullValuePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_NullValue_ACSD"));
        this.incompletePathValuePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_IncompletePathValue_ACSD"));
        this.nullValueCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_NullValue_ACSD"));
        this.incompletePathValueCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_IncompletePathValue_ACSD"));
        this.converterPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Converter_ACSD"));
        this.validatorPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Validator_ACSD"));
        this.namePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Name_ACSD"));
        this.tabbedPane.addTab(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_AdvancedTab"), this.advancedPanel);
        GroupLayout groupLayout9 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout9);
        groupLayout9.setHorizontalGroup((GroupLayout.Group)groupLayout9.createParallelGroup(1).add((Component)this.tabbedPane, -1, 477, Short.MAX_VALUE));
        groupLayout9.setVerticalGroup((GroupLayout.Group)groupLayout9.createParallelGroup(1).add((Component)this.tabbedPane, -1, 449, Short.MAX_VALUE));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ACSD"));
    }

    private void importDataButtonActionPerformed(ActionEvent actionEvent) {
        Future<RADComponent> future;
        DataImporter dataImporter = (DataImporter)Lookup.getDefault().lookup(DataImporter.class);
        if (dataImporter != null && (future = dataImporter.importData(this.bindingComponent.getFormModel())) != null) {
            final ProgressHandle progressHandle = ProgressHandleFactory.createHandle(null, (Cancellable)null);
            JPanel jPanel = BindingCustomizer.panelForHandle(progressHandle);
            progressHandle.start();
            progressHandle.progress(FormUtils.getBundleString("MSG_BindingCustomizer_Importing"));
            String string = FormUtils.getBundleString("MSG_BindingCustomizer_Cancel");
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, FormUtils.getBundleString("MSG_BindingCustomizer_Please_Wait"), true, new Object[]{string}, (Object)string, 0, null, null);
            final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        final RADComponent rADComponent = (RADComponent)future.get();
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                if (rADComponent != null) {
                                    BindingCustomizer.this.fillSourceComponentsCombo();
                                    BindingCustomizer.this.sourceCombo.setSelectedItem(rADComponent.getName());
                                }
                                dialog.setVisible(false);
                                progressHandle.finish();
                            }
                        });
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                    }
                }
            }).start();
            dialog.setVisible(true);
        }
    }

    private void treeComboActionPerformed(ActionEvent actionEvent) {
        this.updateColumnSelector();
        this.fireTypeChange();
    }

    private void incompletePathValueCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.incompletePathValuePanel.setEnabled(this.incompletePathValueCheckBox.isSelected());
    }

    private void nullValueCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.nullValuePanel.setEnabled(this.nullValueCheckBox.isSelected());
    }

    private void sourceComboActionPerformed(ActionEvent actionEvent) {
        int n = this.sourceCombo.getSelectedIndex();
        if (n >= 0) {
            this.setSelectedComponent(n > 0 ? this.allComponents.get(n - 1) : null);
            if (n > 0) {
                this.expressionModel.setRoot(new ExpressionNode(this.allComponents.get(n - 1)));
            } else {
                this.expressionCombo.setSelectedItem("null");
                this.expressionModel.setRoot(new DefaultMutableTreeNode(null, false));
            }
            if (this.tabbedPane.getTabCount() > 1) {
                this.tabbedPane.setEnabledAt(1, n > 0);
            }
        }
        this.expressionCombo.setEnabled(n > 0);
        this.displayExpressionCombo.setEnabled(n > 0);
        this.updateColumnSelector();
        this.fireTypeChange();
    }

    private static JPanel panelForHandle(ProgressHandle progressHandle) {
        JLabel jLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jLabel).add((Component)jComponent)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)jLabel).addPreferredGap(0).add((Component)jComponent).addContainerGap());
        return jPanel;
    }

    public FormUtils.TypeHelper getSelectedType() {
        FormUtils.TypeHelper typeHelper = null;
        if (this.selectedComponent != null) {
            String string;
            Object object = this.expressionCombo.getSelectedItem();
            typeHelper = object == null || "null".equals(object) ? BindingDesignSupport.determineType(this.selectedComponent) : (BindingDesignSupport.isSimpleExpression(string = object.toString()) ? this.designSupport.determineType(this.selectedComponent, BindingDesignSupport.unwrapSimpleExpression(string)) : new FormUtils.TypeHelper((Type)((Object)String.class)));
        }
        return typeHelper;
    }

    private void updateColumnSelector() {
        boolean bl = this.showDisplayExpression();
        if (!bl && this.columnSelector == null) {
            return;
        }
        FormUtils.TypeHelper typeHelper = this.getSelectedType();
        if (typeHelper != null && Collection.class.isAssignableFrom(FormUtils.typeToClass(typeHelper))) {
            FormUtils.TypeHelper typeHelper2 = BindingDesignSupport.typeOfElement(typeHelper);
            if (typeHelper2 != null && typeHelper2.equals(this.lastElemType)) {
                return;
            }
            this.lastElemType = typeHelper2;
            if (this.columnSelector != null) {
                List<BindingDescriptor> list = this.designSupport.getAllBindingDescriptors(typeHelper2);
                this.columnSelector.setVisible(list.size() > 0);
                LinkedList<String> linkedList = new LinkedList<String>();
                this.columnToType = new HashMap<String, String>();
                for (BindingDescriptor bindingDescriptor : list) {
                    FormUtils.TypeHelper typeHelper3 = bindingDescriptor.getGenericValueType();
                    String string = typeHelper3.getName();
                    if (string == null) {
                        Class clazz = bindingDescriptor.getValueType();
                        string = clazz.getName();
                    }
                    this.columnToType.put(bindingDescriptor.getPath(), string);
                    linkedList.add(bindingDescriptor.getPath());
                }
                this.columnSelector.setItems(Collections.EMPTY_LIST, linkedList);
            }
            this.displayExpressionModel.setRoot(new ExpressionNode(typeHelper2));
        } else {
            this.lastElemType = null;
            if (this.columnSelector != null) {
                this.columnSelector.setVisible(false);
            } else {
                this.displayExpressionCombo.setSelectedItem("null");
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(null, true);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(null, false));
            this.displayExpressionModel.setRoot(defaultMutableTreeNode);
        }
    }

    public void addTypeChangeListener(PropertyChangeListener propertyChangeListener) {
        this.typeChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeTypeChangeListener(PropertyChangeListener propertyChangeListener) {
        this.typeChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireTypeChange() {
        this.typeChangeSupport.firePropertyChange(null, null, null);
    }

    private static class TreeComboRenderer
    extends DefaultTreeCellRenderer {
        private String nullString;
        private int baseSize;

        TreeComboRenderer(String string) {
            this.nullString = string;
            this.baseSize = new JLabel().getFont().getSize() + 1;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object2;
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof ExpressionNode) {
                ExpressionNode expressionNode = (ExpressionNode)object;
                Object object3 = expressionNode.getUserObject();
                if (object3 == null) {
                    TreeComboRenderer.updateFont(jLabel, this.baseSize);
                    jLabel.setText(this.nullString);
                } else {
                    BindingDescriptor bindingDescriptor = expressionNode.getDescriptor();
                    if (bindingDescriptor != null) {
                        TreeComboRenderer.updateFont(jLabel, this.baseSize - expressionNode.getCategory());
                        jLabel.setText("<html><b>" + bindingDescriptor.getPath() + "</b> " + this.nameOfClass(bindingDescriptor.getGenericValueType()));
                    }
                }
            } else if (object instanceof DefaultMutableTreeNode && (object2 = (defaultMutableTreeNode = (DefaultMutableTreeNode)object).getUserObject()) == null) {
                TreeComboRenderer.updateFont(jLabel, this.baseSize);
                jLabel.setText("null");
            }
            return jLabel;
        }

        private static void updateFont(JLabel jLabel, int n) {
            if (jLabel.getFont().getSize() != n) {
                jLabel.setFont(jLabel.getFont().deriveFont((float)n));
            }
        }

        private String nameOfClass(FormUtils.TypeHelper typeHelper) {
            String string = typeHelper.getName();
            if (string == null && (string = FormUtils.typeToClass(typeHelper).getName()).startsWith("[")) {
                StringBuilder stringBuilder = new StringBuilder();
                while (string.startsWith("[")) {
                    stringBuilder.append("[]");
                    string = string.substring(1);
                }
                if ("Z".equals(string)) {
                    stringBuilder.insert(0, "boolean");
                } else if ("B".equals(string)) {
                    stringBuilder.insert(0, "byte");
                } else if ("C".equals(string)) {
                    stringBuilder.insert(0, "char");
                } else if ("D".equals(string)) {
                    stringBuilder.insert(0, "double");
                } else if ("F".equals(string)) {
                    stringBuilder.insert(0, "float");
                } else if ("I".equals(string)) {
                    stringBuilder.insert(0, "int");
                } else if ("J".equals(string)) {
                    stringBuilder.insert(0, "long");
                } else if ("S".equals(string)) {
                    stringBuilder.insert(0, "short");
                } else {
                    stringBuilder.insert(0, string.substring(1, string.length() - 1));
                }
                string = stringBuilder.toString();
            }
            return string;
        }
    }

    private static class Converter
    implements ComboBoxWithTree.Converter {
        private DefaultTreeModel treeModel;

        Converter(DefaultTreeModel defaultTreeModel) {
            this.treeModel = defaultTreeModel;
        }

        public String pathToString(TreePath treePath) {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            Object[] objectArray = treePath.getPath();
            for (int i = 1; i < objectArray.length; ++i) {
                stringBuilder.append(objectArray[i]).append('.');
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            return "null".equals(string = stringBuilder.toString().trim()) ? "null" : BindingDesignSupport.elWrap(stringBuilder.toString());
        }

        public TreePath stringToPath(String string) {
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
            if (!BindingDesignSupport.isSimpleExpression(string)) {
                if ("null".equals(string)) {
                    return new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode.getChildAt(0)});
                }
                return null;
            }
            string = BindingDesignSupport.unwrapSimpleExpression(string);
            LinkedList<DefaultMutableTreeNode> linkedList = new LinkedList<DefaultMutableTreeNode>();
            linkedList.add(defaultMutableTreeNode);
            while ((n = string.indexOf(46)) != -1) {
                String string2 = string.substring(0, n);
                if ((defaultMutableTreeNode = this.findNode(defaultMutableTreeNode, string2)) == null) {
                    return null;
                }
                linkedList.add(defaultMutableTreeNode);
                string = string.substring(n + 1);
            }
            if ((defaultMutableTreeNode = this.findNode(defaultMutableTreeNode, string)) == null) {
                return null;
            }
            linkedList.add(defaultMutableTreeNode);
            return new TreePath(linkedList.toArray());
        }

        private DefaultMutableTreeNode findNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                if (!string.equals(defaultMutableTreeNode2.getUserObject())) continue;
                return defaultMutableTreeNode2;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExpressionNode
    extends JTree.DynamicUtilTreeNode {
        private BindingDescriptor descriptor;
        private RADComponent comp;
        private int category;
        private FormUtils.TypeHelper type;

        ExpressionNode(RADComponent rADComponent) {
            this(BindingDesignSupport.determineType(rADComponent));
            this.comp = rADComponent;
        }

        ExpressionNode(FormUtils.TypeHelper typeHelper) {
            super((Object)"root", BindingCustomizer.this.designSupport.getBindingDescriptors(typeHelper));
            this.type = typeHelper;
            this.setAllowsChildren(true);
        }

        private ExpressionNode(BindingDescriptor bindingDescriptor) {
            super((Object)bindingDescriptor.getPath(), BindingCustomizer.this.designSupport.getBindingDescriptors(bindingDescriptor.getGenericValueType()));
            this.descriptor = bindingDescriptor;
            this.type = bindingDescriptor.getGenericValueType();
            this.updateLeafStatus();
        }

        private ExpressionNode() {
            super(null, null);
        }

        private void updateLeafStatus() {
            boolean bl = true;
            if (this.childValue instanceof List[]) {
                List[] listArray = (List[])this.childValue;
                for (int i = 0; i < listArray.length; ++i) {
                    if (listArray[i].size() <= 0) continue;
                    bl = false;
                    break;
                }
            }
            this.setAllowsChildren(!bl);
        }

        BindingDescriptor getDescriptor() {
            return this.descriptor;
        }

        int getCategory() {
            return this.category;
        }

        public String getTypeName() {
            String string;
            String string2 = string = this.type == null ? null : this.type.getName();
            if (string == null) {
                string = FormUtils.typeToClass(this.type).getName();
            }
            return string;
        }

        @Override
        protected void loadChildren() {
            this.loadedChildren = true;
            if ("root".equals(this.getUserObject())) {
                this.add(new ExpressionNode());
            }
            if (this.childValue instanceof List[]) {
                List[] listArray = (List[])this.childValue;
                for (int i = 0; i < listArray.length; ++i) {
                    this.loadChildren(listArray[i], i);
                }
            }
        }

        private void loadChildren(List<BindingDescriptor> list, int n) {
            for (BindingDescriptor bindingDescriptor : list) {
                ExpressionNode expressionNode;
                if (bindingDescriptor.isValueTypeRelative()) {
                    StringBuilder stringBuilder = new StringBuilder(bindingDescriptor.getPath());
                    ExpressionNode expressionNode2 = this;
                    while (expressionNode2.comp == null) {
                        stringBuilder.insert(0, expressionNode2.getDescriptor().getPath() + ".");
                        expressionNode2 = (ExpressionNode)this.getParent();
                    }
                    FormUtils.TypeHelper typeHelper = BindingCustomizer.this.designSupport.determineType(expressionNode2.comp, stringBuilder.toString());
                    expressionNode = new ExpressionNode(new BindingDescriptor(bindingDescriptor.getPath(), typeHelper));
                } else {
                    expressionNode = new ExpressionNode(bindingDescriptor);
                }
                expressionNode.category = n;
                this.add(expressionNode);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RADComponentComparator
    implements Comparator<RADComponent> {
        private RADComponentComparator() {
        }

        @Override
        public int compare(RADComponent rADComponent, RADComponent rADComponent2) {
            String string = rADComponent.getName();
            String string2 = rADComponent2.getName();
            return string.compareToIgnoreCase(string2);
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == BindingCustomizer.this.sourceCombo) {
                BindingCustomizer.this.sourceComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == BindingCustomizer.this.treeCombo) {
                BindingCustomizer.this.treeComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == BindingCustomizer.this.importDataButton) {
                BindingCustomizer.this.importDataButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == BindingCustomizer.this.nullValueCheckBox) {
                BindingCustomizer.this.nullValueCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == BindingCustomizer.this.incompletePathValueCheckBox) {
                BindingCustomizer.this.incompletePathValueCheckBoxActionPerformed(actionEvent);
            }
        }
    }
}

