/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsf.ui.PagebeanPackagePanel;
import org.netbeans.modules.visualweb.project.jsf.ui.SimpleTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class SimpleTargetChooserPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private final List listeners = new ArrayList();
    private SimpleTargetChooserPanelGUI gui;
    private Project project;
    private SourceGroup[] folders;
    private WizardDescriptor.Panel bottomPanel;
    private WizardDescriptor wizard;
    private boolean isFolder;
    private String fileType;

    SimpleTargetChooserPanel(Project project, SourceGroup[] sourceGroupArray, WizardDescriptor.Panel panel, boolean bl, String string) {
        this.folders = sourceGroupArray;
        this.project = project;
        this.bottomPanel = panel;
        if (panel != null) {
            panel.addChangeListener((ChangeListener)this);
        }
        this.isFolder = bl;
        this.fileType = string;
        this.gui = null;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new SimpleTargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.isFolder);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        HelpCtx helpCtx;
        if (this.bottomPanel != null && (helpCtx = this.bottomPanel.getHelp()) != null) {
            return helpCtx;
        }
        return null;
    }

    public boolean isValid() {
        boolean bl;
        boolean bl2 = bl = this.gui != null && this.gui.getTargetName() != null && (this.bottomPanel == null || this.bottomPanel.isValid());
        if (!bl) {
            return false;
        }
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
        String string = SimpleTargetChooserPanel.canUseFileName(this.gui.getTargetGroup().getRootFolder(), this.gui.getTargetFolder(), this.gui.getTargetName(), fileObject.getExt(), this.isFolder);
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
        if (string != null) {
            return false;
        }
        if (!JsfProjectUtils.isWebProject(this.project)) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_NotInWebProject"));
            return false;
        }
        if (!JsfProjectUtils.supportProjectProperty(this.project)) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_NotSupportProperties"));
            return false;
        }
        String string2 = this.gui.getTargetName();
        if (!JsfProjectUtils.isValidJavaFileName(string2)) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_InvalidJavaFileName", (Object)string2));
            return false;
        }
        if (JsfProjectUtils.getSourceRoot(this.project) == null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_NoSourceRoot"));
            return false;
        }
        String string3 = this.checkBackwardsKit();
        if (string3 != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)string3);
            return false;
        }
        if (this.fileType.equals("WebForm")) {
            return this.checkWebForm(string2);
        }
        if (this.fileType.equals("Bean")) {
            return this.checkBean(string2);
        }
        return true;
    }

    private String checkBackwardsKit() {
        String string;
        LibraryManager libraryManager = LibraryManager.getDefault();
        boolean bl = JsfProjectUtils.isJavaEE5Project(this.project);
        ClassPath classPath = ClassPath.getClassPath((FileObject)JsfProjectUtils.getDocumentRoot(this.project), (String)"classpath/compile");
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            if (libraryManager.getLibrary("jsf1102") == null && classPath.findResource("javax/faces/FacesException.class") == null && classPath.findResource("org/apache/myfaces/webapp/StartupServletContextListener.class") == null) {
                bl2 = true;
            }
            if (libraryManager.getLibrary("jaxrpc16") == null && classPath.findResource("javax/xml/rpc/Service.class") == null) {
                bl3 = true;
            }
        }
        if (("1.3".equals(string = JsfProjectUtils.getSourceLevel(this.project)) || "1.4".equals(string)) && libraryManager.getLibrary("rowset-ri") == null && classPath.findResource("javax/sql/rowset/BaseRowSet.class") == null) {
            bl4 = true;
        }
        if (bl2 || bl3 || bl4) {
            return JsfProjectUtils.getBackwardsKitMesg(bl2, bl3, bl4);
        }
        return null;
    }

    private String getFolderPath(String string) {
        FileObject fileObject = this.gui.getTargetGroup().getRootFolder();
        String string2 = FileUtil.getFileDisplayName((FileObject)fileObject).replace(File.separatorChar, '/');
        String string3 = this.gui.getTargetFolder();
        String string4 = string3 != null ? string2 + (string3.startsWith("/") ? "" : "/") + string3 : string2;
        boolean bl = false;
        String string5 = null;
        if (string4.startsWith(string = string.replace(File.separatorChar, '/'))) {
            string5 = string4.substring(string.length());
            if (string5.equals("") || string5.equals("/")) {
                bl = true;
            } else if (string5.startsWith("/")) {
                string5 = string5 + "/";
                bl = true;
            }
        }
        if (!bl) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_NotUnderTargetFolder", (Object)(string4.length() > string2.length() ? string4.substring(string2.length() + 1) : string4), (Object)(string.length() > string2.length() ? string.substring(string2.length() + 1) : string)));
            return null;
        }
        String[] stringArray = string5.split("/");
        for (int i = 0; i < stringArray.length; ++i) {
            String string6 = stringArray[i];
            if ("".equals(string6) || JsfProjectUtils.isValidJavaFileName(string6)) continue;
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_InvalidJavaFolderName", (Object)string6));
            return null;
        }
        return string5;
    }

    private boolean checkWebForm(String string) {
        if (JsfProjectUtils.getPortletSupport(this.project) != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_PortletIncompatible"));
            return false;
        }
        FileObject fileObject = JsfProjectUtils.getDocumentRoot(this.project);
        String string2 = this.getFolderPath(FileUtil.getFileDisplayName((FileObject)fileObject));
        if (string2 == null) {
            return false;
        }
        if (string2.indexOf("WEB-INF") != -1) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_InvalidTargetFolder", (Object)string2));
            return false;
        }
        String string3 = string + ".jsp";
        String string4 = string + ".java";
        FileObject fileObject2 = JsfProjectUtils.getPageBeanRoot(this.project);
        String string5 = string2 + string4;
        if (string5.startsWith("/")) {
            string5 = string5.substring(1);
        }
        if (fileObject2.getFileObject(string5) != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_PageBeanNameConflict", (Object)string4, (Object)string3));
            return false;
        }
        FileObject fileObject3 = fileObject.getFileObject(string2);
        FileObject fileObject4 = fileObject2.getFileObject(string2);
        if (fileObject3 != null && SimpleTargetChooserPanel.checkCaseInsensitiveName(fileObject3, string, "jsp") || fileObject4 != null && SimpleTargetChooserPanel.checkCaseInsensitiveName(fileObject4, string, "java")) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_FileDifferentByCase", (Object)string));
        }
        return true;
    }

    private boolean checkBean(String string) {
        String string2;
        FileObject fileObject;
        String string3 = (String)this.wizard.getProperty("jsf.pagebean.package");
        if (string3 != null) {
            string3 = string3.replace('.', File.separatorChar);
            fileObject = JsfProjectUtils.getSourceRoot(this.project);
            string2 = FileUtil.getFileDisplayName((FileObject)fileObject) + File.separatorChar + string3;
        } else {
            fileObject = JsfProjectUtils.getPageBeanRoot(this.project);
            string2 = FileUtil.getFileDisplayName((FileObject)fileObject);
        }
        String string4 = this.getFolderPath(string2);
        if (string4 == null) {
            return false;
        }
        FileObject fileObject2 = fileObject.getFileObject(string4);
        if (fileObject2 != null && SimpleTargetChooserPanel.checkCaseInsensitiveName(fileObject2, string, "java")) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_FileDifferentByCase", (Object)string));
        }
        return true;
    }

    static boolean checkCaseInsensitiveName(FileObject fileObject, String string, String string2) {
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(fileObject2.getExt()) || !string.equalsIgnoreCase(fileObject2.getName())) continue;
            return true;
        }
        return false;
    }

    public static String canUseFileName(FileObject fileObject, String string, String string2, String string3, boolean bl) {
        assert (string2 != null);
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        if (bl) {
            if (File.separatorChar == '\\') {
                n = 3;
                bl3 = true;
                bl2 = true;
            } else {
                n = 1;
                bl2 = true;
            }
        }
        if (!bl2 && string2.indexOf(47) != -1 || !bl3 && string2.indexOf(92) != -1) {
            assert (n == 0 || n == 1) : "Invalid error variant: " + n;
            return NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_not_valid_filename", (Object)string2, (Object)new Integer(n));
        }
        if (fileObject == null) {
            return NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!fileObject.canWrite()) {
            return NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_fs_is_readonly");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            if (!bl3 && string.indexOf(92) != -1) {
                return NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_not_valid_folder", (Object)string, (Object)new Integer(1));
            }
            stringBuffer.append(string);
            stringBuffer.append('/');
        }
        stringBuffer.append(string2);
        if (string3 != null) {
            stringBuffer.append('.');
            stringBuffer.append(string3);
        }
        if (fileObject.getFileObject(stringBuffer.toString()) != null) {
            return NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)string2);
        }
        return null;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList(this.listeners);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((ChangeListener)object.next()).stateChanged(changeEvent);
        }
    }

    public void readSettings(Object object) {
        this.wizard = (WizardDescriptor)object;
        if (this.gui == null) {
            this.getComponent();
        }
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        String string = Templates.getTargetName((WizardDescriptor)this.wizard);
        this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), fileObject, string);
        Object object2 = this.gui.getClientProperty("NewFileWizard_Title");
        if (object2 != null) {
            this.wizard.putProperty("NewFileWizard_Title", object2);
        }
        this.wizard.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getBundle(SimpleTargetChooserPanel.class).getString("LBL_TemplatesPanel_Name"), NbBundle.getBundle(SimpleTargetChooserPanel.class).getString("LBL_SimpleTargetChooserPanel_Name")});
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings(object);
        }
    }

    public void storeSettings(Object object) {
        if (WizardDescriptor.PREVIOUS_OPTION.equals(((WizardDescriptor)object).getValue())) {
            return;
        }
        if (this.isValid()) {
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings(object);
            }
            FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
            String string = this.gui.getTargetName();
            if (string.indexOf(47) > 0) {
                string = string.substring(string.lastIndexOf(47) + 1);
            }
            Templates.setTargetFolder((WizardDescriptor)((WizardDescriptor)object), (FileObject)this.getTargetFolderFromGUI());
            Templates.setTargetName((WizardDescriptor)((WizardDescriptor)object), (String)string);
        }
        ((WizardDescriptor)object).putProperty("NewFileWizard_Title", null);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        String string;
        if (changeEvent.getSource().getClass() == PagebeanPackagePanel.class && this.fileType.equals("Bean") && (string = (String)this.wizard.getProperty("jsf.pagebean.package")) != null) {
            string = string.replace('.', '/');
            FileObject fileObject = this.gui.getTargetGroup().getRootFolder();
            FileObject fileObject2 = JsfProjectUtils.getSourceRoot(this.project);
            if (fileObject2 != null) {
                String string2 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2).replace(File.separatorChar, '/');
                String string3 = string2 + "/" + string;
                String string4 = this.gui.getTargetFolder();
                if (string4 != null && !string4.equals(string3) && !string4.startsWith(string3 + "/")) {
                    this.gui.setTargetFolder(string3);
                }
            }
        }
        this.fireChange();
    }

    private FileObject getTargetFolderFromGUI() {
        Object object;
        FileObject fileObject = this.gui.getTargetGroup().getRootFolder();
        String string = this.gui.getTargetFolder();
        String string2 = this.gui.getTargetName();
        if (string2.indexOf(47) > 0) {
            object = string2.substring(0, string2.lastIndexOf(47));
            string = string == null || "".equals(string) ? object : string + '/' + (String)object;
        }
        if ((object = string == null ? fileObject : fileObject.getFileObject(string)) == null) {
            try {
                object = FileUtil.createFolder((FileObject)fileObject, (String)string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return object;
    }
}

