/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.ui;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.visualweb.project.jsf.api.JsfDataObjectException;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsf.framework.JSFFrameworkProvider;
import org.netbeans.modules.visualweb.project.jsf.ui.PageLayoutChooserPanel;
import org.netbeans.modules.visualweb.project.jsf.ui.PageLayoutData;
import org.netbeans.modules.visualweb.project.jsf.ui.PagebeanPackagePanel;
import org.netbeans.modules.visualweb.project.jsf.ui.SimpleTargetChooserPanel;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class PageIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 1L;
    public static final String FILETYPE_WEBFORM = "WebForm";
    public static final String FILETYPE_BEAN = "Bean";
    private String fileType;
    private int index;
    private boolean usePageLayout = false;
    PageLayoutChooserPanel pageLayoutChooserPanel = new PageLayoutChooserPanel();
    private transient WizardDescriptor.Panel[] panels;

    public static PageIterator createWebFormIterator() {
        return new PageIterator(FILETYPE_WEBFORM);
    }

    public static PageIterator createBeanIterator() {
        return new PageIterator(FILETYPE_BEAN);
    }

    private PageIterator(String string) {
        this.fileType = string;
    }

    public void initialize(TemplateWizard templateWizard) {
        JComponent jComponent;
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        PagebeanPackagePanel pagebeanPackagePanel = new PagebeanPackagePanel(project);
        SimpleTargetChooserPanel simpleTargetChooserPanel = new SimpleTargetChooserPanel(project, sourceGroupArray, pagebeanPackagePanel, false, this.fileType);
        String string = Templates.getTemplate((WizardDescriptor)templateWizard).getExt();
        boolean bl = this.pageLayoutChooserPanel.isPageLayoutsAvailable();
        if (this.fileType.equals(FILETYPE_WEBFORM) && !"jspf".equals(string) && "1.5".equals(JsfProjectUtils.getJ2eePlatformVersion(project)) && bl) {
            this.usePageLayout = true;
        }
        this.panels = this.usePageLayout ? new WizardDescriptor.Panel[]{simpleTargetChooserPanel, this.pageLayoutChooserPanel} : new WizardDescriptor.Panel[]{simpleTargetChooserPanel};
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = this.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            jComponent = (JComponent)this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = jComponent.getName();
            }
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        if (!JsfProjectUtils.isWebProject(project)) {
            return;
        }
        if (this.fileType.equals(FILETYPE_WEBFORM)) {
            String string2;
            FileObject fileObject = JsfProjectUtils.getDocumentRoot(project);
            jComponent = JsfProjectUtils.getPageBeanRoot(project);
            FileObject fileObject2 = Templates.getTargetFolder((WizardDescriptor)templateWizard);
            String string3 = string2 = fileObject2 == null ? null : FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
            if (string2 == null || string2.indexOf("WEB-INF") != -1) {
                Templates.setTargetFolder((WizardDescriptor)templateWizard, (FileObject)fileObject);
                fileObject2 = fileObject;
            } else if (string2.length() > 0) {
                jComponent = jComponent.getFileObject(string2);
            }
            String string4 = Templates.getTemplate((WizardDescriptor)templateWizard).getExt();
            String string5 = "jsp".equals(string4) ? "Page" : "Fragment";
            int n = 1;
            while (true) {
                String string6;
                if (fileObject2.getFileObject((string6 = string5 + n) + "." + string4) == null && (jComponent == null || jComponent.getFileObject(string6 + ".java") == null)) {
                    templateWizard.setTargetName(string6);
                    return;
                }
                ++n;
            }
        }
        if (this.fileType.equals(FILETYPE_BEAN)) {
            String string7;
            FileObject fileObject = JsfProjectUtils.getPageBeanRoot(project);
            if (fileObject == null) {
                return;
            }
            jComponent = Templates.getTargetFolder((WizardDescriptor)templateWizard);
            String string8 = string7 = jComponent == null ? null : FileUtil.getRelativePath((FileObject)fileObject, (FileObject)jComponent);
            if (string7 == null) {
                Templates.setTargetFolder((WizardDescriptor)templateWizard, (FileObject)fileObject);
                jComponent = fileObject;
            }
            String string9 = Templates.getTemplate((WizardDescriptor)templateWizard).getName();
            int n = 1;
            while (true) {
                String string10;
                if (jComponent.getFileObject((string10 = string9 + n) + ".java") == null) {
                    templateWizard.setTargetName(string10);
                    return;
                }
                ++n;
            }
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        Object object;
        Object object2;
        List list;
        Object object3;
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)templateWizard);
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        if ("1.5".equals(JsfProjectUtils.getJ2eePlatformVersion(project)) && this.usePageLayout) {
            object3 = this.pageLayoutChooserPanel.getSelectedPageLayout();
            ((PageLayoutData)object3).copyResources(JsfProjectUtils.getResourcesDirectory(project));
            fileObject2 = ((PageLayoutData)object3).getFileObject();
        }
        object3 = DataObject.find((FileObject)fileObject2);
        String string = Templates.getTargetName((WizardDescriptor)templateWizard);
        Set set = Collections.EMPTY_SET;
        if (!JsfProjectUtils.isJsfProject(project)) {
            list = WebFrameworks.getFrameworks();
            for (WebFrameworkProvider webFrameworkProvider : list) {
                if (!(webFrameworkProvider instanceof JSFFrameworkProvider)) continue;
                object2 = JsfProjectUtils.getWebModule(project);
                String string2 = (String)templateWizard.getProperty("jsf.pagebean.package");
                if (string2 == null) {
                    string2 = JsfProjectUtils.deriveSafeName(project.getProjectDirectory().getName());
                }
                JsfProjectUtils.createProjectProperty(project, "jsf.pagebean.package", string2);
                if ("jsp".equals(fileObject2.getExt())) {
                    this.setStartPage(project, (WebModule)object2, fileObject, string);
                } else if ("jspf".equals(fileObject2.getExt()) && "Page1".equals(string)) {
                    this.setStartPage(project, (WebModule)object2, fileObject, "Page2");
                }
                WebModuleExtender webModuleExtender = webFrameworkProvider.createWebModuleExtender((WebModule)object2, ExtenderController.create());
                set = webModuleExtender.extend((WebModule)object2);
                if (fileObject.getFileObject(string + "." + fileObject2.getExt()) == null) continue;
                return set;
            }
        }
        try {
            if (string == null) {
                list = object3.createFromTemplate(dataFolder);
            } else {
                object = new HashMap();
                object.put("j2eePlatformVersion", JsfProjectUtils.getJ2eePlatformVersion(project));
                object.put("sourceLevel", JsfProjectUtils.getSourceLevel(project));
                if ("jsp".equals(fileObject2.getExt())) {
                    WebFrameworkProvider webFrameworkProvider;
                    webFrameworkProvider = JsfProjectUtils.getDocumentRoot(project);
                    object2 = fileObject == webFrameworkProvider ? "" : ((object2 = FileUtil.getRelativePath((FileObject)webFrameworkProvider, (FileObject)fileObject)) == null ? "" : ((String)object2).replace('/', '$') + "$");
                    object.put("folder", object2);
                }
                list = object3.createFromTemplate(dataFolder, string, (Map)object);
            }
        }
        catch (JsfDataObjectException jsfDataObjectException) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(PageIterator.class, (String)"TXT_CantCreatePage", (Object)dataFolder.getName())));
            return set;
        }
        if (set == Collections.EMPTY_SET) {
            set = Collections.singleton(list);
        } else {
            set.add((List)list);
        }
        object = (OpenCookie)list.getCookie(OpenCookie.class);
        if (object != null) {
            object.open();
        }
        return set;
    }

    private void setStartPage(Project project, WebModule webModule, FileObject fileObject, String string) {
        String string2;
        String string3 = string + ".jsp";
        FileObject fileObject2 = webModule.getDocumentBase();
        if (fileObject2 != null && (string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject)) != null && string2.length() > 0) {
            string3 = string2 + "/" + string3;
        }
        JsfProjectUtils.createProjectProperty(project, "jsf.startPage", string3);
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public String name() {
        return NbBundle.getMessage(PageIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps(String[] stringArray, WizardDescriptor.Panel[] panelArray) {
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getComponent().getName();
        }
        return stringArray2;
    }
}

