/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.complib.api.ComplibService;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsf.services.DataSourceService;
import org.netbeans.modules.visualweb.project.jsf.services.ThemeNodeService;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class JSFNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        return new JSFNodeList(project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSFNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String THEMES_FOLDER = "themesFolder";
        private static final String COMPONENT_LIBS = "compLib";
        private static final String DATASOURCE_REFS = "dataSource";
        private final Project project;
        private final ArrayList<ChangeListener> listeners = new ArrayList();

        JSFNodeList(Project project) {
            this.project = project;
        }

        public List<String> keys() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (JsfProjectUtils.isJsfProject(this.project)) {
                arrayList.add(THEMES_FOLDER);
                arrayList.add(COMPONENT_LIBS);
                arrayList.add(DATASOURCE_REFS);
            }
            return arrayList;
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        private void fireChange() {
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Node node(String string) {
            if (string == THEMES_FOLDER) {
                Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ThemeNodeService.class));
                for (ThemeNodeService themeNodeService : result.allInstances()) {
                    Node node = themeNodeService.getThemeNode(this.project);
                    if (node == null) continue;
                    return node;
                }
                return null;
            }
            if (string == COMPONENT_LIBS) {
                ComplibService complibService = (ComplibService)Lookup.getDefault().lookup(ComplibService.class);
                if (complibService != null) {
                    return complibService.getComplibsRootNode(this.project);
                }
                return null;
            }
            if (string == DATASOURCE_REFS) {
                DataSourceService dataSourceService = (DataSourceService)Lookup.getDefault().lookup(DataSourceService.class);
                if (dataSourceService != null) {
                    return dataSourceService.getDataSourceReferenceNode(this.project);
                }
                return null;
            }
            assert (false) : "No node for key: " + string;
            return null;
        }

        public void addNotify() {
            JsfProjectUtils.addJsfFrameworkChangeListener(this.project, this);
        }

        public void removeNotify() {
            JsfProjectUtils.removeJsfFrameworkChangeListener(this.project, this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JSFNodeList.this.fireChange();
                }
            });
        }
    }
}

