/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.libraries.provider;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.modules.visualweb.project.jsf.libraries.JavadocForBinaryQueryLibraryImpl;
import org.netbeans.modules.visualweb.project.jsf.libraries.provider.ComponentVolumeCustomizer;
import org.netbeans.modules.visualweb.project.jsf.libraries.provider.VolumeContentModel;
import org.netbeans.spi.project.libraries.LibraryCustomizerContext;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ThemeVolumeCustomizer
extends JPanel
implements Customizer {
    private String volumeType;
    private LibraryImplementation impl;
    private VolumeContentModel model;
    private LibraryStorageArea area;
    private Boolean allowRelativePaths = null;
    private static File lastFolder = null;
    private JButton addButton;
    private JList content;
    private JButton downButton;
    private JScrollPane jScrollPane1;
    private JLabel message;
    private JButton removeButton;
    private JButton upButton;
    private JButton addURLButton;

    ThemeVolumeCustomizer(String string) {
        this.volumeType = string;
        this.initComponents();
        this.postInitComponents();
        this.setName(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)("TXT_" + string)));
    }

    public void addNotify() {
        super.addNotify();
        this.addButton.requestFocus();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.addButton.setEnabled(bl);
        if (this.addURLButton != null) {
            this.addURLButton.setEnabled(bl);
        }
        int[] nArray = this.content.getSelectedIndices();
        this.removeButton.setEnabled(bl && nArray.length > 0);
        this.downButton.setEnabled(bl && nArray.length > 0 && nArray[nArray.length - 1] < this.model.getSize() - 1);
        this.upButton.setEnabled(bl && nArray.length > 0 && nArray[0] > 0);
    }

    private void postInitComponents() {
        this.content.setCellRenderer(new ContentRenderer());
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        if (this.volumeType.equals("classpath")) {
            this.addButton.setText(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"CTL_AddClassPath"));
            this.addButton.setMnemonic(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"MNE_AddClassPath").charAt(0));
            this.message.setText(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"CTL_ContentClassPath"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"MNE_ContentClassPath").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"AD_AddClassPath"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"AD_ContentClassPath"));
        } else if (this.volumeType.equals("javadoc")) {
            this.addButton.setText(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"CTL_AddJavadoc"));
            this.addButton.setMnemonic(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"MNE_AddJavadoc").charAt(0));
            this.message.setText(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"CTL_ContentJavadoc"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"MNE_ContentJavadoc").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"AD_AddJavadoc"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"AD_ContentJavadoc"));
        } else if (this.volumeType.equals("src")) {
            this.addButton.setText(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"CTL_AddSources"));
            this.addButton.setMnemonic(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"MNE_AddSources").charAt(0));
            this.message.setText(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"CTL_ContentSources"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"MNE_ContentSources").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"AD_AddSources"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"AD_ContentSources"));
        } else if (this.volumeType.equals("runtime")) {
            this.addButton.setText(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"CTL_AddSources"));
            this.addButton.setMnemonic(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"MNE_AddSources").charAt(0));
            this.message.setText(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"CTL_ContentSources"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"MNE_ContentSources").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"AD_AddSources"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"AD_ContentSources"));
        }
        this.content.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int[] nArray = ThemeVolumeCustomizer.this.content.getSelectedIndices();
                ThemeVolumeCustomizer.this.removeButton.setEnabled(nArray.length > 0);
                ThemeVolumeCustomizer.this.downButton.setEnabled(nArray.length > 0 && nArray[nArray.length - 1] < ThemeVolumeCustomizer.this.model.getSize() - 1);
                ThemeVolumeCustomizer.this.upButton.setEnabled(nArray.length > 0 && nArray[0] > 0);
            }
        });
    }

    private void initComponents() {
        this.message = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.content = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(null);
        this.message.setLabelFor(this.content);
        Mnemonics.setLocalizedText((JLabel)this.message, (String)NbBundle.getBundle(ThemeVolumeCustomizer.class).getString("CTL_RemoveContent"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 2, 6);
        this.add((Component)this.message, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.content);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 6, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(ThemeVolumeCustomizer.class).getString("CTL_AddContent"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThemeVolumeCustomizer.this.addResource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 5, 6);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(null);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getBundle(ThemeVolumeCustomizer.class).getString("CTL_RemoveContent"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThemeVolumeCustomizer.this.removeResource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(null);
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getBundle(ThemeVolumeCustomizer.class).getString("CTL_UpContent"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThemeVolumeCustomizer.this.upResource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.add((Component)this.upButton, gridBagConstraints);
        this.upButton.getAccessibleContext().setAccessibleDescription(null);
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getBundle(ThemeVolumeCustomizer.class).getString("CTL_DownContent"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThemeVolumeCustomizer.this.downResource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.downButton, gridBagConstraints);
        this.downButton.getAccessibleContext().setAccessibleDescription(null);
    }

    private void downResource(ActionEvent actionEvent) {
        int[] nArray = this.content.getSelectedIndices();
        if (nArray.length == 0 || nArray[0] < 0 || nArray[nArray.length - 1] >= this.model.getSize() - 1) {
            return;
        }
        this.model.moveDown(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = nArray[i] + 1;
        }
        this.content.setSelectedIndices(nArray);
    }

    private void upResource(ActionEvent actionEvent) {
        int[] nArray = this.content.getSelectedIndices();
        if (nArray.length == 0 || nArray[0] <= 0) {
            return;
        }
        this.model.moveUp(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = nArray[i] - 1;
        }
        this.content.setSelectedIndices(nArray);
    }

    private void removeResource(ActionEvent actionEvent) {
        int[] nArray = this.content.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        this.model.removeResources(nArray);
        if (nArray[nArray.length - 1] - nArray.length + 1 < this.model.getSize()) {
            this.content.setSelectedIndex(nArray[nArray.length - 1] - nArray.length + 1);
        } else if (nArray[0] >= 1) {
            this.content.setSelectedIndex(nArray[0] - 1);
        }
    }

    private void addResource(ActionEvent actionEvent) {
        File file = null;
        if (this.allowRelativePaths != null && this.allowRelativePaths.booleanValue()) {
            file = new File(URI.create(this.area.getLocation().toExternalForm())).getParentFile();
        }
        FileChooser fileChooser = new FileChooser(file, file);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (this.volumeType.equalsIgnoreCase("classpath")) {
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"TXT_OpenClasses"));
            fileChooser.setFileSelectionMode(2);
            fileChooser.setFileFilter((FileFilter)new SimpleFileFilter(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"TXT_Classpath"), new String[]{"ZIP", "JAR"}));
            fileChooser.setApproveButtonText(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"CTL_SelectCP"));
            fileChooser.setApproveButtonMnemonic(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"MNE_SelectCP").charAt(0));
        } else if (this.volumeType.equalsIgnoreCase("javadoc")) {
            fileChooser.setDialogTitle(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"TXT_OpenJavadoc"));
            fileChooser.setFileSelectionMode(2);
            fileChooser.setFileFilter((FileFilter)new SimpleFileFilter(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"TXT_Javadoc"), new String[]{"ZIP", "JAR"}));
            fileChooser.setApproveButtonText(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"CTL_SelectJD"));
            fileChooser.setApproveButtonMnemonic(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"MNE_SelectJD").charAt(0));
        } else if (this.volumeType.equalsIgnoreCase("src")) {
            fileChooser.setDialogTitle(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"TXT_OpenSources"));
            fileChooser.setFileSelectionMode(2);
            fileChooser.setFileFilter((FileFilter)new SimpleFileFilter(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"TXT_Sources"), new String[]{"ZIP", "JAR"}));
            fileChooser.setApproveButtonText(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"CTL_SelectSRC"));
            fileChooser.setApproveButtonMnemonic(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"MNE_SelectSRC").charAt(0));
        } else if (this.volumeType.equalsIgnoreCase("runtime")) {
            fileChooser.setDialogTitle(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"TXT_OpenSources"));
            fileChooser.setFileSelectionMode(2);
            fileChooser.setFileFilter((FileFilter)new SimpleFileFilter(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"TXT_Sources"), new String[]{"ZIP", "JAR"}));
            fileChooser.setApproveButtonText(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"CTL_SelectSRC"));
            fileChooser.setApproveButtonMnemonic(NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"MNE_SelectSRC").charAt(0));
        }
        if (lastFolder != null) {
            fileChooser.setCurrentDirectory(lastFolder);
        }
        if (fileChooser.showOpenDialog((Component)this) == 0) {
            try {
                lastFolder = fileChooser.getCurrentDirectory();
                this.addFiles(fileChooser.getSelectedPaths(), this.area != null ? this.area.getLocation() : null);
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private void addFiles(String[] stringArray, URL uRL) throws MalformedURLException {
        Object object;
        int n;
        int n2 = this.model.getSize();
        for (n = 0; n < stringArray.length; ++n) {
            Object object2;
            object = new File(stringArray[n]);
            URI uRI = LibrariesSupport.convertFilePathToURI((String)stringArray[n]);
            if (this.allowRelativePaths != null && this.allowRelativePaths.booleanValue()) {
                object2 = object;
                if (!((File)object).isAbsolute()) {
                    assert (this.area != null);
                    if (this.area != null) {
                        object2 = FileUtil.normalizeFile((File)new File(new File(URI.create(this.area.getLocation().toExternalForm())).getParentFile(), ((File)object).getPath()));
                    }
                }
                if (FileUtil.isArchiveFile((URL)((File)object2).toURI().toURL())) {
                    uRI = LibrariesSupport.getArchiveRoot((URI)uRI);
                } else if (!uRI.toString().endsWith("/")) {
                    try {
                        uRI = new URI(uRI.toString() + "/");
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new AssertionError((Object)uRISyntaxException);
                    }
                }
                this.model.addResource(uRI);
            } else {
                assert (((File)object).isAbsolute()) : ((File)object).getPath();
                object2 = FileUtil.normalizeFile((File)object).toURI().toURL();
                if (FileUtil.isArchiveFile((URL)object2)) {
                    object2 = FileUtil.getArchiveRoot((URL)object2);
                } else if (!((URL)object2).toExternalForm().endsWith("/")) {
                    object2 = new URL(((URL)object2).toExternalForm() + "/");
                }
                this.model.addResource((URL)object2);
            }
            if (!this.volumeType.equals("javadoc") || JavadocForBinaryQueryLibraryImpl.isValidLibraryJavadocRoot(LibrariesSupport.resolveLibraryEntryURI((URL)uRL, (URI)uRI).toURL())) continue;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ComponentVolumeCustomizer.class, (String)"TXT_InvalidJavadocRoot", (Object)((File)object).getPath()), 0));
        }
        n = this.model.getSize() - 1;
        if (n2 <= n) {
            object = new int[n - n2 + 1];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = n2 + i;
            }
            this.content.setSelectedIndices((int[])object);
        }
    }

    public void setObject(Object object) {
        assert (object instanceof LibraryCustomizerContext) : object.getClass();
        LibraryCustomizerContext libraryCustomizerContext = (LibraryCustomizerContext)object;
        this.area = libraryCustomizerContext.getLibraryStorageArea();
        this.impl = libraryCustomizerContext.getLibraryImplementation();
        this.allowRelativePaths = libraryCustomizerContext.getLibraryImplementation2() != null;
        this.model = new VolumeContentModel(this.impl, this.area, this.volumeType);
        this.content.setModel(this.model);
        if (this.model.getSize() > 0) {
            this.content.setSelectedIndex(0);
        }
    }

    private static class ContentRenderer
    extends DefaultListCellRenderer {
        private ContentRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component;
            String string = null;
            Color color = null;
            String string2 = null;
            URI uRI = null;
            if (object instanceof URI) {
                uRI = (URI)object;
            } else if (object instanceof URL) {
                try {
                    uRI = ((URL)object).toURI();
                }
                catch (URISyntaxException uRISyntaxException) {
                    Exceptions.printStackTrace((Throwable)uRISyntaxException);
                }
            }
            if (uRI != null) {
                if (uRI.toString().contains("!/")) {
                    uRI = LibrariesSupport.getArchiveFile((URI)uRI);
                }
                boolean bl3 = false;
                VolumeContentModel volumeContentModel = (VolumeContentModel)jList.getModel();
                LibraryStorageArea libraryStorageArea = volumeContentModel.getArea();
                FileObject fileObject = LibrariesSupport.resolveLibraryEntryFileObject((URL)(libraryStorageArea != null ? libraryStorageArea.getLocation() : null), (URI)uRI);
                if (fileObject == null) {
                    bl3 = true;
                    string = "file".equals(uRI.getScheme()) ? LibrariesSupport.convertURIToFilePath((URI)uRI) : uRI.toString();
                } else if (uRI.isAbsolute()) {
                    string = FileUtil.getFileDisplayName((FileObject)fileObject);
                } else {
                    string = LibrariesSupport.convertURIToFilePath((URI)uRI);
                    string2 = FileUtil.getFileDisplayName((FileObject)fileObject);
                }
                if (bl3) {
                    color = new Color(164, 0, 0);
                    string2 = NbBundle.getMessage(ThemeVolumeCustomizer.class, (String)"TXT_BrokenFile");
                }
            }
            if ((component = super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2)) instanceof JComponent) {
                if (color != null) {
                    ((JComponent)component).setForeground(color);
                }
                if (string2 != null) {
                    ((JComponent)component).setToolTipText(string2);
                } else {
                    ((JComponent)component).setToolTipText(null);
                }
            }
            return component;
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n <= 0 || n == string.length() - 1) {
                return false;
            }
            String string2 = string.substring(n + 1).toUpperCase();
            return this.extensions.contains(string2);
        }

        public String getDescription() {
            return this.description;
        }
    }
}

