/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class SetStartPageAction
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup,
ContextAwareAction {
    private static final int TYPE_NONE = 0;
    private static final int TYPE_JSP = 1;
    private static final int TYPE_PORTLET = 2;
    private final int type;
    private final FileObject fo;

    public SetStartPageAction() {
        this(0, null);
    }

    private SetStartPageAction(int n, FileObject fileObject) {
        super(n == 1 ? NbBundle.getMessage(SetStartPageAction.class, (String)"LBL_SetAsStartPage") : null);
        this.type = n;
        this.fo = fileObject;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.type == 1) {
            String string = JsfProjectUtils.setStartPage(this.fo);
            String string2 = string != null ? NbBundle.getMessage(SetStartPageAction.class, (String)"MSG_StartPageChanged") + " " + string : NbBundle.getMessage(SetStartPageAction.class, (String)"MSG_NoStartPage");
            StatusDisplayer.getDefault().setStatusText(string2);
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        Project project;
        DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
        if (dataObject == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("SetStartPageAction: missing DataObject instance in the context, context=" + lookup));
            return null;
        }
        int n = 1;
        FileObject fileObject = dataObject.getPrimaryFile();
        if (fileObject != null && "jsp".equalsIgnoreCase(fileObject.getExt()) && JsfProjectUtils.getPortletSupport(project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null) {
            n = 2;
        }
        return new SetStartPageAction(n, fileObject);
    }

    public JMenuItem getMenuPresenter() {
        return this.getPresenter();
    }

    public JMenuItem getPopupPresenter() {
        return this.getPresenter();
    }

    public JMenuItem getPresenter() {
        JMenuItem jMenuItem = new JMenuItem();
        if (this.type == 1) {
            String string = NbBundle.getMessage(SetStartPageAction.class, (String)"LBL_SetAsStartPage");
            jMenuItem.setEnabled(!JsfProjectUtils.isStartPage(this.fo) && !this.fo.getExt().equalsIgnoreCase("jspf"));
            Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)string);
            jMenuItem.addActionListener(this);
        } else {
            jMenuItem.setVisible(false);
        }
        return jMenuItem;
    }
}

