/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.util.logging.Logger;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.javahl.JhlDirEntry;
import org.tigris.subversion.svnclientadapter.javahl.JhlLock;
import org.tigris.subversion.svnclientadapter.javahl.JhlLogMessage;
import org.tigris.subversion.svnclientadapter.javahl.JhlLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.javahl.JhlStatus;

public class JhlConverter {
    private static final Logger log = Logger.getLogger(JhlConverter.class.getName());

    private JhlConverter() {
    }

    public static Revision convert(SVNRevision svnRevision) {
        switch (svnRevision.getKind()) {
            case 5: {
                return Revision.BASE;
            }
            case 3: {
                return Revision.COMMITTED;
            }
            case 2: {
                return new Revision.DateSpec(((SVNRevision.DateSpec)svnRevision).getDate());
            }
            case 7: {
                return Revision.HEAD;
            }
            case 1: {
                return new Revision.Number(((SVNRevision.Number)svnRevision).getNumber());
            }
            case 4: {
                return Revision.PREVIOUS;
            }
            case 0: {
                return Revision.START;
            }
            case 6: {
                return Revision.WORKING;
            }
        }
        log.severe("unknown revision kind :" + svnRevision.getKind());
        return Revision.START;
    }

    public static SVNRevision convert(Revision rev) {
        switch (rev.getKind()) {
            case 5: {
                return SVNRevision.BASE;
            }
            case 3: {
                return SVNRevision.COMMITTED;
            }
            case 1: {
                Revision.Number n = (Revision.Number)rev;
                if (n.getNumber() == -1L) {
                    return null;
                }
                return new SVNRevision.Number(n.getNumber());
            }
            case 4: {
                return SVNRevision.PREVIOUS;
            }
            case 6: {
                return SVNRevision.WORKING;
            }
        }
        return SVNRevision.HEAD;
    }

    static SVNRevision.Number convertRevisionNumber(long revisionNumber) {
        if (revisionNumber == -1L) {
            return null;
        }
        return new SVNRevision.Number(revisionNumber);
    }

    public static SVNNodeKind convertNodeKind(int javahlNodeKind) {
        switch (javahlNodeKind) {
            case 2: {
                return SVNNodeKind.DIR;
            }
            case 1: {
                return SVNNodeKind.FILE;
            }
            case 0: {
                return SVNNodeKind.NONE;
            }
            case 3: {
                return SVNNodeKind.UNKNOWN;
            }
        }
        log.severe("unknown node kind :" + javahlNodeKind);
        return SVNNodeKind.UNKNOWN;
    }

    public static JhlStatus convert(Status status) {
        return new JhlStatus(status);
    }

    public static SVNStatusKind convertStatusKind(int kind) {
        switch (kind) {
            case 0: {
                return SVNStatusKind.NONE;
            }
            case 1: {
                return SVNStatusKind.NORMAL;
            }
            case 3: {
                return SVNStatusKind.ADDED;
            }
            case 6: {
                return SVNStatusKind.MISSING;
            }
            case 12: {
                return SVNStatusKind.INCOMPLETE;
            }
            case 4: {
                return SVNStatusKind.DELETED;
            }
            case 7: {
                return SVNStatusKind.REPLACED;
            }
            case 2: {
                return SVNStatusKind.MODIFIED;
            }
            case 8: {
                return SVNStatusKind.MERGED;
            }
            case 9: {
                return SVNStatusKind.CONFLICTED;
            }
            case 10: {
                return SVNStatusKind.OBSTRUCTED;
            }
            case 11: {
                return SVNStatusKind.IGNORED;
            }
            case 13: {
                return SVNStatusKind.EXTERNAL;
            }
            case 5: {
                return SVNStatusKind.UNVERSIONED;
            }
        }
        log.severe("unknown status kind :" + kind);
        return SVNStatusKind.NONE;
    }

    static JhlDirEntry[] convert(DirEntry[] dirEntry) {
        JhlDirEntry[] entries = new JhlDirEntry[dirEntry.length];
        for (int i = 0; i < dirEntry.length; ++i) {
            entries[i] = new JhlDirEntry(dirEntry[i]);
        }
        return entries;
    }

    static JhlDirEntry convert(DirEntry dirEntry) {
        return new JhlDirEntry(dirEntry);
    }

    static JhlLogMessage[] convert(LogMessage[] msg) {
        JhlLogMessage[] messages = new JhlLogMessage[msg.length];
        for (int i = 0; i < msg.length; ++i) {
            messages[i] = new JhlLogMessage(msg[i]);
        }
        return messages;
    }

    public static JhlStatus[] convert(Status[] status) {
        JhlStatus[] jhlStatus = new JhlStatus[status.length];
        for (int i = 0; i < status.length; ++i) {
            jhlStatus[i] = new JhlStatus(status[i]);
        }
        return jhlStatus;
    }

    static ISVNLogMessageChangePath[] convert(ChangePath[] changePaths) {
        if (changePaths == null) {
            return new SVNLogMessageChangePath[0];
        }
        ISVNLogMessageChangePath[] jhlChangePaths = new SVNLogMessageChangePath[changePaths.length];
        for (int i = 0; i < changePaths.length; ++i) {
            jhlChangePaths[i] = new JhlLogMessageChangePath(changePaths[i]);
        }
        return jhlChangePaths;
    }

    public static SVNScheduleKind convertScheduleKind(int kind) {
        switch (kind) {
            case 0: {
                return SVNScheduleKind.NORMAL;
            }
            case 2: {
                return SVNScheduleKind.DELETE;
            }
            case 1: {
                return SVNScheduleKind.ADD;
            }
            case 3: {
                return SVNScheduleKind.REPLACE;
            }
        }
        log.severe("unknown schedule kind :" + kind);
        return SVNScheduleKind.NORMAL;
    }

    public static JhlLock convertLock(Lock lock) {
        return new JhlLock(lock);
    }
}

