/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapter;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotificationHandler;
import org.tigris.subversion.svnclientadapter.commandline.Helper;

abstract class CommandLine {
    protected String commandName;
    protected CmdLineNotificationHandler notificationHandler;
    protected Process process;

    protected CommandLine(String commandName, CmdLineNotificationHandler notificationHandler) {
        this.commandName = commandName;
        this.notificationHandler = notificationHandler;
    }

    String version() throws CmdLineException {
        CmdArguments args = new CmdArguments();
        args.add("--version");
        return this.execString(args, false);
    }

    private Process execProcess(CmdArguments svnArguments) throws CmdLineException {
        int svnArgsLen = svnArguments.size();
        String[] cmdline = new String[svnArgsLen + 1];
        cmdline[0] = this.commandName;
        StringBuffer svnCommand = new StringBuffer();
        boolean nextIsPassword = false;
        for (int i = 0; i < svnArgsLen; ++i) {
            Object arg;
            if (i != 0) {
                svnCommand.append(' ');
            }
            if ((arg = svnArguments.get(i)) != null) {
                arg = arg.toString();
            }
            if ("".equals(arg) && (!nextIsPassword || CmdLineClientAdapter.isOsWindows())) {
                arg = "\"\"";
            }
            if (nextIsPassword) {
                svnCommand.append("*******");
                nextIsPassword = false;
            } else {
                svnCommand.append(arg);
            }
            if ("--password".equals(arg)) {
                nextIsPassword = true;
            }
            cmdline[i + 1] = (String)arg;
        }
        this.notificationHandler.logCommandLine(svnCommand.toString());
        try {
            this.process = Runtime.getRuntime().exec(cmdline, this.getEnvironmentVariables());
            return this.process;
        }
        catch (IOException e) {
            throw new CmdLineException(e);
        }
    }

    protected String[] getEnvironmentVariables() {
        Map vars = CmdLineClientAdapter.getEnvironmentVariables();
        ArrayList<String> ret = new ArrayList<String>(vars.keySet().size());
        Iterator it = vars.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.equals("LC_ALL")) {
                ret.add("LC_ALL=");
                continue;
            }
            if (key.equals("LC_MESSAGES")) {
                ret.add("LC_MESSAGES=C");
                continue;
            }
            if (key.equals("LC_MESSAGES")) {
                ret.add("LC_TIME=C");
                continue;
            }
            ret.add(key + "=" + vars.get(key));
        }
        if (!vars.containsKey("LC_ALL")) {
            ret.add("LC_ALL=");
        }
        if (!vars.containsKey("LC_MESSAGES")) {
            ret.add("LC_MESSAGES=C");
        }
        if (!vars.containsKey("LC_TIME")) {
            ret.add("LC_TIME=C");
        }
        return ret.toArray(new String[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pumpProcessStreams(Process proc, StreamPumper outPumper, StreamPumper errPumper) {
        new Thread(outPumper).start();
        new Thread(errPumper).start();
        try {
            outPumper.waitFor();
            errPumper.waitFor();
        }
        catch (InterruptedException ignored) {
            this.notificationHandler.logError("Command output processing interrupted !");
        }
        finally {
            try {
                proc.getInputStream().close();
                proc.getOutputStream().close();
                proc.getErrorStream().close();
            }
            catch (IOException ioex) {}
        }
    }

    protected String execString(CmdArguments svnArguments, boolean coalesceLines) throws CmdLineException {
        Process proc = this.execProcess(svnArguments);
        CharacterStreamPumper outPumper = new CharacterStreamPumper(proc.getInputStream(), coalesceLines, this.notificationHandler);
        CharacterStreamPumper errPumper = new CharacterStreamPumper(proc.getErrorStream(), false);
        this.pumpProcessStreams(proc, outPumper, errPumper);
        try {
            String errMessage = ((Object)errPumper).toString();
            if (errMessage.length() > 0) {
                throw new CmdLineException(errMessage);
            }
            String outputString = ((Object)outPumper).toString();
            this.notifyFromSvnOutput(outputString);
            return outputString;
        }
        catch (CmdLineException e) {
            this.notificationHandler.logException(e);
            throw e;
        }
    }

    protected byte[] execBytes(CmdArguments svnArguments, boolean assumeUTF8) throws CmdLineException {
        Process proc = this.execProcess(svnArguments);
        ByteStreamPumper outPumper = new ByteStreamPumper(proc.getInputStream());
        CharacterStreamPumper errPumper = new CharacterStreamPumper(proc.getErrorStream(), false);
        this.pumpProcessStreams(proc, outPumper, errPumper);
        try {
            String errMessage = ((Object)errPumper).toString();
            if (errMessage.length() > 0) {
                throw new CmdLineException(errMessage);
            }
            byte[] bytes = outPumper.getBytes();
            String notifyMessage = "";
            if (assumeUTF8) {
                try {
                    notifyMessage = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {}
            } else {
                notifyMessage = new String(bytes);
            }
            this.notifyFromSvnOutputInternal(notifyMessage);
            return bytes;
        }
        catch (CmdLineException e) {
            this.notificationHandler.logException(e);
            throw e;
        }
    }

    protected void execVoid(CmdArguments svnArguments) throws CmdLineException {
        this.execString(svnArguments, false);
    }

    protected InputStream execInputStream(CmdArguments svnArguments) throws CmdLineException {
        Process proc = this.execProcess(svnArguments);
        try {
            proc.getOutputStream().close();
            proc.getErrorStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return proc.getInputStream();
    }

    protected void notifyFromSvnOutput(String svnOutput) {
    }

    private void notifyFromSvnOutputInternal(String svnOutput) {
        StringTokenizer st = new StringTokenizer(svnOutput, Helper.NEWLINE);
        int size = st.countTokens();
        for (int i = 1; i < size; ++i) {
            this.notificationHandler.logMessage(st.nextToken());
        }
        if (size > 0) {
            this.notificationHandler.logCompleted(st.nextToken());
        }
        this.notifyFromSvnOutput(svnOutput);
    }

    protected void stopProcess() {
        if (this.process != null) {
            try {
                this.process.getInputStream().close();
                this.process.getOutputStream().close();
                this.process.getErrorStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.process.destroy();
        }
    }

    protected static String createTempCommandFile(String value, String prefix) throws CmdLineException {
        return CommandLine.createTempCommandFile(new String[]{value}, prefix);
    }

    protected static String createTempCommandFile(String[] lines, String prefix) throws CmdLineException {
        File targetFile;
        String tmp = System.getProperty("java.io.tmpdir");
        try {
            targetFile = File.createTempFile("svn_" + prefix + "_", "", new File(tmp));
            targetFile.deleteOnExit();
        }
        catch (IOException ex) {
            throw new CmdLineException(ex);
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(targetFile)));
            for (int i = 0; i < lines.length; ++i) {
                writer.print(i < lines.length - 1 ? lines[i] + "\n" : lines[i]);
            }
        }
        catch (FileNotFoundException ex) {
            throw new CmdLineException(ex);
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        return targetFile.getAbsolutePath();
    }

    protected static class CmdArguments {
        private List args = new ArrayList();

        protected CmdArguments() {
        }

        protected void add(Object arg) {
            this.args.add(arg);
        }

        protected void addAuthInfo(String user, String pass) {
            if (user != null && user.length() > 0) {
                this.add("--username");
                this.add(user);
                this.add("--password");
                this.add(pass != null && pass.length() > 0 ? pass : "");
            }
            this.add("--non-interactive");
        }

        protected void addConfigInfo(String configDir) {
            if (configDir != null) {
                this.add("--config-dir");
                this.add(configDir);
            }
        }

        protected void addLogMessage(String message) throws CmdLineException {
            this.add("--force-log");
            this.add("-F");
            String msgFile = CommandLine.createTempCommandFile(message != null ? message : "", "message");
            this.add(msgFile);
        }

        private int size() {
            return this.args.size();
        }

        private Object get(int index) {
            return this.args.get(index);
        }
    }

    private static class ByteStreamPumper
    extends StreamPumper {
        private InputStream bis;
        private ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        private static final int BUFFER_LENGTH = 1024;
        private byte[] inputBuffer = new byte[1024];

        public ByteStreamPumper(InputStream is) {
            this.bis = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void pumpStream() {
            try {
                int bytesRead;
                while ((bytesRead = this.bis.read(this.inputBuffer)) != -1) {
                    this.bytes.write(this.inputBuffer, 0, bytesRead);
                }
            }
            catch (IOException ex) {
                System.err.println("Problem occured during fetching the command output: " + ex.getMessage());
            }
            finally {
                try {
                    this.bytes.flush();
                    this.bytes.close();
                    this.bis.close();
                }
                catch (IOException iOException) {}
            }
        }

        public synchronized byte[] getBytes() {
            return this.bytes.toByteArray();
        }
    }

    private static class CharacterStreamPumper
    extends StreamPumper {
        private BufferedReader reader;
        private StringBuffer sb = new StringBuffer();
        private boolean coalesceLines = false;
        private final CmdLineNotificationHandler messageHandler;

        public CharacterStreamPumper(InputStream is, boolean coalesceLines) {
            this(is, coalesceLines, null);
        }

        public CharacterStreamPumper(InputStream is, boolean coalesceLines, CmdLineNotificationHandler messageHandler) {
            this.messageHandler = messageHandler;
            this.reader = new BufferedReader(new InputStreamReader(is));
            this.coalesceLines = coalesceLines;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void pumpStream() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    if (this.coalesceLines) {
                        this.sb.append(line);
                    } else {
                        this.sb.append(line).append(Helper.NEWLINE);
                    }
                    if (this.messageHandler == null) continue;
                    this.messageHandler.logMessage(line);
                }
            }
            catch (IOException ex) {
                System.err.println("Problem occured during fetching the command output: " + ex.getMessage());
                if (this.messageHandler != null) {
                    this.messageHandler.logCompleted("");
                }
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {}
            }
        }

        public synchronized String toString() {
            return this.sb.toString();
        }
    }

    private static abstract class StreamPumper
    implements Runnable {
        private boolean finished;

        protected StreamPumper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.finished = false;
            }
            try {
                this.pumpStream();
            }
            finally {
                streamPumper = this;
                synchronized (streamPumper) {
                    this.finished = true;
                    this.notify();
                }
            }
        }

        protected abstract void pumpStream();

        public synchronized boolean isFinished() {
            return this.finished;
        }

        public synchronized void waitFor() throws InterruptedException {
            while (!this.isFinished()) {
                this.wait();
            }
        }
    }
}

