/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.designpattern;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.ElementLocator;
import org.netbeans.modules.uml.designpattern.DefaultDesignPatternResource;
import org.netbeans.modules.uml.designpattern.DesignPatternUtilities;
import org.netbeans.modules.uml.designpattern.IDesignPatternDetails;
import org.netbeans.modules.uml.designpattern.IDesignPatternManager;
import org.netbeans.modules.uml.designpattern.IDesignPatternRole;
import org.netbeans.modules.uml.designpattern.JRoleTreeTable;
import org.netbeans.modules.uml.designpattern.RoleTreeTableModel;
import org.netbeans.modules.uml.designpattern.Wizard;
import org.netbeans.modules.uml.designpattern.WizardRoleObject;
import org.netbeans.modules.uml.ui.support.commonresources.CommonResourceManager;
import org.netbeans.modules.uml.ui.support.commonresources.ICommonResourceManager;
import org.netbeans.modules.uml.ui.support.wizard.IWizardSheet;
import org.netbeans.modules.uml.ui.support.wizard.WizardInteriorPage;
import org.netbeans.modules.uml.ui.swing.commondialogs.SwingErrorDialog;
import org.netbeans.modules.uml.ui.swing.treetable.JDefaultMutableTreeNode;
import org.netbeans.modules.uml.ui.swing.treetable.JTreeTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardRoles
extends WizardInteriorPage {
    private static final String PG_CAPTION = DefaultDesignPatternResource.getString("IDS_WIZARDCAPTION");
    private static final String PG_TITLE = DefaultDesignPatternResource.getString("IDS_CHOOSEPARTICIPANTS");
    private static final String PG_SUBTITLE = DefaultDesignPatternResource.getString("IDS_CHOOSEPARTICIPANTSHELP");
    private Wizard m_Wizard = null;
    private JDefaultMutableTreeNode m_Root = null;
    private RoleTreeTableModel m_Model = null;
    private JTreeTable m_Tree = null;
    private ICommonResourceManager m_ResourceMgr = CommonResourceManager.instance();
    private Hashtable<String, Hashtable> m_TypeMap = new Hashtable();
    private int m_RightClickRow = 0;

    public WizardRoles(IWizardSheet iWizardSheet, String string, String string2, String string3) {
        super(iWizardSheet, string, string2, string3);
        this.createUI();
    }

    public WizardRoles(IWizardSheet iWizardSheet) {
        this(iWizardSheet, PG_CAPTION, PG_TITLE, PG_SUBTITLE);
    }

    protected void createUI() {
        super.createUI();
        this.addActionListeners();
        this.onInitDialog();
    }

    private void addActionListeners() {
    }

    protected boolean onInitDialog() {
        super.onInitDialog();
        IWizardSheet iWizardSheet = this.getParentSheet();
        this.m_Wizard = (Wizard)iWizardSheet;
        this.populateGrid();
        return true;
    }

    public void onSetActive() {
        if (this.m_Wizard != null) {
            this.populateGrid();
        }
        super.onSetActive();
    }

    private void populateGrid() {
        ETList<IDesignPatternRole> eTList;
        IDesignPatternDetails iDesignPatternDetails;
        this.m_Root = new JDefaultMutableTreeNode((Object)"Root");
        if (this.m_Wizard != null && (iDesignPatternDetails = this.m_Wizard.getDetails()) != null && (eTList = iDesignPatternDetails.getRoles()) != null) {
            IDesignPatternRole iDesignPatternRole;
            int n = eTList.size();
            for (int i = 0; i < n && ((iDesignPatternRole = (IDesignPatternRole)eTList.get(i)) == null || this.addRoleToGrid(iDesignPatternRole)); ++i) {
            }
            this.m_Model = null;
            this.m_Model = new RoleTreeTableModel(this.m_Root, this);
            this.m_Tree = null;
            this.m_Tree = new JRoleTreeTable(this.m_Model, this);
            FontMetrics fontMetrics = this.m_Tree.getFontMetrics(this.m_Tree.getFont());
            this.m_Tree.setRowHeight(fontMetrics.getHeight() + 6);
            this.m_Tree.getTree().setRootVisible(false);
            this.m_Tree.getAccessibleContext().setAccessibleName(DefaultDesignPatternResource.getString("ACSN_ROLETREE"));
            this.m_Tree.getAccessibleContext().setAccessibleDescription(DefaultDesignPatternResource.getString("ACSD_ROLETREE"));
            this.m_Model.setTreeTable(this.m_Tree);
            int n2 = this.m_Model.getChildCount(this.m_Root);
            for (int i = n2 - 1; i >= 0; --i) {
                this.m_Model.expand(i, true);
            }
            this.prepareToShow();
        }
    }

    public void prepareToShow() {
        this.pnlContents.setLayout(new GridBagLayout());
        this.pnlContents.removeAll();
        if (this.m_Tree != null) {
            JScrollPane jScrollPane = new JScrollPane((Component)this.m_Tree);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.8;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(12, 10, 12, 10);
            this.pnlContents.add((Component)jScrollPane, gridBagConstraints);
            this.refresh();
        }
    }

    public void refresh() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paintAll(graphics);
        }
    }

    public void onWizardBack() {
        if (this.m_Wizard != null) {
            this.m_Wizard.m_RefreshPages = false;
        }
        super.onWizardBack();
    }

    public void onWizardNext() {
        if (this.storeParticipants()) {
            ETList<String> eTList = this.validatePage();
            if (eTList != null && eTList.size() == 0) {
                super.onWizardNext();
            } else if (eTList != null && eTList.size() > 0) {
                String string = DesignPatternUtilities.formatErrorMessage(eTList);
                DesignPatternUtilities.displayErrorMessage((JDialog)((Object)this.m_Wizard), string);
            }
        }
    }

    private boolean addRoleToGrid(IDesignPatternRole iDesignPatternRole) {
        boolean bl = true;
        if (iDesignPatternRole != null) {
            String string = iDesignPatternRole.getName();
            int n = iDesignPatternRole.getMultiplicity();
            WizardRoleObject wizardRoleObject = new WizardRoleObject("", iDesignPatternRole);
            JDefaultMutableTreeNode jDefaultMutableTreeNode = new JDefaultMutableTreeNode((Object)wizardRoleObject, true);
            this.m_Root.add((MutableTreeNode)jDefaultMutableTreeNode);
            if (n > 1) {
                bl = this.addChildNodeForRole(jDefaultMutableTreeNode, iDesignPatternRole);
            } else {
                this.calculateName(jDefaultMutableTreeNode, wizardRoleObject);
            }
        }
        return bl;
    }

    private void buildRoleMaps(IDesignPatternRole iDesignPatternRole) {
        if (iDesignPatternRole != null) {
            Hashtable hashtable;
            Hashtable<String, Vector<String>> hashtable2 = new Hashtable<String, Vector<String>>();
            String string = iDesignPatternRole.getTypeID();
            if (string == null || string.length() == 0) {
                string = "Classifier";
            }
            if ((hashtable = this.m_TypeMap.get(string)) == null || string == null || string.length() == 0) {
                IProject iProject;
                IDesignPatternDetails iDesignPatternDetails;
                String string2 = "";
                if (string.equals("Classifier")) {
                    string2 = "//*[name() = 'UML:Class'";
                    string2 = string2 + " or name() = 'UML:Activity'";
                    string2 = string2 + " or name() = 'UML:Actor'";
                    string2 = string2 + " or name() = 'UML:Aggregation'";
                    string2 = string2 + " or name() = 'UML:Artifact'";
                    string2 = string2 + " or name() = 'UML:Association'";
                    string2 = string2 + " or name() = 'UML:Collaboration'";
                    string2 = string2 + " or name() = 'UML:Component'";
                    string2 = string2 + " or name() = 'UML:DataType'";
                    string2 = string2 + " or name() = 'UML:Interface'";
                    string2 = string2 + " or name() = 'UML:Node'";
                    string2 = string2 + " or name() = 'UML:UseCase'";
                    string2 = string2 + "]";
                } else {
                    string2 = "//UML:";
                    string2 = string2 + string;
                }
                if (this.m_Wizard != null && (iDesignPatternDetails = this.m_Wizard.getDetails()) != null && (iProject = iDesignPatternDetails.getProject()) != null) {
                    ETList<String> eTList = DesignPatternUtilities.getElementNames(iProject, string2, false);
                    ETList<String> eTList2 = DesignPatternUtilities.getElementNames(iProject, string2, true);
                    if (eTList != null) {
                        String string3 = this.formatElementNames(eTList);
                        int n = eTList.size();
                        for (int i = 0; i < n; ++i) {
                            String string4 = (String)eTList.get(i);
                            String string5 = (String)eTList2.get(i);
                            if (string5 == null || string5.length() <= 0) continue;
                            Vector<String> vector = (Vector<String>)hashtable2.get(string4);
                            if (vector == null) {
                                vector = new Vector<String>();
                            }
                            vector.add(string5);
                            hashtable2.put(string4, vector);
                        }
                        this.m_TypeMap.put(string, hashtable2);
                    }
                }
            }
        }
    }

    private boolean addChildNodeForRole(JDefaultMutableTreeNode jDefaultMutableTreeNode, IDesignPatternRole iDesignPatternRole) {
        boolean bl = true;
        if (iDesignPatternRole != null) {
            String string = iDesignPatternRole.getName();
            int n = iDesignPatternRole.getMultiplicity();
            int n2 = jDefaultMutableTreeNode.getChildCount();
            if (n2 < n) {
                WizardRoleObject wizardRoleObject = new WizardRoleObject(string, iDesignPatternRole);
                JDefaultMutableTreeNode jDefaultMutableTreeNode2 = new JDefaultMutableTreeNode((Object)wizardRoleObject, true);
                jDefaultMutableTreeNode.add((MutableTreeNode)jDefaultMutableTreeNode2);
                if (n > 1) {
                    this.calculateName(jDefaultMutableTreeNode2, wizardRoleObject);
                }
            } else {
                SwingErrorDialog swingErrorDialog = new SwingErrorDialog((JDialog)((Object)this.m_Wizard));
                if (swingErrorDialog != null) {
                    Integer n3 = new Integer(n);
                    String string2 = DesignPatternUtilities.translateString("IDS_INVALIDROLECOUNT");
                    string2 = StringUtilities.replaceSubString((String)string2, (String)"%d", (String)n3.toString());
                    String string3 = DesignPatternUtilities.translateString("IDS_TITLE1");
                    swingErrorDialog.display(string2, 0, string3);
                }
            }
        }
        return bl;
    }

    private void removeChildNodeForRole(int n) {
        int n2;
        JDefaultMutableTreeNode jDefaultMutableTreeNode;
        JDefaultMutableTreeNode jDefaultMutableTreeNode2 = this.getNodeAtGridRow(n);
        if (jDefaultMutableTreeNode2 != null && (jDefaultMutableTreeNode = (JDefaultMutableTreeNode)jDefaultMutableTreeNode2.getParent()) != null && (n2 = jDefaultMutableTreeNode.getChildCount()) > 1) {
            jDefaultMutableTreeNode.remove((MutableTreeNode)jDefaultMutableTreeNode2);
        }
    }

    public void calculateName(JDefaultMutableTreeNode jDefaultMutableTreeNode, WizardRoleObject wizardRoleObject) {
        IDesignPatternRole iDesignPatternRole;
        String string = "";
        if (wizardRoleObject != null && (iDesignPatternRole = wizardRoleObject.getRole()) != null) {
            int n;
            ETList<String> eTList;
            Object object;
            String string2 = iDesignPatternRole.getID();
            String string3 = iDesignPatternRole.getName();
            int n2 = iDesignPatternRole.getMultiplicity();
            if (n2 > 1) {
                if (jDefaultMutableTreeNode.getParent() != null && !jDefaultMutableTreeNode.getParent().equals(this.m_Root)) {
                    string = string3;
                }
            } else {
                string = string3;
            }
            int n3 = 0;
            TreeNode treeNode = jDefaultMutableTreeNode.getParent();
            if (treeNode != null && !treeNode.equals(this.m_Root) && treeNode.getChildCount() > 1) {
                object = new Integer(treeNode.getChildCount());
                string = string + ((Integer)object).toString();
            }
            if ((object = this.m_Wizard.getDetails()) != null && (eTList = object.getParticipantNames(string2)) != null && (n = eTList.size()) > 0) {
                String string4;
                String string5 = (String)eTList.get(0);
                IProject iProject = object.getProject();
                INamedElement iNamedElement = this.getElement(iProject, string4 = "//*[@xmi.id=\"" + string5 + "\"]");
                if (iNamedElement != null) {
                    string = iNamedElement.getQualifiedName();
                    wizardRoleObject.setChosenID(string5);
                } else {
                    string = string5;
                }
                if (n3 > 1) {
                    Integer n4 = new Integer(n3);
                    String string6 = n4.toString();
                    string = string + string6;
                }
            }
        }
        wizardRoleObject.setChosenName(string);
    }

    private String formatElementNames(ETList<String> eTList) {
        String string = "";
        if (eTList != null) {
            int n = eTList.size();
            if (n > 0) {
                string = string + "|";
            }
            for (int i = 0; i < n; ++i) {
                String string2 = (String)eTList.get(i);
                string = string + string2;
                string = string + "|";
            }
        }
        return string;
    }

    private INamedElement getElement(IProject iProject, String string) {
        ETList eTList;
        ElementLocator elementLocator;
        INamedElement iNamedElement = null;
        if (iProject != null && (elementLocator = new ElementLocator()) != null && (eTList = elementLocator.findElementsByDeepQuery((INamespace)iProject, string)) != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IElement iElement = (IElement)eTList.get(i);
                if (iElement == null || !(iElement instanceof INamedElement)) continue;
                iNamedElement = (INamedElement)iElement;
                break;
            }
        }
        return iNamedElement;
    }

    private void onBeforeEditGrid(int n, int n2) {
    }

    public void onCellButtonClickGrid(int n, int n2) {
        WizardRoleObject wizardRoleObject = this.getObjectAtGridRow(n);
        if (wizardRoleObject != null) {
            Object object;
            IDesignPatternRole iDesignPatternRole = wizardRoleObject.getRole();
            JTreeTable.TreeTableCellRenderer treeTableCellRenderer = this.m_Tree.getTree();
            TreePath treePath = treeTableCellRenderer.getPathForRow(n);
            if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JDefaultMutableTreeNode) {
                JDefaultMutableTreeNode jDefaultMutableTreeNode = (JDefaultMutableTreeNode)object;
                this.addChildNodeForRole(jDefaultMutableTreeNode, iDesignPatternRole);
                this.refreshTree(jDefaultMutableTreeNode, n);
            }
        }
    }

    private void refreshTree(JDefaultMutableTreeNode jDefaultMutableTreeNode, int n) {
        this.m_Tree.getTree().updateUI();
        this.m_Model.expand(n, true);
        if (jDefaultMutableTreeNode != null) {
            jDefaultMutableTreeNode.setExpanded(true);
            int n2 = jDefaultMutableTreeNode.getChildCount();
            this.m_Model.expand(n + n2, true);
        }
    }

    private void onEnterCell() {
    }

    private void onKeyDownGrid() {
    }

    public void onPopupCreate(int n) {
        JDefaultMutableTreeNode jDefaultMutableTreeNode;
        JDefaultMutableTreeNode jDefaultMutableTreeNode2 = this.getNodeAtGridRow(n);
        if (jDefaultMutableTreeNode2 != null && (jDefaultMutableTreeNode = (JDefaultMutableTreeNode)jDefaultMutableTreeNode2.getParent()) != null) {
            if (jDefaultMutableTreeNode.getParent() == null) {
                this.onCellButtonClickGrid(n, 1);
            } else {
                int n2 = jDefaultMutableTreeNode.getRow();
                this.onCellButtonClickGrid(n2 - 1, 1);
            }
        }
        this.updateUI();
    }

    public void onPopupDelete(int n) {
        Object object;
        this.removeChildNodeForRole(n);
        JTreeTable.TreeTableCellRenderer treeTableCellRenderer = this.m_Tree.getTree();
        TreePath treePath = treeTableCellRenderer.getPathForRow(n);
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JDefaultMutableTreeNode) {
            JDefaultMutableTreeNode jDefaultMutableTreeNode = (JDefaultMutableTreeNode)object;
            this.refreshTree(jDefaultMutableTreeNode, n);
        }
        this.updateUI();
    }

    public void onPopupRename(int n) {
        this.m_Tree.editCellAt(n, 2);
    }

    private void onBeforeMouseDownGrid() {
    }

    public ETList<String> showMenu(int n) {
        ETArrayList eTArrayList = new ETArrayList();
        boolean bl = this.isMultipleParticipant(n);
        boolean bl2 = this.isMultipleParticipantInstance(n);
        String string = DefaultDesignPatternResource.getString("IDS_CREATE");
        String string2 = DefaultDesignPatternResource.getString("IDS_DELETE");
        String string3 = DefaultDesignPatternResource.getString("IDS_RENAME");
        if (bl) {
            eTArrayList.add((Object)string);
        } else if (bl2) {
            eTArrayList.add((Object)string);
            eTArrayList.add((Object)string2);
        }
        return eTArrayList;
    }

    public ETList<Integer> handleKeys(int n) {
        ETArrayList eTArrayList = new ETArrayList();
        boolean bl = this.isMultipleParticipant(n);
        boolean bl2 = this.isMultipleParticipantInstance(n);
        if (bl) {
            eTArrayList.add((Object)new Integer(155));
        } else if (bl2) {
            eTArrayList.add((Object)new Integer(155));
            eTArrayList.add((Object)new Integer(127));
        }
        return eTArrayList;
    }

    private void onChangeEditGrid() {
    }

    public String getIDForElementNamed(String string, WizardRoleObject wizardRoleObject) {
        IDesignPatternRole iDesignPatternRole;
        String string2 = "";
        if (wizardRoleObject != null && (iDesignPatternRole = wizardRoleObject.getRole()) != null) {
            Object e;
            Vector vector;
            Object v;
            Hashtable hashtable;
            String string3 = iDesignPatternRole.getTypeID();
            if (string3 == null || string3.length() == 0) {
                string3 = "Classifier";
            }
            if ((hashtable = this.m_TypeMap.get(string3)) != null && (v = hashtable.get(string)) != null && (vector = (Vector)v) != null && vector.size() > 0 && (e = vector.get(0)) instanceof String) {
                string2 = (String)e;
            }
        }
        return string2;
    }

    private boolean isMultipleParticipant(int n) {
        int n2;
        JDefaultMutableTreeNode jDefaultMutableTreeNode;
        IDesignPatternRole iDesignPatternRole;
        boolean bl = false;
        WizardRoleObject wizardRoleObject = this.getObjectAtGridRow(n);
        if (wizardRoleObject != null && (iDesignPatternRole = wizardRoleObject.getRole()) != null && (jDefaultMutableTreeNode = this.getNodeAtGridRow(n)) != null && (n2 = iDesignPatternRole.getMultiplicity()) > 1 && jDefaultMutableTreeNode.getParent().equals(this.m_Root)) {
            bl = true;
        }
        return bl;
    }

    private boolean isMultipleParticipantInstance(int n) {
        int n2;
        JDefaultMutableTreeNode jDefaultMutableTreeNode;
        IDesignPatternRole iDesignPatternRole;
        boolean bl = false;
        WizardRoleObject wizardRoleObject = this.getObjectAtGridRow(n);
        if (wizardRoleObject != null && (iDesignPatternRole = wizardRoleObject.getRole()) != null && (jDefaultMutableTreeNode = this.getNodeAtGridRow(n)) != null && (n2 = iDesignPatternRole.getMultiplicity()) > 1 && !jDefaultMutableTreeNode.getParent().equals(this.m_Root)) {
            bl = true;
        }
        return bl;
    }

    private ETList<String> validatePage() {
        IDesignPatternManager iDesignPatternManager;
        IDesignPatternDetails iDesignPatternDetails;
        ETArrayList eTArrayList = new ETArrayList();
        if (this.m_Wizard != null && (iDesignPatternDetails = this.m_Wizard.getDetails()) != null && (iDesignPatternManager = this.m_Wizard.getManager()) != null) {
            iDesignPatternManager.setDetails(iDesignPatternDetails);
            int n = iDesignPatternManager.validatePattern(iDesignPatternDetails);
            if (n != -1) {
                String string = DesignPatternUtilities.translateString("IDS_MISSINGPARTICIPANT");
                eTArrayList.add((Object)string);
            }
        }
        return eTArrayList;
    }

    private boolean storeParticipants() {
        IDesignPatternDetails iDesignPatternDetails;
        boolean bl = true;
        if (this.m_Wizard != null && (iDesignPatternDetails = this.m_Wizard.getDetails()) != null) {
            iDesignPatternDetails.clearParticipantNames();
            int n = this.m_Tree.getRowCount();
            for (int i = 0; i < n; ++i) {
                IDesignPatternRole iDesignPatternRole;
                WizardRoleObject wizardRoleObject = this.getObjectAtGridRow(i);
                if (wizardRoleObject == null || (iDesignPatternRole = wizardRoleObject.getRole()) == null) continue;
                String string = iDesignPatternRole.getID();
                String string2 = wizardRoleObject.getChosenName();
                String string3 = wizardRoleObject.getChosenID();
                if (string3 != null && string3.length() > 0) {
                    iDesignPatternDetails.addParticipantName(string, string3);
                    continue;
                }
                if (string2 == null || string2.length() <= 0) continue;
                iDesignPatternDetails.addParticipantName(string, string2);
            }
        }
        return bl;
    }

    private void setPicture(IDesignPatternRole iDesignPatternRole, int n) {
        if (iDesignPatternRole != null) {
            String string = "PartFacade";
            String string2 = iDesignPatternRole.getTypeID();
            Icon icon = this.m_ResourceMgr.getIconForElementType(string = string + string2);
            if (icon != null) {
                // empty if block
            }
        }
    }

    public String buildRoleMap(IDesignPatternRole iDesignPatternRole) {
        String string = "";
        if (iDesignPatternRole != null) {
            Hashtable hashtable;
            String string2 = iDesignPatternRole.getTypeID();
            if (string2 == null || string2.length() == 0) {
                string2 = "Classifier";
            }
            if ((hashtable = this.m_TypeMap.get(string2)) == null) {
                DesignPatternUtilities.startWaitCursor((Component)this.m_Tree);
                this.buildRoleMaps(iDesignPatternRole);
                DesignPatternUtilities.endWaitCursor((Component)this.m_Tree);
            }
            if ((hashtable = this.m_TypeMap.get(string2)) != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    String string3 = (String)k;
                    string = string + "|";
                    string = string + string3;
                }
            }
        }
        return string;
    }

    public WizardRoleObject getObjectAtGridRow(int n) {
        Object object;
        WizardRoleObject wizardRoleObject = null;
        JTreeTable.TreeTableCellRenderer treeTableCellRenderer = this.m_Tree.getTree();
        TreePath treePath = treeTableCellRenderer.getPathForRow(n);
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JDefaultMutableTreeNode) {
            JDefaultMutableTreeNode jDefaultMutableTreeNode = (JDefaultMutableTreeNode)object;
            wizardRoleObject = (WizardRoleObject)jDefaultMutableTreeNode.getUserObject();
        }
        return wizardRoleObject;
    }

    public JDefaultMutableTreeNode getNodeAtGridRow(int n) {
        Object object;
        JTreeTable.TreeTableCellRenderer treeTableCellRenderer;
        TreePath treePath;
        JDefaultMutableTreeNode jDefaultMutableTreeNode = null;
        if (n >= 0 && this.m_Tree != null && (treePath = (treeTableCellRenderer = this.m_Tree.getTree()).getPathForRow(n)) != null && (object = treePath.getLastPathComponent()) instanceof JDefaultMutableTreeNode) {
            jDefaultMutableTreeNode = (JDefaultMutableTreeNode)object;
        }
        return jDefaultMutableTreeNode;
    }

    public void setRightClickRow(int n) {
        this.m_RightClickRow = n;
    }
}

