/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.designpattern;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.infrastructure.ICollaboration;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.designpattern.DefaultDesignPatternResource;
import org.netbeans.modules.uml.designpattern.DesignPatternUtilities;
import org.netbeans.modules.uml.designpattern.IDesignPatternDetails;
import org.netbeans.modules.uml.designpattern.IDesignPatternManager;
import org.netbeans.modules.uml.designpattern.Wizard;
import org.netbeans.modules.uml.ui.support.wizard.IWizardSheet;
import org.netbeans.modules.uml.ui.support.wizard.WizardInteriorPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardPatternSelection
extends WizardInteriorPage {
    private static final String PG_CAPTION = DefaultDesignPatternResource.getString("IDS_WIZARDCAPTION");
    private static final String PG_TITLE = DefaultDesignPatternResource.getString("IDS_PATTERNSELECTION");
    private static final String PG_SUBTITLE = DefaultDesignPatternResource.getString("IDS_PATTERNSELECTIONHELP");
    private Wizard m_Wizard = null;
    private ICollaboration m_Pattern = null;
    private IProject m_Project = null;
    private JComboBox m_ProjectList = new JComboBox();
    private JLabel jLabel1 = new JLabel();
    private JComboBox m_PatternList = new JComboBox();
    private JLabel jLabel2 = new JLabel();
    private JTextArea helpCaption = new JTextArea();

    public WizardPatternSelection(IWizardSheet iWizardSheet, String string, String string2, String string3) {
        super(iWizardSheet, string, string2, string3);
        this.createUI();
    }

    public WizardPatternSelection(IWizardSheet iWizardSheet) {
        this(iWizardSheet, PG_CAPTION, PG_TITLE, PG_SUBTITLE);
    }

    protected void createUI() {
        super.createUI();
        this.jLabel1.setText(DefaultDesignPatternResource.determineText((String)DefaultDesignPatternResource.getString("IDS_PROJECT")));
        DefaultDesignPatternResource.setMnemonic((Object)this.jLabel1, (String)DefaultDesignPatternResource.getString("IDS_PROJECT"));
        this.jLabel1.setLabelFor(this.m_ProjectList);
        DefaultDesignPatternResource.setFocusAccelerator((Object)this.m_ProjectList, (String)DefaultDesignPatternResource.getString("IDS_PROJECT"));
        this.jLabel1.setBorder(new EmptyBorder(new Insets(0, 0, 3, 0)));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(DefaultDesignPatternResource.getString("ACSD_PROJECT_COMBOBOX"));
        this.jLabel2.setText(DefaultDesignPatternResource.determineText((String)DefaultDesignPatternResource.getString("IDS_DESIGNPATTERN")));
        DefaultDesignPatternResource.setMnemonic((Object)this.jLabel2, (String)DefaultDesignPatternResource.getString("IDS_DESIGNPATTERN"));
        this.jLabel2.setLabelFor(this.m_PatternList);
        DefaultDesignPatternResource.setFocusAccelerator((Object)this.m_PatternList, (String)DefaultDesignPatternResource.getString("IDS_DESIGNPATTERN"));
        this.jLabel2.setBorder(new EmptyBorder(new Insets(0, 0, 3, 0)));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(DefaultDesignPatternResource.getString("ACSD_DESIGNPATTERN_COMBOBOX"));
        this.helpCaption.setLineWrap(true);
        this.helpCaption.setOpaque(false);
        this.helpCaption.setPreferredSize(new Dimension(300, 30));
        this.helpCaption.setMinimumSize(new Dimension(300, 30));
        this.helpCaption.setFont(new Font("SansSerif", 0, 10));
        this.helpCaption.setEditable(false);
        this.helpCaption.setFocusable(false);
        this.helpCaption.getAccessibleContext().setAccessibleName(DefaultDesignPatternResource.getString("ACSN_TEXTAREA"));
        this.helpCaption.getAccessibleContext().setAccessibleDescription(DefaultDesignPatternResource.getString("ACSD_TEXTAREA"));
        this.pnlContents.setLayout(new GridBagLayout());
        this.pnlContents.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 0, 205), 32, 0));
        this.pnlContents.add((Component)this.m_ProjectList, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 284, 0));
        this.pnlContents.add((Component)this.jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 0, 205), 32, 0));
        this.pnlContents.add((Component)this.m_PatternList, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 284, 0));
        this.pnlContents.add((Component)this.helpCaption, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 20, 200, 20), 47, 1));
        this.m_ProjectList.setEditable(false);
        this.m_PatternList.setEditable(false);
        this.pnlContents.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.addActionListeners();
        this.onInitDialog();
    }

    private void addActionListeners() {
        this.m_ProjectList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WizardPatternSelection.this.m_ProjectList_actionPerformed(actionEvent);
            }
        });
        this.m_PatternList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WizardPatternSelection.this.m_PatternList_actionPerformed(actionEvent);
            }
        });
    }

    private void m_ProjectList_actionPerformed(ActionEvent actionEvent) {
        this.onSelChangeProjectList();
    }

    private void m_PatternList_actionPerformed(ActionEvent actionEvent) {
        this.onSelChangePatternList();
    }

    protected boolean onInitDialog() {
        IDesignPatternDetails iDesignPatternDetails;
        super.onInitDialog();
        IWizardSheet iWizardSheet = this.getParentSheet();
        this.m_Wizard = (Wizard)iWizardSheet;
        if (this.m_Wizard != null && (iDesignPatternDetails = this.m_Wizard.getDetails()) != null) {
            this.m_Pattern = iDesignPatternDetails.getCollaboration();
        }
        if (this.m_Pattern != null) {
            this.m_ProjectList.setEnabled(false);
            this.m_PatternList.setEnabled(false);
        } else {
            this.m_ProjectList.setEnabled(true);
            this.m_PatternList.setEnabled(true);
        }
        return true;
    }

    public void onSetActive() {
        this.populateProjectList();
        this.populateProject();
        this.populatePattern();
        super.onSetActive();
    }

    public void onWizardBack() {
        if (this.m_Wizard != null) {
            this.m_Wizard.m_RefreshPages = false;
        }
        super.onWizardBack();
    }

    public void onWizardNext() {
        ETList<String> eTList = this.validatePage();
        if (eTList != null && eTList.size() == 0) {
            ETList<IElement> eTList2;
            String string = (String)this.m_PatternList.getSelectedItem();
            IDesignPatternManager iDesignPatternManager = this.m_Wizard.getManager();
            if (iDesignPatternManager != null && (eTList2 = iDesignPatternManager.getPatternsInProject(this.m_Project)) != null) {
                int n = eTList2.size();
                for (int i = 0; i < n; ++i) {
                    ICollaboration iCollaboration;
                    String string2;
                    IElement iElement = (IElement)eTList2.get(i);
                    if (iElement == null || !(iElement instanceof ICollaboration) || (string2 = (iCollaboration = (ICollaboration)iElement).getQualifiedName()) == null || !string2.equals(string)) continue;
                    this.m_Pattern = iCollaboration;
                    IDesignPatternDetails iDesignPatternDetails = this.m_Wizard.getDetails();
                    if (iDesignPatternDetails == null) continue;
                    iDesignPatternDetails.setCollaboration(this.m_Pattern);
                    iDesignPatternDetails.setRoles(null);
                    iDesignPatternDetails.clearParticipantNames();
                    iDesignPatternManager.buildPatternDetails(this.m_Pattern, iDesignPatternDetails);
                    break;
                }
            }
            super.onWizardNext();
        } else if (eTList != null && eTList.size() > 0) {
            String string = DesignPatternUtilities.formatErrorMessage(eTList);
            DesignPatternUtilities.displayErrorMessage((JDialog)((Object)this.m_Wizard), string);
        }
    }

    private void populateProjectList() {
        if (this.m_ProjectList.getItemCount() == 0) {
            DesignPatternUtilities.populateProjectListWithDesignCenterProjects(this.m_ProjectList, false);
        }
    }

    private void populateProject() {
        IProject iProject;
        if (this.m_Pattern != null && (iProject = this.m_Pattern.getProject()) != null) {
            DesignPatternUtilities.populateProjectListWithUserProjects(this.m_ProjectList, false);
            String string = iProject.getName();
            this.m_ProjectList.setSelectedItem(string);
        }
        this.onSelChangeProjectList();
    }

    private void populatePattern() {
        if (this.m_Pattern != null) {
            String string = this.m_Pattern.getQualifiedName();
            this.m_PatternList.setSelectedItem(string);
        }
    }

    private void onSelChangeProjectList() {
        IProject iProject;
        this.m_Project = null;
        String string = (String)this.m_ProjectList.getSelectedItem();
        if (string != null && string.length() > 0 && (iProject = DesignPatternUtilities.onSelChangeProjectList(string, (JDialog)((Object)this.m_Wizard))) != null) {
            this.m_Project = iProject;
            DesignPatternUtilities.populatePatternList(this.m_PatternList, iProject);
            this.m_Wizard.m_RefreshPages = true;
        }
    }

    private ETList<String> validatePage() {
        ETArrayList eTArrayList = new ETArrayList();
        if (this.m_Pattern == null) {
            String string;
            if (this.m_ProjectList.getSelectedIndex() == -1) {
                string = DesignPatternUtilities.translateString("IDS_SCOPE_NOSELECT");
                eTArrayList.add((Object)string);
            }
            if (this.m_PatternList.getSelectedIndex() == -1) {
                string = DesignPatternUtilities.translateString("IDS_SCOPE_SELECT");
                eTArrayList.add((Object)string);
            }
        }
        return eTArrayList;
    }

    private void onSelChangePatternList() {
        this.m_Wizard.m_RefreshPages = true;
    }
}

