/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.xpatheditor;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.SoaUiUtil;
import org.netbeans.modules.soa.ui.UserNotification;
import org.netbeans.modules.soa.ui.axinodes.AxiomChildren;
import org.netbeans.modules.soa.ui.axinodes.AxiomNode;
import org.netbeans.modules.soa.ui.axinodes.AxiomTreeNodeFactory;
import org.netbeans.modules.soa.ui.axinodes.AxiomUtils;
import org.netbeans.modules.soa.ui.axinodes.NodeType;
import org.netbeans.modules.soa.ui.form.ChooserLifeCycle;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.soa.ui.nodes.NodeFactory;
import org.netbeans.modules.soa.ui.nodes.NodesTreeModel;
import org.netbeans.modules.soa.ui.nodes.NodesTreeRenderer;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.XPathException;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathModel;
import org.netbeans.modules.xslt.mapper.model.MapperContext;
import org.netbeans.modules.xslt.mapper.view.XsltMapper;
import org.netbeans.modules.xslt.mapper.xpatheditor.ItemNode;
import org.netbeans.modules.xslt.mapper.xpatheditor.PaletteTreeNodeFactory;
import org.netbeans.modules.xslt.mapper.xpatheditor.XpathPaletteItemInfo;
import org.netbeans.modules.xslt.model.XslModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEditor
extends JPanel
implements ChooserLifeCycle<String>,
Validator.Provider {
    private static final long serialVersionUID = 1L;
    private XsltMapper myMapper;
    private DefaultValidator myValidator;
    private static final String INPUT_PARAM = "InputParam";
    private JButton btnCheckSyntax;
    private JLabel lblExpression;
    private JLabel lblFunctions;
    private JLabel lblSchema;
    private JScrollPane scrExpression;
    private JScrollPane scrFunctions;
    private JScrollPane scrSchema;
    private JTree treeFunctions;
    private JTree treeSchema;
    private JTextArea txtExpression;

    public ExpressionEditor(IBasicMapper iBasicMapper) {
        assert (iBasicMapper instanceof XsltMapper);
        this.myMapper = (XsltMapper)iBasicMapper;
        this.createContent();
        this.initControls();
    }

    public void createContent() {
        AxiomChildren axiomChildren;
        Lookup lookup;
        PaletteTreeNodeFactory paletteTreeNodeFactory;
        FileObject fileObject;
        this.initComponents();
        Lookup lookup2 = this.myMapper.getLookup();
        MapperContext mapperContext = this.myMapper.getContext();
        AXIComponent aXIComponent = mapperContext.getSourceType();
        if (aXIComponent != null) {
            boolean bl;
            fileObject = new AxiomTreeNodeFactory();
            paletteTreeNodeFactory = ExtendedLookup.createExtendedLookup((Lookup)lookup2, (Object[])new Object[]{fileObject});
            if (aXIComponent instanceof Element) {
                lookup = fileObject.createNode(NodeType.ELEMENT, (Object)aXIComponent, (Lookup)paletteTreeNodeFactory);
                bl = true;
            } else {
                axiomChildren = new AxiomChildren(aXIComponent, (Lookup)paletteTreeNodeFactory);
                String string = NbBundle.getMessage(this.getClass(), (String)"LBL_SourceSchemaModel");
                lookup = new NodeFactory.TextNode((Children)axiomChildren, string);
                bl = false;
            }
            axiomChildren = new NodesTreeModel((Node)lookup);
            this.treeSchema.setModel((TreeModel)axiomChildren);
            this.treeSchema.setCellRenderer((TreeCellRenderer)new NodesTreeRenderer());
            this.treeSchema.setRootVisible(bl);
            this.treeSchema.setShowsRootHandles(true);
        }
        fileObject = ExpressionEditor.getPaletteFolder("XsltPalette");
        paletteTreeNodeFactory = new PaletteTreeNodeFactory();
        lookup = ExtendedLookup.createExtendedLookup((Lookup)lookup2, (Object[])new Object[]{paletteTreeNodeFactory});
        Node node = paletteTreeNodeFactory.createNode(PaletteTreeNodeFactory.NodeType.ROOT, (Object)fileObject, lookup);
        axiomChildren = new NodesTreeModel(node);
        this.treeFunctions.setModel((TreeModel)axiomChildren);
        this.treeFunctions.setCellRenderer((TreeCellRenderer)new NodesTreeRenderer());
        this.treeFunctions.setRootVisible(false);
        this.treeFunctions.setShowsRootHandles(true);
        this.treeSchema.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                TreePath treePath;
                if (mouseEvent.getClickCount() == 2 && (treePath = ExpressionEditor.this.treeSchema.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) != null && object instanceof AxiomNode) {
                    ExpressionEditor.this.addXPath((AxiomNode)object);
                }
            }
        });
        this.treeFunctions.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                TreePath treePath;
                if (mouseEvent.getClickCount() == 2 && (treePath = ExpressionEditor.this.treeFunctions.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) != null && object instanceof ItemNode) {
                    ExpressionEditor.this.addFunction((ItemNode)((Object)object));
                }
            }
        });
        this.btnCheckSyntax.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ExpressionEditor.this.checkSyntax();
                if (bl) {
                    String string = NbBundle.getMessage(ExpressionEditor.class, (String)"MSG_ValidXPath");
                    UserNotification.showMessage((String)string);
                }
            }
        });
        SoaUiUtil.activateInlineMnemonics((Container)this);
    }

    public boolean initControls() {
        return true;
    }

    public void setSelectedValue(String string) {
        this.txtExpression.setText(string);
    }

    public String getSelectedValue() {
        return this.txtExpression.getText();
    }

    public boolean afterClose() {
        return true;
    }

    public boolean unsubscribeListeners() {
        return true;
    }

    public boolean subscribeListeners() {
        return true;
    }

    private static FileObject getPaletteFolder(String string) {
        FileObject fileObject = null;
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        fileObject = fileSystem.findResource(string);
        return fileObject;
    }

    private void addXPath(AxiomNode axiomNode) {
        XslModel xslModel = this.myMapper.getContext().getXSLModel();
        AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)xslModel.getStylesheet();
        String string = this.txtExpression.getText();
        int n = this.txtExpression.getSelectionStart();
        int n2 = this.txtExpression.getSelectionEnd();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.needWhitespaceBefore(string, n)) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(AxiomUtils.calculateSimpleXPath((AxiomNode)axiomNode, (AbstractDocumentComponent)abstractDocumentComponent));
        if (this.needWhitespaceAfter(string, n2)) {
            stringBuilder.append(" ");
        }
        int n3 = n;
        int n4 = n + stringBuilder.length();
        this.txtExpression.replaceSelection(stringBuilder.toString());
        this.txtExpression.setCaretPosition(n4);
        this.txtExpression.requestFocus();
    }

    private void addFunction(ItemNode itemNode) {
        XpathPaletteItemInfo xpathPaletteItemInfo = itemNode.getItemInfo();
        if (xpathPaletteItemInfo != null) {
            String string = this.txtExpression.getText();
            int n = this.txtExpression.getSelectionStart();
            int n2 = this.txtExpression.getSelectionEnd();
            int n3 = n;
            int n4 = n;
            StringBuilder stringBuilder = new StringBuilder();
            if (xpathPaletteItemInfo.isOperator()) {
                if (this.needWhitespaceBefore(string, n)) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(xpathPaletteItemInfo.getOperation());
                if (this.needWhitespaceAfter(string, n2)) {
                    stringBuilder.append(" ");
                }
                n4 = n3 = n + stringBuilder.length();
            } else if (xpathPaletteItemInfo.isFunction()) {
                if (this.needWhitespaceBefore(string, n)) {
                    stringBuilder.append(" ");
                }
                int n5 = xpathPaletteItemInfo.getMaxInput();
                switch (n5) {
                    case 1: {
                        String string2 = xpathPaletteItemInfo.getItemAttribute("InputParam1");
                        stringBuilder.append(xpathPaletteItemInfo.getOperation()).append("(");
                        n3 = n + stringBuilder.length();
                        stringBuilder.append(string2);
                        n4 = n + stringBuilder.length();
                        stringBuilder.append(")");
                        break;
                    }
                    case 2: {
                        String string3 = xpathPaletteItemInfo.getItemAttribute("InputParam1");
                        stringBuilder.append(xpathPaletteItemInfo.getOperation()).append("(");
                        n3 = n + stringBuilder.length();
                        stringBuilder.append(string3);
                        n4 = n + stringBuilder.length();
                        String string4 = xpathPaletteItemInfo.getItemAttribute("InputParam2");
                        stringBuilder.append(", ").append(string4);
                        stringBuilder.append(")");
                        break;
                    }
                    case 3: {
                        String string5 = xpathPaletteItemInfo.getItemAttribute("InputParam1");
                        stringBuilder.append(xpathPaletteItemInfo.getOperation()).append("(");
                        n3 = n + stringBuilder.length();
                        stringBuilder.append(string5);
                        n4 = n + stringBuilder.length();
                        String string6 = xpathPaletteItemInfo.getItemAttribute("InputParam2");
                        stringBuilder.append(", ").append(string6);
                        String string7 = xpathPaletteItemInfo.getItemAttribute("InputParam3");
                        stringBuilder.append(", ").append(string7);
                        stringBuilder.append(")");
                        break;
                    }
                    default: {
                        String string8 = xpathPaletteItemInfo.getItemAttribute("InputParam1");
                        stringBuilder.append(xpathPaletteItemInfo.getOperation()).append("(");
                        n4 = n3 = n + stringBuilder.length();
                        stringBuilder.append(")");
                    }
                }
                if (this.needWhitespaceAfter(string, n2)) {
                    stringBuilder.append(" ");
                }
            }
            if (stringBuilder != null && stringBuilder.length() > 0) {
                this.txtExpression.replaceSelection(stringBuilder.toString());
                this.txtExpression.setCaretPosition(n3);
                this.txtExpression.setSelectionStart(n3);
                this.txtExpression.setSelectionEnd(n4);
                this.txtExpression.requestFocus();
            }
        }
    }

    private boolean needWhitespaceBefore(String string, int n) {
        if (string.length() == 0 || n == 0) {
            return false;
        }
        char c = string.charAt(n - 1);
        return !Character.isWhitespace(c) && "(".indexOf(c) < 0;
    }

    private boolean needWhitespaceAfter(String string, int n) {
        if (string.length() == 0 || n == string.length()) {
            return false;
        }
        char c = string.charAt(n);
        return !Character.isWhitespace(c) && ",)".indexOf(c) < 0;
    }

    private boolean checkSyntax() {
        boolean bl = true;
        String string = this.txtExpression.getText();
        if (string == null || string.length() == 0) {
            return bl;
        }
        XPathModel xPathModel = AbstractXPathModelHelper.getInstance().newXPathModel();
        try {
            XPathExpression xPathExpression = xPathModel.parseExpression(string);
        }
        catch (XPathException xPathException) {
            String string2 = null;
            Throwable throwable = xPathException.getCause();
            if (throwable != null) {
                string2 = throwable.getMessage();
            }
            if (string2 == null) {
                string2 = xPathException.getMessage();
            }
            UserNotification.showMessage((String)string2);
            bl = false;
        }
        return bl;
    }

    public Validator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = new DefaultValidator(this, ExpressionEditor.class){

                public void doFastValidation() {
                }

                public void doDetailedValidation() {
                    super.doDetailedValidation();
                    if (!ExpressionEditor.this.checkSyntax()) {
                        this.addReason(new Validator.Reason(Validator.Severity.ERROR, "Wrong XPath syntax"));
                    }
                }
            };
        }
        return this.myValidator;
    }

    private void initComponents() {
        this.lblSchema = new JLabel();
        this.lblFunctions = new JLabel();
        this.lblExpression = new JLabel();
        this.scrSchema = new JScrollPane();
        this.treeSchema = new JTree();
        this.scrFunctions = new JScrollPane();
        this.treeFunctions = new JTree();
        this.scrExpression = new JScrollPane();
        this.txtExpression = new JTextArea();
        this.btnCheckSyntax = new JButton();
        this.lblSchema.setLabelFor(this.treeSchema);
        this.lblSchema.setText(NbBundle.getMessage(ExpressionEditor.class, (String)"LBL_Schema"));
        this.lblFunctions.setLabelFor(this.treeFunctions);
        this.lblFunctions.setText(NbBundle.getMessage(ExpressionEditor.class, (String)"LBL_Functions"));
        this.lblExpression.setLabelFor(this.txtExpression);
        this.lblExpression.setText(NbBundle.getMessage(ExpressionEditor.class, (String)"LBL_Expression"));
        this.scrSchema.setViewportView(this.treeSchema);
        this.scrFunctions.setViewportView(this.treeFunctions);
        this.txtExpression.setColumns(20);
        this.txtExpression.setRows(5);
        this.scrExpression.setViewportView(this.txtExpression);
        this.btnCheckSyntax.setText(NbBundle.getMessage(ExpressionEditor.class, (String)"BTN_CheckSyntax"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.scrExpression, -1, 655, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.scrSchema, -1, 435, Short.MAX_VALUE).add(7, 7, 7)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblSchema).addPreferredGap(0))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblFunctions).add((Component)this.scrFunctions, -2, 213, -2))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblExpression).addPreferredGap(0, 500, Short.MAX_VALUE).add((Component)this.btnCheckSyntax))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblSchema).add((Component)this.lblFunctions)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.scrFunctions, -1, 250, Short.MAX_VALUE).add((Component)this.scrSchema, -1, 250, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnCheckSyntax).add((Component)this.lblExpression)).addPreferredGap(0).add((Component)this.scrExpression, -2, 115, -2)));
        this.lblSchema.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExpressionEditor.class, (String)"ACSN_LBL_Schema"));
        this.lblSchema.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExpressionEditor.class, (String)"ACSD_LBL_Schema"));
        this.lblFunctions.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExpressionEditor.class, (String)"ACSN_LBL_Functions"));
        this.lblFunctions.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExpressionEditor.class, (String)"ACSD_LBL_Functions"));
        this.lblExpression.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExpressionEditor.class, (String)"ACSN_LBL_Expression"));
        this.lblExpression.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExpressionEditor.class, (String)"ACSD_LBL_Expression"));
        this.btnCheckSyntax.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExpressionEditor.class, (String)"ACSN_BTN_CheckSyntax"));
        this.btnCheckSyntax.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExpressionEditor.class, (String)"ACSD_BTN_CheckSyntax"));
    }
}

