/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.view;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mapper.basicmapper.BasicMapper;
import org.netbeans.modules.soa.mapper.basicmapper.util.MapperUtilities;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperListener;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperRule;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.IMapperCanvasView;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdaterFactory;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeView;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasMouseListener;
import org.netbeans.modules.xslt.mapper.methoid.LiteralUpdaterFactory;
import org.netbeans.modules.xslt.mapper.model.MapperContext;
import org.netbeans.modules.xslt.mapper.model.MapperContextChangeListenerAdapter;
import org.netbeans.modules.xslt.mapper.model.SchemaModelBridge;
import org.netbeans.modules.xslt.mapper.model.SourceTreeModel;
import org.netbeans.modules.xslt.mapper.model.XsltModelBridge;
import org.netbeans.modules.xslt.mapper.model.XsltNodesTreeRenderer;
import org.netbeans.modules.xslt.mapper.model.nodes.Node;
import org.netbeans.modules.xslt.mapper.model.nodes.TreeNode;
import org.netbeans.modules.xslt.mapper.model.nodes.actions.DeleteAction;
import org.netbeans.modules.xslt.mapper.model.targettree.TargetTreeModel;
import org.netbeans.modules.xslt.mapper.view.DiagramBuilder;
import org.netbeans.modules.xslt.mapper.view.ErrorPanel;
import org.netbeans.modules.xslt.mapper.view.LiteralEditListener;
import org.netbeans.modules.xslt.mapper.view.PredicateManager;
import org.netbeans.modules.xslt.mapper.view.XsltMapperRule;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class XsltMapper
extends BasicMapper
implements HelpCtx.Provider {
    private MapperContext context;
    private Lookup lookup;
    private ILiteralUpdaterFactory myLiteralUpdaterFactory;
    private LiteralEditListener myLiteralEditListener;
    private XsltModelBridge xslModelBridge;
    private SchemaModelBridge schemaModelBridge;
    private DiagramBuilder diagramBuilder;
    private ErrorPanel errorPanel;
    private PredicateManager myPredicateManager;

    public XsltMapper(Lookup lookup) {
        this.lookup = lookup;
        this.context = (MapperContext)lookup.lookup(MapperContext.class);
        this.myPredicateManager = new PredicateManager(this);
        this.errorPanel = new ErrorPanel(this);
        this.initializeTrees();
        this.xslModelBridge = new XsltModelBridge(this);
        this.schemaModelBridge = new SchemaModelBridge(this);
        this.diagramBuilder = new DiagramBuilder(this);
        super.addMapperListener((IMapperListener)this.xslModelBridge);
        super.setMapperRule((IBasicMapperRule)new XsltMapperRule(this));
        if (this.context != null) {
            this.context.addMapperContextChangeListener(new MapperContextChangeListenerAdapter(){

                public void mapperContextChanged(Object object, Object object2) {
                    XsltMapper.this.schemaModelBridge.updateDiagram();
                }
            });
        }
        this.setLiteralUpdaterFactory(new LiteralUpdaterFactory((IBasicMapper)this));
        this.xslModelBridge.updateDiagram();
    }

    public MapperContext getContext() {
        return this.context;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public DiagramBuilder getBuilder() {
        return this.diagramBuilder;
    }

    protected void initializeTrees() {
        JTree jTree = this.getMapperViewManager().getSourceView().getTree();
        jTree.setModel(new SourceTreeModel(this));
        jTree.setRootVisible(true);
        jTree.setShowsRootHandles(true);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.expandRow(0);
        jTree.setCellRenderer(new XsltNodesTreeRenderer());
        final JTree jTree2 = this.getMapperViewManager().getDestView().getTree();
        jTree2.setModel(new TargetTreeModel(this));
        jTree2.setRootVisible(false);
        jTree2.setShowsRootHandles(true);
        jTree2.getSelectionModel().setSelectionMode(1);
        jTree2.expandRow(0);
        jTree2.setCellRenderer(new XsltNodesTreeRenderer());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TreeNode treeNode;
                    JPopupMenu jPopupMenu;
                    Object object;
                    Object object2 = mouseEvent.getSource();
                    assert (object2 instanceof JTree);
                    TreePath treePath = ((JTree)object2).getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null && (object = treePath.getLastPathComponent()) instanceof TreeNode && (jPopupMenu = (treeNode = (TreeNode)object).constructPopupMenu()) != null) {
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        };
        jTree2.addMouseListener(mouseAdapter);
        jTree.addMouseListener(mouseAdapter);
        jTree2.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    TreeNode treeNode = (TreeNode)jTree2.getSelectionPath().getLastPathComponent();
                    DeleteAction deleteAction = new DeleteAction(XsltMapper.this, treeNode);
                    deleteAction.actionPerformed(null);
                }
            }
        });
    }

    public void setLiteralUpdaterFactory(ILiteralUpdaterFactory iLiteralUpdaterFactory) {
        super.setLiteralUpdaterFactory(iLiteralUpdaterFactory);
        this.myLiteralUpdaterFactory = iLiteralUpdaterFactory;
        if (this.myLiteralEditListener == null) {
            IMapperCanvasView iMapperCanvasView = this.getMapperViewManager().getCanvasView();
            this.myLiteralEditListener = new LiteralEditListener((IBasicMapper)this);
            iMapperCanvasView.getCanvas().addCanvasMouseListener((ICanvasMouseListener)this.myLiteralEditListener);
            this.getMapperController().addMapperListener((IMapperListener)this.myLiteralEditListener);
        }
    }

    public ILiteralUpdaterFactory getLiteralUpdaterFactory() {
        return this.myLiteralUpdaterFactory;
    }

    public IMapperNode getMapperNode(TreeNode treeNode) {
        TreePath treePath = TreeNode.getTreePath(treeNode);
        IMapperNode iMapperNode = this.findNodeInTree(treePath, this.getMapperViewManager().getSourceView());
        if (iMapperNode == null) {
            return this.findNodeInTree(treePath, this.getMapperViewManager().getDestView());
        }
        return iMapperNode;
    }

    private IMapperNode findNodeInTree(TreePath treePath, IMapperTreeView iMapperTreeView) {
        if (iMapperTreeView.getTree().getModel().getRoot() == treePath.getPathComponent(0)) {
            return iMapperTreeView.getMapperTreeNode(treePath);
        }
        return null;
    }

    public void addLink(Node node, Node node2) {
        IMapperNode iMapperNode;
        IMapperNode iMapperNode2 = node.getOutputNode();
        if (iMapperNode2 != null & (iMapperNode = node2.getInputNode(node)) != null) {
            IMapperLink iMapperLink = super.createLink(iMapperNode2, iMapperNode);
            this.addLink(iMapperLink);
        }
    }

    public void removeLink(IMapperLink iMapperLink) {
        IMapperNode iMapperNode = iMapperLink.getStartNode();
        IMapperNode iMapperNode2 = iMapperLink.getEndNode();
        if (iMapperNode != null) {
            iMapperNode.removeLink(iMapperLink);
        }
        if (iMapperNode2 != null) {
            iMapperNode2.removeLink(iMapperLink);
        }
        if (this.getMapperViewManager().getMapperModel() != null && this.getMapperViewManager().getMapperModel().getSelectedViewModel() != null) {
            IBasicViewModel iBasicViewModel = this.getMapperViewManager().getMapperModel().getSelectedViewModel();
            if (iMapperNode instanceof IMapperTreeNode && iMapperNode.getLinkCount() == 0) {
                iBasicViewModel.removeNode(iMapperNode);
            }
            if (iMapperNode2 instanceof IMapperTreeNode && iMapperNode2.getLinkCount() == 0) {
                iBasicViewModel.removeNode(iMapperNode2);
            }
        }
        if (!this.diagramBuilder.isUpdating()) {
            this.getMapperViewManager().postMapperEvent(MapperUtilities.getMapperEvent((Object)((Object)this), (Object)iMapperLink, (String)"MapperEvt.LinkDel", (String)"Link removed from mapper"));
        }
    }

    public void addLink(IMapperLink iMapperLink) {
        IMapperNode iMapperNode = iMapperLink.getStartNode();
        IMapperNode iMapperNode2 = iMapperLink.getEndNode();
        this.connectLink(iMapperLink);
        if (this.getMapperViewManager().getMapperModel() != null && this.getMapperViewManager().getMapperModel().getSelectedViewModel() != null) {
            IMapperNode iMapperNode3;
            IBasicViewModel iBasicViewModel = this.getMapperViewManager().getMapperModel().getSelectedViewModel();
            if (iMapperNode != null) {
                iMapperNode3 = iMapperNode;
                while (iMapperNode3.getGroupNode() != null) {
                    iMapperNode3 = iMapperNode3.getGroupNode();
                }
                if (!iBasicViewModel.containsNode(iMapperNode3)) {
                    this.addNode(iMapperNode3);
                }
            }
            if (iMapperNode2 != null) {
                iMapperNode3 = iMapperNode2;
                while (iMapperNode3.getGroupNode() != null) {
                    iMapperNode3 = iMapperNode3.getGroupNode();
                }
                if (!iBasicViewModel.containsNode(iMapperNode3)) {
                    this.addNode(iMapperNode3);
                }
            }
        }
        if (!this.diagramBuilder.isUpdating()) {
            this.getMapperViewManager().postMapperEvent(MapperUtilities.getMapperEvent((Object)((Object)this), (Object)iMapperLink, (String)"MapperEvt.LinkAdded", (String)"New Link added to mapper"));
        }
    }

    public void addNode(IMapperNode iMapperNode) {
        if (this.getMapperViewManager().getMapperModel() != null && this.getMapperViewManager().getMapperModel().getSelectedViewModel() != null) {
            IBasicViewModel iBasicViewModel = this.getMapperViewManager().getMapperModel().getSelectedViewModel();
            iBasicViewModel.addNode(iMapperNode);
            if (!this.diagramBuilder.isUpdating()) {
                this.getMapperViewManager().postMapperEvent(MapperUtilities.getMapperEvent((Object)((Object)this), (Object)iMapperNode, (String)"MapperEvt.NodeAdded", (String)"New Node added to mapper"));
            }
        }
    }

    public void setError(String string) {
        if (string == null) {
            this.errorPanel.uninstall();
        } else {
            this.errorPanel.setMessage(string);
            this.errorPanel.install();
        }
    }

    public PredicateManager getPredicateManager() {
        return this.myPredicateManager;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("xslt_editor_design_about");
    }
}

