/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.view;

import java.awt.Point;
import org.netbeans.modules.soa.mapper.common.IMapperEvent;
import org.netbeans.modules.soa.mapper.common.IMapperListener;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperRule;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasView;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdater;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IField;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasMouseData;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasMouseListener;
import org.netbeans.modules.xslt.mapper.methoid.Constants;
import org.netbeans.modules.xslt.mapper.model.nodes.LiteralCanvasNode;
import org.netbeans.modules.xslt.mapper.view.XsltMapper;

public class LiteralEditListener
implements ICanvasMouseListener,
IMapperListener {
    private XsltMapper myMapper;

    public LiteralEditListener(IBasicMapper iBasicMapper) {
        assert (iBasicMapper instanceof XsltMapper);
        this.myMapper = (XsltMapper)iBasicMapper;
    }

    public boolean doMouseDblClick(ICanvasMouseData iCanvasMouseData) {
        String string;
        Point point;
        int n = iCanvasMouseData.getMouseModifier();
        if ((n & 0x10) == 0) {
            return false;
        }
        ICanvasView iCanvasView = this.myMapper.getMapperViewManager().getCanvasView().getCanvas();
        ICanvasMethoidNode iCanvasMethoidNode = iCanvasView.getCanvasMethoidNodeByPoint(point = iCanvasMouseData.getViewLocation());
        if (iCanvasMethoidNode == null) {
            return false;
        }
        IMethoidNode iMethoidNode = iCanvasMethoidNode.getMethoidNode();
        if (iMethoidNode == null) {
            return false;
        }
        Object object = iMethoidNode.getNodeObject();
        if (object == null || !(object instanceof LiteralCanvasNode)) {
            return false;
        }
        ICanvasFieldNode iCanvasFieldNode = iCanvasView.getCanvasFieldNodeByPoint(point);
        if (iCanvasFieldNode == null) {
            return false;
        }
        IFieldNode iFieldNode = iCanvasFieldNode.getFieldNode();
        if (iFieldNode == null) {
            return false;
        }
        IField iField = (IField)iFieldNode.getFieldObject();
        if (iField == null) {
            return false;
        }
        ILiteralUpdater iLiteralUpdater = iField.getLiteralUpdater();
        if (iLiteralUpdater == null) {
            string = iField.getType();
            iLiteralUpdater = this.myMapper.getLiteralUpdaterFactory().createLiteralUpdater(string);
            if (iLiteralUpdater == null) {
                return false;
            }
        }
        if ((string = iLiteralUpdater.getEditor((IBasicMapper)this.myMapper, iFieldNode)) != null) {
            string.show();
        }
        return true;
    }

    public boolean doMouseUp(ICanvasMouseData iCanvasMouseData) {
        return false;
    }

    public boolean doMouseMove(ICanvasMouseData iCanvasMouseData) {
        return false;
    }

    public boolean doMouseDown(ICanvasMouseData iCanvasMouseData) {
        return false;
    }

    public boolean doMouseClick(ICanvasMouseData iCanvasMouseData) {
        return false;
    }

    public void eventInvoked(IMapperEvent iMapperEvent) {
        IMethoidNode iMethoidNode;
        IBasicMapperRule iBasicMapperRule;
        Object object = iMapperEvent.getTransferObject();
        if (iMapperEvent.getEventType().equals("MapperEvt.ReqNewNode") && (iBasicMapperRule = this.myMapper.getMapperRule()) != null && object instanceof IMapperNode && iBasicMapperRule.isAllowToCreate((IMapperNode)(iMethoidNode = (IMethoidNode)object))) {
            this.handleLiteral(iMethoidNode);
        }
    }

    private void handleLiteral(IMethoidNode iMethoidNode) {
        IMethoid iMethoid = (IMethoid)iMethoidNode.getMethoidObject();
        if (iMethoid.isLiteral()) {
            IFieldNode iFieldNode = (IFieldNode)iMethoidNode.getOutputFieldNodes().get(0);
            String string = iFieldNode.getTypeName();
            switch (Constants.LiteralType.findByName(string)) {
                case XPATH_LITERAL_TYPE: {
                    ILiteralUpdater iLiteralUpdater = this.myMapper.getLiteralUpdaterFactory().createLiteralUpdater(string);
                    iLiteralUpdater.getEditor((IBasicMapper)this.myMapper, iFieldNode).show();
                    return;
                }
            }
        }
    }
}

