/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.methoid;

import java.text.NumberFormat;
import java.text.ParseException;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.BasicLiteralEditorFactory;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralEditor;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdater;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.xml.xpath.XPathNumericLiteral;
import org.netbeans.modules.xslt.mapper.methoid.AbstractLiteralUpdater;
import org.netbeans.modules.xslt.mapper.model.nodes.LiteralCanvasNode;

public class NumericLiteralUpdater
extends AbstractLiteralUpdater {
    private final String TYPE_LONG = "Long";
    private final String TYPE_DOUBLE = "Double";

    public ILiteralEditor getEditor(IBasicMapper iBasicMapper, IFieldNode iFieldNode) {
        return BasicLiteralEditorFactory.createStrictNumericEditor((IBasicMapper)iBasicMapper, (IFieldNode)iFieldNode, (ILiteralUpdater)this);
    }

    public String literalSet(IFieldNode iFieldNode, String string) {
        ILiteralUpdater.LiteralSubTypeInfo literalSubTypeInfo = this.getLiteralSubType(string);
        String string2 = literalSubTypeInfo.getType();
        LiteralCanvasNode literalCanvasNode = (LiteralCanvasNode)iFieldNode.getGroupNode().getNodeObject();
        XPathNumericLiteral xPathNumericLiteral = (XPathNumericLiteral)literalCanvasNode.getDataObject();
        if ("Long".equals(string2)) {
            xPathNumericLiteral.setValue((Number)new Long(string));
        } else {
            xPathNumericLiteral.setValue((Number)new Double(string));
        }
        this.mProcessor.updateNodeExpression(iFieldNode);
        return string;
    }

    public ILiteralUpdater.LiteralSubTypeInfo getLiteralSubType(String string) {
        if (string == null || string.length() < 1) {
            return null;
        }
        String string2 = string.trim().toUpperCase();
        Number number = null;
        try {
            number = NumberFormat.getInstance().parse(string2);
        }
        catch (ParseException parseException) {
            return null;
        }
        ILiteralUpdater.LiteralSubTypeInfo literalSubTypeInfo = null;
        try {
            if (string2.indexOf(".") > 0) {
                Double.parseDouble(string2);
                return new ILiteralUpdater.LiteralSubTypeInfo("Double", string2);
            }
            if (number instanceof Long) {
                Long.parseLong(string2);
                literalSubTypeInfo = new ILiteralUpdater.LiteralSubTypeInfo("Long", new Long(string2).toString());
            } else {
                Double.parseDouble(string2);
                literalSubTypeInfo = new ILiteralUpdater.LiteralSubTypeInfo("Double", string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return literalSubTypeInfo;
    }
}

