/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.methoid;

import org.netbeans.modules.soa.mapper.basicmapper.util.MapperUtilities;
import org.netbeans.modules.soa.mapper.common.IMapperGroupNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdater;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdaterFactory;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.xslt.mapper.methoid.AbstractLiteralUpdater;
import org.netbeans.modules.xslt.mapper.methoid.Constants;
import org.netbeans.modules.xslt.mapper.methoid.NumericLiteralUpdater;
import org.netbeans.modules.xslt.mapper.methoid.StringLiteralUpdater;
import org.netbeans.modules.xslt.mapper.methoid.XPathLiteralUpdater;

public class LiteralUpdaterFactory
implements ILiteralUpdaterFactory {
    private StringLiteralUpdater mStringUpdater;
    private NumericLiteralUpdater mNumericUpdater;
    private XPathLiteralUpdater mXPathUpdater;
    private IBasicMapper mMapper;
    private AbstractLiteralUpdater.XPathNodeExpressionUpdater mXPathNodeExpressionUpdater;

    public LiteralUpdaterFactory(IBasicMapper iBasicMapper) {
        this.mMapper = iBasicMapper;
    }

    public ILiteralUpdater getStringUpdater() {
        if (this.mStringUpdater == null) {
            this.mStringUpdater = new StringLiteralUpdater();
            this.mStringUpdater.setXPathProcessor(this.getExpressionUpdater());
        }
        return this.mStringUpdater;
    }

    public ILiteralUpdater getNumericUpdater() {
        if (this.mNumericUpdater == null) {
            this.mNumericUpdater = new NumericLiteralUpdater();
            this.mNumericUpdater.setXPathProcessor(this.getExpressionUpdater());
        }
        return this.mNumericUpdater;
    }

    public ILiteralUpdater getXPathUpdater() {
        if (this.mXPathUpdater == null) {
            this.mXPathUpdater = new XPathLiteralUpdater();
            this.mXPathUpdater.setXPathProcessor(this.getExpressionUpdater());
        }
        return this.mXPathUpdater;
    }

    private AbstractLiteralUpdater.XPathNodeExpressionUpdater getExpressionUpdater() {
        if (this.mXPathNodeExpressionUpdater == null) {
            this.mXPathNodeExpressionUpdater = new AbstractLiteralUpdater.XPathNodeExpressionUpdater(){

                public void updateNodeExpression(IFieldNode iFieldNode) {
                    IMapperGroupNode iMapperGroupNode = iFieldNode.getGroupNode();
                    LiteralUpdaterFactory.this.mMapper.getMapperViewManager().postMapperEvent(MapperUtilities.getMapperEvent((Object)this, (Object)iMapperGroupNode, (String)"MapperEvt.ReqUpdateNode", (String)"LITERAL UPDATED"));
                }
            };
        }
        return this.mXPathNodeExpressionUpdater;
    }

    public ILiteralUpdater createLiteralUpdater(String string) {
        Constants.LiteralType literalType = Constants.LiteralType.findByName(string);
        return this.createLiteralUpdater(literalType);
    }

    public ILiteralUpdater createLiteralUpdater(Constants.LiteralType literalType) {
        if (literalType == null) {
            return null;
        }
        ILiteralUpdater iLiteralUpdater = null;
        switch (literalType) {
            case NUMBER_LITERAL_TYPE: {
                iLiteralUpdater = this.getNumericUpdater();
                break;
            }
            case STRING_LITERAL_TYPE: {
                iLiteralUpdater = this.getStringUpdater();
                break;
            }
            case XPATH_LITERAL_TYPE: {
                iLiteralUpdater = this.getXPathUpdater();
                break;
            }
        }
        return iLiteralUpdater;
    }
}

