/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.DeleteAction;
import org.netbeans.modules.localhistory.ui.view.RevertFileAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreEntryNode
extends AbstractNode
implements Comparable {
    static final String PROPERTY_NAME_LABEL = "label";
    private List<StoreEntry> entries;
    private static DateFormat defaultFormat = DateFormat.getDateTimeInstance();

    private StoreEntryNode(List<StoreEntry> list) {
        super(StoreEntryNode.createChildren(list));
        this.entries = list;
        this.initProperties();
    }

    private StoreEntryNode(List<StoreEntry> list, Lookup lookup) {
        super(Children.LEAF, lookup);
        this.entries = list;
        this.initProperties();
    }

    static StoreEntryNode create(List<StoreEntry> list) {
        assert (list != null && list.size() > 0);
        if (list.size() > 1) {
            return new StoreEntryNode(list);
        }
        return new StoreEntryNode(list, Lookups.fixed((Object[])new Object[]{list.get(0)}));
    }

    private static Children createChildren(List<StoreEntry> list) {
        FileNode[] fileNodeArray = new FileNode[list.size()];
        int n = 0;
        for (StoreEntry storeEntry : list) {
            fileNodeArray[n++] = new FileNode(storeEntry);
        }
        Children.SortedArray sortedArray = new Children.SortedArray();
        sortedArray.add((Node[])fileNodeArray);
        return sortedArray;
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new LabelProperty());
        sheet.put(set);
        this.setSheet(sheet);
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        return StoreEntryNode.getFormatedDate(this.entries.get(0));
    }

    static String getFormatedDate(StoreEntry storeEntry) {
        return defaultFormat.format(storeEntry.getDate());
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(RevertFileAction.class), SystemAction.get(DeleteAction.class)};
    }

    public int compareTo(Object object) {
        if (!(object instanceof StoreEntryNode) || object == null) {
            return 1;
        }
        StoreEntryNode storeEntryNode = (StoreEntryNode)object;
        if (storeEntryNode.entries.get(0).getTimestamp() > this.entries.get(0).getTimestamp()) {
            return 1;
        }
        if (storeEntryNode.entries.get(0).getTimestamp() < this.entries.get(0).getTimestamp()) {
            return -1;
        }
        return 0;
    }

    private static class FileNode
    extends AbstractNode
    implements Comparable {
        private final StoreEntry entry;

        FileNode(StoreEntry storeEntry) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{storeEntry}));
            this.entry = storeEntry;
        }

        public Action[] getActions(boolean bl) {
            ArrayList<StoreEntry> arrayList = new ArrayList<StoreEntry>(1);
            arrayList.add(this.entry);
            return new Action[]{SystemAction.get(RevertFileAction.class), SystemAction.get(DeleteAction.class)};
        }

        public String getName() {
            return this.entry.getFile().getName();
        }

        public int compareTo(Object object) {
            if (!(object instanceof FileNode) || object == null) {
                return -1;
            }
            FileNode fileNode = (FileNode)object;
            return this.getName().compareTo(fileNode.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LabelProperty
    extends PropertySupport.ReadWrite<String> {
        public LabelProperty() {
            super(StoreEntryNode.PROPERTY_NAME_LABEL, String.class, NbBundle.getMessage(StoreEntryNode.class, (String)"LBL_LabelProperty_Name"), NbBundle.getMessage(StoreEntryNode.class, (String)"LBL_LabelProperty_Desc"));
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return ((StoreEntry)StoreEntryNode.this.entries.get(0)).getLabel();
        }

        public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            string = string.trim();
            ArrayList<StoreEntry> arrayList = new ArrayList<StoreEntry>(StoreEntryNode.this.entries.size());
            for (StoreEntry storeEntry : StoreEntryNode.this.entries) {
                LocalHistory.getInstance().getLocalHistoryStore().setLabel(storeEntry.getFile(), storeEntry.getTimestamp(), !string.equals("") ? string : null);
                arrayList.add(StoreEntry.createStoreEntry(storeEntry.getFile(), storeEntry.getStoreFile(), storeEntry.getTimestamp(), string));
            }
            StoreEntryNode.this.entries = arrayList;
        }

        public PropertyEditor getPropertyEditor() {
            return new PropertyEditorSupport();
        }
    }
}

