/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.UIManager;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.StoreEntryNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalHistoryRootNode
extends AbstractNode {
    static final Action[] NO_ACTION = new Action[0];

    private LocalHistoryRootNode(Children children) {
        super(children);
    }

    static Node createRootNode(File[] fileArray) {
        Children.SortedArray sortedArray = new Children.SortedArray();
        sortedArray.add((Node[])LocalHistoryRootNode.createDateFolders(fileArray));
        return new LocalHistoryRootNode((Children)sortedArray);
    }

    private static DateFolderNode[] createDateFolders(File[] fileArray) {
        Children.SortedArray sortedArray;
        Object object;
        HashMap<Long, ArrayList<StoreEntry>> hashMap = new HashMap<Long, ArrayList<StoreEntry>>();
        for (File file : fileArray) {
            object = LocalHistory.getInstance().getLocalHistoryStore().getStoreEntries(file);
            for (StoreEntry storeEntry : object) {
                ArrayList<StoreEntry> arrayList = (ArrayList<StoreEntry>)hashMap.get(storeEntry.getTimestamp());
                if (arrayList == null) {
                    arrayList = new ArrayList<StoreEntry>();
                    hashMap.put(storeEntry.getTimestamp(), arrayList);
                }
                arrayList.add(storeEntry);
            }
        }
        HashMap hashMap2 = new HashMap();
        for (Long l : hashMap.keySet()) {
            int n = LocalHistoryRootNode.getDay(l);
            object = (List)hashMap2.get(n);
            if (object == null) {
                object = new ArrayList();
                hashMap2.put(n, object);
            }
            sortedArray = (List)hashMap.get(l);
            object.add(LocalHistoryRootNode.createStoreEntryNode((List<StoreEntry>)sortedArray, fileArray));
        }
        ArrayList arrayList = new ArrayList(hashMap2.keySet().size());
        Iterator iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            object = (List)hashMap2.get(n);
            sortedArray = new Children.SortedArray();
            sortedArray.add(object.toArray(new Node[object.size()]));
            arrayList.add(new DateFolderNode(n, (Children)sortedArray));
        }
        return arrayList.toArray(new DateFolderNode[arrayList.size()]);
    }

    private static int getDay(long l) {
        Date date = new Date(l);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int n = calendar.get(11) * 60 * 60 * 1000 + calendar.get(12) * 60 * 1000 + calendar.get(13) * 1000 + calendar.get(14);
        calendar.add(14, -1 * n);
        if (calendar.getTime().compareTo(date) < 0) {
            return 0;
        }
        return (int)((calendar.getTimeInMillis() - l) / 86400000L) + 1;
    }

    private static Node createStoreEntryNode(List<StoreEntry> list, File[] fileArray) {
        if (fileArray.length == 1) {
            return StoreEntryNode.create(list);
        }
        long l = list.get(0).getTimestamp();
        ArrayList<StoreEntry> arrayList = new ArrayList<StoreEntry>();
        for (File file : fileArray) {
            boolean bl = false;
            for (StoreEntry storeEntry : list) {
                if (!file.equals(storeEntry.getFile())) continue;
                arrayList.add(storeEntry);
                bl = true;
                break;
            }
            if (bl) continue;
            StoreEntry storeEntry = LocalHistory.getInstance().getLocalHistoryStore().getStoreEntry(file, l);
            if (storeEntry != null) {
                arrayList.add(storeEntry);
                continue;
            }
            arrayList.add(StoreEntry.createFakeStoreEntry(file, l));
        }
        return StoreEntryNode.create(arrayList);
    }

    public String getName() {
        return "rootnode";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"LBL_LocalHistory_Column_Version");
    }

    public Action[] getActions(boolean bl) {
        return NO_ACTION;
    }

    static class DateFolderNode
    extends AbstractNode
    implements Comparable {
        private final int day;

        DateFolderNode(int n, Children children) {
            super(children);
            this.day = n;
        }

        int getDay() {
            return this.day;
        }

        public Image getIcon(int n) {
            Image image = null;
            if (n == 1) {
                image = (Image)UIManager.get("Nb.Explorer.Folder.icon");
            }
            if (image == null) {
                image = super.getIcon(n);
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = null;
            if (n == 1) {
                image = (Image)UIManager.get("Nb.Explorer.Folder.openedIcon");
            }
            if (image == null) {
                image = super.getIcon(n);
            }
            return image;
        }

        public Action[] getActions(boolean bl) {
            return NO_ACTION;
        }

        public String getName() {
            switch (this.day) {
                case 0: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_0");
                }
                case 1: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_1");
                }
                case 2: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_2");
                }
                case 3: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_3");
                }
                case 4: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_4");
                }
                case 5: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_5");
                }
                case 6: {
                    return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_6");
                }
            }
            return NbBundle.getMessage(LocalHistoryRootNode.class, (String)"DateFolderName_other");
        }

        public int compareTo(Object object) {
            if (!(object instanceof DateFolderNode) || object == null) {
                return -1;
            }
            DateFolderNode dateFolderNode = (DateFolderNode)object;
            if (dateFolderNode.getDay() > this.getDay()) {
                return -1;
            }
            if (dateFolderNode.getDay() < this.getDay()) {
                return 1;
            }
            return 0;
        }
    }
}

