/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.LocalHistoryStore;
import org.netbeans.modules.versioning.spi.VCSInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalHistoryVCSInterceptor
extends VCSInterceptor {
    private Map<String, StorageMoveHandler> moveHandlerMap;
    private Set<File> toBeDeleted = new HashSet<File>();
    private Set<File> toBeCreated = new HashSet<File>();
    private Set<File> wasJustCreated = new HashSet<File>();

    private LocalHistoryStore getStore() {
        return LocalHistory.getInstance().getLocalHistoryStore();
    }

    public boolean beforeDelete(File file) {
        if (!this.accept(file)) {
            return false;
        }
        this.toBeDeleted.add(file);
        this.storeFile(file);
        return false;
    }

    public void doDelete(File file) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDelete(File file) {
        if (!this.toBeDeleted.remove(file)) {
            return;
        }
        String string = file.getAbsolutePath();
        if (this.getMoveHandlerMap().containsKey(string)) {
            StorageMoveHandler storageMoveHandler = this.getMoveHandlerMap().get(string);
            try {
                storageMoveHandler.delete();
            }
            finally {
                this.getMoveHandlerMap().remove(string);
            }
        } else {
            this.getStore().fileDelete(file, System.currentTimeMillis());
        }
    }

    public boolean beforeMove(File file, File file2) {
        if (!this.accept(file)) {
            return false;
        }
        StorageMoveHandler storageMoveHandler = new StorageMoveHandler(file, file2);
        this.getMoveHandlerMap().put(file2.getAbsolutePath(), storageMoveHandler);
        this.getMoveHandlerMap().put(file.getAbsolutePath(), storageMoveHandler);
        return false;
    }

    public void doMove(File file, File file2) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterMove(File file, File file2) {
        String string = file2.getAbsolutePath();
        if (this.getMoveHandlerMap().containsKey(string)) {
            StorageMoveHandler storageMoveHandler = this.getMoveHandlerMap().get(string);
            try {
                storageMoveHandler.create();
                storageMoveHandler.delete();
            }
            finally {
                this.getMoveHandlerMap().remove(string);
                this.getMoveHandlerMap().remove(file.getAbsolutePath());
            }
        }
    }

    public boolean beforeCreate(File file, boolean bl) {
        this.toBeCreated.add(file);
        return false;
    }

    public void doCreate(File file, boolean bl) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreate(File file) {
        if (LocalHistory.getInstance().isManagedByParent(file) == null) {
            return;
        }
        LocalHistory.getInstance().fireFileEvent(LocalHistory.EVENT_FILE_CREATED, file);
        this.toBeCreated.remove(file);
        if (file.isFile()) {
            this.wasJustCreated.add(file);
        }
        String string = file.getAbsolutePath();
        if (this.getMoveHandlerMap().containsKey(string)) {
            StorageMoveHandler storageMoveHandler = this.getMoveHandlerMap().get(string);
            try {
                storageMoveHandler.create();
            }
            finally {
                this.getMoveHandlerMap().remove(string);
            }
        }
    }

    public void beforeChange(File file) {
        if (this.toBeCreated.contains(file) || this.wasJustCreated.remove(file)) {
            return;
        }
        if (!this.accept(file)) {
            return;
        }
        this.storeFile(file);
    }

    public void afterChange(File file) {
        this.wasJustCreated.remove(file);
    }

    private void storeFile(File file) {
        this.getStore().fileChange(file, file.lastModified());
    }

    private Map<String, StorageMoveHandler> getMoveHandlerMap() {
        if (this.moveHandlerMap == null) {
            this.moveHandlerMap = new HashMap<String, StorageMoveHandler>();
        }
        return this.moveHandlerMap;
    }

    private boolean accept(File file) {
        return LocalHistory.getInstance().isManaged(file);
    }

    private class StorageMoveHandler {
        private long ts = -1L;
        private final File from;
        private final File to;

        StorageMoveHandler(File file, File file2) {
            this.from = file;
            this.to = file2;
        }

        public void delete() {
            LocalHistoryVCSInterceptor.this.getStore().fileDeleteFromMove(this.from, this.to, this.ts);
        }

        public void create() {
            this.ts = this.to.lastModified();
            LocalHistoryVCSInterceptor.this.getStore().fileCreateFromMove(this.from, this.to, this.ts);
        }
    }
}

