/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge.impl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.bridge.impl.NbInputHandler;
import org.apache.tools.ant.module.run.Hyperlink;
import org.apache.tools.ant.module.run.LoggerTrampoline;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NbBuildLogger
implements BuildListener,
LoggerTrampoline.AntSessionImpl {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(NbBuildLogger.class.getName());
    private static final int EM_LEVEL = Boolean.getBoolean(NbBuildLogger.class.getName() + ".LOG_AT_WARNING") ? 16 : 1;
    private static final boolean LOGGABLE = ERR.isLoggable(EM_LEVEL);
    private final AntSession thisSession;
    private final File origScript;
    private String[] targets = null;
    private final OutputWriter out;
    private final OutputWriter err;
    private final int verbosity;
    private final String displayName;
    private final Runnable interestingOutputCallback;
    private final ProgressHandle handle;
    private boolean insideRunTask = false;
    private final RequestProcessor.Task sleepTask = RequestProcessor.getDefault().create(new Runnable(){

        public void run() {
            NbBuildLogger.this.handle.suspend(NbBuildLogger.this.insideRunTask ? NbBundle.getMessage(NbBuildLogger.class, (String)"MSG_sleep_running") : "");
        }
    });
    private static final int SLEEP_DELAY = 5000;
    private final Map<AntLogger, Object> customData = new HashMap<AntLogger, Object>();
    private List<AntLogger> interestedLoggers = null;
    private Map<File, Collection<AntLogger>> interestedLoggersByScript = new HashMap<File, Collection<AntLogger>>();
    private Map<String, Collection<AntLogger>> interestedLoggersByTarget = new HashMap<String, Collection<AntLogger>>();
    private Map<String, Collection<AntLogger>> interestedLoggersByTask = new HashMap<String, Collection<AntLogger>>();
    private Map<Integer, Collection<AntLogger>> interestedLoggersByLevel = new HashMap<Integer, Collection<AntLogger>>();
    private final Set<Project> projectsWithProperties = Collections.synchronizedSet(new WeakSet());
    private final Set<Throwable> consumedExceptions = new WeakSet();
    private boolean stop = false;
    private boolean running = true;
    private final Map<String, Map<String, String>> knownImportedTargets = Collections.synchronizedMap(new HashMap());
    private String currentlyParsedMainScript = null;
    private String currentlyParsedImportedScript = null;
    private Task lastTask = null;
    private final Collection<AntLogger>[] interestedLoggersByVariousCriteria = new Collection[4];
    private static final Comparator<Collection<AntLogger>> INTERESTED_LOGGERS_SORTER = new Comparator<Collection<AntLogger>>(){

        @Override
        public int compare(Collection<AntLogger> c1, Collection<AntLogger> c2) {
            int x = c1.size() - c2.size();
            if (x != 0) {
                return x;
            }
            return System.identityHashCode(c1) - System.identityHashCode(c2);
        }
    };
    private static final Pattern PARSING_BUILDFILE_MESSAGE = Pattern.compile("parsing buildfile (.+) with URI = (?:.+)");
    private static final Pattern IMPORTING_FILE_MESSAGE = Pattern.compile("Importing file (?:.+) from (.+)");
    private static final Pattern PARSED_TARGET_MESSAGE = Pattern.compile(" \\+Target: (.+)");
    private static final Method targetGetLocation;
    private static final Method locationGetFileName;
    private static final Method locationGetLineNumber;
    private static final Method runtimeConfigurableGetAttributeMap;
    private static final Method runtimeConfigurableGetChildren;
    private static final Method runtimeConfigurableGetText;

    public NbBuildLogger(File origScript, OutputWriter out, OutputWriter err, int verbosity, String displayName, Runnable interestingOutputCallback, ProgressHandle handle) {
        this.thisSession = LoggerTrampoline.ANT_SESSION_CREATOR.makeAntSession((LoggerTrampoline.AntSessionImpl)this);
        this.origScript = origScript;
        this.out = out;
        this.err = err;
        this.verbosity = verbosity;
        this.displayName = displayName;
        this.interestingOutputCallback = interestingOutputCallback;
        this.handle = handle;
        if (LOGGABLE) {
            ERR.log(EM_LEVEL, "---- Initializing build of " + origScript + " \"" + displayName + "\" at verbosity " + verbosity + " ----");
        }
    }

    public void stop() {
        this.stop = true;
    }

    private void checkForStop() {
        if (this.stop) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbBuildLogger.class, (String)"MSG_stopped", (Object)this.displayName));
            throw new ThreadDeath();
        }
        if (this.running) {
            this.handle.switchToIndeterminate();
            this.sleepTask.schedule(5000);
        }
    }

    public void shutdown() {
        this.running = false;
        this.out.close();
        this.err.close();
        this.handle.finish();
        this.sleepTask.cancel();
    }

    private void verifyRunning() {
        if (!this.running) {
            throw new IllegalStateException("AntSession/AntEvent/TaskStructure method called after completion of Ant process");
        }
    }

    private synchronized void initInterestedLoggers() {
        if (this.interestedLoggers == null) {
            this.interestedLoggers = new ArrayList<AntLogger>();
            for (AntLogger l : Lookup.getDefault().lookupAll(AntLogger.class)) {
                if (!l.interestedInSession(this.thisSession)) continue;
                this.interestedLoggers.add(l);
            }
            if (LOGGABLE) {
                ERR.log(EM_LEVEL, "getInterestedLoggers: loggers=" + this.interestedLoggers);
            }
        }
    }

    private synchronized Collection<AntLogger> getInterestedLoggersByEvent(AntEvent e) {
        this.initInterestedLoggers();
        this.interestedLoggersByVariousCriteria[0] = this.getInterestedLoggersByScript(e.getScriptLocation());
        this.interestedLoggersByVariousCriteria[1] = this.getInterestedLoggersByTarget(e.getTargetName());
        this.interestedLoggersByVariousCriteria[2] = this.getInterestedLoggersByTask(e.getTaskName());
        this.interestedLoggersByVariousCriteria[3] = this.getInterestedLoggersByLevel(e.getLogLevel());
        Arrays.sort(this.interestedLoggersByVariousCriteria, INTERESTED_LOGGERS_SORTER);
        if (LOGGABLE) {
            ERR.log(EM_LEVEL, "getInterestedLoggersByVariousCriteria: event=" + e + " loggers=" + Arrays.asList(this.interestedLoggersByVariousCriteria));
        }
        LinkedList<AntLogger> loggers = new LinkedList<AntLogger>(this.interestedLoggersByVariousCriteria[0]);
        for (int i = 1; i < 4; ++i) {
            loggers.retainAll(this.interestedLoggersByVariousCriteria[i]);
        }
        if (LOGGABLE) {
            ERR.log(EM_LEVEL, "getInterestedLoggersByEvent: event=" + e + " loggers=" + loggers);
        }
        return loggers;
    }

    private synchronized Collection<AntLogger> getInterestedLoggersByScript(File script) {
        Collection<AntLogger> c = this.interestedLoggersByScript.get(script);
        if (c == null) {
            c = new LinkedHashSet<AntLogger>(this.interestedLoggers.size());
            this.interestedLoggersByScript.put(script, c);
            for (AntLogger l : this.interestedLoggers) {
                if (!l.interestedInAllScripts(this.thisSession) && (script == null || !l.interestedInScript(script, this.thisSession))) continue;
                c.add(l);
            }
            if (LOGGABLE) {
                ERR.log(EM_LEVEL, "getInterestedLoggersByScript: script=" + script + " loggers=" + c);
            }
        }
        return c;
    }

    private synchronized Collection<AntLogger> getInterestedLoggersByTarget(String target) {
        Collection<AntLogger> c = this.interestedLoggersByTarget.get(target);
        if (c == null) {
            c = new LinkedHashSet<AntLogger>(this.interestedLoggers.size());
            this.interestedLoggersByTarget.put(target, c);
            for (AntLogger l : this.interestedLoggers) {
                String[] interestingTargets = l.interestedInTargets(this.thisSession);
                if (interestingTargets != AntLogger.ALL_TARGETS && (target == null || !Arrays.asList(interestingTargets).contains(target)) && (target != null || interestingTargets != AntLogger.NO_TARGETS)) continue;
                c.add(l);
            }
            if (LOGGABLE) {
                ERR.log(EM_LEVEL, "getInterestedLoggersByTarget: target=" + target + " loggers=" + c);
            }
        }
        return c;
    }

    private synchronized Collection<AntLogger> getInterestedLoggersByTask(String task) {
        Collection<AntLogger> c = this.interestedLoggersByTask.get(task);
        if (c == null) {
            c = new LinkedHashSet<AntLogger>(this.interestedLoggers.size());
            this.interestedLoggersByTask.put(task, c);
            for (AntLogger l : this.interestedLoggers) {
                String[] tasks = l.interestedInTasks(this.thisSession);
                if (tasks != AntLogger.ALL_TASKS && (task == null || !Arrays.asList(tasks).contains(task)) && (task != null || tasks != AntLogger.NO_TASKS)) continue;
                c.add(l);
            }
            if (LOGGABLE) {
                ERR.log(EM_LEVEL, "getInterestedLoggersByTask: task=" + task + " loggers=" + c);
            }
        }
        return c;
    }

    private synchronized Collection<AntLogger> getInterestedLoggersByLevel(int level) {
        Collection<AntLogger> c = this.interestedLoggersByLevel.get(level);
        if (c == null) {
            c = new LinkedHashSet<AntLogger>(this.interestedLoggers.size());
            this.interestedLoggersByLevel.put(level, c);
            block0: for (AntLogger l : this.interestedLoggers) {
                int[] levels;
                if (level == -1) {
                    c.add(l);
                    continue;
                }
                for (int _level : levels = l.interestedInLogLevels(this.thisSession)) {
                    if (_level != level) continue;
                    c.add(l);
                    continue block0;
                }
            }
            if (LOGGABLE) {
                ERR.log(EM_LEVEL, "getInterestedLoggersByLevel: level=" + level + " loggers=" + c);
            }
        }
        return c;
    }

    synchronized void setActualTargets(String[] targets) {
        this.targets = targets;
    }

    void buildInitializationFailed(BuildException be) {
        this.initInterestedLoggers();
        AntEvent ev = LoggerTrampoline.ANT_EVENT_CREATOR.makeAntEvent((LoggerTrampoline.AntEventImpl)new Event(be));
        if (LOGGABLE) {
            ERR.log(EM_LEVEL, "buildInitializationFailed: " + ev);
        }
        for (AntLogger l : this.getInterestedLoggersByScript(null)) {
            l.buildInitializationFailed(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildStarted(BuildEvent ev) {
        AntBridge.suspendDelegation();
        try {
            this.checkForStop();
            this.initInterestedLoggers();
            AntEvent e = LoggerTrampoline.ANT_EVENT_CREATOR.makeAntEvent((LoggerTrampoline.AntEventImpl)new Event(ev, false));
            if (LOGGABLE) {
                ERR.log(EM_LEVEL, "buildStarted: " + e);
            }
            for (AntLogger l : this.interestedLoggers) {
                try {
                    l.buildStarted(e);
                }
                catch (RuntimeException x) {
                    ERR.notify(EM_LEVEL, (Throwable)x);
                }
            }
        }
        finally {
            AntBridge.resumeDelegation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(BuildEvent ev) {
        AntBridge.suspendDelegation();
        try {
            this.stop = false;
            this.lastTask = null;
            this.initInterestedLoggers();
            AntEvent e = LoggerTrampoline.ANT_EVENT_CREATOR.makeAntEvent((LoggerTrampoline.AntEventImpl)new Event(ev, false));
            if (LOGGABLE) {
                ERR.log(EM_LEVEL, "buildFinished: " + e);
                if (e.getException() != null) {
                    ERR.notify(EM_LEVEL, e.getException());
                }
            }
            for (AntLogger l : this.interestedLoggers) {
                try {
                    l.buildFinished(e);
                }
                catch (RuntimeException x) {
                    ERR.notify(EM_LEVEL, (Throwable)x);
                }
                catch (Error x) {
                    ERR.notify(EM_LEVEL, (Throwable)x);
                }
            }
        }
        finally {
            AntBridge.resumeDelegation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetStarted(BuildEvent ev) {
        AntBridge.suspendDelegation();
        try {
            String targetName;
            this.checkForStop();
            this.lastTask = null;
            AntEvent e = LoggerTrampoline.ANT_EVENT_CREATOR.makeAntEvent((LoggerTrampoline.AntEventImpl)new Event(ev, false));
            if (LOGGABLE) {
                ERR.log(EM_LEVEL, "targetStarted: " + e);
            }
            for (AntLogger l : this.getInterestedLoggersByEvent(e)) {
                try {
                    l.targetStarted(e);
                }
                catch (RuntimeException x) {
                    ERR.notify(EM_LEVEL, (Throwable)x);
                }
            }
            Project p = ev.getProject();
            String projectName = null;
            if (p != null) {
                projectName = p.getName();
            }
            if ((targetName = e.getTargetName()) != null) {
                String message = projectName != null ? NbBundle.getMessage(NbBuildLogger.class, (String)"MSG_progress_target", (Object)projectName, (Object)targetName) : targetName;
                this.handle.progress(message);
            }
        }
        finally {
            AntBridge.resumeDelegation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetFinished(BuildEvent ev) {
        AntBridge.suspendDelegation();
        try {
            this.checkForStop();
            this.lastTask = null;
            AntEvent e = LoggerTrampoline.ANT_EVENT_CREATOR.makeAntEvent((LoggerTrampoline.AntEventImpl)new Event(ev, false));
            if (LOGGABLE) {
                ERR.log(EM_LEVEL, "targetFinished: " + e);
            }
            for (AntLogger l : this.getInterestedLoggersByEvent(e)) {
                try {
                    l.targetFinished(e);
                }
                catch (RuntimeException x) {
                    ERR.notify(EM_LEVEL, (Throwable)x);
                }
            }
        }
        finally {
            AntBridge.resumeDelegation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskStarted(BuildEvent ev) {
        AntBridge.suspendDelegation();
        try {
            String def;
            TaskStructure s;
            this.checkForStop();
            this.lastTask = ev.getTask();
            AntEvent e = LoggerTrampoline.ANT_EVENT_CREATOR.makeAntEvent((LoggerTrampoline.AntEventImpl)new Event(ev, false));
            if (LOGGABLE) {
                ERR.log(EM_LEVEL, "taskStarted: " + e);
            }
            for (AntLogger l : this.getInterestedLoggersByEvent(e)) {
                try {
                    l.taskStarted(e);
                }
                catch (RuntimeException x) {
                    ERR.notify(EM_LEVEL, (Throwable)x);
                }
            }
            if ("input".equals(e.getTaskName()) && (s = e.getTaskStructure()) != null && (def = s.getAttribute("defaultvalue")) != null) {
                NbInputHandler.setDefaultValue(e.evaluate(def));
            }
            if (this.isRunTask(e)) {
                this.insideRunTask = true;
            }
        }
        finally {
            AntBridge.resumeDelegation();
        }
    }

    private boolean isRunTask(AntEvent event) {
        String taskName = event.getTaskName();
        return "java".equals(taskName) || "exec".equals(taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskFinished(BuildEvent ev) {
        AntBridge.suspendDelegation();
        try {
            this.checkForStop();
            this.lastTask = null;
            AntEvent e = LoggerTrampoline.ANT_EVENT_CREATOR.makeAntEvent((LoggerTrampoline.AntEventImpl)new Event(ev, false));
            if (LOGGABLE) {
                ERR.log(EM_LEVEL, "taskFinished: " + e);
            }
            for (AntLogger l : this.getInterestedLoggersByEvent(e)) {
                try {
                    l.taskFinished(e);
                }
                catch (RuntimeException x) {
                    ERR.notify(EM_LEVEL, (Throwable)x);
                }
            }
            NbInputHandler.setDefaultValue(null);
            if (this.isRunTask(e)) {
                this.insideRunTask = false;
            }
        }
        finally {
            AntBridge.resumeDelegation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageLogged(BuildEvent ev) {
        AntBridge.suspendDelegation();
        try {
            this.checkForStop();
            AntEvent e = LoggerTrampoline.ANT_EVENT_CREATOR.makeAntEvent((LoggerTrampoline.AntEventImpl)new Event(ev, true));
            if (LOGGABLE) {
                ERR.log(EM_LEVEL, "messageLogged: " + e);
            }
            for (AntLogger l : this.getInterestedLoggersByEvent(e)) {
                try {
                    l.messageLogged(e);
                }
                catch (RuntimeException x) {
                    ERR.notify(EM_LEVEL, (Throwable)x);
                }
            }
            String msg = ev.getMessage();
            if (msg.contains("ant.PropertyHelper") || msg.contains("ant.projectHelper")) {
                this.projectsWithProperties.add(ev.getProject());
            }
            if (targetGetLocation == null) {
                Matcher matcher = PARSING_BUILDFILE_MESSAGE.matcher(msg);
                if (matcher.matches()) {
                    if (this.currentlyParsedMainScript != null) {
                        this.currentlyParsedImportedScript = matcher.group(1);
                    }
                    if (LOGGABLE) {
                        ERR.log(EM_LEVEL, "Got PARSING_BUILDFILE_MESSAGE: " + this.currentlyParsedImportedScript);
                    }
                    this.lastTask = null;
                } else {
                    matcher = IMPORTING_FILE_MESSAGE.matcher(msg);
                    if (matcher.matches()) {
                        this.currentlyParsedMainScript = matcher.group(1);
                        this.currentlyParsedImportedScript = null;
                        if (LOGGABLE) {
                            ERR.log(EM_LEVEL, "Got IMPORTING_FILE_MESSAGE: " + this.currentlyParsedMainScript);
                        }
                        this.lastTask = null;
                    } else {
                        matcher = PARSED_TARGET_MESSAGE.matcher(msg);
                        if (matcher.matches()) {
                            if (this.currentlyParsedMainScript != null && this.currentlyParsedImportedScript != null) {
                                Map<String, String> targetLocations = this.knownImportedTargets.get(this.currentlyParsedMainScript);
                                if (targetLocations == null) {
                                    targetLocations = new HashMap<String, String>();
                                    this.knownImportedTargets.put(this.currentlyParsedMainScript, targetLocations);
                                }
                                targetLocations.put(matcher.group(1), this.currentlyParsedImportedScript);
                            }
                            if (LOGGABLE) {
                                ERR.log(EM_LEVEL, "Got PARSED_TARGET_MESSAGE: " + matcher.group(1));
                            }
                            this.lastTask = null;
                        }
                    }
                }
            }
        }
        finally {
            AntBridge.resumeDelegation();
        }
    }

    public File getOriginatingScript() {
        this.verifyRunning();
        return this.origScript;
    }

    public String[] getOriginatingTargets() {
        this.verifyRunning();
        return this.targets != null ? this.targets : new String[]{};
    }

    public synchronized Object getCustomData(AntLogger logger) {
        this.verifyRunning();
        return this.customData.get(logger);
    }

    public synchronized void putCustomData(AntLogger logger, Object data) {
        this.verifyRunning();
        this.customData.put(logger, data);
    }

    public void println(String message, boolean error, OutputListener listener) {
        this.verifyRunning();
        if (LOGGABLE) {
            ERR.log(EM_LEVEL, "println: error=" + error + " listener=" + listener + " message=" + message);
        }
        OutputWriter ow = error ? this.err : this.out;
        try {
            if (listener != null) {
                boolean important = message.indexOf("[deprecation]") == -1 && message.indexOf("warning") == -1 && message.indexOf("stopped") == -1;
                ow.println(message, listener, important);
                this.interestingOutputCallback.run();
            } else {
                ow.println(message);
            }
        }
        catch (IOException e) {
            ERR.notify((Throwable)e);
        }
    }

    public void deliverMessageLogged(AntEvent originalEvent, String message, int level) {
        this.verifyRunning();
        if (originalEvent == null) {
            throw new IllegalArgumentException("Must pass an original event to deliverMessageLogged");
        }
        if (message == null) {
            throw new IllegalArgumentException("Must pass a message to deliverMessageLogged");
        }
        if (level < 0 || level > 4) {
            throw new IllegalArgumentException("Unknown log level for reposted log event: " + level);
        }
        if (LOGGABLE) {
            ERR.log(EM_LEVEL, "deliverMessageLogged: level=" + level + " message=" + message);
        }
        AntEvent newEvent = LoggerTrampoline.ANT_EVENT_CREATOR.makeAntEvent((LoggerTrampoline.AntEventImpl)new RepostedEvent(originalEvent, message, level));
        for (AntLogger l : this.getInterestedLoggersByEvent(newEvent)) {
            try {
                l.messageLogged(newEvent);
            }
            catch (RuntimeException x) {
                ERR.notify(EM_LEVEL, (Throwable)x);
            }
        }
    }

    public synchronized void consumeException(Throwable t) throws IllegalStateException {
        this.verifyRunning();
        if (this.isExceptionConsumed(t)) {
            throw new IllegalStateException("Already consumed " + t);
        }
        this.consumedExceptions.add(t);
    }

    public synchronized boolean isExceptionConsumed(Throwable t) {
        this.verifyRunning();
        if (this.consumedExceptions.contains(t)) {
            return true;
        }
        Throwable nested = t.getCause();
        if (nested != null && this.isExceptionConsumed(nested)) {
            this.consumedExceptions.add(t);
            return true;
        }
        return false;
    }

    public int getVerbosity() {
        this.verifyRunning();
        return this.verbosity;
    }

    String getDisplayNameNoLock() {
        return this.displayName;
    }

    public String getDisplayName() {
        this.verifyRunning();
        return this.displayName;
    }

    public OutputListener createStandardHyperlink(URL file, String message, int line1, int column1, int line2, int column2) {
        this.verifyRunning();
        return new Hyperlink(file, message, line1, column1, line2, column2);
    }

    private Location getLocationOfTarget(Target target, Project project) {
        String importedFile;
        Map<String, String> targetLocations;
        String file;
        if (targetGetLocation != null) {
            try {
                return (Location)targetGetLocation.invoke((Object)target, new Object[0]);
            }
            catch (Exception e) {
                ERR.notify(EM_LEVEL, (Throwable)e);
            }
        }
        if (LOGGABLE) {
            ERR.log(EM_LEVEL, "knownImportedTargets: " + this.knownImportedTargets);
        }
        if (project != null && (file = project.getProperty("ant.file")) != null && (targetLocations = this.knownImportedTargets.get(file)) != null && (importedFile = targetLocations.get(target.getName())) != null) {
            return new Location(importedFile);
        }
        return null;
    }

    private static String getFileNameOfLocation(Location loc) {
        String locs;
        int x;
        if (locationGetFileName != null) {
            try {
                return (String)locationGetFileName.invoke((Object)loc, new Object[0]);
            }
            catch (Exception e) {
                ERR.notify(EM_LEVEL, (Throwable)e);
            }
        }
        if ((x = (locs = loc.toString()).indexOf(58)) != -1) {
            return locs.substring(0, x);
        }
        return null;
    }

    private static int getLineNumberOfLocation(Location loc) {
        int x2;
        String locs;
        int x;
        if (locationGetLineNumber != null) {
            try {
                return (Integer)locationGetLineNumber.invoke((Object)loc, new Object[0]);
            }
            catch (Exception e) {
                ERR.notify(EM_LEVEL, (Throwable)e);
            }
        }
        if ((x = (locs = loc.toString()).indexOf(58)) != -1 && (x2 = locs.indexOf(58, x + 1)) != -1) {
            String line = locs.substring(x + 1, x2);
            try {
                return Integer.parseInt(line);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return 0;
    }

    private static Map<String, String> getAttributeMapOfRuntimeConfigurable(RuntimeConfigurable rc) {
        if (runtimeConfigurableGetAttributeMap != null) {
            try {
                return (Map)runtimeConfigurableGetAttributeMap.invoke((Object)rc, new Object[0]);
            }
            catch (Exception e) {
                ERR.notify(EM_LEVEL, (Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    private static Enumeration<RuntimeConfigurable> getChildrenOfRuntimeConfigurable(RuntimeConfigurable rc) {
        if (runtimeConfigurableGetChildren != null) {
            try {
                return (Enumeration)runtimeConfigurableGetChildren.invoke((Object)rc, new Object[0]);
            }
            catch (Exception e) {
                ERR.notify(EM_LEVEL, (Throwable)e);
            }
        }
        return Collections.enumeration(Collections.emptySet());
    }

    private static String getTextOfRuntimeConfigurable(RuntimeConfigurable rc) {
        if (runtimeConfigurableGetText != null) {
            try {
                return ((StringBuffer)runtimeConfigurableGetText.invoke((Object)rc, new Object[0])).toString();
            }
            catch (Exception e) {
                ERR.notify(EM_LEVEL, (Throwable)e);
            }
        }
        return "";
    }

    static {
        Method _targetGetLocation = null;
        try {
            _targetGetLocation = Target.class.getMethod("getLocation", new Class[0]);
            if (AntBridge.getInterface().getAntVersion().indexOf("1.6.2") != -1) {
                _targetGetLocation = null;
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            ERR.notify(EM_LEVEL, (Throwable)e);
        }
        targetGetLocation = _targetGetLocation;
        Method _locationGetFileName = null;
        try {
            _locationGetFileName = Location.class.getMethod("getFileName", new Class[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            ERR.notify(EM_LEVEL, (Throwable)e);
        }
        locationGetFileName = _locationGetFileName;
        Method _locationGetLineNumber = null;
        try {
            _locationGetLineNumber = Location.class.getMethod("getLineNumber", new Class[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            ERR.notify(EM_LEVEL, (Throwable)e);
        }
        locationGetLineNumber = _locationGetLineNumber;
        Method _runtimeConfigurableGetAttributeMap = null;
        try {
            _runtimeConfigurableGetAttributeMap = RuntimeConfigurable.class.getMethod("getAttributeMap", new Class[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            ERR.notify(EM_LEVEL, (Throwable)e);
        }
        runtimeConfigurableGetAttributeMap = _runtimeConfigurableGetAttributeMap;
        Method _runtimeConfigurableGetChildren = null;
        try {
            _runtimeConfigurableGetChildren = RuntimeConfigurable.class.getMethod("getChildren", new Class[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            ERR.notify(EM_LEVEL, (Throwable)e);
        }
        runtimeConfigurableGetChildren = _runtimeConfigurableGetChildren;
        Method _runtimeConfigurableGetText = null;
        try {
            _runtimeConfigurableGetText = RuntimeConfigurable.class.getMethod("getText", new Class[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            ERR.notify(EM_LEVEL, (Throwable)e);
        }
        runtimeConfigurableGetText = _runtimeConfigurableGetText;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TaskStructureImpl
    implements LoggerTrampoline.TaskStructureImpl {
        private final RuntimeConfigurable rc;

        public TaskStructureImpl(RuntimeConfigurable rc) {
            this.rc = rc;
        }

        public String getName() {
            NbBuildLogger.this.verifyRunning();
            String name = this.rc.getElementTag();
            if (name != null) {
                return name;
            }
            return "";
        }

        public String getAttribute(String name) {
            NbBuildLogger.this.verifyRunning();
            return (String)NbBuildLogger.getAttributeMapOfRuntimeConfigurable(this.rc).get(name);
        }

        public Set<String> getAttributeNames() {
            NbBuildLogger.this.verifyRunning();
            return NbBuildLogger.getAttributeMapOfRuntimeConfigurable(this.rc).keySet();
        }

        public String getText() {
            NbBuildLogger.this.verifyRunning();
            String s = NbBuildLogger.getTextOfRuntimeConfigurable(this.rc);
            if (s.length() > 0) {
                return s;
            }
            return null;
        }

        public TaskStructure[] getChildren() {
            NbBuildLogger.this.verifyRunning();
            ArrayList<TaskStructure> structures = new ArrayList<TaskStructure>();
            for (RuntimeConfigurable subrc : NbCollections.iterable((Enumeration)NbBuildLogger.getChildrenOfRuntimeConfigurable(this.rc))) {
                structures.add(LoggerTrampoline.TASK_STRUCTURE_CREATOR.makeTaskStructure((LoggerTrampoline.TaskStructureImpl)new TaskStructureImpl(subrc)));
            }
            return structures.toArray(new TaskStructure[structures.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RepostedEvent
    implements LoggerTrampoline.AntEventImpl {
        private final AntEvent originalEvent;
        private final String message;
        private final int level;
        private boolean consumed = false;

        public RepostedEvent(AntEvent originalEvent, String message, int level) {
            this.originalEvent = originalEvent;
            this.message = message;
            this.level = level;
        }

        public void consume() throws IllegalStateException {
            NbBuildLogger.this.verifyRunning();
            if (this.consumed) {
                throw new IllegalStateException("Event already consumed");
            }
            this.consumed = true;
        }

        public boolean isConsumed() {
            NbBuildLogger.this.verifyRunning();
            return this.consumed;
        }

        public AntSession getSession() {
            return this.originalEvent.getSession();
        }

        public File getScriptLocation() {
            return this.originalEvent.getScriptLocation();
        }

        public int getLine() {
            return this.originalEvent.getLine();
        }

        public String getTargetName() {
            return this.originalEvent.getTargetName();
        }

        public String getTaskName() {
            return this.originalEvent.getTaskName();
        }

        public TaskStructure getTaskStructure() {
            return this.originalEvent.getTaskStructure();
        }

        public String getMessage() {
            NbBuildLogger.this.verifyRunning();
            return this.message;
        }

        public int getLogLevel() {
            NbBuildLogger.this.verifyRunning();
            return this.level;
        }

        public Throwable getException() {
            NbBuildLogger.this.verifyRunning();
            return null;
        }

        public String getProperty(String name) {
            return this.originalEvent.getProperty(name);
        }

        public Set<String> getPropertyNames() {
            return this.originalEvent.getPropertyNames();
        }

        public String evaluate(String text) {
            return this.originalEvent.evaluate(text);
        }

        public String toString() {
            return "RepostedEvent[consumed=" + this.consumed + ",level=" + this.level + ",message=" + this.message + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Event
    implements LoggerTrampoline.AntEventImpl {
        private boolean consumed = false;
        private final BuildEvent e;
        private final Throwable exception;
        private final int level;
        private File scriptLocation;

        public Event(BuildEvent e, boolean msgLogged) {
            this.e = e;
            this.exception = e.getException();
            this.level = msgLogged ? e.getPriority() : -1;
        }

        public Event(Throwable exception) {
            this.e = null;
            this.exception = exception;
            this.level = -1;
        }

        public AntSession getSession() {
            NbBuildLogger.this.verifyRunning();
            return NbBuildLogger.this.thisSession;
        }

        public void consume() throws IllegalStateException {
            NbBuildLogger.this.verifyRunning();
            if (this.consumed) {
                throw new IllegalStateException("Event already consumed");
            }
            this.consumed = true;
        }

        public boolean isConsumed() {
            NbBuildLogger.this.verifyRunning();
            return this.consumed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public File getScriptLocation() {
            String file;
            String file2;
            Location l;
            String file3;
            Location l2;
            NbBuildLogger.this.verifyRunning();
            if (this.scriptLocation != null) {
                return this.scriptLocation;
            }
            if (this.e == null) {
                return null;
            }
            Task task = this.e.getTask();
            if (task != null && (l2 = task.getLocation()) != null && (file3 = NbBuildLogger.getFileNameOfLocation(l2)) != null) {
                this.scriptLocation = new File(file3);
                return this.scriptLocation;
            }
            Target target = this.e.getTarget();
            Project project = this.getProjectIfPropertiesDefined();
            if (target != null && (l = NbBuildLogger.this.getLocationOfTarget(target, project)) != null && (file2 = NbBuildLogger.getFileNameOfLocation(l)) != null) {
                this.scriptLocation = new File(file2);
                return this.scriptLocation;
            }
            if (project != null && (file = project.getProperty("ant.file")) != null) {
                this.scriptLocation = new File(file);
                return this.scriptLocation;
            }
            NbBuildLogger nbBuildLogger = NbBuildLogger.this;
            synchronized (nbBuildLogger) {
                String file4;
                Location l3;
                if (NbBuildLogger.this.lastTask != null && (l3 = NbBuildLogger.this.lastTask.getLocation()) != null && (file4 = NbBuildLogger.getFileNameOfLocation(l3)) != null) {
                    this.scriptLocation = new File(file4);
                    return this.scriptLocation;
                }
            }
            return null;
        }

        private Project getProjectIfPropertiesDefined() {
            Project project = this.e.getProject();
            if (project != null && NbBuildLogger.this.projectsWithProperties.contains(project)) {
                return project;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getLine() {
            int line;
            Location l;
            int line2;
            Location l2;
            NbBuildLogger.this.verifyRunning();
            if (this.e == null) {
                return -1;
            }
            Task task = this.e.getTask();
            if (task != null && (l2 = task.getLocation()) != null && (line2 = NbBuildLogger.getLineNumberOfLocation(l2)) > 0) {
                return line2;
            }
            Target target = this.e.getTarget();
            if (target != null && (l = NbBuildLogger.this.getLocationOfTarget(target, this.getProjectIfPropertiesDefined())) != null && (line = NbBuildLogger.getLineNumberOfLocation(l)) > 0) {
                return line;
            }
            NbBuildLogger nbBuildLogger = NbBuildLogger.this;
            synchronized (nbBuildLogger) {
                int line3;
                Location l3;
                if (NbBuildLogger.this.lastTask != null && (l3 = NbBuildLogger.this.lastTask.getLocation()) != null && (line3 = NbBuildLogger.getLineNumberOfLocation(l3)) > 0) {
                    return line3;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getTargetName() {
            String name;
            NbBuildLogger.this.verifyRunning();
            if (this.e == null) {
                return null;
            }
            Target target = this.e.getTarget();
            if (target != null && (name = target.getName()) != null && name.length() > 0) {
                return name;
            }
            NbBuildLogger nbBuildLogger = NbBuildLogger.this;
            synchronized (nbBuildLogger) {
                String name2;
                if (NbBuildLogger.this.lastTask != null && (target = NbBuildLogger.this.lastTask.getOwningTarget()) != null && (name2 = target.getName()) != null && name2.length() > 0) {
                    return name2;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getTaskName() {
            NbBuildLogger.this.verifyRunning();
            if (this.e == null) {
                return null;
            }
            Task task = this.e.getTask();
            if (task != null) {
                return task.getRuntimeConfigurableWrapper().getElementTag();
            }
            NbBuildLogger nbBuildLogger = NbBuildLogger.this;
            synchronized (nbBuildLogger) {
                if (NbBuildLogger.this.lastTask != null) {
                    return NbBuildLogger.this.lastTask.getRuntimeConfigurableWrapper().getElementTag();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TaskStructure getTaskStructure() {
            NbBuildLogger.this.verifyRunning();
            Task task = this.e.getTask();
            if (task != null) {
                return LoggerTrampoline.TASK_STRUCTURE_CREATOR.makeTaskStructure((LoggerTrampoline.TaskStructureImpl)new TaskStructureImpl(task.getRuntimeConfigurableWrapper()));
            }
            NbBuildLogger nbBuildLogger = NbBuildLogger.this;
            synchronized (nbBuildLogger) {
                if (NbBuildLogger.this.lastTask != null) {
                    return LoggerTrampoline.TASK_STRUCTURE_CREATOR.makeTaskStructure((LoggerTrampoline.TaskStructureImpl)new TaskStructureImpl(NbBuildLogger.this.lastTask.getRuntimeConfigurableWrapper()));
                }
            }
            return null;
        }

        public String getMessage() {
            NbBuildLogger.this.verifyRunning();
            if (this.e == null) {
                return null;
            }
            return this.e.getMessage();
        }

        public int getLogLevel() {
            NbBuildLogger.this.verifyRunning();
            return this.level;
        }

        public Throwable getException() {
            NbBuildLogger.this.verifyRunning();
            return this.exception;
        }

        public String getProperty(String name) {
            NbBuildLogger.this.verifyRunning();
            Project project = this.getProjectIfPropertiesDefined();
            if (project != null) {
                Object o = project.getProperty(name);
                if (o instanceof String) {
                    return o;
                }
                o = project.getReference(name);
                if (o != null) {
                    return o.toString();
                }
                return null;
            }
            return null;
        }

        public Set<String> getPropertyNames() {
            NbBuildLogger.this.verifyRunning();
            Project project = this.getProjectIfPropertiesDefined();
            if (project != null) {
                HashSet<String> s = new HashSet<String>();
                s.addAll(NbCollections.checkedSetByFilter(project.getProperties().keySet(), String.class, (boolean)true));
                s.addAll(NbCollections.checkedSetByFilter(project.getReferences().keySet(), String.class, (boolean)true));
                return s;
            }
            return Collections.emptySet();
        }

        public String evaluate(String text) {
            NbBuildLogger.this.verifyRunning();
            Project project = this.getProjectIfPropertiesDefined();
            if (project != null) {
                return project.replaceProperties(text);
            }
            return text;
        }

        public String toString() {
            return "Event[target=" + this.getTargetName() + ",task=" + this.getTaskName() + ",message=" + this.getMessage() + ",scriptLocation=" + this.getScriptLocation() + ",exception=" + this.exception + ",level=" + this.level + ",consumed=" + this.consumed + "]";
        }
    }
}

