/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.ImageIcon;
import org.netbeans.modules.visualweb.api.designer.DomProviderService;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.Interaction;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.w3c.dom.Element;

public class Resizer
extends Interaction
implements KeyListener {
    protected transient Cursor previousCursor = null;
    private WebForm webform;
    private boolean snapDisabled = false;
    private Element componentRootElement;
    private int origW = 0;
    private int origH = 0;
    private int origX = 0;
    private int origY = 0;
    private int direction = 0;
    private int prevX = -500;
    private int prevY = -500;
    private int prevMouseX = -500;
    private int prevMouseY = -500;
    private boolean preserveAspect;
    private final CssBox box;
    private Rectangle currentSize = null;

    public Resizer(WebForm webForm, Element element, CssBox cssBox, int n, Shape shape, boolean bl) {
        this.webform = webForm;
        this.componentRootElement = element;
        this.direction = n;
        this.box = cssBox;
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        this.origX = rectangle.x;
        this.origY = rectangle.y;
        this.origW = rectangle.width;
        this.origH = rectangle.height;
        Element element2 = element;
        String string = element2.getTagName();
        if (HtmlTag.IMG.name.equals(string) || HtmlTag.INPUT.name.equals(string) && element2.getAttribute("type").equals("image")) {
            bl = true;
        }
        this.preserveAspect = bl;
        if (this.origW == 0 || this.origH == 0) {
            this.preserveAspect = false;
        }
    }

    public void cancel(DesignerPane designerPane) {
        designerPane.removeKeyListener(this);
        this.cleanup(designerPane);
        this.currentSize = null;
    }

    private void cleanup(DesignerPane designerPane) {
        designerPane.setCursor(this.previousCursor);
        if (this.prevX != -500) {
            Rectangle rectangle = new Rectangle();
            this.resize(rectangle, this.prevX, this.prevY);
            ++rectangle.width;
            ++rectangle.height;
            designerPane.repaint(rectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            if (mouseEvent != null && !mouseEvent.isConsumed()) {
                int n;
                int n2;
                this.updateSnapState(mouseEvent);
                Point point = mouseEvent.getPoint();
                DesignerPane designerPane = this.webform.getPane();
                designerPane.removeKeyListener(this);
                Rectangle rectangle = new Rectangle();
                if (this.snapDisabled) {
                    n2 = point.x;
                    n = point.y;
                } else {
                    n2 = this.webform.snapX(point.x, this.box.getPositionedBy());
                    n = this.webform.snapY(point.y, this.box.getPositionedBy());
                }
                this.resize(rectangle, n2, n);
                if (this.componentRootElement != null && rectangle.width > 0 && rectangle.height > 0) {
                    boolean bl = this.origW != rectangle.width;
                    boolean bl2 = this.origH != rectangle.height;
                    Insets insets = this.box.getCssSizeInsets();
                    rectangle.width -= insets.left;
                    rectangle.width -= insets.right;
                    rectangle.height -= insets.top;
                    rectangle.height -= insets.bottom;
                    if (!(this.preserveAspect || this.direction != 9 && this.direction != 8)) {
                        bl = false;
                    }
                    if (!(this.preserveAspect || this.direction != 11 && this.direction != 10)) {
                        bl2 = false;
                    }
                    this.webform.getDomDocument().resizeComponent(this.webform, this.componentRootElement, rectangle.x, this.origX != rectangle.x, rectangle.y, this.origY != rectangle.y, rectangle.width, bl, rectangle.height, bl2, this.box, !this.snapDisabled);
                }
                this.cleanup(designerPane);
                mouseEvent.consume();
            }
        }
        finally {
            this.componentRootElement = null;
            this.previousCursor = null;
            this.currentSize = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.prevMouseX = point.x;
        this.prevMouseY = point.y;
        this.update(mouseEvent, point.x, point.y);
        this.webform.getPane().scrollRectToVisible(new Rectangle(point));
    }

    private void resize(Rectangle rectangle, int n, int n2) {
        switch (this.direction) {
            case 9: {
                rectangle.x = this.origX;
                rectangle.y = this.origY;
                rectangle.width = this.origW;
                rectangle.height = n2 - this.origY;
                break;
            }
            case 11: {
                rectangle.x = this.origX;
                rectangle.y = this.origY;
                rectangle.width = n - this.origX;
                rectangle.height = this.origH;
                break;
            }
            case 5: {
                if (this.preserveAspect) {
                    rectangle.x = this.origX;
                    rectangle.y = this.origY;
                    int n3 = this.origX;
                    int n4 = this.origH;
                    int n5 = this.origY;
                    int n6 = this.origW;
                    int n7 = (n - n3) * n4 - (n2 - n5) * n6;
                    if (n7 > 0) {
                        rectangle.width = n - this.origX;
                        rectangle.height = rectangle.width * this.origH / this.origW;
                        break;
                    }
                    rectangle.height = n2 - this.origY;
                    rectangle.width = rectangle.height * this.origW / this.origH;
                    break;
                }
                rectangle.x = this.origX;
                rectangle.y = this.origY;
                rectangle.width = n - this.origX;
                rectangle.height = n2 - this.origY;
                break;
            }
            case 10: {
                rectangle.x = n;
                rectangle.y = this.origY;
                rectangle.width = this.origX - n + this.origW;
                rectangle.height = this.origH;
                break;
            }
            case 4: {
                if (this.preserveAspect) {
                    int n8 = this.origX;
                    int n9 = -this.origH;
                    int n10 = this.origY + this.origH;
                    int n11 = this.origW;
                    int n12 = (n - n8) * n9 - (n2 - n10) * n11;
                    if (n12 > 0) {
                        rectangle.width = this.origX - n + this.origW;
                        rectangle.height = rectangle.width * this.origH / this.origW;
                    } else {
                        rectangle.height = n2 - this.origY;
                        rectangle.width = rectangle.height * this.origW / this.origH;
                    }
                    rectangle.x = this.origX + this.origW - rectangle.width;
                    rectangle.y = this.origY;
                    break;
                }
                rectangle.x = n;
                rectangle.y = this.origY;
                rectangle.width = this.origX - n + this.origW;
                rectangle.height = n2 - this.origY;
                break;
            }
            case 8: {
                rectangle.x = this.origX;
                rectangle.y = n2;
                rectangle.width = this.origW;
                rectangle.height = this.origY - n2 + this.origH;
                break;
            }
            case 6: {
                if (this.preserveAspect) {
                    int n13 = this.origX;
                    int n14 = this.origH;
                    int n15 = this.origY;
                    int n16 = this.origW;
                    int n17 = (n - n13) * n14 - (n2 - n15) * n16;
                    if (n17 < 0) {
                        rectangle.width = this.origX - n + this.origW;
                        rectangle.height = rectangle.width * this.origH / this.origW;
                    } else {
                        rectangle.height = this.origY - n2 + this.origH;
                        rectangle.width = rectangle.height * this.origW / this.origH;
                    }
                    rectangle.x = this.origX + this.origW - rectangle.width;
                    rectangle.y = this.origY + this.origH - rectangle.height;
                    break;
                }
                rectangle.x = n;
                rectangle.y = n2;
                rectangle.width = this.origX - n + this.origW;
                rectangle.height = this.origY - n2 + this.origH;
                break;
            }
            case 7: {
                if (this.preserveAspect) {
                    int n18 = this.origX;
                    int n19 = -this.origH;
                    int n20 = this.origY + this.origH;
                    int n21 = this.origW;
                    int n22 = (n - n18) * n19 - (n2 - n20) * n21;
                    if (n22 < 0) {
                        rectangle.width = n - this.origX;
                        rectangle.height = rectangle.width * this.origH / this.origW;
                    } else {
                        rectangle.height = this.origY - n2 + this.origH;
                        rectangle.width = rectangle.height * this.origW / this.origH;
                    }
                    rectangle.x = this.origX;
                    rectangle.y = this.origY + this.origH - rectangle.height;
                    break;
                }
                rectangle.x = this.origX;
                rectangle.y = n2;
                rectangle.width = n - this.origX;
                rectangle.height = this.origY - n2 + this.origH;
                break;
            }
            default: {
                Thread.dumpStack();
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.currentSize != null) {
            if (DesignerPane.useAlpha) {
                graphics.setColor(this.webform.getColors().resizerColor);
                graphics.fillRect(this.currentSize.x + 1, this.currentSize.y + 1, this.currentSize.width - 1, this.currentSize.height - 1);
                graphics.setColor(this.webform.getColors().resizerColorBorder);
            } else {
                graphics.setColor(Color.BLACK);
            }
            graphics.drawRect(this.currentSize.x, this.currentSize.y, this.currentSize.width, this.currentSize.height);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            this.updateSnapState(mouseEvent);
            Point point = mouseEvent.getPoint();
            this.prevMouseX = point.x;
            this.prevMouseY = point.y;
            DesignerPane designerPane = this.webform.getPane();
            designerPane.addKeyListener(this);
            this.previousCursor = designerPane.getCursor();
            designerPane.setCursor(Cursor.getPredefinedCursor(this.direction));
            ImageIcon imageIcon = new ImageIcon(Resizer.class.getResource("/org/netbeans/modules/visualweb/designer/resources/drag_resize.gif"));
            mouseEvent.consume();
        }
    }

    private void updateSnapState(InputEvent inputEvent) {
        this.snapDisabled = inputEvent.isShiftDown();
    }

    private void update(InputEvent inputEvent, int n, int n2) {
        if (!inputEvent.isConsumed()) {
            Rectangle rectangle;
            this.updateSnapState(inputEvent);
            DesignerPane designerPane = this.webform.getPane();
            if (this.currentSize != null) {
                rectangle = this.currentSize;
                ++rectangle.width;
                ++rectangle.height;
            } else {
                rectangle = new Rectangle();
            }
            if (this.snapDisabled) {
                this.prevX = n;
                this.prevY = n2;
            } else {
                this.prevX = this.webform.snapX(n, this.box.getPositionedBy());
                this.prevY = this.webform.snapY(n2, this.box.getPositionedBy());
            }
            this.currentSize = new Rectangle();
            this.resize(this.currentSize, this.prevX, this.prevY);
            rectangle.add(this.currentSize.x, this.currentSize.y);
            rectangle.add(this.currentSize.x + this.currentSize.width, this.currentSize.y + this.currentSize.height);
            ++rectangle.width;
            ++rectangle.height;
            designerPane.repaint(rectangle);
            int n3 = this.currentSize.width;
            int n4 = this.currentSize.height;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            inputEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.snapDisabled != keyEvent.isShiftDown()) {
            this.update(keyEvent, this.prevMouseX, this.prevMouseY);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.snapDisabled != keyEvent.isShiftDown()) {
            this.update(keyEvent, this.prevMouseX, this.prevMouseY);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public static DomProviderService.ResizeConstraint[] getResizeConstraints(WebForm webForm, Element element) {
        CssBox cssBox;
        Element element2 = element;
        if (element2 != null && (cssBox = webForm.findCssBoxForElement(element2)) != null && cssBox.isInlineBox() && !cssBox.isReplacedBox() && cssBox.getBoxType().isNormalFlow()) {
            return new DomProviderService.ResizeConstraint[0];
        }
        return webForm.getDomProviderService().getResizeConstraintsForComponent(element);
    }

    public static boolean hasMaintainAspectRatioResizeConstraint(DomProviderService.ResizeConstraint[] resizeConstraintArray) {
        if (resizeConstraintArray == null) {
            return false;
        }
        return Arrays.asList(resizeConstraintArray).contains((Object)DomProviderService.ResizeConstraint.MAINTAIN_ASPECT_RATIO);
    }

    public static boolean hasTopResizeConstraint(DomProviderService.ResizeConstraint[] resizeConstraintArray) {
        if (resizeConstraintArray == null) {
            return false;
        }
        return Arrays.asList(resizeConstraintArray).contains((Object)DomProviderService.ResizeConstraint.TOP);
    }

    public static boolean hasLeftResizeConstraint(DomProviderService.ResizeConstraint[] resizeConstraintArray) {
        if (resizeConstraintArray == null) {
            return false;
        }
        return Arrays.asList(resizeConstraintArray).contains((Object)DomProviderService.ResizeConstraint.LEFT);
    }

    public static boolean hasRightResizeConstraint(DomProviderService.ResizeConstraint[] resizeConstraintArray) {
        if (resizeConstraintArray == null) {
            return false;
        }
        return Arrays.asList(resizeConstraintArray).contains((Object)DomProviderService.ResizeConstraint.RIGHT);
    }

    public static boolean hasBottomResizeConstraint(DomProviderService.ResizeConstraint[] resizeConstraintArray) {
        if (resizeConstraintArray == null) {
            return false;
        }
        return Arrays.asList(resizeConstraintArray).contains((Object)DomProviderService.ResizeConstraint.BOTTOM);
    }
}

