/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.designer.AttributeInlineEditor;
import org.netbeans.modules.visualweb.designer.FormComponentEditor;
import org.netbeans.modules.visualweb.designer.InteractionManager;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.openide.awt.MouseUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class InlineEditor {
    protected WebForm webform;
    protected final DomProvider.InlineEditorSupport inlineEditorSupport;
    private long editingStarted = 0L;
    private long lastClick = 0L;

    protected InlineEditor(WebForm webForm, DomProvider.InlineEditorSupport inlineEditorSupport) {
        this.webform = webForm;
        this.inlineEditorSupport = inlineEditorSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InlineEditor getInlineEditor(WebForm webForm, CssBox cssBox, Element element, String string, boolean bl) {
        int n;
        String string2;
        Object object;
        WebForm webForm2;
        if (element == null) {
            return null;
        }
        WebForm webForm3 = webForm2 = cssBox == null ? null : cssBox.getWebForm();
        if (webForm2 == null) {
            return null;
        }
        String[] stringArray = webForm2.getDomProviderService().getEditableProperties(element);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        InlineEditor inlineEditor = null;
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        if (cssBox != null && cssBox.getElement() != null) {
            object = cssBox.getElement();
            block6: for (int i = 0; i < stringArray.length; ++i) {
                Element element2;
                string2 = stringArray[i];
                n = string2.indexOf(58);
                if (n != -1) {
                    stringArray3[i] = string2.substring(n + 1);
                    string2 = string2.substring(0, n);
                }
                if (string2.length() > 0 && string2.charAt(0) == '*') {
                    string2 = string2.substring(1);
                    if ((bl || stringArray3[i] == null) && n2 == -1) {
                        n2 = i;
                    }
                }
                stringArray2[i] = string2;
                if (bl) {
                    assert (string == null);
                    continue;
                }
                if (string != null) {
                    if (!string2.equals(string)) continue;
                    n2 = i;
                    break;
                }
                if (stringArray3[i] == null || (element2 = element) == null) continue;
                Node node = webForm2.getDomProviderService().findPropertyNode(element2, stringArray3[i]);
                Object object2 = object;
                int n4 = 0;
                while (object2 != null) {
                    if (object2 == node && n4 < n3) {
                        n2 = i;
                        n3 = n4;
                        continue block6;
                    }
                    object2 = object2.getParentNode();
                    ++n4;
                }
            }
        }
        if (n2 == -1) {
            if (!bl) {
                InlineEditor.warn("There is no value found for specified inline editable properties, properties=" + Arrays.asList(stringArray) + ", component root element=" + element);
            }
            return null;
        }
        try {
            DomProvider.InlineEditorSupport inlineEditorSupport;
            object = stringArray2[n2];
            String string3 = stringArray3[n2];
            string2 = null;
            if (string3 != null && string3.startsWith("//")) {
                int n5;
                n = string3.length();
                for (n5 = 2; n5 < n && Character.isLetter(string3.charAt(n5)); ++n5) {
                }
                string2 = HtmlTag.getTag((String)string3.substring(2, n5));
            }
            if ((inlineEditorSupport = webForm.createInlineEditorSupport(element, (String)object, string3)) == null) {
                InlineEditor.log(new NullPointerException("Missing inline editor support, componentRootElement=" + element + ", propertyName=" + (String)object));
                InlineEditor inlineEditor2 = null;
                return inlineEditor2;
            }
            if (string2 == null && cssBox != null && cssBox.getElement() != null) {
                string2 = HtmlTag.getTag((String)cssBox.getElement().getTagName());
            }
            if (string2 != null && string2.isFormMemberTag() && (inlineEditor = FormComponentEditor.get(webForm, cssBox, element, inlineEditorSupport)) != null) {
                InlineEditor inlineEditor3 = inlineEditor;
                return inlineEditor3;
            }
            inlineEditor = AttributeInlineEditor.get(webForm, element, inlineEditorSupport);
            if (inlineEditor != null) {
                InlineEditor inlineEditor4 = inlineEditor;
                return inlineEditor4;
            }
            InlineEditor inlineEditor5 = null;
            return inlineEditor5;
        }
        finally {
            if (inlineEditor != null) {
                inlineEditor.lastClick = inlineEditor.editingStarted = System.currentTimeMillis();
            }
        }
    }

    public abstract void start(boolean var1, String var2);

    public void cycleEditableProperty(boolean bl) {
    }

    abstract void finish(boolean var1);

    public boolean isEdited(CssBox cssBox) {
        while (cssBox != null) {
            Element element = this.inlineEditorSupport.getRenderedElement();
            if (element != null && element == CssBox.getElementForComponentRootCssBox(cssBox)) {
                return true;
            }
            cssBox = cssBox.getParent();
        }
        return false;
    }

    public DomProvider.DomPosition getBegin() {
        return this.inlineEditorSupport.getBeginPosition();
    }

    public DomProvider.DomPosition getEnd() {
        return this.inlineEditorSupport.getEndPosition();
    }

    public abstract boolean isEscaped();

    public boolean isDocumentEditor() {
        return false;
    }

    public abstract boolean isMultiLine();

    public void paint(Graphics2D graphics2D) {
        InteractionManager interactionManager = this.webform.getManager();
        List<Rectangle> list = ModelViewMapper.getComponentRectangles(this.webform.getPane().getPageBox(), this.inlineEditorSupport.getRenderedElement());
        int n = list.size();
        if (n > 0) {
            Rectangle rectangle = list.get(n - 1);
            interactionManager.drawInlineEditorBox(graphics2D, rectangle);
        }
    }

    protected void checkInitialDoubleClick(MouseEvent mouseEvent) {
        if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent) && this.lastClick <= this.editingStarted) {
            WebForm.DefaultDesignerEvent defaultDesignerEvent = new WebForm.DefaultDesignerEvent(this.webform, null);
            this.webform.fireUserActionPerformed(defaultDesignerEvent);
        }
        this.lastClick = mouseEvent.getWhen();
    }

    public abstract boolean checkPosition(DomProvider.DomPosition var1);

    public abstract Transferable copyText(boolean var1);

    public boolean isEditing(Element element, String string) {
        String string2 = this.inlineEditorSupport.getName();
        return element == this.inlineEditorSupport.getRenderedElement() && string2 != null && string2.equals(string) || string2 == string;
    }

    public abstract void invokeDeleteNextCharAction(ActionEvent var1);

    private static void log(Exception exception) {
        Logger logger = InlineEditor.getLogger();
        logger.log(Level.INFO, null, exception);
    }

    private static void info(String string) {
        Logger logger = InlineEditor.getLogger();
        logger.info(string);
    }

    private static void warn(String string) {
        Logger logger = InlineEditor.getLogger();
        logger.warning(string);
    }

    private static Logger getLogger() {
        return Logger.getLogger(InlineEditor.class.getName());
    }
}

