/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.visualweb.designer.DesignerTransferHandler;

class BasicDropTargetListener
implements DropTargetListener,
UIResource,
ActionListener {
    private Timer timer;
    private Point lastPosition;
    private Rectangle outer = new Rectangle();
    private Rectangle inner = new Rectangle();
    private boolean canImport;
    private JComponent component;

    protected BasicDropTargetListener() {
    }

    protected void saveComponentState(JComponent jComponent) {
    }

    protected void restoreComponentState(JComponent jComponent) {
    }

    protected void restoreComponentStateForDrop(JComponent jComponent) {
    }

    protected void updateInsertionLocation(JComponent jComponent, Point point) {
    }

    void updateAutoscrollRegion(JComponent jComponent) {
        Rectangle rectangle = jComponent.getVisibleRect();
        this.outer.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = new Insets(0, 0, 0, 0);
        if (jComponent instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)jComponent);
            insets.left = scrollable.getScrollableUnitIncrement(rectangle, 0, 1);
            insets.top = scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
            insets.right = scrollable.getScrollableUnitIncrement(rectangle, 0, -1);
            insets.bottom = scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
        }
        this.inner.setBounds(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
    }

    void autoscroll(JComponent jComponent, Point point) {
        if (jComponent instanceof Scrollable) {
            Rectangle rectangle;
            int n;
            Scrollable scrollable = (Scrollable)((Object)jComponent);
            if (point.y < this.inner.y) {
                n = scrollable.getScrollableUnitIncrement(this.outer, 1, 1);
                rectangle = new Rectangle(this.inner.x, this.outer.y - n, this.inner.width, n);
                jComponent.scrollRectToVisible(rectangle);
            } else if (point.y > this.inner.y + this.inner.height) {
                n = scrollable.getScrollableUnitIncrement(this.outer, 1, -1);
                rectangle = new Rectangle(this.inner.x, this.outer.y + this.outer.height, this.inner.width, n);
                jComponent.scrollRectToVisible(rectangle);
            }
            if (point.x < this.inner.x) {
                n = scrollable.getScrollableUnitIncrement(this.outer, 0, 1);
                rectangle = new Rectangle(this.outer.x - n, this.inner.y, n, this.inner.height);
                jComponent.scrollRectToVisible(rectangle);
            } else if (point.x > this.inner.x + this.inner.width) {
                n = scrollable.getScrollableUnitIncrement(this.outer, 0, -1);
                rectangle = new Rectangle(this.outer.x + this.outer.width, this.inner.y, n, this.inner.height);
                jComponent.scrollRectToVisible(rectangle);
            }
        }
    }

    private void initPropertiesIfNecessary() {
        if (this.timer == null) {
            Integer n;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Integer n2 = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.initialDelay");
            if (n2 == null) {
                n2 = new Integer(100);
            }
            if ((n = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.interval")) == null) {
                n = new Integer(100);
            }
            this.timer = new Timer(n, this);
            this.timer.setCoalesce(true);
            this.timer.setInitialDelay(n2);
        }
    }

    static JComponent getComponent(DropTargetEvent dropTargetEvent) {
        DropTargetContext dropTargetContext = dropTargetEvent.getDropTargetContext();
        return (JComponent)dropTargetContext.getComponent();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.updateAutoscrollRegion(this.component);
        if (this.outer.contains(this.lastPosition) && !this.inner.contains(this.lastPosition)) {
            this.autoscroll(this.component, this.lastPosition);
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.component = BasicDropTargetListener.getComponent(dropTargetDragEvent);
        TransferHandler transferHandler = this.component.getTransferHandler();
        this.canImport = transferHandler instanceof DesignerTransferHandler ? ((DesignerTransferHandler)transferHandler).canImport(this.component, dropTargetDragEvent.getCurrentDataFlavors(), dropTargetDragEvent.getTransferable()) : transferHandler.canImport(this.component, dropTargetDragEvent.getCurrentDataFlavors());
        if (this.canImport) {
            this.saveComponentState(this.component);
            this.lastPosition = dropTargetDragEvent.getLocation();
            this.updateAutoscrollRegion(this.component);
            this.initPropertiesIfNecessary();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.canImport && this.component != null) {
            this.restoreComponentState(this.component);
        }
        this.cleanup();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.canImport) {
            this.restoreComponentStateForDrop(this.component);
        }
        this.cleanup();
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private void cleanup() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.component = null;
        this.lastPosition = null;
    }
}

