/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssComputedValue;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssListValue;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.css2.BackgroundImagePainter;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.ContainerBox;
import org.netbeans.modules.visualweb.css2.CssBorder;
import org.netbeans.modules.visualweb.css2.FormatContext;
import org.netbeans.modules.visualweb.css2.LineBoxGroup;
import org.netbeans.modules.visualweb.css2.TableBox;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.ImageCache;
import org.netbeans.modules.visualweb.designer.Interaction;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.netbeans.modules.visualweb.spi.designer.Decoration;
import org.openide.util.Utilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssBox
implements Designer.Box {
    private static final int MINIMUM_BEAN_SIZE = 24;
    public static final int AUTO = 0x7FFFFFFE;
    public static final int UNINITIALIZED = 0x7FFFFFFD;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    protected static final boolean DEBUGFORMAT = false;
    private static boolean debugPaint = System.getProperty("rave.debugLayout") != null;
    static boolean paintPositioning = System.getProperty("rave.debugPositioning") != null;
    static boolean paintSpaces = debugPaint;
    static boolean paintText = false;
    protected final WebForm webform;
    int top = 0x7FFFFFFE;
    int left = 0x7FFFFFFE;
    int right = 0x7FFFFFFE;
    int bottom = 0x7FFFFFFE;
    int contentWidth;
    int contentHeight;
    int z = 0x7FFFFFFE;
    private ContainerBox parent;
    CssBox positionedBy;
    int extentX;
    int extentY;
    int extentX2;
    int extentY2;
    int topMargin;
    int bottomMargin;
    int leftMargin;
    int rightMargin;
    int topPadding;
    int bottomPadding;
    int leftPadding;
    int rightPadding;
    int topBorderWidth;
    int bottomBorderWidth;
    int rightBorderWidth;
    int leftBorderWidth;
    CssBorder border;
    private final Element element;
    Color bg;
    HtmlTag tag;
    BackgroundImagePainter bgPainter;
    int x = 0x7FFFFFFD;
    int y = 0x7FFFFFFD;
    int width = 0x7FFFFFFD;
    int height = 0x7FFFFFFD;
    private int parentIndex = -1;
    int containingBlockX;
    int containingBlockY;
    int containingBlockWidth = -1;
    int containingBlockHeight = -1;
    boolean inline;
    boolean replaced;
    BoxType boxType;
    int effectiveTopMargin = 0x7FFFFFFD;
    int effectiveBottomMargin = 0x7FFFFFFD;
    boolean hidden;
    private final boolean elementFocused;
    CssBox originalInlineContainer = null;

    public CssBox(WebForm webForm, Element element, BoxType boxType, boolean bl, boolean bl2) {
        this.webform = webForm;
        this.boxType = boxType;
        this.inline = bl;
        this.element = element;
        this.replaced = bl2;
        this.initializeDesignBean();
        this.effectiveTopMargin = 0;
        this.effectiveBottomMargin = 0;
        this.initializeInvariants();
        boolean bl3 = this.elementFocused = webForm == null ? false : webForm.getDomProviderService().isFocusedElement(element);
        if (this.elementFocused) {
            webForm.setInitialFocusMarkCssBox(null);
        }
    }

    protected void initializeDesignBean() {
        if (this.element != null && this.boxType != BoxType.LINEBOX) {
            this.putBoxReference(this.element, this);
            Element element = this.findSourceElement();
            if (element != null) {
                this.putBoxReference(element, this);
            }
        }
    }

    protected void initializeInvariants() {
        this.initializeBackground();
        if (this.element != null) {
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.element, 56);
            this.hidden = !CssProvider.getValueService().isVisibleValue(cssValue);
        }
    }

    protected void initialize() {
        if (this.element != null) {
            this.initializeBorder();
            this.initializeMargins();
            this.initializePadding();
        } else {
            this.effectiveTopMargin = 0;
            this.effectiveBottomMargin = 0;
        }
    }

    protected void initializeContentSize() {
        this.contentWidth = CssUtilities.getCssLength(this.element, 58);
        this.contentHeight = CssUtilities.getCssLength(this.element, 31);
    }

    public BoxType getBoxType() {
        return this.boxType;
    }

    protected void initializeZOrder() {
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.element, 59);
        if (!CssProvider.getValueService().isAutoValue(cssValue)) {
            this.z = (int)cssValue.getFloatValue();
        }
    }

    protected void initializeBorder() {
        this.border = CssBorder.getBorder(this.element);
        if (this.border != null) {
            this.leftBorderWidth = this.border.getLeftBorderWidth();
            this.topBorderWidth = this.border.getTopBorderWidth();
            this.bottomBorderWidth = this.border.getBottomBorderWidth();
            this.rightBorderWidth = this.border.getRightBorderWidth();
        }
        this.considerDesignBorder();
    }

    protected void considerDesignBorder() {
        if (this.border != null) {
            return;
        }
        if (!this.boxType.isAbsolutelyPositioned()) {
            return;
        }
        Element element = CssBox.getElementForComponentRootCssBox(this);
        if (element == null) {
            return;
        }
        if (this.tag == HtmlTag.FORM) {
            return;
        }
        if (this.webform.getDomProviderService().ignoreDesignBorder(element)) {
            return;
        }
        if (!this.isInlineBox() || CssProvider.getEngineService().isInlineStyleValue(this.element, 58) || CssProvider.getEngineService().isInlineStyleValue(this.element, 31)) {
            this.border = CssBorder.getDesignerBorder();
            this.leftBorderWidth = this.border.getLeftBorderWidth();
            this.topBorderWidth = this.border.getTopBorderWidth();
            this.bottomBorderWidth = this.border.getBottomBorderWidth();
            this.rightBorderWidth = this.border.getRightBorderWidth();
        }
    }

    protected void initializeBackground() {
        this.initializeBackgroundColor();
        this.initializeBackgroundImage();
    }

    protected void initializeBackgroundColor() {
        this.bg = CssProvider.getValueService().getColorForElement(this.element, 0);
    }

    protected void initializeBackgroundImage() {
        ImageIcon imageIcon;
        ImageCache imageCache;
        URL uRL = this.webform.getBaseUrl();
        if (uRL == null) {
            return;
        }
        URL uRL2 = CssProvider.getEngineService().getBackgroundImageUrlForElement(this.element, uRL);
        if (uRL2 != null) {
            imageCache = this.webform.getImageCache();
            imageIcon = imageCache.get(uRL2);
            if (imageIcon == null) {
                imageIcon = new ImageIcon(uRL2);
                imageCache.put(uRL2, imageIcon);
            }
        } else {
            imageIcon = null;
        }
        if (imageIcon != null) {
            imageCache = CssProvider.getEngineService().getComputedValueForElement(this.element, 3);
            CssListValue cssListValue = CssProvider.getValueService().getComputedCssListValue(CssProvider.getEngineService().getComputedValueForElement(this.element, 2));
            this.bgPainter = new BackgroundImagePainter(imageIcon, (CssValue)imageCache, cssListValue, this.element, this.webform.getDefaultFontSize());
        }
    }

    protected void initializeMargins() {
        this.leftMargin = CssUtilities.getCssLength(this.element, 35);
        this.rightMargin = CssUtilities.getCssLength(this.element, 36);
        this.topMargin = CssUtilities.getCssLength(this.element, 37);
        if (this.topMargin == 0x7FFFFFFE) {
            this.topMargin = 0;
        }
        this.effectiveTopMargin = this.topMargin;
        this.bottomMargin = CssUtilities.getCssLength(this.element, 38);
        if (this.bottomMargin == 0x7FFFFFFE) {
            this.bottomMargin = 0;
        }
        this.effectiveBottomMargin = this.bottomMargin;
    }

    protected void initializePadding() {
        this.leftPadding = CssUtilities.getCssLength(this.element, 44);
        this.rightPadding = CssUtilities.getCssLength(this.element, 45);
        if (this.leftPadding < 0) {
            this.leftPadding = 0;
        }
        if (this.rightPadding < 0) {
            this.rightPadding = 0;
        }
        this.topPadding = CssUtilities.getCssLength(this.element, 46);
        this.bottomPadding = CssUtilities.getCssLength(this.element, 47);
        if (this.topPadding < 0) {
            this.topPadding = 0;
        }
        if (this.bottomPadding < 0) {
            this.bottomPadding = 0;
        }
    }

    @Override
    public final Element getElement() {
        return this.element;
    }

    private Element findSourceElement() {
        Element element = CssBox.getElementForPrincipalCssBox(this);
        if (element == this.element) {
            return MarkupService.getSourceElementForElement((Element)element);
        }
        return null;
    }

    @Override
    public final Element getSourceElement() {
        Element element = this.findSourceElement();
        if (element != null) {
            return element;
        }
        return this.getElement();
    }

    protected void computeRectangles(Element element, List<Rectangle> list) {
        if (CssBox.getElementForComponentRootCssBox(this) == element || this.webform.getDomProviderService().areLinkedToSameBean(this.element, element)) {
            list.add(new Rectangle(this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight()));
            return;
        }
        int n = this.getBoxCount();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.getBox(i);
            cssBox.computeRectangles(element, list);
            if (list.size() >= 1) break;
        }
    }

    protected Rectangle computeBounds(Element element, Rectangle rectangle) {
        if (CssBox.getElementForComponentRootCssBox(this) == element || this.webform.getDomProviderService().areLinkedToSameBean(this.element, element)) {
            Rectangle rectangle2 = new Rectangle(this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight());
            if (rectangle == null) {
                rectangle = rectangle2;
            } else {
                rectangle.add(rectangle2);
            }
        }
        int n = this.getBoxCount();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.getBox(i);
            rectangle = cssBox.computeBounds(element, rectangle);
        }
        return rectangle;
    }

    public final Rectangle computeRegionBounds(Element element, Rectangle object) {
        if (this.element != null && this.webform.getDomProviderService().isSameRegionOfElement(element, this.element)) {
            Rectangle rectangle = new Rectangle(this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight());
            if (object == null) {
                object = rectangle;
            } else {
                ((Rectangle)object).add(rectangle);
            }
        }
        int n = this.getBoxCount();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.getBox(i);
            if (cssBox.element != null && cssBox.element.getParentNode() != this.element) {
                Object object2;
                boolean bl = false;
                for (Node node = cssBox.element.getParentNode(); node instanceof Element && node != this.element; node = node.getParentNode()) {
                    object2 = (Element)node;
                    if (!this.webform.getDomProviderService().isSameRegionOfElement(element, (Element)object2)) continue;
                    bl = true;
                }
                if (bl) {
                    object2 = new Rectangle(cssBox.getAbsoluteX(), cssBox.getAbsoluteY(), cssBox.getWidth(), cssBox.getHeight());
                    if (object == null) {
                        object = object2;
                        continue;
                    }
                    ((Rectangle)object).add((Rectangle)object2);
                    continue;
                }
            }
            object = cssBox.computeRegionBounds(element, (Rectangle)object);
        }
        return object;
    }

    private static CssBox findCssBoxInTree(Element element, CssBox cssBox) {
        if (element == null) {
            return null;
        }
        if (element == CssBox.getElementForComponentRootCssBox(cssBox)) {
            return cssBox;
        }
        int n = cssBox.getBoxCount();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox2 = cssBox.getBox(i);
            CssBox cssBox3 = CssBox.findCssBoxInTree(element, cssBox2);
            if (cssBox3 == null) continue;
            return cssBox3;
        }
        return null;
    }

    protected CssBox findCssBoxForComponentRootElement(Element element) {
        if (element == null) {
            return null;
        }
        CssBox cssBox = this.getWebForm().findCssBoxForElement(element);
        if (cssBox != null) {
            return cssBox;
        }
        return CssBox.findCssBoxInTree(element, this);
    }

    void putBoxReference(Element element, CssBox cssBox) {
        this.getWebForm().setCssBoxForElement(element, cssBox);
    }

    protected void paintBox(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.hidden) {
            return;
        }
        if (this.border != null) {
            this.border.paintBorder(graphics, n, n2, n3, n4);
        }
        n += this.leftBorderWidth;
        n2 += this.topBorderWidth;
        n3 -= this.leftBorderWidth;
        n3 -= this.rightBorderWidth;
        n4 -= this.topBorderWidth;
        n4 -= this.bottomBorderWidth;
        if (this.bg != null) {
            graphics.setColor(this.bg);
            graphics.fillRect(n, n2, n3, n4);
        }
        if (this.bgPainter != null) {
            this.bgPainter.paint(graphics, n, n2, n3, n4);
        }
    }

    @Override
    public int getAbsoluteX() {
        if (this.positionedBy != this.parent) {
            return this.positionedBy.getAbsoluteX() + this.getX() + this.leftMargin;
        }
        if (this.parent != null) {
            return this.parent.getAbsoluteX() + this.x + this.leftMargin;
        }
        return this.x + this.leftMargin;
    }

    @Override
    public int getAbsoluteY() {
        if (this.positionedBy != this.parent) {
            return this.positionedBy.getAbsoluteY() + this.getY() + this.effectiveTopMargin;
        }
        if (this.parent != null) {
            return this.parent.getAbsoluteY() + this.y + this.effectiveTopMargin;
        }
        return this.y + this.effectiveTopMargin;
    }

    protected int getBaseline() {
        return this.getHeight();
    }

    protected int getContributingBaseline() {
        return this.getBaseline();
    }

    public boolean isGrid() {
        return false;
    }

    void setX(int n) {
        this.x = n;
    }

    void setY(int n) {
        this.y = n;
    }

    public final void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public final String toString() {
        return super.toString() + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "pos=" + this.x + ":" + this.y + "," + "element=" + this.element + ", size=" + this.width + ":" + this.height;
    }

    public void paint(Graphics graphics, int n, int n2) {
        n += this.getX();
        n2 += this.getY();
        if (Math.abs(n += this.leftMargin) > 50000 || Math.abs(n2 += this.effectiveTopMargin) > 50000 || Math.abs(this.width) > 50000 || Math.abs(this.height) > 50000) {
            CssBox cssBox = CssBox.findBadBox(this);
            CssBox.info(new IllegalStateException("Fatal painting error:\nthis box=" + this + "\nbad box=" + cssBox + "\nparent of bad box=" + cssBox.getParent()));
            return;
        }
        this.paintBackground(graphics, n, n2);
        if (this.hasInitialFocus() && this.webform.getInitialFocusMarkCssBox() == null) {
            this.webform.setInitialFocusMarkCssBox(this);
        }
        int n3 = this.getBoxCount();
        for (int i = 0; i < n3; ++i) {
            CssBox cssBox = this.getBox(i);
            if (DesignerPane.INCREMENTAL_LAYOUT && DesignerPane.isOutsideClip(cssBox.extentX, cssBox.extentY, cssBox.extentX2, cssBox.extentY2) && this.isBoxDecorationOutsideClip(cssBox)) continue;
            CssBox cssBox2 = cssBox.getPositionedBy();
            if (cssBox2 != this) {
                cssBox.paint(graphics, cssBox2.getAbsoluteX(), cssBox2.getAbsoluteY());
                continue;
            }
            cssBox.paint(graphics, n, n2);
        }
        if (this == this.webform.getInitialFocusMarkCssBox()) {
            this.paintFocusWaterMark(graphics, n, n2);
        }
        this.paintDecoration(graphics, n + this.getWidth(), n2);
        if (paintPositioning) {
            this.paintDebugPositioning(graphics);
        }
    }

    private boolean isBoxDecorationOutsideClip(CssBox cssBox) {
        if (!this.webform.isShowDecorations()) {
            return true;
        }
        Decoration decoration = cssBox.getDecoration();
        if (decoration != null) {
            int n = cssBox.extentX2;
            int n2 = cssBox.extentY;
            int n3 = n + decoration.getWidth();
            int n4 = n2 + decoration.getHeight();
            return DesignerPane.isOutsideClip(n, n2, n3, n4);
        }
        return true;
    }

    protected final boolean hasInitialFocus() {
        return this.elementFocused;
    }

    protected final void paintFocusWaterMark(Graphics graphics, int n, int n2) {
        Image image = Utilities.loadImage((String)"org/netbeans/modules/visualweb/designer/resources/focus-watermark.gif");
        if (image != null && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            graphics2D.drawImage(image, affineTransform, null);
            graphics2D.setComposite(composite);
        }
    }

    protected void paintDecoration(Graphics graphics, int n, int n2) {
        if (!this.webform.isShowDecorations()) {
            return;
        }
        Decoration decoration = this.getDecoration();
        if (decoration == null) {
            return;
        }
        Image image = decoration.getImage();
        if (image != null) {
            ImageIcon imageIcon = new ImageIcon(image);
            imageIcon.paintIcon(null, graphics, n, n2);
        }
    }

    protected void paintDebugPositioning(Graphics graphics) {
        Element element = CssBox.getElementForComponentRootCssBox(this);
        if (element == null || !this.boxType.isPositioned() || !this.webform.getDomProviderService().isFacesComponent(element) || this.webform.isFormComponent(element)) {
            return;
        }
        CssBox cssBox = this.getPositionedBy();
        if (cssBox == null) {
            return;
        }
        int n = cssBox.getAbsoluteX();
        int n2 = cssBox.getAbsoluteY();
        int n3 = this.getAbsoluteX();
        int n4 = this.getAbsoluteY();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics.setColor(Color.LIGHT_GRAY);
        String string = Integer.toString(this.x);
        String string2 = Integer.toString(this.y);
        Font font = UIManager.getFont("Label.font");
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = fontMetrics.getAscent() + fontMetrics.getDescent();
        int n7 = (n3 - n) / 2 - n5 / 2 - 2;
        if (n7 > 0) {
            graphics.drawLine(n, n4, n + n7, n4);
            graphics.drawLine(n3 - n7, n4, n3, n4);
        }
        graphics.drawString(string, n + n7 + 1, n4 + fontMetrics.getHeight() / 2 - fontMetrics.getDescent());
        n7 = (n4 - n2) / 2 - n6 / 2 - 2;
        if (n7 > 0) {
            graphics.drawLine(n3, n2, n3, n2 + n7);
            graphics.drawLine(n3, n4 - n7, n3, n4);
        }
        graphics2D.setStroke(stroke);
        graphics.drawString(string2, n3 - n5 / 2, n4 - n7 - fontMetrics.getDescent() + 1);
    }

    private static CssBox findBadBox(CssBox cssBox) {
        int n = cssBox.getBoxCount();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox2 = cssBox.getBox(i);
            if (Math.abs(cssBox2.extentX) > 50000 || Math.abs(cssBox2.extentX2) > 50000 || Math.abs(cssBox2.extentY) > 50000 || Math.abs(cssBox2.extentY2) > 50000) {
                return CssBox.findBadBox(cssBox2);
            }
            if (Math.abs(cssBox2.getX()) <= 50000 && Math.abs(cssBox2.getY()) <= 50000 && Math.abs(cssBox2.width) <= 50000 && Math.abs(cssBox2.height) <= 50000 && Math.abs(cssBox2.leftMargin) <= 50000 && Math.abs(cssBox2.effectiveTopMargin) <= 50000) continue;
            return CssBox.findBadBox(cssBox2);
        }
        return cssBox;
    }

    protected void paintBackground(Graphics graphics, int n, int n2) {
        if (this.hidden) {
            return;
        }
        this.paintBox(graphics, n, n2, this.getWidth(), this.getHeight());
    }

    public int getInternalResizeDirection(int n, int n2) {
        return 0;
    }

    public Interaction getInternalResizer(int n, int n2) {
        return null;
    }

    public static Element getComponentRootElementForCssBox(CssBox cssBox) {
        WebForm webForm;
        WebForm webForm2 = webForm = cssBox == null ? null : cssBox.getWebForm();
        if (webForm == null) {
            return null;
        }
        while (cssBox != null) {
            Element element = cssBox.getElement();
            if (webForm.getDomProviderService().isPrincipalElement(element, null)) {
                return element;
            }
            cssBox = cssBox.getParent();
        }
        return null;
    }

    public static Element getElementForComponentRootCssBox(CssBox cssBox) {
        if (cssBox == null) {
            return null;
        }
        Element element = cssBox.getElement();
        BoxType boxType = cssBox.getBoxType();
        if (element == null || boxType == BoxType.LINEBOX || boxType == BoxType.TEXT || boxType == BoxType.SPACE) {
            return null;
        }
        return CssBox.getElementForPrincipalCssBox(cssBox);
    }

    private static Element getElementForPrincipalCssBox(CssBox cssBox) {
        if (cssBox == null) {
            return null;
        }
        WebForm webForm = cssBox.getWebForm();
        if (webForm == null) {
            return null;
        }
        Element element = cssBox.getElement();
        ContainerBox containerBox = cssBox.getParent();
        Element element2 = containerBox == null ? null : containerBox.getElement();
        return webForm.getDomProviderService().isPrincipalElement(element, element2) ? element : null;
    }

    protected CssBox findCssBox(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        boolean bl2;
        int n6;
        for (n6 = this.getBoxCount() - 1; n6 >= 0; --n6) {
            CssBox cssBox;
            CssBox cssBox2 = this.getBox(n6);
            bl2 = n >= cssBox2.getExtentX() && n <= cssBox2.getExtentX2() && n2 >= cssBox2.getExtentY() && n2 <= cssBox2.getExtentY2();
            bl = this.isInsideBoxDecoration(n, n2, cssBox2);
            if (!bl2 && !bl || (cssBox = cssBox2.findCssBox(n, n2, n3, n4, n5 + 1)) == null) continue;
            return cssBox;
        }
        n6 = this.getAbsoluteX();
        int n7 = this.getAbsoluteY();
        bl2 = n >= n6 && n <= n6 + this.getWidth() && n2 >= n7 && n2 <= n7 + this.getHeight();
        bl = this.isInsideDecoration(n, n2, n6, n7);
        if (bl2 || bl) {
            return this;
        }
        return null;
    }

    private boolean isInsideBoxDecoration(int n, int n2, CssBox cssBox) {
        if (!this.webform.isShowDecorations()) {
            return false;
        }
        Decoration decoration = cssBox.getDecoration();
        if (decoration != null) {
            return n >= cssBox.getExtentX2() && n <= cssBox.getExtentX2() + decoration.getWidth() && n2 >= cssBox.getExtentY() && n2 <= cssBox.getExtentY() + decoration.getHeight();
        }
        return false;
    }

    private boolean isInsideDecoration(int n, int n2, int n3, int n4) {
        if (!this.webform.isShowDecorations()) {
            return false;
        }
        Decoration decoration = this.getDecoration();
        if (decoration != null) {
            return n >= n3 + this.getWidth() && n <= n3 + this.getWidth() + decoration.getWidth() && n2 >= n4 && n2 <= n4 + decoration.getHeight();
        }
        return false;
    }

    protected int getExtentX() {
        return this.extentX;
    }

    protected int getExtentX2() {
        return this.extentX2;
    }

    protected int getExtentY() {
        return this.extentY;
    }

    protected int getExtentY2() {
        return this.extentY2;
    }

    protected void updateExtents(int n, int n2, int n3) {
        if (this.positionedBy != this.parent) {
            n = this.positionedBy.getAbsoluteX();
            n2 = this.positionedBy.getAbsoluteY();
        }
        n += this.getX();
        n2 += this.getY();
        this.extentX = n += this.leftMargin;
        this.extentY = n2 += this.effectiveTopMargin;
        this.extentX2 = n + this.width;
        this.extentY2 = n2 + this.height;
        int n4 = this.getBoxCount();
        for (int i = 0; i < n4; ++i) {
            CssBox cssBox = this.getBox(i);
            cssBox.updateExtents(n, n2, n3 + 1);
            if (cssBox.extentX < this.extentX) {
                this.extentX = cssBox.extentX;
            }
            if (cssBox.extentY < this.extentY) {
                this.extentY = cssBox.extentY;
            }
            if (cssBox.extentX2 > this.extentX2) {
                this.extentX2 = cssBox.extentX2;
            }
            if (cssBox.extentY2 <= this.extentY2) continue;
            this.extentY2 = cssBox.extentY2;
        }
    }

    @Override
    public final ContainerBox getParent() {
        return this.parent;
    }

    @Override
    public CssBox getPositionedBy() {
        return this.positionedBy;
    }

    final void setParent(ContainerBox containerBox) {
        this.parent = containerBox;
    }

    void setPositionedBy(CssBox cssBox) {
        this.positionedBy = cssBox;
    }

    public int getBoxCount() {
        return 0;
    }

    public CssBox getBox(int n) {
        throw new IllegalArgumentException();
    }

    protected void setContainingBlock(int n, int n2, int n3, int n4) {
        this.containingBlockX = n;
        this.containingBlockY = n2;
        this.containingBlockWidth = n3;
        this.containingBlockHeight = n4;
    }

    public boolean isClearBox() {
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.getElement(), 18);
        return CssProvider.getValueService().isLeftValue(cssValue) || CssProvider.getValueService().isBothValue(cssValue) || CssProvider.getValueService().isRightValue(cssValue);
    }

    public boolean isInlineBox() {
        return this.inline;
    }

    public boolean isBlockLevel() {
        return !this.inline;
    }

    public boolean isReplacedBox() {
        return this.replaced;
    }

    @Override
    public HtmlTag getTag() {
        return this.tag;
    }

    public WebForm getWebForm() {
        return this.webform;
    }

    protected int getPrefMinWidth() {
        int n = this.contentWidth != 0x7FFFFFFE && this.contentWidth != 0x7FFFFFFD ? this.contentWidth : this.getIntrinsicWidth();
        n += this.leftBorderWidth + this.leftPadding + this.rightPadding + this.rightBorderWidth;
        if (this.leftMargin != 0x7FFFFFFE) {
            n += this.leftMargin;
        }
        if (this.rightMargin != 0x7FFFFFFE) {
            n += this.rightMargin;
        }
        return n;
    }

    protected int getPrefWidth() {
        int n = this.contentWidth != 0x7FFFFFFE && this.contentWidth != 0x7FFFFFFD ? this.contentWidth : this.getIntrinsicWidth();
        if (!this.isBorderSizeIncluded()) {
            n += this.leftBorderWidth + this.leftPadding + this.rightPadding + this.rightBorderWidth;
        }
        if (this.leftMargin != 0x7FFFFFFE) {
            n += this.leftMargin;
        }
        if (this.rightMargin != 0x7FFFFFFE) {
            n += this.rightMargin;
        }
        return n;
    }

    protected int getContentWidth() {
        return this.width - this.leftPadding - this.rightPadding;
    }

    protected int getContentHeight() {
        return this.height - this.topPadding - this.bottomPadding;
    }

    protected int getContentX() {
        return this.x + this.leftMargin + this.leftBorderWidth + this.leftPadding;
    }

    protected int getContentY() {
        return this.y + this.topMargin + this.topBorderWidth + this.topPadding;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    protected int getIntrinsicWidth() {
        return 0;
    }

    protected int getIntrinsicHeight() {
        return 0;
    }

    @Override
    public int getLeftMargin() {
        return this.leftMargin;
    }

    @Override
    public int getRightMargin() {
        return this.rightMargin;
    }

    @Override
    public int getEffectiveTopMargin() {
        return this.effectiveTopMargin;
    }

    protected int getEffectiveBottomMargin() {
        return this.effectiveBottomMargin;
    }

    public void setMargins(int n, int n2) {
        this.leftMargin = n;
        this.effectiveTopMargin = n2;
    }

    protected boolean isBorderSizeIncluded() {
        return false;
    }

    public Insets getCssSizeInsets() {
        return new Insets(this.topBorderWidth + this.topPadding, this.leftBorderWidth + this.leftPadding, this.bottomBorderWidth + this.bottomPadding, this.rightBorderWidth + this.rightPadding);
    }

    protected void relayout(FormatContext formatContext) {
    }

    protected void initializeHorizontalWidths(FormatContext formatContext) {
        if (this.element == null) {
            CssBox.fine("Unexpected null element in initialize horizontal widths");
            return;
        }
        this.initializeContainingBlock();
        this.initialize();
        CssValue cssValue = this.computeWidthCssValue();
        this.contentWidth = cssValue == null || CssProvider.getValueService().isAutoValue(cssValue) ? (this.replaced ? this.getIntrinsicWidth() : 0) : (int)cssValue.getFloatValue();
        if (cssValue instanceof CssComputedValue) {
            this.uncomputeWidthCssValue();
        }
    }

    private void initializeContainingBlock() {
        this.containingBlockX = 0;
        this.containingBlockY = 0;
        int n = CssBox.getParentContainerLength(this, 58);
        int n2 = CssBox.getParentContainerLength(this, 31);
        int n3 = this.getIntrinsicWidth();
        int n4 = this.getIntrinsicHeight();
        this.containingBlockWidth = n3 > n ? n : n3;
        this.containingBlockHeight = n4 > n2 ? n2 : n4;
    }

    private static int getParentContainerLength(CssBox cssBox, int n) {
        for (ContainerBox containerBox = cssBox.getParent(); containerBox != null; containerBox = containerBox.getParent()) {
            Element element = containerBox.getElement();
            if (element == null) continue;
            CssValue cssValue = containerBox.computeWidthCssValue();
            if (CssProvider.getValueService().isAutoValue(cssValue)) continue;
            int n2 = cssValue == null ? 0 : (int)cssValue.getFloatValue();
            if (cssValue instanceof CssComputedValue) {
                containerBox.uncomputeWidthCssValue();
            }
            return n2;
        }
        return 0;
    }

    protected CssValue computeWidthCssValue() {
        return CssProvider.getEngineService().getComputedValueForElement(this.element, 58);
    }

    protected void uncomputeWidthCssValue() {
        CssProvider.getEngineService().uncomputeValueForElement(this.element, 58);
    }

    void setParentIndex(int n) {
        this.parentIndex = n;
    }

    protected int getParentIndex() {
        return this.parentIndex;
    }

    void computeHorizontalLengths(FormatContext formatContext) {
        int n = this.containingBlockWidth;
        assert (this.boxType != BoxType.LINEBOX) : this;
        Element element = this.getElement();
        if (element != null) {
            this.initializeContentSize();
            if (this.boxType.isPositioned()) {
                this.left = CssUtilities.getCssLength(element, 39);
                this.right = CssUtilities.getCssLength(element, 40);
            }
            if (this.isBorderSizeIncluded()) {
                if (this.contentWidth != 0x7FFFFFFE) {
                    this.contentWidth -= this.leftBorderWidth + this.leftPadding + this.rightPadding + this.rightBorderWidth;
                }
                if (this.contentHeight != 0x7FFFFFFE) {
                    this.contentHeight -= this.topBorderWidth + this.topPadding + this.bottomPadding + this.bottomBorderWidth;
                }
            }
        } else {
            this.contentWidth = 0x7FFFFFFE;
            this.contentHeight = 0x7FFFFFFE;
        }
        if (this.boxType == BoxType.FLOAT) {
            this.computeHorizontalFloat(formatContext, n);
        } else if (!this.replaced && this.boxType.isAbsolutelyPositioned()) {
            this.computeHorizontalNonReplacedAbsPos(formatContext, n);
        } else if (this.replaced && this.boxType.isAbsolutelyPositioned()) {
            this.computeHorizontalReplacedAbsPos(formatContext, n);
        } else if (this.inline) {
            this.computeHorizInlineNormal();
        } else if (!this.inline && this.boxType.isNormalFlow()) {
            this.computeHorizNonInlineNormalFlow(formatContext, n);
        } else assert (false) : this + ";" + this.boxType + ";" + this.inline + ";" + this.replaced;
        if (this.boxType == BoxType.RELATIVE) {
            if (this.left == 0x7FFFFFFE && this.right == 0x7FFFFFFE) {
                this.left = 0;
                this.right = 0;
            } else if (this.left == 0x7FFFFFFE) {
                this.left = -this.right;
            } else {
                this.right = this.right == 0x7FFFFFFE ? -this.left : -this.left;
            }
        }
    }

    private void computeHorizontalFloat(FormatContext formatContext, int n) {
        if (this.left == 0x7FFFFFFE) {
            this.left = 0;
        }
        if (this.right == 0x7FFFFFFE) {
            this.right = 0;
        }
        if (this.leftMargin == 0x7FFFFFFE) {
            this.leftMargin = 0;
        }
        if (this.rightMargin == 0x7FFFFFFE) {
            this.rightMargin = 0;
        }
        if (this.replaced) {
            this.updateAutoContentSize();
        } else if (this.contentWidth == 0x7FFFFFFE) {
            int n2 = n - this.leftMargin - this.left - this.leftBorderWidth - this.leftPadding - this.rightPadding - this.rightBorderWidth - this.rightMargin - this.right;
            this.contentWidth = this.shrinkToFit(n2, formatContext);
        }
    }

    private void computeHorizontalNonReplacedAbsPos(FormatContext formatContext, int n) {
        if (this.boxType == BoxType.FIXED) {
            n = this.getInitialWidth(formatContext);
        }
        if (this.left == 0x7FFFFFFE && this.right == 0x7FFFFFFE && this.contentWidth == 0x7FFFFFFE) {
            if (this.leftMargin == 0x7FFFFFFE) {
                this.leftMargin = 0;
            }
            if (this.rightMargin == 0x7FFFFFFE) {
                this.rightMargin = 0;
            }
            this.left = this.getStaticLeft(formatContext);
            int n2 = n - this.leftMargin - 0 - this.leftBorderWidth - this.leftPadding - this.rightPadding - this.rightBorderWidth - this.rightMargin - this.left;
            this.contentWidth = this.shrinkToFit(n2, formatContext);
            this.right = n - this.left - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.rightMargin;
        } else if (this.left != 0x7FFFFFFE && this.right != 0x7FFFFFFE && this.contentWidth != 0x7FFFFFFE) {
            if (this.leftMargin == 0x7FFFFFFE && this.rightMargin == 0x7FFFFFFE) {
                int n3 = n - this.left - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth;
                int n4 = n3 / 2;
                int n5 = n3 % 2;
                this.leftMargin = n4;
                this.rightMargin = n4 + n5;
            } else if (this.leftMargin != 0x7FFFFFFE && this.rightMargin == 0x7FFFFFFE) {
                this.rightMargin = n - this.left - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.right;
            } else if (this.leftMargin == 0x7FFFFFFE && this.rightMargin != 0x7FFFFFFE) {
                this.leftMargin = n - this.left - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.rightMargin - this.right;
            } else {
                this.right = n - this.left - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.rightMargin;
            }
        } else {
            if (this.leftMargin == 0x7FFFFFFE) {
                this.leftMargin = 0;
            }
            if (this.rightMargin == 0x7FFFFFFE) {
                this.rightMargin = 0;
            }
            if (this.left == 0x7FFFFFFE && this.contentWidth == 0x7FFFFFFE && this.right != 0x7FFFFFFE) {
                int n6 = n - this.leftMargin - 0 - this.leftBorderWidth - this.leftPadding - this.rightPadding - this.rightBorderWidth - this.rightMargin - this.right;
                this.contentWidth = this.shrinkToFit(n6, formatContext);
                this.left = n - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.rightMargin - this.right;
            } else if (this.left == 0x7FFFFFFE && this.right == 0x7FFFFFFE && this.contentWidth != 0x7FFFFFFE) {
                this.left = this.getStaticLeft(formatContext);
                this.right = n - this.left - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.rightMargin;
            } else if (this.contentWidth == 0x7FFFFFFE && this.right == 0x7FFFFFFE && this.left != 0x7FFFFFFE) {
                int n7 = n - this.leftMargin - 0 - this.leftBorderWidth - this.leftPadding - this.rightPadding - this.rightBorderWidth - this.rightMargin - this.left;
                this.contentWidth = this.shrinkToFit(n7, formatContext);
                this.right = n - this.left - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.rightMargin;
            } else if (this.left == 0x7FFFFFFE && this.contentWidth != 0x7FFFFFFE && this.right != 0x7FFFFFFE) {
                this.left = n - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.rightMargin - this.right;
            } else if (this.left != 0x7FFFFFFE && this.contentWidth == 0x7FFFFFFE && this.right != 0x7FFFFFFE) {
                this.contentWidth = n - this.left - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.rightPadding - this.rightBorderWidth - this.rightMargin - this.right;
            } else if (this.left != 0x7FFFFFFE && this.contentWidth != 0x7FFFFFFE && this.right == 0x7FFFFFFE) {
                this.right = n - this.left - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.rightMargin;
            }
        }
        assert (this.left + this.leftMargin + this.leftBorderWidth + this.leftPadding + this.contentWidth + this.rightPadding + this.rightBorderWidth + this.rightMargin + this.right == n);
    }

    private void computeHorizontalReplacedAbsPos(FormatContext formatContext, int n) {
        int n2;
        int n3;
        if (this.boxType == BoxType.FIXED) {
            n = this.getInitialWidth(formatContext);
        }
        this.updateAutoContentSize();
        if (this.leftMargin == 0x7FFFFFFE) {
            this.leftMargin = 0;
        }
        if (this.rightMargin == 0x7FFFFFFE) {
            this.rightMargin = 0;
        }
        if (this.left != 0x7FFFFFFE && this.right == 0x7FFFFFFE) {
            this.right = n - this.left - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.rightMargin;
        } else if (this.left == 0x7FFFFFFE && this.right != 0x7FFFFFFE) {
            this.left = n - this.right - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.rightMargin;
        } else if (this.left == 0x7FFFFFFE) {
            this.left = this.getStaticLeft(formatContext);
        }
        if (this.right == 0x7FFFFFFE) {
            if (this.leftMargin == 0x7FFFFFFE) {
                this.leftMargin = 0;
            }
            if (this.rightMargin == 0x7FFFFFFE) {
                this.rightMargin = 0;
            }
        }
        if (this.leftMargin == 0x7FFFFFFE && this.rightMargin == 0x7FFFFFFE) {
            n3 = n - this.left - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.right;
            n2 = n3 / 2;
            int n4 = n3 % 2;
            this.leftMargin = n2;
            this.rightMargin = n2 + n4;
        }
        n3 = 0;
        if (this.contentWidth == 0x7FFFFFFE) {
            ++n3;
        }
        if (this.leftMargin == 0x7FFFFFFE) {
            ++n3;
        }
        if (this.rightMargin == 0x7FFFFFFE) {
            ++n3;
        }
        if (this.right == 0x7FFFFFFE) {
            ++n3;
        }
        if (n3 == 1) {
            n2 = n - this.left - this.leftBorderWidth - this.rightBorderWidth - this.leftPadding - this.rightPadding;
            Equation equation = new Equation(n2, new int[]{this.leftMargin, this.rightMargin, this.contentWidth, this.right});
            equation.solve();
            switch (equation.index) {
                case 0: {
                    this.leftMargin = equation.value;
                    break;
                }
                case 1: {
                    this.rightMargin = equation.value;
                    break;
                }
                case 2: {
                    this.contentWidth = equation.value;
                    break;
                }
                case 3: {
                    this.right = equation.value;
                }
            }
        } else {
            assert (n3 == 0);
            this.right = n - this.left - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.contentWidth - this.rightPadding - this.rightBorderWidth - this.rightMargin;
        }
        assert (this.left + this.leftMargin + this.leftBorderWidth + this.leftPadding + this.contentWidth + this.rightPadding + this.rightBorderWidth + this.rightMargin + this.right == n);
    }

    private void computeHorizInlineNormal() {
        if (this.replaced) {
            this.updateAutoContentSize();
        }
        if (this.getBoxType() != BoxType.RELATIVE) {
            if (this.left == 0x7FFFFFFE) {
                this.left = 0;
            }
            if (this.right == 0x7FFFFFFE) {
                this.right = 0;
            }
            if (this.top == 0x7FFFFFFE) {
                this.top = 0;
            }
            if (this.bottom == 0x7FFFFFFE) {
                this.bottom = 0;
            }
        }
        if (this.leftMargin == 0x7FFFFFFE) {
            this.leftMargin = 0;
        }
        if (this.rightMargin == 0x7FFFFFFE) {
            this.rightMargin = 0;
        }
        if (this.topMargin == 0x7FFFFFFE) {
            this.topMargin = 0;
        }
        if (this.bottomMargin == 0x7FFFFFFE) {
            this.bottomMargin = 0;
        }
    }

    protected void computeHorizNonInlineNormalFlow(FormatContext formatContext, int n) {
        if (this.left == 0x7FFFFFFE) {
            this.left = 0;
        }
        if (this.right == 0x7FFFFFFE) {
            this.right = 0;
        }
        if (this.replaced && this.contentWidth == 0x7FFFFFFE) {
            this.updateAutoContentSize();
        }
        int n2 = 0;
        if (this.contentWidth == 0x7FFFFFFE) {
            ++n2;
        }
        if (this.leftMargin == 0x7FFFFFFE) {
            ++n2;
        }
        if (this.rightMargin == 0x7FFFFFFE) {
            ++n2;
        }
        if (n2 == 0) {
            this.rightMargin = n - this.contentWidth - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.rightPadding - this.rightBorderWidth;
        } else if (n2 == 1) {
            int n3 = n - this.leftBorderWidth - this.rightBorderWidth - this.leftPadding - this.rightPadding;
            Equation equation = new Equation(n3, new int[]{this.leftMargin, this.rightMargin, this.contentWidth});
            equation.solve();
            switch (equation.index) {
                case 0: {
                    this.leftMargin = equation.value;
                    break;
                }
                case 1: {
                    this.rightMargin = equation.value;
                    break;
                }
                case 2: {
                    this.contentWidth = equation.value;
                }
            }
        } else if (n2 == 2 && this.leftMargin == 0x7FFFFFFE && this.rightMargin == 0x7FFFFFFE) {
            int n4 = n - this.contentWidth - this.leftBorderWidth - this.leftPadding - this.rightPadding - this.rightBorderWidth;
            if (n4 < 0 && formatContext.initialWidth < this.contentWidth - this.leftBorderWidth - this.leftPadding - this.rightPadding - this.rightBorderWidth) {
                n4 = 0;
            }
            int n5 = n4 / 2;
            int n6 = n4 % 2;
            this.leftMargin = n5;
            this.rightMargin = n5 + n6;
        } else if (this.contentWidth == 0x7FFFFFFE) {
            if (this.leftMargin == 0x7FFFFFFE) {
                this.leftMargin = 0;
            }
            if (this.rightMargin == 0x7FFFFFFE) {
                this.rightMargin = 0;
            }
            if (this.leftPadding == 0x7FFFFFFE) {
                this.leftPadding = 0;
            }
            if (this.rightPadding == 0x7FFFFFFE) {
                this.rightPadding = 0;
            }
            if (this.leftBorderWidth == 0x7FFFFFFE) {
                this.leftBorderWidth = 0;
            }
            if (this.rightBorderWidth == 0x7FFFFFFE) {
                this.rightBorderWidth = 0;
            }
            this.contentWidth = n - this.leftMargin - this.leftBorderWidth - this.leftPadding - this.rightPadding - this.rightBorderWidth - this.rightMargin;
        } else {
            if (this.leftMargin == 0x7FFFFFFE) {
                this.leftMargin = 0;
            }
            if (this.rightMargin == 0x7FFFFFFE) {
                this.rightMargin = 0;
            }
            if (this.leftPadding == 0x7FFFFFFE) {
                this.leftPadding = 0;
            }
            if (this.rightPadding == 0x7FFFFFFE) {
                this.rightPadding = 0;
            }
            if (this.leftBorderWidth == 0x7FFFFFFE) {
                this.leftBorderWidth = 0;
            }
            if (this.rightBorderWidth == 0x7FFFFFFE) {
                this.rightBorderWidth = 0;
            }
        }
    }

    private int getStaticLeft(FormatContext formatContext) {
        if (this.isInlineBox() && formatContext.lineBox != null && formatContext.lineBox.canFit(this)) {
            return formatContext.lineBox.getNextX();
        }
        return 0;
    }

    private int getLineBoxY(FormatContext formatContext) {
        int n;
        if (formatContext.lineBox != null) {
            n = formatContext.lineBox.getY();
        } else {
            CssBox cssBox = this.getPrevNormalBox();
            if (cssBox != null) {
                int n2 = cssBox.effectiveBottomMargin;
                n = cssBox.getY() + cssBox.getHeight() + n2;
            } else {
                CssBox cssBox2 = this;
                while (cssBox2.inline) {
                    cssBox2 = cssBox2.parent;
                }
                n = cssBox2.topPadding + cssBox2.topBorderWidth;
            }
        }
        return n;
    }

    protected CssBox getPrevNormalBox() {
        ContainerBox containerBox = this.getParent();
        if (containerBox == null) {
            return null;
        }
        if (!containerBox.containsChild(this)) {
            return null;
        }
        for (int i = this.getParentIndex() - 1; i >= 0; --i) {
            CssBox cssBox = containerBox.getBox(i);
            if (cssBox == null || cssBox.getBoxType() == BoxType.LINEBOX && !cssBox.getParent().getBoxType().isNormalFlow() || !cssBox.getBoxType().isNormalFlow()) continue;
            return cssBox;
        }
        return null;
    }

    protected CssBox getNextNormalBox() {
        ContainerBox containerBox = this.getParent();
        if (containerBox == null) {
            return null;
        }
        if (!containerBox.containsChild(this)) {
            return null;
        }
        int n = containerBox.getBoxCount();
        for (int i = this.getParentIndex() + 1; i < n; ++i) {
            CssBox cssBox = containerBox.getBox(i);
            if (cssBox == null || !cssBox.getBoxType().isNormalFlow()) continue;
            return cssBox;
        }
        return null;
    }

    protected CssBox getPrevNormalBlockBox() {
        ContainerBox containerBox = this.getParent();
        if (containerBox == null) {
            return null;
        }
        if (!containerBox.containsChild(this)) {
            return null;
        }
        for (int i = this.getParentIndex() - 1; i >= 0; --i) {
            CssBox cssBox = containerBox.getBox(i);
            if (cssBox == null || !cssBox.getBoxType().isNormalFlow() || cssBox.getBoxType() != BoxType.LINEBOX && !cssBox.isBlockLevel()) continue;
            return cssBox;
        }
        return null;
    }

    protected CssBox getNextNormalBlockBox() {
        ContainerBox containerBox = this.getParent();
        if (containerBox == null) {
            return null;
        }
        if (!containerBox.containsChild(this)) {
            return null;
        }
        int n = containerBox.getBoxCount();
        for (int i = this.getParentIndex() + 1; i < n; ++i) {
            CssBox cssBox = containerBox.getBox(i);
            if (cssBox == null || !cssBox.getBoxType().isNormalFlow() || cssBox.getBoxType() != BoxType.LINEBOX && !cssBox.isBlockLevel()) continue;
            return cssBox;
        }
        return null;
    }

    CssBox getFirstNormalBox() {
        int n = this.getBoxCount();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.getBox(i);
            if (!cssBox.getBoxType().isNormalFlow()) continue;
            return cssBox;
        }
        return null;
    }

    private CssBox getLastNormalBox() {
        for (int i = this.getBoxCount() - 1; i >= 0; --i) {
            CssBox cssBox = this.getBox(i);
            if (!cssBox.getBoxType().isNormalFlow()) continue;
            return cssBox;
        }
        return null;
    }

    private int getStaticTop(FormatContext formatContext) {
        return this.getLineBoxY(formatContext);
    }

    protected int shrinkToFit(int n, FormatContext formatContext) {
        Object object;
        int n2;
        int n3 = this.getBoxCount();
        for (n2 = 0; n2 < n3; ++n2) {
            CssBox cssBox = this.getBox(n2);
            if (cssBox.getBoxType().isAbsolutelyPositioned()) continue;
            cssBox.uncomputeWidthCssValue();
            cssBox.initializeHorizontalWidths(formatContext);
        }
        for (n2 = 0; n2 < this.getBoxCount(); ++n2) {
            CssBox cssBox = this.getBox(n2);
            if (!(cssBox instanceof LineBoxGroup)) continue;
            for (int i = 0; i < ((LineBoxGroup)cssBox).getManagedBoxes().size(); ++i) {
                object = ((LineBoxGroup)cssBox).getManagedBoxes().get(i);
                CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(((CssBox)object).element, 58);
                if (cssValue == null || CssProvider.getValueService().isAutoValue(cssValue) || !(cssValue instanceof CssComputedValue) || !CssProvider.getValueService().isOfPrimitivePercentageType(((CssComputedValue)cssValue).getCascadedValue())) continue;
                ((CssBox)object).contentWidth = 0x7FFFFFFD;
                CssProvider.getEngineService().uncomputeValueForElement(((CssBox)object).element, 58);
            }
        }
        n2 = this.getPrefWidth();
        n3 = this.getPrefMinWidth();
        int n4 = Math.min(Math.max(n3, n), n2);
        object = CssBox.getElementForComponentRootCssBox(this);
        if (n4 <= this.leftBorderWidth + this.rightBorderWidth && object != null) {
            n4 = 24;
            if (this.border == null && (this.parent == null || CssBox.getElementForComponentRootCssBox(this.parent) != object) && this.tag != HtmlTag.FORM) {
                this.border = CssBorder.getDesignerBorder();
                this.leftBorderWidth = this.border.getLeftBorderWidth();
                this.topBorderWidth = this.border.getTopBorderWidth();
                this.bottomBorderWidth = this.border.getBottomBorderWidth();
                this.rightBorderWidth = this.border.getRightBorderWidth();
            }
        }
        return n4;
    }

    private int computeContentHeight() {
        int n = 0;
        int n2 = 0;
        int n3 = this.getBoxCount();
        for (int i = 0; i < n3; ++i) {
            int n4;
            CssBox cssBox = this.getBox(i);
            if (!cssBox.getBoxType().isNormalFlow() || (n4 = cssBox.getY() + cssBox.getHeight()) <= n2) continue;
            n2 = n4;
        }
        n = n2 == this.topPadding && this.topBorderWidth > 0 ? this.topBorderWidth : n2 - this.topPadding - this.topBorderWidth;
        Element element = CssBox.getElementForComponentRootCssBox(this);
        if (n <= this.topBorderWidth && element != null && !this.element.getTagName().equals(HtmlTag.HR.name)) {
            n = 24;
        }
        return n;
    }

    void computeVerticalLengths(FormatContext formatContext) {
        int n = this.containingBlockHeight;
        assert (this.boxType != BoxType.LINEBOX) : this;
        Element element = this.getElement();
        if (element != null && this.boxType.isPositioned()) {
            this.top = CssUtilities.getCssLength(element, 41);
            this.bottom = CssUtilities.getCssLength(element, 42);
        }
        if (this.boxType == BoxType.FLOAT && !this.replaced) {
            this.computeVerticalNonReplacedFloat();
        } else if (this.boxType.isAbsolutelyPositioned() && !this.replaced) {
            this.computeVerticalNonReplacedAbsPos(formatContext, n);
        } else if (this.boxType.isAbsolutelyPositioned() && this.replaced) {
            this.computeVerticalReplacedAbsPos(formatContext, n);
        } else if (this.inline && !this.replaced) {
            this.computeVerticalNonReplacedInline();
        } else if (this.inline && this.replaced || this.replaced && !this.inline && this.boxType.isNormalFlow() || this.replaced && this.boxType == BoxType.FLOAT) {
            this.computeVerticalSec10_6_2();
        } else if (!this.inline && !this.replaced && this.boxType.isNormalFlow()) {
            this.computeNonInlineNonReplacedNormal();
        }
        if (this.effectiveTopMargin == 0x7FFFFFFD) {
            this.effectiveTopMargin = this.topMargin;
        }
        if (this.effectiveBottomMargin == 0x7FFFFFFD) {
            this.effectiveBottomMargin = this.bottomMargin;
        }
        if (this.boxType == BoxType.RELATIVE) {
            if (this.top == 0x7FFFFFFE && this.bottom == 0x7FFFFFFE) {
                this.top = 0;
                this.bottom = 0;
            } else if (this.top == 0x7FFFFFFE) {
                this.top = -this.bottom;
            } else {
                this.bottom = this.bottom == 0x7FFFFFFE ? -this.top : -this.top;
            }
        }
    }

    private void computeVerticalNonReplacedFloat() {
        if (this.topMargin == 0x7FFFFFFE) {
            this.topMargin = 0;
        }
        if (this.bottomMargin == 0x7FFFFFFE) {
            this.bottomMargin = 0;
        }
        if (this.contentHeight == 0x7FFFFFFE) {
            CssBox cssBox;
            int n;
            int n2;
            int n3;
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MIN_VALUE;
            if (this.hasNormalBlockLevelChildren()) {
                n3 = 0;
                n2 = this.getBoxCount();
                for (n = 0; n < n2; ++n) {
                    cssBox = this.getBox(n);
                    if (cssBox.getY() < n4) {
                        n4 = cssBox.getY();
                    }
                    if (cssBox.getY() + cssBox.getHeight() <= n5) continue;
                    n5 = cssBox.getY() + cssBox.getHeight();
                }
                if (n4 != Integer.MAX_VALUE) {
                    n3 = n5 - n4;
                }
                this.contentHeight = n3;
            } else {
                n3 = 0;
                n2 = this.getBoxCount();
                for (n = 0; n < n2; ++n) {
                    cssBox = this.getBox(n);
                    if (!(cssBox instanceof LineBoxGroup)) continue;
                    LineBoxGroup lineBoxGroup = (LineBoxGroup)cssBox;
                    if (lineBoxGroup.getY() < n4) {
                        n4 = lineBoxGroup.getY();
                    }
                    if (lineBoxGroup.getY() + lineBoxGroup.getHeight() <= n5) continue;
                    n5 = lineBoxGroup.getY() + lineBoxGroup.getHeight();
                }
                if (n4 != Integer.MAX_VALUE && n5 != Integer.MAX_VALUE) {
                    n3 = n5 - n4;
                }
                this.contentHeight = n3;
            }
            for (n3 = 0; n3 < this.getBoxCount(); ++n3) {
                CssBox cssBox2 = this.getBox(n3);
                if (cssBox2 instanceof LineBoxGroup) {
                    n = ((LineBoxGroup)cssBox2).getSizeWithFloats();
                    if (n <= this.contentHeight) continue;
                    this.contentHeight = n;
                    continue;
                }
                if (cssBox2 == null || cssBox2.getBoxType() != BoxType.FLOAT || (n = cssBox2.getHeight()) == 0x7FFFFFFD || n == 0x7FFFFFFE || n <= this.contentHeight) continue;
                this.contentHeight = n;
            }
        }
    }

    private void computeVerticalNonReplacedAbsPos(FormatContext formatContext, int n) {
        if (this.boxType == BoxType.FIXED) {
            n = this.getInitialHeight(formatContext);
        }
        if (n == 0x7FFFFFFE) {
            n = this.getInitialHeight(formatContext);
        }
        if (this.top == 0x7FFFFFFE && this.bottom == 0x7FFFFFFE && this.contentHeight == 0x7FFFFFFE) {
            this.top = this.getStaticTop(formatContext);
            if (this.topMargin == 0x7FFFFFFE) {
                this.topMargin = 0;
            }
            if (this.bottomMargin == 0x7FFFFFFE) {
                this.bottomMargin = 0;
            }
            this.contentHeight = this.computeContentHeight();
            this.bottom = n - this.top - this.topMargin - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottomMargin;
        } else if (this.top != 0x7FFFFFFE && this.bottom != 0x7FFFFFFE && this.contentHeight != 0x7FFFFFFE) {
            if (this.topMargin == 0x7FFFFFFE && this.bottomMargin == 0x7FFFFFFE) {
                int n2 = n - this.top - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottom;
                int n3 = n2 / 2;
                int n4 = n2 % 2;
                this.topMargin = n3;
                this.bottomMargin = n3 + n4;
            } else if (this.topMargin != 0x7FFFFFFE && this.bottomMargin == 0x7FFFFFFE) {
                this.bottomMargin = n - this.top - this.topMargin - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottom;
            } else if (this.topMargin == 0x7FFFFFFE && this.bottomMargin != 0x7FFFFFFE) {
                this.topMargin = n - this.top - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottomMargin - this.bottom;
            } else {
                this.bottom = n - this.top - this.topMargin - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottomMargin;
            }
        } else if (this.top == 0x7FFFFFFE && this.contentHeight == 0x7FFFFFFE && this.bottom != 0x7FFFFFFE) {
            this.contentHeight = this.computeContentHeight();
            if (this.topMargin == 0x7FFFFFFE) {
                this.topMargin = 0;
            }
            if (this.bottomMargin == 0x7FFFFFFE) {
                this.bottomMargin = 0;
            }
            this.top = n - this.topMargin - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottomMargin - this.bottom;
        } else if (this.top == 0x7FFFFFFE && this.bottom == 0x7FFFFFFE && this.contentHeight != 0x7FFFFFFE) {
            this.top = this.getStaticTop(formatContext);
            if (this.topMargin == 0x7FFFFFFE) {
                this.topMargin = 0;
            }
            if (this.bottomMargin == 0x7FFFFFFE) {
                this.bottomMargin = 0;
            }
            this.bottom = n - this.top - this.topMargin - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottomMargin;
        } else if (this.contentHeight == 0x7FFFFFFE && this.bottom == 0x7FFFFFFE && this.top != 0x7FFFFFFE) {
            this.contentHeight = this.computeContentHeight();
            if (this.topMargin == 0x7FFFFFFE) {
                this.topMargin = 0;
            }
            if (this.bottomMargin == 0x7FFFFFFE) {
                this.bottomMargin = 0;
            }
            this.bottom = n - this.top - this.topMargin - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottomMargin;
        } else if (this.top == 0x7FFFFFFE && this.contentHeight != 0x7FFFFFFE && this.bottom != 0x7FFFFFFE) {
            if (this.topMargin == 0x7FFFFFFE) {
                this.topMargin = 0;
            }
            if (this.bottomMargin == 0x7FFFFFFE) {
                this.bottomMargin = 0;
            }
            this.top = n - this.topMargin - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottomMargin - this.bottom;
        } else if (this.top != 0x7FFFFFFE && this.contentHeight == 0x7FFFFFFE && this.bottom != 0x7FFFFFFE) {
            if (this.topMargin == 0x7FFFFFFE) {
                this.topMargin = 0;
            }
            if (this.bottomMargin == 0x7FFFFFFE) {
                this.bottomMargin = 0;
            }
            this.contentHeight = n - this.top - this.topMargin - this.topBorderWidth - this.topPadding - this.bottomPadding - this.bottomBorderWidth - this.bottomMargin - this.bottom;
        } else if (this.top != 0x7FFFFFFE && this.contentHeight != 0x7FFFFFFE && this.bottom == 0x7FFFFFFE) {
            if (this.topMargin == 0x7FFFFFFE) {
                this.topMargin = 0;
            }
            if (this.bottomMargin == 0x7FFFFFFE) {
                this.bottomMargin = 0;
            }
            this.bottom = n - this.top - this.topMargin - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottomMargin;
        }
        assert (this.top + this.topMargin + this.topBorderWidth + this.topPadding + this.contentHeight + this.bottomPadding + this.bottomBorderWidth + this.bottomMargin + this.bottom == n);
    }

    private void computeVerticalReplacedAbsPos(FormatContext formatContext, int n) {
        int n2;
        int n3;
        if (this.boxType == BoxType.FIXED) {
            n = this.getInitialHeight(formatContext);
        }
        if (n == 0x7FFFFFFE) {
            n = this.getInitialHeight(formatContext);
        }
        this.updateAutoContentSize();
        if (this.top == 0x7FFFFFFE && this.bottom != 0x7FFFFFFE) {
            if (this.topMargin == 0x7FFFFFFE) {
                this.topMargin = 0;
            }
            if (this.bottomMargin == 0x7FFFFFFE) {
                this.bottomMargin = 0;
            }
            this.top = n - this.bottom - this.topMargin - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottomMargin;
        } else if (this.top != 0x7FFFFFFE && this.bottom == 0x7FFFFFFE) {
            if (this.topMargin == 0x7FFFFFFE) {
                this.topMargin = 0;
            }
            if (this.bottomMargin == 0x7FFFFFFE) {
                this.bottomMargin = 0;
            }
            this.bottom = n - this.top - this.topMargin - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottomMargin;
        } else if (this.top == 0x7FFFFFFE) {
            this.top = this.getStaticTop(formatContext);
        }
        if (this.bottom == 0x7FFFFFFE) {
            if (this.topMargin == 0x7FFFFFFE) {
                this.topMargin = 0;
            }
            if (this.bottomMargin == 0x7FFFFFFE) {
                this.bottomMargin = 0;
            }
        }
        if (this.topMargin == 0x7FFFFFFE && this.bottomMargin == 0x7FFFFFFE) {
            n3 = n - this.top - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottom;
            n2 = n3 / 2;
            int n4 = n3 % 2;
            this.topMargin = n2;
            this.bottomMargin = n2 + n4;
        }
        n3 = 0;
        if (this.contentHeight == 0x7FFFFFFE) {
            ++n3;
        }
        if (this.topMargin == 0x7FFFFFFE) {
            ++n3;
        }
        if (this.bottomMargin == 0x7FFFFFFE) {
            ++n3;
        }
        if (this.bottom == 0x7FFFFFFE) {
            ++n3;
        }
        if (n3 == 1) {
            n2 = n - this.top - this.topBorderWidth - this.bottomBorderWidth - this.topPadding - this.bottomPadding;
            Equation equation = new Equation(n2, new int[]{this.topMargin, this.bottomMargin, this.contentHeight, this.bottom});
            equation.solve();
            switch (equation.index) {
                case 0: {
                    this.topMargin = equation.value;
                    break;
                }
                case 1: {
                    this.bottomMargin = equation.value;
                    break;
                }
                case 2: {
                    this.contentHeight = equation.value;
                    break;
                }
                case 3: {
                    this.bottom = equation.value;
                }
            }
        } else {
            assert (n3 == 0);
            this.bottom = n - this.top - this.topMargin - this.topBorderWidth - this.topPadding - this.contentHeight - this.bottomPadding - this.bottomBorderWidth - this.bottomMargin;
        }
        assert (this.top + this.topMargin + this.topBorderWidth + this.topPadding + this.contentHeight + this.bottomPadding + this.bottomBorderWidth + this.bottomMargin + this.bottom == n);
    }

    private void computeVerticalNonReplacedInline() {
        if (!(this instanceof TableBox)) {
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.element, 32);
            this.contentHeight = CssProvider.getValueService().isNormalValue(cssValue) ? (int)(1.1 * (double)CssProvider.getValueService().getFontSizeForElement(this.element, this.webform.getDefaultFontSize())) : (int)cssValue.getFloatValue();
        }
        this.topPadding = 0;
        this.bottomPadding = 0;
        this.topBorderWidth = 0;
        this.bottomBorderWidth = 0;
        this.topMargin = 0;
        this.bottomMargin = 0;
    }

    private void computeVerticalSec10_6_2() {
        if (this.topMargin == 0x7FFFFFFE) {
            this.topMargin = 0;
        }
        if (this.bottomMargin == 0x7FFFFFFE) {
            this.bottomMargin = 0;
        }
        this.updateAutoContentSize();
    }

    private void computeNonInlineNonReplacedNormal() {
        if (this.topMargin == 0x7FFFFFFE) {
            this.topMargin = 0;
        }
        if (this.bottomMargin == 0x7FFFFFFE) {
            this.bottomMargin = 0;
        }
        if (this.contentHeight == 0x7FFFFFFE) {
            if (this.hasNormalBlockLevelChildren()) {
                int n = 0;
                int n2 = Integer.MAX_VALUE;
                int n3 = Integer.MIN_VALUE;
                int n4 = this.getBoxCount();
                for (int i = 0; i < n4; ++i) {
                    CssBox cssBox = this.getBox(i);
                    if (!cssBox.getBoxType().isNormalFlow()) continue;
                    if (cssBox.getY() < n2) {
                        n2 = cssBox.getY();
                    }
                    if (cssBox.getY() + cssBox.getHeight() <= n3) continue;
                    n3 = cssBox.getY() + cssBox.getHeight();
                }
                if (n2 != Integer.MAX_VALUE) {
                    n = n3 - n2;
                }
                this.contentHeight = n;
            } else {
                int n = 0;
                int n5 = Integer.MAX_VALUE;
                int n6 = Integer.MIN_VALUE;
                int n7 = this.getBoxCount();
                for (int i = 0; i < n7; ++i) {
                    CssBox cssBox = this.getBox(i);
                    if (!cssBox.getBoxType().isNormalFlow() || !(cssBox instanceof LineBoxGroup)) continue;
                    LineBoxGroup lineBoxGroup = (LineBoxGroup)cssBox;
                    if (lineBoxGroup.getY() < n5) {
                        n5 = lineBoxGroup.getY();
                    }
                    if (lineBoxGroup.getY() + lineBoxGroup.getHeight() <= n6) continue;
                    n6 = lineBoxGroup.getY() + lineBoxGroup.getHeight();
                }
                n = n5 != Integer.MAX_VALUE && n6 != Integer.MAX_VALUE ? n6 - n5 : this.getIntrinsicHeight();
                this.contentHeight = n;
            }
        }
    }

    protected void clearTop(FormatContext formatContext, CssValue cssValue) {
        int n;
        int n2 = formatContext.clear(cssValue, this);
        if (n2 > Integer.MIN_VALUE && (n = n2 - this.getAbsoluteY()) > 0) {
            this.y += n;
        }
    }

    protected void clearBottom(FormatContext formatContext, CssValue cssValue) {
        int n;
        int n2 = formatContext.clear(cssValue, null);
        if (n2 > Integer.MIN_VALUE && (n = n2 - (this.getAbsoluteY() + this.getHeight())) > 0) {
            this.contentHeight += n;
            this.height += n;
        }
    }

    protected boolean hasNormalBlockLevelChildren() {
        return false;
    }

    private int getInitialWidth(FormatContext formatContext) {
        return formatContext.initialWidth;
    }

    private int getInitialHeight(FormatContext formatContext) {
        return formatContext.initialHeight;
    }

    protected void updateAutoContentSize() {
        if (this.contentWidth == 0x7FFFFFFE && this.contentHeight == 0x7FFFFFFE) {
            if (this.contentWidth == 0x7FFFFFFE) {
                this.contentWidth = this.getIntrinsicWidth();
            }
            if (this.contentHeight == 0x7FFFFFFE) {
                this.contentHeight = this.getIntrinsicHeight();
            }
        } else if (this.contentWidth == 0x7FFFFFFE && this.contentHeight != 0x7FFFFFFE) {
            this.contentWidth = this.getIntrinsicHeight() == 0 ? this.getIntrinsicWidth() : this.getIntrinsicWidth() * this.contentHeight / this.getIntrinsicHeight();
        } else if (this.contentWidth != 0x7FFFFFFE && this.contentHeight == 0x7FFFFFFE) {
            this.contentHeight = this.getIntrinsicWidth() == 0 ? this.getIntrinsicHeight() : this.getIntrinsicHeight() * this.contentWidth / this.getIntrinsicWidth();
        }
    }

    protected int getCollapsedTopMargin() {
        int n;
        int n2 = this.topMargin > 0 ? this.topMargin : 0;
        int n3 = n = this.topMargin > 0 ? 0 : -this.topMargin;
        if (this.getBoxCount() > 0) {
            for (CssBox cssBox = this.getFirstNormalBox(); cssBox != null; cssBox = cssBox.getFirstNormalBox()) {
                if (cssBox.topMargin > 0) {
                    if (cssBox.topMargin > n2) {
                        n2 = cssBox.topMargin;
                    }
                } else if (-cssBox.topMargin > n) {
                    n = -cssBox.topMargin;
                }
                if (cssBox.topBorderWidth != 0 || cssBox.topPadding != 0 || cssBox.getBoxCount() <= 0) break;
            }
        }
        return n2 - n;
    }

    protected int getCollapsedBottomMargin() {
        int n;
        int n2 = this.bottomMargin > 0 ? this.bottomMargin : 0;
        int n3 = n = this.bottomMargin > 0 ? 0 : -this.bottomMargin;
        if (this.getBoxCount() > 0) {
            for (CssBox cssBox = this.getLastNormalBox(); cssBox != null; cssBox = cssBox.getLastNormalBox()) {
                if (cssBox.bottomMargin > 0) {
                    if (cssBox.bottomMargin > n2) {
                        n2 = cssBox.bottomMargin;
                    }
                } else if (-cssBox.bottomMargin > n) {
                    n = -cssBox.bottomMargin;
                }
                if (cssBox.bottomBorderWidth != 0 || cssBox.bottomPadding != 0 || cssBox.getBoxCount() <= 0) break;
            }
        }
        return n2 - n;
    }

    @Override
    public int getBlockWidth() {
        return this.containingBlockWidth;
    }

    @Override
    public int getBlockHeight() {
        return this.containingBlockHeight;
    }

    public Rectangle getCBRectangle() {
        return new Rectangle(this.containingBlockX, this.containingBlockY, this.containingBlockWidth, this.containingBlockHeight);
    }

    public Rectangle getExtentsRectangle() {
        return new Rectangle(this.extentX, this.extentY, this.extentX2 - this.extentX, this.extentY2 - this.extentY);
    }

    public Point getPosition() {
        return new Point(this.getAbsoluteX(), this.getAbsoluteY());
    }

    public Point getRelPosition() {
        return new Point(this.getX(), this.getY());
    }

    public Rectangle getPositionRect() {
        if (this.boxType.isPositioned()) {
            return new Rectangle(this.left, this.top, this.bottom, this.right);
        }
        return null;
    }

    public String getBoxTypeName() {
        return this.boxType.getDescription();
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Dimension getContentSize() {
        return new Dimension(this.contentWidth, this.contentHeight);
    }

    public Rectangle getMarginRectangle() {
        return new Rectangle(this.leftMargin, this.topMargin, this.rightMargin, this.bottomMargin);
    }

    public Rectangle getPaddingRectangle() {
        return new Rectangle(this.leftPadding, this.topPadding, this.rightPadding, this.bottomPadding);
    }

    public Rectangle getBorderWidthRectangle() {
        return new Rectangle(this.leftBorderWidth, this.topBorderWidth, this.rightBorderWidth, this.bottomBorderWidth);
    }

    public Color getBg() {
        return this.bg;
    }

    public String getStyles() {
        if (this.element != null) {
            String string = CssProvider.getEngineService().getAllStylesForElement(this.element);
            if (string == null) {
                return "";
            }
            return string;
        }
        if (this.getBoxType() == BoxType.TEXT || this.getBoxType() == BoxType.SPACE) {
            return this.parent.getStyles();
        }
        return "";
    }

    public String getRules() {
        if (this.element != null) {
            String string = CssProvider.getEngineService().getAllRulesForElement(this.element);
            if (string == null) {
                return "";
            }
            return string;
        }
        if (this.getBoxType() == BoxType.TEXT || this.getBoxType() == BoxType.SPACE) {
            return this.parent.getRules();
        }
        return "";
    }

    public String getComputedStyles() {
        if (this.element != null) {
            String string = CssProvider.getEngineService().getAllComputedStylesForElement(this.element);
            if (string == null) {
                return "";
            }
            return string;
        }
        if (this.getBoxType() == BoxType.TEXT || this.getBoxType() == BoxType.SPACE) {
            return this.parent.getComputedStyles();
        }
        return "";
    }

    public boolean getPaintSpaces() {
        return paintSpaces;
    }

    public void setPaintSpaces(boolean bl) {
        paintSpaces = bl;
        this.webform.getPane().repaint();
    }

    public boolean getPaintText() {
        return paintText;
    }

    public void setPaintText(boolean bl) {
        paintText = bl;
        this.webform.getPane().repaint();
    }

    public boolean getPaintPositions() {
        return paintPositioning;
    }

    public void setPaintPositions(boolean bl) {
        paintPositioning = bl;
        this.webform.getPane().repaint();
    }

    protected boolean isPlaceHolder() {
        return false;
    }

    @Override
    public void list(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print("    ");
        }
        printStream.println("*" + this);
    }

    @Override
    public void list(PrintWriter printWriter, int n) {
        for (int i = 0; i < n; ++i) {
            printWriter.print("    ");
        }
        printWriter.println("*" + this);
    }

    public Decoration getDecoration() {
        return this.webform.getDecoration(this.element);
    }

    @Override
    public Element getComponentRootElement() {
        return CssBox.getElementForComponentRootCssBox(this);
    }

    @Override
    public Designer.Box[] getChildren() {
        ArrayList<CssBox> arrayList = new ArrayList<CssBox>();
        int n = this.getBoxCount();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.getBox(i);
            arrayList.add(cssBox);
        }
        return arrayList.toArray(new Designer.Box[arrayList.size()]);
    }

    @Override
    public boolean isPositioned() {
        return this.getBoxType().isPositioned();
    }

    @Override
    public boolean isAbsolutelyPositioned() {
        return this.getBoxType().isAbsolutelyPositioned();
    }

    private static void info(Exception exception) {
        CssBox.getLogger().log(Level.INFO, null, exception);
    }

    private static void fine(String string) {
        CssBox.getLogger().fine(string);
    }

    private static Logger getLogger() {
        return Logger.getLogger(CssBox.class.getName());
    }

    private static class Equation {
        private final int[] variables;
        private int index;
        private int value;
        private final int total;

        private Equation(int n, int[] nArray) {
            this.total = n;
            this.variables = nArray;
        }

        private void solve() {
            int n;
            this.index = -1;
            for (n = 0; n < this.variables.length; ++n) {
                if (this.variables[n] != 0x7FFFFFFE) continue;
                this.index = n;
                break;
            }
            assert (this.index != -1);
            n = this.total;
            for (int i = 0; i < this.variables.length; ++i) {
                if (i == this.index) continue;
                n -= this.variables[i];
            }
            this.value = n;
        }
    }
}

