/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.DatabaseUser;
import org.netbeans.modules.db.mysql.DatabaseUtils;
import org.netbeans.modules.db.mysql.ServerInstance;
import org.netbeans.modules.db.mysql.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CreateDatabasePanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(CreateDatabasePanel.class.getName());
    DialogDescriptor descriptor;
    final ServerInstance server;
    private Color nbErrorForeground;
    private JCheckBox chkGrantAccess;
    private JComboBox comboDatabaseName;
    private JComboBox comboUsers;
    private JLabel jLabel1;
    private JLabel messageLabel;

    private void validatePanel(String string) {
        if (this.descriptor == null) {
            return;
        }
        String string2 = null;
        this.comboUsers.setEnabled(this.isGrantAccess());
        if (Utils.isEmpty(string)) {
            string2 = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_SpecifyDatabase");
        }
        if (string2 != null) {
            this.messageLabel.setText(string2);
            this.descriptor.setValid(false);
        } else {
            this.messageLabel.setText(" ");
            this.descriptor.setValid(true);
        }
    }

    public static DatabaseConnection showCreateDatabaseDialog(ServerInstance serverInstance) {
        assert (SwingUtilities.isEventDispatchThread());
        CreateDatabasePanel createDatabasePanel = new CreateDatabasePanel(serverInstance);
        String string = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.LBL_CreateDatabaseTitle");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)createDatabasePanel, string);
        createDatabasePanel.setDialogDescriptor(dialogDescriptor);
        while (true) {
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            String string2 = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.ACSD_CreateDatabasePanel");
            dialog.getAccessibleContext().setAccessibleDescription(string2);
            dialog.setVisible(true);
            dialog.dispose();
            if (!DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
                return null;
            }
            if (!Utils.isEmpty(createDatabasePanel.getDatabaseName())) break;
            Utils.displayErrorMessage(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_EmptyDatabaseName"));
        }
        return CreateDatabasePanel.createDatabase(createDatabasePanel.getServer(), createDatabasePanel.getDatabaseName(), createDatabasePanel.getGrantUser());
    }

    private static DatabaseConnection createDatabase(ServerInstance serverInstance, String string, DatabaseUser databaseUser) {
        boolean bl = false;
        DatabaseConnection databaseConnection = null;
        try {
            String string2;
            if (!CreateDatabasePanel.checkDeleteExistingDatabase(serverInstance, string)) {
                return null;
            }
            serverInstance.createDatabase(string);
            bl = true;
            if (databaseUser != null) {
                serverInstance.grantFullDatabaseRights(string, databaseUser);
                string2 = databaseUser.getUser();
            } else {
                string2 = serverInstance.getUser();
            }
            databaseConnection = CreateDatabasePanel.createConnection(serverInstance, string, string2);
            if (databaseConnection != null && ServerInstance.isSampleName(string)) {
                serverInstance.createSample(string, databaseConnection);
            }
        }
        catch (DatabaseException databaseException) {
            CreateDatabasePanel.displayCreateFailure(serverInstance, databaseException, string, bl);
            return null;
        }
        return databaseConnection;
    }

    private static void displayCreateFailure(ServerInstance serverInstance, DatabaseException databaseException, String string, boolean bl) {
        Utils.displayError(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_CreateFailed"), (Exception)((Object)databaseException));
        if (bl) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_DeleteCreatedDatabase", (Object)string), NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.STR_DeleteCreatedDatabaseTitle"), 0);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (object == NotifyDescriptor.YES_OPTION) {
                try {
                    serverInstance.dropDatabase(string);
                }
                catch (DatabaseException databaseException2) {
                    Utils.displayError(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_DeleteFailed"), (Exception)((Object)databaseException));
                }
            }
        }
    }

    private static boolean checkDeleteExistingDatabase(ServerInstance serverInstance, String string) throws DatabaseException {
        if (!serverInstance.databaseExists(string)) {
            return true;
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_DatabaseAlreadyExists", (Object)string), NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.STR_DatabaseExistsTitle"), 0);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (object == NotifyDescriptor.NO_OPTION) {
            return false;
        }
        serverInstance.dropDatabase(string);
        return true;
    }

    private static DatabaseConnection createConnection(ServerInstance serverInstance, String string, String string2) {
        List<DatabaseConnection> list = DatabaseUtils.findDatabaseConnections(serverInstance.getURL(string));
        if (!list.isEmpty()) {
            return list.get(0);
        }
        String string3 = string2 == null || string2.equals("") ? serverInstance.getUser() : string2;
        String string4 = serverInstance.getURL(string);
        return ConnectionManager.getDefault().showAddConnectionDialogFromEventThread(DatabaseUtils.getJDBCDriver(), string4, string3, null);
    }

    public CreateDatabasePanel(ServerInstance serverInstance) {
        this.server = serverInstance;
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.initComponents();
        this.comboDatabaseName.setModel(new DatabaseComboModel());
        this.comboDatabaseName.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                String string = Character.toString(keyEvent.getKeyChar()).trim();
                String string2 = Utils.isEmpty(string) ? CreateDatabasePanel.this.comboDatabaseName.getEditor().getItem().toString().trim() : string;
                CreateDatabasePanel.this.validatePanel(string2);
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.comboUsers.setModel(new UsersComboModel(serverInstance));
        if (this.comboUsers.getItemCount() == 0) {
            this.comboUsers.setVisible(false);
            this.chkGrantAccess.setVisible(false);
        } else {
            this.comboUsers.setSelectedIndex(0);
            this.setGrantAccess(false);
        }
        this.setBackground(this.getBackground());
        this.messageLabel.setBackground(this.getBackground());
        this.messageLabel.setText(" ");
    }

    private String getDatabaseName() {
        String string = (String)this.comboDatabaseName.getSelectedItem();
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    private DatabaseUser getGrantUser() {
        return (DatabaseUser)this.comboUsers.getSelectedItem();
    }

    private void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
        this.validatePanel("");
    }

    private void setGrantAccess(boolean bl) {
        this.chkGrantAccess.setSelected(bl);
    }

    private boolean isGrantAccess() {
        return this.chkGrantAccess.isSelected();
    }

    private ServerInstance getServer() {
        return this.server;
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.comboDatabaseName = new JComboBox();
        this.jLabel1 = new JLabel();
        this.chkGrantAccess = new JCheckBox();
        this.comboUsers = new JComboBox();
        this.messageLabel.setForeground(new Color(255, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.messageLabel.text"));
        this.comboDatabaseName.setEditable(true);
        this.comboDatabaseName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboDatabaseName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CreateDatabasePanel.this.comboDatabaseNameItemStateChanged(itemEvent);
            }
        });
        this.comboDatabaseName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateDatabasePanel.this.comboDatabaseNameActionPerformed(actionEvent);
            }
        });
        this.comboDatabaseName.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                CreateDatabasePanel.this.comboDatabaseNameFocusLost(focusEvent);
            }
        });
        this.comboDatabaseName.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
                CreateDatabasePanel.this.comboDatabaseNameInputMethodTextChanged(inputMethodEvent);
            }

            public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
            }
        });
        this.comboDatabaseName.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                CreateDatabasePanel.this.comboDatabaseNameKeyTyped(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                CreateDatabasePanel.this.comboDatabaseNameKeyPressed(keyEvent);
            }
        });
        this.comboDatabaseName.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                CreateDatabasePanel.this.comboDatabaseNameMouseReleased(mouseEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkGrantAccess, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.chkGrantAccess.text"));
        this.chkGrantAccess.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CreateDatabasePanel.this.chkGrantAccessItemStateChanged(itemEvent);
            }
        });
        this.comboUsers.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.chkGrantAccess).add(18, 18, 18).add((Component)this.comboUsers, -2, 216, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).add(18, 18, 18).add((Component)this.comboDatabaseName, 0, -1, Short.MAX_VALUE)).add((Component)this.messageLabel, -2, 344, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(20, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.comboDatabaseName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.chkGrantAccess).add((Component)this.comboUsers, -2, -1, -2)).addPreferredGap(0).add((Component)this.messageLabel).add(22, 22, 22)));
        this.messageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.messageLabel.AccessibleContext.accessibleName"));
        this.chkGrantAccess.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.chkGrantAccess.AccessibleContext.accessibleDescription"));
    }

    private void comboDatabaseNameActionPerformed(ActionEvent actionEvent) {
    }

    private void comboDatabaseNameItemStateChanged(ItemEvent itemEvent) {
        this.validatePanel(itemEvent.getItem().toString().trim());
    }

    private void comboDatabaseNameMouseReleased(MouseEvent mouseEvent) {
    }

    private void comboDatabaseNameKeyTyped(KeyEvent keyEvent) {
    }

    private void comboDatabaseNameFocusLost(FocusEvent focusEvent) {
    }

    private void chkGrantAccessItemStateChanged(ItemEvent itemEvent) {
        if (this.isGrantAccess()) {
            this.comboUsers.setEnabled(true);
        } else {
            this.comboUsers.setEnabled(false);
        }
    }

    private void comboDatabaseNameKeyPressed(KeyEvent keyEvent) {
    }

    private void comboDatabaseNameInputMethodTextChanged(InputMethodEvent inputMethodEvent) {
    }

    private static class UsersComboModel
    implements ComboBoxModel {
        final ServerInstance server;
        ArrayList<DatabaseUser> users = new ArrayList();
        DatabaseUser selected;

        public UsersComboModel(ServerInstance serverInstance) {
            this.server = serverInstance;
            try {
                this.users.addAll(serverInstance.getUsers());
                DatabaseUser databaseUser = null;
                for (DatabaseUser databaseUser2 : this.users) {
                    if (databaseUser2.getUser() == null || !databaseUser2.getUser().equals("root")) continue;
                    databaseUser = databaseUser2;
                    break;
                }
                if (databaseUser != null) {
                    this.users.remove(databaseUser);
                }
            }
            catch (DatabaseException databaseException) {
                LOGGER.log(Level.INFO, null, databaseException);
                this.users.clear();
            }
        }

        public void setSelectedItem(Object object) {
            this.selected = (DatabaseUser)object;
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public int getSize() {
            return this.users.size();
        }

        public Object getElementAt(int n) {
            return this.users.get(n);
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    private static class DatabaseComboModel
    implements ComboBoxModel {
        static final ServerInstance.SampleName[] SAMPLES = ServerInstance.SampleName.values();
        static final String samplePrefix = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.STR_SampleDatabase") + ": ";
        String selected = null;
        final ArrayList<ListDataListener> listeners = new ArrayList();

        private DatabaseComboModel() {
        }

        public void setSelectedItem(Object object) {
            this.selected = (String)object;
        }

        public Object getSelectedItem() {
            if (this.selected != null && this.selected.startsWith(samplePrefix)) {
                return this.selected.replace(samplePrefix, "");
            }
            if (this.selected != null) {
                return this.selected;
            }
            return "";
        }

        public int getSize() {
            return SAMPLES.length;
        }

        public Object getElementAt(int n) {
            return samplePrefix + SAMPLES[n].toString();
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

