/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Utils {
    private static Logger LOGGER = Logger.getLogger(Utils.class.getName());

    public static void displayError(String string, Exception exception) {
        LOGGER.log(Level.INFO, string, exception);
        String string2 = exception.getMessage() != null ? exception.getMessage() : NbBundle.getMessage(Utils.class, (String)"MSG_SeeErrorLog");
        string = string + ": " + string2;
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    public static boolean isValidDirectory(String string, boolean bl) {
        return Utils.isValidPath(string, true, bl);
    }

    public static boolean isValidExecutable(String string, boolean bl) {
        return Utils.isValidPath(string, false, bl);
    }

    public static boolean isValidExecutable(String string) {
        return Utils.isValidExecutable(string, false);
    }

    private static boolean isValidPath(String string, boolean bl, boolean bl2) {
        if (Utils.isEmpty(string)) {
            return bl2;
        }
        File file = new File(string).getAbsoluteFile();
        if (!file.exists()) {
            return false;
        }
        return bl && file.isDirectory() || !bl && file.isFile() || Utilities.isMac() && !bl && string.endsWith(".app");
    }

    public static boolean isValidURL(String string, boolean bl) {
        if (Utils.isEmpty(string)) {
            return bl;
        }
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean displayConfirmDialog(String string) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        return object == NotifyDescriptor.OK_OPTION;
    }

    public static void displayErrorMessage(String string) {
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, NbBundle.getMessage(Utils.class, (String)"MSG_ErrorDialogTitle"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    public static boolean stringEquals(String string, String string2) {
        return string == null && string2 == null || string2 != null && string != null && string.equals(string2);
    }
}

