/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.mysql.DriverClassLoader;
import org.netbeans.modules.db.mysql.MySQLOptions;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseUtils {
    public static final String SQLSTATE_COMM_ERROR = "08S01";
    private static final String SQLSTATE_CLIENT_PREFIX = "20";
    private static final Logger LOGGER = Logger.getLogger(DatabaseUtils.class.getName());
    private static Driver driver;

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static JDBCDriver getJDBCDriver() {
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(MySQLOptions.getDriverClass());
        if (jDBCDriverArray.length == 0) {
            return null;
        }
        return jDBCDriverArray[0];
    }

    public static Driver getDriver() throws DatabaseException {
        if (driver != null) {
            return driver;
        }
        JDBCDriver jDBCDriver = DatabaseUtils.getJDBCDriver();
        if (jDBCDriver == null) {
            throw new DatabaseException(NbBundle.getMessage(DatabaseUtils.class, (String)"MSG_JDBCDriverNotRegistered"));
        }
        try {
            DriverClassLoader driverClassLoader = new DriverClassLoader(jDBCDriver);
            driver = (Driver)Class.forName(jDBCDriver.getClassName(), true, driverClassLoader).newInstance();
        }
        catch (Exception exception) {
            DatabaseException databaseException = new DatabaseException(NbBundle.getMessage(DatabaseUtils.class, (String)"MSG_UnableToLoadJDBCDriver") + exception.getMessage());
            databaseException.initCause((Throwable)exception);
            throw databaseException;
        }
        return driver;
    }

    public static Connection getConnection(DatabaseConnection databaseConnection) throws SQLException {
        Connection connection = databaseConnection.getJDBCConnection();
        if (connection == null || connection.isClosed()) {
            ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
            connection = databaseConnection.getJDBCConnection();
        }
        return connection;
    }

    public static Connection connect(String string, String string2, String string3) throws DatabaseException {
        Driver driver = DatabaseUtils.getDriver();
        Properties properties = new Properties();
        properties.put("user", string2 == null ? "" : string2);
        properties.put("password", string3 == null ? "" : string3);
        properties.put("connectTimeout", MySQLOptions.getDefault().getConnectTimeout());
        try {
            return driver.connect(string, properties);
        }
        catch (SQLException sQLException) {
            if (SQLSTATE_COMM_ERROR.equals(sQLException.getSQLState())) {
                String string4 = NbBundle.getMessage(DatabaseUtils.class, (String)"ERR_MySQLCommunicationFailure");
                DatabaseException databaseException = new DatabaseException(string4);
                databaseException.initCause((Throwable)sQLException);
                throw databaseException;
            }
            throw new DatabaseException((Throwable)sQLException);
        }
    }

    static void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.FINE, null, sQLException);
        }
    }

    public static DatabaseConnection findDatabaseConnection(String string, String string2) {
        List<DatabaseConnection> list = DatabaseUtils.findDatabaseConnections(string);
        for (DatabaseConnection databaseConnection : list) {
            if (!databaseConnection.getUser().equals(string2)) continue;
            return databaseConnection;
        }
        return null;
    }

    public static List<DatabaseConnection> findDatabaseConnections(String string) {
        DatabaseConnection[] databaseConnectionArray;
        ArrayList<DatabaseConnection> arrayList = new ArrayList<DatabaseConnection>();
        for (DatabaseConnection databaseConnection : databaseConnectionArray = ConnectionManager.getDefault().getConnections()) {
            if (!databaseConnection.getDriverClass().equals(MySQLOptions.getDriverClass()) || !databaseConnection.getDatabaseURL().equals(string)) continue;
            arrayList.add(databaseConnection);
        }
        return arrayList;
    }

    public static String getURL(String string, String string2) {
        return DatabaseUtils.getURL(string, string2, null);
    }

    public static String getURL(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer("jdbc:mysql://");
        stringBuffer.append(string == null || string.equals("") ? "localhost" : string);
        if (string2 != null && !string2.equals("")) {
            stringBuffer.append(":" + string2);
        }
        if (string3 != null && !string3.equals("")) {
            stringBuffer.append("/" + string3);
        }
        return stringBuffer.toString();
    }

    static boolean ensureConnected(DatabaseConnection databaseConnection) {
        try {
            Connection connection = databaseConnection.getJDBCConnection();
            if (connection == null || connection.isClosed()) {
                ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
            }
            return (connection = databaseConnection.getJDBCConnection()) != null && !connection.isClosed();
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
            return false;
        }
    }

    public static boolean isServerException(SQLException sQLException) {
        String string = sQLException.getSQLState();
        SQLException sQLException2 = sQLException.getNextException();
        if (SQLSTATE_COMM_ERROR.equals(string)) {
            return false;
        }
        if (string.startsWith(SQLSTATE_CLIENT_PREFIX)) {
            return false;
        }
        if (sQLException2 != null) {
            return DatabaseUtils.isServerException(sQLException2);
        }
        return true;
    }

    public static ConnectStatus testConnection(String string, String string2, String string3) {
        Connection connection;
        try {
            connection = DatabaseUtils.connect(string, string2, string3);
        }
        catch (DatabaseException databaseException) {
            if (databaseException.getCause() instanceof SQLException) {
                LOGGER.log(Level.FINE, null, databaseException);
                if (DatabaseUtils.isServerException((SQLException)databaseException.getCause())) {
                    return ConnectStatus.SERVER_RUNNING;
                }
                return ConnectStatus.NO_SERVER;
            }
            Exceptions.printStackTrace((Throwable)databaseException);
            return ConnectStatus.NO_SERVER;
        }
        if (connection == null) {
            return ConnectStatus.NO_SERVER;
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.FINE, null, sQLException);
        }
        return ConnectStatus.CONNECT_SUCCEEDED;
    }

    public static class URLParser {
        private static final String MYSQL_PROTOCOL = "jdbc:mysql://";
        private String host;
        private String port;
        private final String url;

        public URLParser(String string) {
            assert (string != null && string.startsWith(MYSQL_PROTOCOL));
            this.url = string.replaceFirst(MYSQL_PROTOCOL, "");
        }

        public String getHost() {
            if (this.host == null) {
                this.host = this.url.indexOf(":") >= 0 ? this.url.split(":")[0] : this.url.split("/")[0];
            }
            return this.host;
        }

        public String getPort() {
            if (this.port == null) {
                if (this.url.indexOf(":") >= 0) {
                    this.port = this.url.split(":")[1];
                    if (this.url.indexOf("/") >= 0) {
                        this.port = this.url.split("/")[0];
                    }
                } else {
                    this.port = "";
                }
            }
            return this.port;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectStatus {
        NO_SERVER,
        SERVER_RUNNING,
        CONNECT_SUCCEEDED;

    }
}

