/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.UEIEmulatorConfiguratorImpl;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectPanel
extends JPanel {
    private static final Dimension PREF_DIM = new Dimension(560, 350);
    public static final String PLATFORM_LOCATION = "PlatformLocation";
    public static final String PLATFORM = "Platform";
    protected String detectedFolder = null;
    private static final String NAMEHINT = "LBL_DetectPanel_NameHint";
    private static final String BR = "<br>";
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JList lDevices;
    private JProgressBar progressBar;
    private JTextArea tNote;
    private JTextField tPlatformConfiguration;
    private JTextField tPlatformDisplayName;
    private JTextField tPlatformOptional;
    private JTextField tPlatformPath;
    private JTextField tPlatformProfile;
    private JTextField tPlatformType;

    public DetectPanel() {
        this.initComponents();
        this.initAccessibility();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.tPlatformPath = new JTextField();
        this.tNote = new JTextArea();
        this.jSeparator1 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.tPlatformDisplayName = new JTextField();
        this.jLabel4 = new JLabel();
        this.tPlatformType = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lDevices = new JList();
        this.jLabel6 = new JLabel();
        this.tPlatformConfiguration = new JTextField();
        this.jLabel5 = new JLabel();
        this.tPlatformProfile = new JTextField();
        this.jLabel7 = new JLabel();
        this.tPlatformOptional = new JTextField();
        this.progressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        this.setName(NbBundle.getMessage(DetectPanel.class, (String)"TITLE_J2MEWizardIterator_DetectPanel"));
        this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage(DetectPanel.class, (String)"MNM_DetectPanel_Location").charAt(0));
        this.jLabel2.setLabelFor(this.tPlatformPath);
        this.jLabel2.setText(NbBundle.getMessage(DetectPanel.class, (String)"LAB_DetectPanel_Location"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.tPlatformPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tPlatformPath, gridBagConstraints);
        this.tNote.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.tNote.setEditable(false);
        this.tNote.setLineWrap(true);
        this.tNote.setRows(5);
        this.tNote.setText(NbBundle.getMessage(DetectPanel.class, (String)"TXT_DetectPanel_Explain"));
        this.tNote.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tNote, gridBagConstraints);
        this.tNote.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACD_DetectPanel_Panel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel3.setDisplayedMnemonic(NbBundle.getMessage(DetectPanel.class, (String)"MNM_DetectPanel_Name").charAt(0));
        this.jLabel3.setLabelFor(this.tPlatformDisplayName);
        this.jLabel3.setText(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.tPlatformDisplayName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tPlatformDisplayName, gridBagConstraints);
        this.tPlatformDisplayName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACD_DetectPanel_Name"));
        this.jLabel4.setDisplayedMnemonic(NbBundle.getMessage(DetectPanel.class, (String)"MNM_DetectPanel_Type").charAt(0));
        this.jLabel4.setLabelFor(this.tPlatformType);
        this.jLabel4.setText(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.tPlatformType.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tPlatformType, gridBagConstraints);
        this.tPlatformType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACD_DetectPanel_Type"));
        this.jLabel1.setText(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Devices"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(22, 0));
        this.jScrollPane1.setPreferredSize(new Dimension(259, 100));
        this.jScrollPane1.setAutoscrolls(true);
        this.lDevices.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.lDevices.setSelectionMode(0);
        this.lDevices.setEnabled(false);
        this.jScrollPane1.setViewportView(this.lDevices);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel6.setDisplayedMnemonic(NbBundle.getMessage(DetectPanel.class, (String)"MNM_DetectPanel_Configuration").charAt(0));
        this.jLabel6.setLabelFor(this.tPlatformConfiguration);
        this.jLabel6.setText(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Configuration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.tPlatformConfiguration.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tPlatformConfiguration, gridBagConstraints);
        this.tPlatformConfiguration.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACD_DetectPanel_Configuration"));
        this.jLabel5.setDisplayedMnemonic(NbBundle.getMessage(DetectPanel.class, (String)"MNM_DetectPanel_Profile").charAt(0));
        this.jLabel5.setLabelFor(this.tPlatformProfile);
        this.jLabel5.setText(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Profile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.tPlatformProfile.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tPlatformProfile, gridBagConstraints);
        this.tPlatformProfile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACD_DetectPanel_Profile"));
        this.jLabel7.setDisplayedMnemonic(NbBundle.getMessage(DetectPanel.class, (String)"MNM_DetectPanel_Optional").charAt(0));
        this.jLabel7.setLabelFor(this.tPlatformOptional);
        this.jLabel7.setText(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Optional"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.tPlatformOptional.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tPlatformOptional, gridBagConstraints);
        this.tPlatformOptional.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACD_DetectPanel_Optional"));
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.progressBar, gridBagConstraints);
    }

    private void initAccessibility() {
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public void addListener(DocumentListener documentListener) {
        this.tPlatformDisplayName.getDocument().addDocumentListener(documentListener);
    }

    public void removeListener(DocumentListener documentListener) {
        this.tPlatformDisplayName.getDocument().removeDocumentListener(documentListener);
    }

    public String getPlatformName() {
        return this.tPlatformDisplayName.getText();
    }

    public void storeData(WizardDescriptor wizardDescriptor) {
        J2MEPlatform j2MEPlatform = (J2MEPlatform)((Object)wizardDescriptor.getProperty(PLATFORM));
        if (j2MEPlatform == null) {
            return;
        }
        String string = this.getPlatformName();
        j2MEPlatform.setDisplayName(string);
        j2MEPlatform.setName(J2MEPlatform.computeUniqueName(string));
    }

    public void readData(WizardDescriptor wizardDescriptor) {
        String string = (String)wizardDescriptor.getProperty(PLATFORM_LOCATION);
        if (string == null) {
            return;
        }
        J2MEPlatform[] j2MEPlatformArray = new J2MEPlatform[]{(J2MEPlatform)((Object)wizardDescriptor.getProperty(PLATFORM))};
        this.detectPlatform(j2MEPlatformArray, string, wizardDescriptor, null);
    }

    void detectPlatform(final J2MEPlatform[] j2MEPlatformArray, final String string, final WizardDescriptor wizardDescriptor, final DialogDescriptor dialogDescriptor) {
        if (dialogDescriptor != null) {
            dialogDescriptor.setValid(false);
        }
        this.tPlatformPath.setText(string);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setString(NbBundle.getMessage(DetectPanel.class, (String)"TXT_DetectPanel_WaitMessage"));
        this.tPlatformDisplayName.setEditable(false);
        final J2MEPlatform j2MEPlatform = j2MEPlatformArray[0];
        this.clearData(wizardDescriptor == null && j2MEPlatform != null ? j2MEPlatform.getDisplayName() : "");
        RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (j2MEPlatformArray[0] != null && DetectPanel.this.detectedFolder != null && string.equals(DetectPanel.this.detectedFolder)) {
                    return;
                }
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                try {
                    j2MEPlatformArray[0] = new UEIEmulatorConfiguratorImpl(string).getPlatform(printWriter);
                }
                finally {
                    printWriter.flush();
                    ErrorManager.getDefault().log(1, stringWriter.getBuffer().toString());
                }
                if (wizardDescriptor != null) {
                    wizardDescriptor.putProperty(DetectPanel.PLATFORM, (Object)j2MEPlatformArray[0]);
                } else if (j2MEPlatform != null && j2MEPlatformArray[0] != null) {
                    j2MEPlatformArray[0].setName(j2MEPlatform.getName());
                    j2MEPlatformArray[0].setDisplayName(j2MEPlatform.getDisplayName());
                }
                DetectPanel.this.detectedFolder = string;
            }
        });
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DetectPanel.this.progressBar.setIndeterminate(false);
                        DetectPanel.this.progressBar.setString(NbBundle.getMessage(DetectPanel.class, (String)(j2MEPlatformArray[0] != null ? "TXT_DetectPanel_ConfigSuccess" : "TXT_DetectPanel_ConfigFailed")));
                        DetectPanel.this.updateData(j2MEPlatformArray[0], wizardDescriptor != null);
                        DetectPanel.this.tPlatformDisplayName.requestFocus();
                        if (dialogDescriptor != null && j2MEPlatformArray[0] != null) {
                            dialogDescriptor.setValid(true);
                        }
                    }
                });
            }
        });
    }

    void clearData(String string) {
        this.tPlatformDisplayName.setText(string);
        this.tPlatformDisplayName.setToolTipText(NbBundle.getMessage(DetectPanel.class, (String)NAMEHINT));
        this.tPlatformType.setText("");
        this.tPlatformType.setToolTipText(NbBundle.getMessage(DetectPanel.class, (String)NAMEHINT));
        this.tPlatformProfile.setText("");
        this.tPlatformProfile.setToolTipText(NbBundle.getMessage(DetectPanel.class, (String)NAMEHINT));
        this.tPlatformConfiguration.setText("");
        this.tPlatformConfiguration.setToolTipText(NbBundle.getMessage(DetectPanel.class, (String)NAMEHINT));
        this.tPlatformOptional.setText("");
        this.tPlatformOptional.setToolTipText(NbBundle.getMessage(DetectPanel.class, (String)NAMEHINT));
        this.lDevices.setModel(new DefaultListModel());
        this.lDevices.setToolTipText(NbBundle.getMessage(DetectPanel.class, (String)NAMEHINT));
    }

    void updateData(J2MEPlatform j2MEPlatform, boolean bl) {
        if (j2MEPlatform == null) {
            this.clearData("");
            return;
        }
        String string = j2MEPlatform.getDisplayName();
        this.tPlatformDisplayName.setText(string == null ? j2MEPlatform.getName() : string);
        this.tPlatformDisplayName.setToolTipText(NbBundle.getMessage(DetectPanel.class, (String)"HINT_DetectPanel_DisplayName"));
        this.tPlatformDisplayName.setEditable(bl);
        this.tPlatformType.setText(j2MEPlatform.getType());
        this.tPlatformType.setToolTipText(NbBundle.getMessage(DetectPanel.class, (String)"HINT_DetectPanel_PlatformType"));
        J2MEPlatform.Device[] deviceArray = j2MEPlatform.getDevices();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        if (deviceArray != null) {
            for (int i = 0; i < deviceArray.length; ++i) {
                J2MEPlatform.J2MEProfile[] j2MEProfileArray = deviceArray[i].getProfiles();
                if (j2MEProfileArray == null) continue;
                for (int j = 0; j < j2MEProfileArray.length; ++j) {
                    String string2 = j2MEProfileArray[j].toString();
                    String string3 = j2MEProfileArray[j].isNameIsJarFileName() ? j2MEProfileArray[j].getDisplayName() : j2MEProfileArray[j].getDisplayNameWithVersion();
                    String string4 = j2MEProfileArray[j].getType();
                    if ("profile".equals(string4)) {
                        if (!arrayList.contains(string2)) {
                            arrayList.add(string2);
                        }
                        if (arrayList2.contains(string3)) continue;
                        arrayList2.add(string3);
                        continue;
                    }
                    if ("configuration".equals(string4)) {
                        if (!arrayList3.contains(string2)) {
                            arrayList3.add(string2);
                        }
                        if (arrayList4.contains(string3)) continue;
                        arrayList4.add(string3);
                        continue;
                    }
                    if (!"optional".equals(string4)) continue;
                    if (!arrayList5.contains(string2)) {
                        arrayList5.add(string2);
                    }
                    if (arrayList6.contains(string3)) continue;
                    arrayList6.add(string3);
                }
            }
        }
        this.tPlatformProfile.setText(DetectPanel.list2String(arrayList));
        if (arrayList2.size() > 0) {
            this.tPlatformProfile.setToolTipText("<html>" + NbBundle.getMessage(DetectPanel.class, (String)"MSG_ProfilesHintTitle") + BR + DetectPanel.list2String(arrayList2, BR));
        }
        this.tPlatformConfiguration.setText(DetectPanel.list2String(arrayList3));
        if (arrayList4.size() > 0) {
            this.tPlatformConfiguration.setToolTipText("<html>" + NbBundle.getMessage(DetectPanel.class, (String)"MSG_ConfigurationsHintTitle") + BR + DetectPanel.list2String(arrayList4, BR));
        }
        this.tPlatformOptional.setText(DetectPanel.list2String(arrayList5));
        if (arrayList6.size() > 0) {
            this.tPlatformOptional.setToolTipText("<html>" + NbBundle.getMessage(DetectPanel.class, (String)"MSG_OptionalsHintTitle") + BR + DetectPanel.list2String(arrayList6, BR));
        }
        if (deviceArray != null && deviceArray.length > 0) {
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            for (int i = 0; i < deviceArray.length; ++i) {
                defaultListModel.addElement(deviceArray[i].getName());
            }
            this.lDevices.setModel(defaultListModel);
            this.lDevices.setEnabled(true);
        } else {
            this.lDevices.setEnabled(false);
        }
        this.lDevices.setToolTipText("");
    }

    private static String list2String(ArrayList<String> arrayList) {
        return DetectPanel.list2String(arrayList, ", ");
    }

    private static String list2String(ArrayList<String> arrayList, String string) {
        if (arrayList == null || arrayList.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(arrayList.get(0));
        for (int i = 1; i < arrayList.size(); ++i) {
            stringBuffer.append(string);
            stringBuffer.append(arrayList.get(i));
        }
        return stringBuffer.toString();
    }

    public static class WizardPanel
    implements WizardDescriptor.FinishablePanel,
    DocumentListener {
        DetectPanel component;
        WizardDescriptor wizard;
        ArrayList<ChangeListener> listeners = new ArrayList();
        boolean valid = false;
        boolean finishable;

        public WizardPanel(boolean bl) {
            this.finishable = bl;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new DetectPanel();
                this.component.addListener(this);
                this.checkValid();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(DetectPanel.class);
        }

        public boolean isFinishPanel() {
            return this.finishable;
        }

        public void showError(String string) {
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
            }
        }

        public boolean isValid() {
            boolean bl;
            J2MEPlatform j2MEPlatform = null;
            if (this.wizard != null) {
                j2MEPlatform = (J2MEPlatform)((Object)this.wizard.getProperty(DetectPanel.PLATFORM));
            }
            if (j2MEPlatform == null) {
                this.showError(NbBundle.getMessage(DetectPanel.class, (String)"ERR_DetectPanel_PlatformWasNotDetected"));
                return false;
            }
            String string = J2MEPlatform.computeUniqueName(this.component.getPlatformName());
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services/Platforms/org-netbeans-api-java-Platform");
            if (fileObject.getFileObject(string, "xml") != null) {
                this.showError(NbBundle.getMessage(DetectPanel.class, (String)"ERR_DetectPanel_PlatformAlreadyExists"));
                return false;
            }
            String string2 = this.component.getPlatformName();
            boolean bl2 = string2 != null ? string2.length() > 0 : (bl = false);
            if (!bl) {
                this.showError(NbBundle.getMessage(DetectPanel.class, (String)"ERR_DetectPanel_EmptyDisplayName"));
            } else {
                this.showError(null);
            }
            return bl;
        }

        public void readSettings(Object object) {
            this.wizard = (WizardDescriptor)object;
            ((DetectPanel)this.getComponent()).readData(this.wizard);
        }

        public void storeSettings(Object object) {
            this.wizard = (WizardDescriptor)object;
            ((DetectPanel)this.getComponent()).storeData(this.wizard);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] changeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged((ChangeEvent)object);
            }
        }

        void checkValid() {
            if (this.isValid() != this.valid) {
                this.valid ^= this.valid;
                this.fireStateChange();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.checkValid();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.checkValid();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.checkValid();
        }
    }
}

