/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.ide.JBLogWriter;
import org.netbeans.modules.j2ee.jboss4.ide.JBStartServer;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

class JBStartRunnable
implements Runnable {
    private static final String STARTUP_SH = "/bin/run.sh";
    private static final String STARTUP_BAT = "/bin/run.bat";
    private JBDeploymentManager dm;
    private String instanceName;
    private JBStartServer startServer;
    private ProfilerServerSettings profilerSettings;

    JBStartRunnable(ProfilerServerSettings profilerServerSettings, JBDeploymentManager jBDeploymentManager, JBStartServer jBStartServer) {
        this.dm = jBDeploymentManager;
        this.instanceName = jBDeploymentManager.getInstanceProperties().getProperty("displayName");
        this.startServer = jBStartServer;
        this.profilerSettings = profilerServerSettings;
    }

    public void run() {
        InstanceProperties instanceProperties = this.dm.getInstanceProperties();
        boolean bl = this.checkPorts(instanceProperties);
        if (!bl) {
            return;
        }
        Process process = this.createProcess(instanceProperties);
        if (process == null) {
            return;
        }
        JBLogWriter jBLogWriter = this.createLogWriter();
        this.waitForServerToStart(jBLogWriter, process);
    }

    /*
     * WARNING - void declaration
     */
    private String[] createEnvironment(InstanceProperties instanceProperties) {
        String[] stringArray;
        JBProperties jBProperties = this.dm.getProperties();
        String string = jBProperties.getJavaOpts();
        StringBuilder stringBuilder = new StringBuilder(string);
        if (jBProperties.getProxyEnabled()) {
            for (String string2 : stringArray = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"}) {
                String string3;
                if (string.indexOf(string2) != -1 || (string3 = System.getProperty(string2)) == null) continue;
                if ("http.nonProxyHosts".equals(string2)) {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
                        String string4 = null;
                        StringBuilder stringBuilder2 = new StringBuilder();
                        while ((string4 = bufferedReader.readLine()) != null) {
                            stringBuilder2.append(string4);
                        }
                        string3 = stringBuilder2.toString();
                        string3 = "\"" + string3 + "\"";
                    }
                    catch (IOException iOException) {
                        Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(JBStartRunnable.class, (String)"ERR_NonProxyHostParsingError"));
                        Logger.getLogger("global").log(Level.WARNING, null, iOException);
                        string3 = null;
                    }
                }
                if (string3 == null) continue;
                stringBuilder.append(" -D").append(string2).append("=").append(string3);
            }
        }
        if (this.startServer.getMode() == JBStartServer.MODE.DEBUG && stringBuilder.toString().indexOf("-Xdebug") == -1) {
            stringBuilder.append(" -classic -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,address=").append(this.dm.getDebuggingPort()).append(",server=y,suspend=n");
        } else if (this.startServer.getMode() == JBStartServer.MODE.PROFILE) {
            void var6_8;
            stringArray = this.profilerSettings.getJvmArgs();
            boolean i = false;
            while (var6_8 < stringArray.length) {
                stringBuilder.append(" ").append(stringArray[var6_8]);
                ++var6_8;
            }
        }
        string = stringBuilder.toString();
        stringArray = this.startServer.getMode() != JBStartServer.MODE.PROFILE ? jBProperties.getJavaPlatform() : this.profilerSettings.getJavaPlatform();
        String string5 = JBStartRunnable.getJavaHome((JavaPlatform)stringArray);
        String[] stringArray2 = new String[]{"JAVA=" + string5 + "/bin/java", "JAVA_HOME=" + string5, "JAVA_OPTS=" + string};
        return stringArray2;
    }

    private boolean checkPorts(InstanceProperties instanceProperties) {
        try {
            String string;
            int n;
            String string2 = instanceProperties.getProperty("displayName");
            String string3 = instanceProperties.getProperty("port");
            int n2 = new Integer(string3);
            if (!JBPluginUtils.isPortFree(n2)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_HTTP_PORT_IN_USE", string3));
                return false;
            }
            String string4 = instanceProperties.getProperty("server-dir");
            String string5 = JBPluginUtils.getJnpPort(string4);
            int n3 = new Integer(string5);
            if (!JBPluginUtils.isPortFree(n3)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_JNP_PORT_IN_USE", string5));
                return false;
            }
            String string6 = JBPluginUtils.getRMINamingServicePort(string4);
            int n4 = new Integer(string6);
            if (!JBPluginUtils.isPortFree(n4)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_RMI_PORT_IN_USE", string6));
                return false;
            }
            String string7 = instanceProperties.getProperty("server");
            if (!"minimal".equals(string7) && !JBPluginUtils.isPortFree(n = new Integer(string = JBPluginUtils.getRMIInvokerPort(string4)).intValue())) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_INVOKER_PORT_IN_USE", string));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return true;
    }

    private NbProcessDescriptor createProcessDescriptor(InstanceProperties instanceProperties) {
        String string = instanceProperties.getProperty("root-dir");
        String string2 = string + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH);
        if (!new File(string2).exists()) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_FNF"));
            return null;
        }
        String string3 = instanceProperties.getProperty("server");
        String string4 = ("all".equals(string3) ? "-b 127.0.0.1 " : "") + "-c " + string3;
        return new NbProcessDescriptor(string2, string4);
    }

    private static String getJavaHome(JavaPlatform javaPlatform) {
        FileObject fileObject = (FileObject)javaPlatform.getInstallFolders().iterator().next();
        return FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
    }

    private String createProgressMessage(String string) {
        return this.createProgressMessage(string, null);
    }

    private String createProgressMessage(String string, String string2) {
        return NbBundle.getMessage(JBStartRunnable.class, (String)string, (Object)this.instanceName, (Object)string2);
    }

    private Process createProcess(InstanceProperties instanceProperties) {
        JBLogWriter jBLogWriter;
        if (this.startServer.getMode() == JBStartServer.MODE.PROFILE && (jBLogWriter = JBLogWriter.getInstance(this.instanceName)) != null && jBLogWriter.isRunning()) {
            jBLogWriter.stop();
        }
        if ((jBLogWriter = this.createProcessDescriptor(instanceProperties)) == null) {
            return null;
        }
        String[] stringArray = this.createEnvironment(instanceProperties);
        try {
            return jBLogWriter.exec(null, stringArray, true, null);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
            String string = instanceProperties.getProperty("root-dir");
            String string2 = string + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH);
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_PD", string2));
            return null;
        }
    }

    private InputOutput openConsole() {
        InputOutput inputOutput = UISupport.getServerIO((String)this.dm.getUrl());
        if (inputOutput == null) {
            return null;
        }
        try {
            inputOutput.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        inputOutput.select();
        return inputOutput;
    }

    private void fireStartProgressEvent(StateType stateType, String string) {
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.START, stateType, string));
    }

    private JBLogWriter createLogWriter() {
        InputOutput inputOutput = this.openConsole();
        return JBLogWriter.createInstance(inputOutput, this.instanceName);
    }

    private void waitForServerToStart(JBLogWriter jBLogWriter, Process process) {
        this.fireStartProgressEvent(StateType.RUNNING, this.createProgressMessage("MSG_START_SERVER_IN_PROGRESS"));
        JBStartServer.ACTION_STATUS aCTION_STATUS = jBLogWriter.start(process, this.startServer);
        this.dm.setNeedsRestart(false);
        if (aCTION_STATUS == JBStartServer.ACTION_STATUS.SUCCESS) {
            this.fireStartProgressEvent(StateType.COMPLETED, this.createProgressMessage("MSG_SERVER_STARTED"));
        } else if (aCTION_STATUS == JBStartServer.ACTION_STATUS.FAILURE) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED"));
        } else if (aCTION_STATUS == JBStartServer.ACTION_STATUS.UNKNOWN) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_StartServerTimeout"));
        }
    }
}

