/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.common.api.J2eeLibraryTypeProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JBJ2eePlatformFactory
extends J2eePlatformFactory {
    private static final WeakHashMap<InstanceProperties, J2eePlatformImplImpl> instanceCache = new WeakHashMap();

    public synchronized J2eePlatformImpl getJ2eePlatformImpl(DeploymentManager deploymentManager) {
        assert (JBDeploymentManager.class.isAssignableFrom(deploymentManager.getClass())) : (Object)((Object)this) + " cannot create platform for unknown deployment manager:" + deploymentManager;
        JBDeploymentManager jBDeploymentManager = (JBDeploymentManager)deploymentManager;
        InstanceProperties instanceProperties = jBDeploymentManager.getInstanceProperties();
        if (instanceProperties == null) {
            throw new RuntimeException("Cannot create J2eePlatformImpl instance for " + jBDeploymentManager.getUrl());
        }
        J2eePlatformImplImpl j2eePlatformImplImpl = instanceCache.get(instanceProperties);
        if (j2eePlatformImplImpl == null) {
            j2eePlatformImplImpl = new J2eePlatformImplImpl(jBDeploymentManager.getProperties());
            instanceCache.put(instanceProperties, j2eePlatformImplImpl);
        }
        return j2eePlatformImplImpl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class J2eePlatformImplImpl
    extends J2eePlatformImpl {
        private static final String J2EE_API_DOC = "docs/javaee5-doc-api.zip";
        private static final Set MODULE_TYPES = new HashSet();
        private static final Set SPEC_VERSIONS;
        private static final Set SPEC_VERSIONS_5;
        private LibraryImplementation[] libraries;
        private final JBProperties properties;

        public J2eePlatformImplImpl(JBProperties jBProperties) {
            this.properties = jBProperties;
        }

        public Set getSupportedSpecVersions() {
            if (this.properties.supportsJavaEE5ejb3() && this.properties.supportsJavaEE5web()) {
                return SPEC_VERSIONS_5;
            }
            return SPEC_VERSIONS;
        }

        public Set<String> getSupportedSpecVersions(Object object) {
            if (this.properties.supportsJavaEE5ejb3() && this.properties.supportsJavaEE5web() && !J2eeModule.CLIENT.equals(object)) {
                return SPEC_VERSIONS_5;
            }
            if (this.properties.supportsJavaEE5ejb3() && !J2eeModule.EAR.equals(object) && !J2eeModule.WAR.equals(object) && !J2eeModule.CLIENT.equals(object)) {
                return SPEC_VERSIONS_5;
            }
            return SPEC_VERSIONS;
        }

        public Set getSupportedModuleTypes() {
            return MODULE_TYPES;
        }

        public Set getSupportedJavaPlatformVersions() {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("1.4");
            hashSet.add("1.5");
            return hashSet;
        }

        public JavaPlatform getJavaPlatform() {
            return this.properties.getJavaPlatform();
        }

        public File[] getPlatformRoots() {
            return new File[]{this.properties.getRootDir()};
        }

        public LibraryImplementation[] getLibraries() {
            if (this.libraries == null) {
                this.initLibraries();
            }
            return (LibraryImplementation[])this.libraries.clone();
        }

        public void notifyLibrariesChanged() {
            this.initLibraries();
            this.firePropertyChange("libraries", null, this.libraries.clone());
        }

        public Image getIcon() {
            return null;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(JBJ2eePlatformFactory.class, (String)"TITLE_JBOSS_FACTORY");
        }

        public boolean isToolSupported(String string) {
            if ("jsr109".equals(string) && this.containsJaxWsLibraries()) {
                return true;
            }
            if ("wsimport".equals(string) && this.containsJaxWsLibraries()) {
                return true;
            }
            if ("wsgen".equals(string) && this.containsJaxWsLibraries()) {
                return true;
            }
            if ("JaxWs-in-j2ee14-supported".equals(string) && this.containsJaxWsLibraries()) {
                return true;
            }
            if (!this.containsJaxWsLibraries() && ("wscompile".equals(string) || "appClientRuntime".equals(string))) {
                return true;
            }
            if ("org.hibernate.ejb.HibernatePersistence".equals(string) || "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider".equals(string) || "kodo.persistence.PersistenceProviderImpl".equals(string)) {
                return this.containsPersistenceProvider(string);
            }
            if ("hibernatePersistenceProviderIsDefault".equals(string)) {
                return true;
            }
            return "defaultPersistenceProviderJavaEE5".equals(string);
        }

        private boolean containsJaxWsLibraries() {
            File file = new File(this.properties.getRootDir(), "client");
            File file2 = new File(file, "jboss-jaxws.jar");
            return file2.exists();
        }

        private boolean containsPersistenceProvider(String string) {
            return J2eePlatformImplImpl.containsService(this.libraries, "javax.persistence.spi.PersistenceProvider", string);
        }

        private static boolean containsService(LibraryImplementation[] libraryImplementationArray, String string, String string2) {
            for (LibraryImplementation libraryImplementation : libraryImplementationArray) {
                if (!J2eePlatformImplImpl.containsService(libraryImplementation, string, string2)) continue;
                return true;
            }
            return false;
        }

        private static boolean containsService(LibraryImplementation libraryImplementation, String string, String string2) {
            List list = libraryImplementation.getContent("classpath");
            for (URL uRL : list) {
                String string3;
                FileObject fileObject;
                FileObject fileObject2;
                FileObject fileObject3 = URLMapper.findFileObject((URL)uRL);
                if (fileObject3 == null || !"jar".equals(uRL.getProtocol()) || (fileObject2 = (fileObject = FileUtil.getArchiveRoot((FileObject)FileUtil.getArchiveFile((FileObject)fileObject3))).getFileObject(string3 = "META-INF/services/" + string)) == null || !J2eePlatformImplImpl.containsService(fileObject2, string, string2)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static boolean containsService(FileObject fileObject, String string, String string2) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
                try {
                    String string3;
                    do {
                        if ((string3 = bufferedReader.readLine()) == null) return false;
                        int n = string3.indexOf(35);
                        if (n < 0) continue;
                        string3 = string3.substring(0, n);
                    } while (!string3.trim().equals(string2));
                    boolean bl = true;
                    return bl;
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                try {
                    Exceptions.attachLocalizedMessage((Throwable)exception, (String)fileObject.getURL().toString());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                Logger.getLogger("global").log(Level.INFO, null, exception);
            }
            return false;
        }

        public File[] getToolClasspathEntries(String string) {
            if ("wsimport".equals(string)) {
                return this.getJaxWsLibraries();
            }
            if ("wsgen".equals(string)) {
                return this.getJaxWsLibraries();
            }
            if ("wscompile".equals(string)) {
                File file = InstalledFileLocator.getDefault().locate("modules/ext/jaxrpc16", null, false);
                return new File[]{new File(file, "saaj-api.jar"), new File(file, "saaj-impl.jar"), new File(file, "jaxrpc-api.jar"), new File(file, "jaxrpc-impl.jar")};
            }
            if ("appClientRuntime".equals(string)) {
                return new File(this.properties.getRootDir(), "client").listFiles(new FF());
            }
            return null;
        }

        private File[] getJaxWsLibraries() {
            File file = new File(this.properties.getRootDir(), "client");
            File file2 = new File(file, "jboss-jaxws.jar");
            if (file2.exists()) {
                return new File[]{new File(file, "activation.jar"), new File(file, "getopt.jar"), new File(file, "wstx.jar"), new File(file, "jbossall-client.jar"), new File(file, "log4j.jar"), new File(file, "mail.jar"), new File(file, "jbossws-spi.jar"), new File(file, "jaxws-tools.jar"), new File(file, "jaxws-rt.jar"), new File(file, "stax-api.jar"), new File(file, "jaxb-api.jar"), new File(file, "jaxb-impl.jar"), new File(file, "jaxb-xjc.jar"), new File(file, "streambuffer.jar"), new File(file, "stax-ex.jar"), new File(file, "javassist.jar"), new File(file, "jboss-xml-binding.jar"), new File(file, "jbossws-client.jar"), new File(file, "jboss-jaxws.jar"), new File(file, "jboss-jaxrpc.jar"), new File(file, "jboss-saaj.jar")};
            }
            return null;
        }

        private URL fileToUrl(File file) throws MalformedURLException {
            URL uRL = file.toURI().toURL();
            if (FileUtil.isArchiveFile((URL)uRL)) {
                uRL = FileUtil.getArchiveRoot((URL)uRL);
            }
            return uRL;
        }

        public String getToolProperty(String string, String string2) {
            if ("appClientRuntime".equals(string)) {
                if ("main.class".equals(string2)) {
                    return "";
                }
                if ("main.class.args".equals(string2)) {
                    return "";
                }
                if ("j2ee.clientName".equals(string2)) {
                    return "${jar.name}";
                }
                if ("jvm.opts".equals(string2)) {
                    return "-Djava.naming.factory.initial=org.jnp.interfaces.NamingContextFactory -Djava.naming.provider.url=jnp://localhost:1099 -Djava.naming.factory.url.pkgs=org.jboss.naming.client";
                }
            }
            return null;
        }

        private void initLibraries() {
            LibraryImplementation libraryImplementation = new J2eeLibraryTypeProvider().createLibrary();
            libraryImplementation.setName(NbBundle.getMessage(JBJ2eePlatformFactory.class, (String)"TITLE_JBOSS_LIBRARY"));
            libraryImplementation.setContent("classpath", this.properties.getClasses());
            libraryImplementation.setContent("javadoc", this.properties.getJavadocs());
            libraryImplementation.setContent("src", this.properties.getSources());
            this.libraries = new LibraryImplementation[]{libraryImplementation};
        }

        static {
            MODULE_TYPES.add(J2eeModule.EAR);
            MODULE_TYPES.add(J2eeModule.WAR);
            MODULE_TYPES.add(J2eeModule.EJB);
            MODULE_TYPES.add(J2eeModule.CONN);
            MODULE_TYPES.add(J2eeModule.CLIENT);
            SPEC_VERSIONS = new HashSet();
            SPEC_VERSIONS_5 = new HashSet();
            SPEC_VERSIONS.add("1.4");
            SPEC_VERSIONS_5.add("1.4");
            SPEC_VERSIONS_5.add("1.5");
        }

        private static class FF
        implements FilenameFilter {
            private FF() {
            }

            public boolean accept(File file, String string) {
                return string.endsWith(".jar") || new File(file, string).isDirectory();
            }
        }
    }
}

