/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.designer.jsf.JsfDesignerPreferences;
import org.netbeans.modules.visualweb.designer.jsf.JsfForm;
import org.netbeans.modules.visualweb.designer.jsf.JsfSupportUtilities;
import org.netbeans.modules.visualweb.designer.jsf.ui.AbstractJsfTopComponent;
import org.netbeans.modules.visualweb.designer.jsf.ui.JsfDesignerListener;
import org.netbeans.modules.visualweb.extension.openide.loaders.SystemFileSystemSupport;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.netbeans.spi.navigator.NavigatorLookupPanelsPolicy;
import org.netbeans.spi.palette.PaletteController;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerUtils;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JsfTopComponent
extends AbstractJsfTopComponent {
    private static final boolean SHOW_RENDER_ERRORS = System.getProperty("rave.hideRenderErrors") == null;
    private static final NavigatorLookupHint NAVIGATOR_HINT = new DesignerNavigatorLookupHint();
    private static final NavigatorLookupPanelsPolicy NAVIGATOR_LOOKUP_PANELS_POLICY = new DesignerNavigatorLookupPanelsPolicy();
    private boolean componentInited;
    private transient JToolBar toolbar;
    private transient boolean needListeners = true;
    private boolean showingErrors = false;
    private Component hiddenComp = null;
    private JComponent html;
    private transient MultiViewElementCallback multiViewElementCallback;
    private final PreferenceChangeListener settingsListener = new SettingsListener(this);
    private final PropertyChangeListener activatedNodesListener = new ActivatedNodesListener(this);
    private final Designer.DesignerListener designerListener = new JsfDesignerListener(this);
    private final JsfLookupProvider jsfLookupProvider;
    private DataObject jspDataObject;
    private static final Logger TIMERS = Logger.getLogger("TIMER.visualweb");
    private final JPanel panel = new JPanel();
    private static final String PATH_TOOLBAR_FOLDER = "Designer/application/x-designer/Toolbars/Default";
    private static final String PATH_DESIGNER_ACTIONS = "Designer/application/x-designer/Popup";
    private WeakReference<Lookup> lookupWRef = new WeakReference<Object>(null);

    public JsfTopComponent(JsfForm jsfForm, Designer designer, DataObject dataObject) {
        super(jsfForm, designer);
        if (TIMERS.isLoggable(Level.FINER)) {
            LogRecord logRecord = new LogRecord(Level.FINER, "JsfTopComponent");
            logRecord.setParameters(new Object[]{this});
            TIMERS.log(logRecord);
        }
        this.jspDataObject = dataObject;
        this.jsfLookupProvider = new JsfLookupProvider(this, dataObject);
        this.setName("Visual Design");
        this.setDisplayName(NbBundle.getMessage(JsfTopComponent.class, (String)"LBL_JsfDisplayName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JsfTopComponent.class, (String)"ACSD_DesignerTopComp"));
        this.initActivatedNodes(dataObject);
        this.initDesignerPreferences();
        this.panel.setOpaque(false);
        this.panel.setLayout(new GridBagLayout());
        this.setLayout(new BorderLayout());
        this.add(this.panel, "Center");
    }

    JsfForm getJsfForm() {
        return this.jsfForm;
    }

    Designer getDesigner() {
        return this.designer;
    }

    private void initActivatedNodes(DataObject dataObject) {
        this.setActivatedNodes(new Node[]{new DummyNode(dataObject)});
    }

    private void initDesignerPreferences() {
        JsfDesignerPreferences jsfDesignerPreferences = JsfDesignerPreferences.getInstance();
        this.designer.setPageSize(new Dimension(jsfDesignerPreferences.getPageSizeWidth(), jsfDesignerPreferences.getPageSizeHeight()));
        this.designer.setGridShow(jsfDesignerPreferences.getGridShow());
        this.designer.setGridSnap(jsfDesignerPreferences.getGridSnap());
        this.designer.setGridWidth(jsfDesignerPreferences.getGridWidth());
        this.setGridTraceWidth(jsfDesignerPreferences.getGridWidth());
        this.designer.setGridHeight(jsfDesignerPreferences.getGridHeight());
        this.setGridTraceHeight(jsfDesignerPreferences.getGridHeight());
        this.designer.setShowDecorations(jsfDesignerPreferences.isShowDecorations());
        this.designer.setDefaultFontSize(jsfDesignerPreferences.getDefaultFontSize());
    }

    private void initComponent() {
        if (this.jsfForm.isValid()) {
            this.initDesigner();
        } else {
            this.initLoadingComponent();
        }
    }

    private void initDesigner() {
        this.initDesignerComponent();
        this.initDesignerListeners();
    }

    private void initDesignerListeners() {
        JsfDesignerPreferences.getInstance().addWeakPreferenceChangeListener(this.settingsListener);
        this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.activatedNodesListener, (Object)this));
        this.designer.addDesignerListener((Designer.DesignerListener)WeakListeners.create(Designer.DesignerListener.class, (EventListener)this.designerListener, (Object)this.designer));
    }

    private void initDesignerComponent() {
        this.panel.removeAll();
        this.createDesignerPane();
        this.installActions();
        ActionMap actionMap = this.getActionMap();
        ActionMap actionMap2 = this.designer.getPaneActionMap();
        actionMap.setParent(actionMap2);
        this.designer.setPaintSizeMask(this.jsfForm.isFragment() || this.jsfForm.isPortlet());
    }

    private void initLoadingComponent() {
        this.panel.removeAll();
        this.panel.add((Component)this.createLoadingComponent(), JsfTopComponent.getDefaultGridBagConstraints());
    }

    private JComponent createLoadingComponent() {
        JLabel jLabel = new JLabel(NbBundle.getMessage(JsfTopComponent.class, (String)"LBL_LoadingModel"), 0);
        jLabel.setForeground(SystemColor.textInactiveText);
        jLabel.setCursor(Cursor.getPredefinedCursor(3));
        return jLabel;
    }

    private JComponent createReloadingComponent() {
        JLabel jLabel = new JLabel(NbBundle.getMessage(JsfTopComponent.class, (String)"LBL_ReloadingModel"), 0);
        jLabel.setOpaque(true);
        SystemColor systemColor = SystemColor.control;
        jLabel.setBackground(new Color(systemColor.getRed(), systemColor.getGreen(), systemColor.getBlue(), 150));
        jLabel.setForeground(SystemColor.textInactiveText);
        jLabel.setCursor(Cursor.getPredefinedCursor(3));
        return jLabel;
    }

    protected String preferredID() {
        return "DESIGNER";
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentOpened() {
        if (this.jsfForm.isValid()) {
            this.designerOpened();
        }
    }

    protected void componentClosed() {
        if (this.jsfForm.isValid()) {
            this.designerClosed();
        }
    }

    public void requestFocus() {
        this.designer.paneRequestFocus();
    }

    public void requestVisible() {
        if (this.multiViewElementCallback != null) {
            this.multiViewElementCallback.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.multiViewElementCallback != null) {
            this.multiViewElementCallback.requestActive();
        } else {
            super.requestActive();
        }
    }

    public void updateErrors() {
        boolean bl = this.jsfForm.isModelBusted();
        if (!bl && this.needListeners) {
            this.needListeners = false;
            this.jsfForm.attachContext();
        }
        if (SHOW_RENDER_ERRORS && (this.jsfForm.hasRenderingErrors() || this.jsfForm.getHtmlBody(false) == null)) {
            if (!this.jsfForm.isRenderFailureShown()) {
                this.showErrors(true);
            }
        } else {
            this.showErrors(bl);
        }
    }

    void showErrors(boolean bl) {
        if (bl == this.showingErrors) {
            Component component;
            if (bl && (component = this.panel.getComponent(0)) instanceof JsfForm.ErrorPanel) {
                ((JsfForm.ErrorPanel)((Object)component)).updateErrors();
            }
            return;
        }
        assert (SwingUtilities.isEventDispatchThread());
        if (bl) {
            if (this.panel.getComponentCount() == 0) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Designer top component is not initialized, there is no designer pane or error panel in it"));
                return;
            }
            int n = this.panel.getComponentCount();
            if (n > 0) {
                this.hiddenComp = this.panel.getComponent(n - 1);
            }
            this.panel.removeAll();
            JComponent jComponent = this.jsfForm.getErrorPanel(new ErrorPanelCallbackImpl(this));
            this.panel.add((Component)jComponent, JsfTopComponent.getDefaultGridBagConstraints());
        } else {
            assert (this.panel.getComponentCount() >= 1);
            this.panel.removeAll();
            assert (this.hiddenComp != null);
            this.panel.add(this.hiddenComp, JsfTopComponent.getDefaultGridBagConstraints());
            if (this.hiddenComp.getWidth() == 0 || this.hiddenComp.getHeight() == 0) {
                this.hiddenComp.setSize(this.getWidth(), this.getHeight());
                this.showingErrors = bl;
                this.jsfForm.refreshModel(false);
            }
        }
        this.showingErrors = bl;
        this.revalidate();
        this.repaint();
    }

    public void designContextGenerationChanged() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JsfTopComponent.this.designer.syncSelection(true);
                if (JsfTopComponent.this.isShowing()) {
                    JsfTopComponent.this.updateErrors();
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        Node[] nodeArray = this.getActivatedNodes();
        Node[] nodeArray2 = nodeArray == null ? new Node[]{} : nodeArray;
        return ExplorerUtils.getHelpCtx((Node[])nodeArray2, (HelpCtx)new HelpCtx("projrave_ui_elements_editors_about_visual_editor"));
    }

    protected void componentActivated() {
        if (this.jsfForm.isValid()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JsfTopComponent.this.designerActivated();
                }
            });
        }
    }

    public JComponent getPane() {
        return this.html;
    }

    private void createDesignerPane() {
        this.jsfForm.syncModel();
        this.html = this.designer.createPaneComponent();
        JScrollPane jScrollPane = new JScrollPane();
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.add(this.html);
        this.panel.add((Component)jScrollPane, JsfTopComponent.getDefaultGridBagConstraints());
        this.designer.updatePaneViewPort();
    }

    protected void componentShowing() {
        if (!this.componentInited) {
            this.componentInited = true;
            if (!this.jsfForm.isValid()) {
                if (!JsfForm.tryFacesModelForJsfForm(this.jsfForm, this.jspDataObject)) {
                    JsfForm.loadFacesModelForJsfForm(this.jsfForm, this.jspDataObject);
                }
                this.jspDataObject = null;
            }
            this.initComponent();
        }
        if (this.jsfForm.isValid()) {
            this.designerShowing();
        }
    }

    protected void componentHidden() {
        if (this.jsfForm.isValid()) {
            this.designerHidden();
        }
    }

    public CloseOperationState canCloseElement() {
        return MultiViewFactory.createUnsafeCloseState((String)"ID_CLOSING_DESIGNER", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewElementCallback = multiViewElementCallback;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            this.toolbar.setRollover(true);
            this.toolbar.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.toolbar.addSeparator();
            Action[] actionArray = SystemFileSystemSupport.getActions((String)PATH_TOOLBAR_FOLDER);
            Lookup lookup = this.getLookup();
            for (int i = 0; i < actionArray.length; ++i) {
                Object object;
                Object object2 = actionArray[i];
                if (object2 == null) {
                    this.toolbar.addSeparator();
                    continue;
                }
                if (object2 instanceof ContextAwareAction && (object = ((ContextAwareAction)object2).createContextAwareInstance(lookup)) != null) {
                    object2 = object;
                }
                if (object2 instanceof Presenter.Toolbar) {
                    object = ((Presenter.Toolbar)object2).getToolbarPresenter();
                    this.toolbar.add((Component)object);
                    continue;
                }
                object = new JButton();
                Actions.connect((AbstractButton)object, (Action)object2);
                this.toolbar.add((Component)object);
            }
        }
        return this.toolbar;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    protected void installActions() {
        super.installActions();
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(2);
        inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(113, 0), "edit-value");
        actionMap.put("edit-value", new EditValueAction(this));
        inputMap.put(KeyStroke.getKeyStroke(113, 192), "rave-designer-dump-html");
        actionMap.put("rave-designer-dump-html", new DumpHtmlAction(this));
        inputMap.put(KeyStroke.getKeyStroke(114, 192), "rave-designer-dump-boxes");
        actionMap.put("rave-designer-dump-boxes", new DumpBoxesAction(this));
    }

    private boolean editValue() {
        Element[] elementArray = this.designer.getSelectedComponents();
        if (elementArray.length == 1) {
            for (Element element : elementArray) {
                if (element == null) continue;
                this.requestActive();
                this.designer.startInlineEditing(element, null);
            }
        }
        return false;
    }

    private void dumpActivatedMarkupDesignBeansHtml() {
        Node[] nodeArray = this.getActivatedNodes();
        if (nodeArray == null) {
            return;
        }
        for (Node node : nodeArray) {
            if (node == null) continue;
            this.jsfForm.dumpHtmlMarkupForNode(node);
        }
    }

    private void dumpActivatedComponentCssBoxes() {
        Node[] nodeArray = this.getActivatedNodes();
        if (nodeArray == null) {
            return;
        }
        for (Node node : nodeArray) {
            if (node == null) continue;
            Element element = JsfSupportUtilities.getComponentRootElementFromNode(node);
            if (element == null) {
                JsfTopComponent.log("Node doesn't have design bean, node=" + node);
                this.dumpRootComponentCssBoxes();
                continue;
            }
            Designer.Box box = this.designer.findBoxForComponentRootElement(element);
            if (box == null) {
                JsfTopComponent.log("Component doesn't have a corresponding css box, componentRootElement=" + element);
                this.dumpRootComponentCssBoxes();
                continue;
            }
            JsfTopComponent.log("Css boxes for componentRootElement=" + element);
            box.list(System.err, 0);
        }
    }

    private void dumpRootComponentCssBoxes() {
        Designer.Box box;
        Document document = this.jsfForm.getHtmlDom();
        Element element = JsfSupportUtilities.findHtmlElementDescendant(document);
        if (element == null) {
            element = this.jsfForm.getHtmlBody(false);
        }
        if ((box = this.designer.getPageBox()) == null) {
            return;
        }
        JsfTopComponent.log("CssBoxes for element=" + element);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(stringWriter));
        box.list(printWriter, 0);
        printWriter.flush();
        JsfTopComponent.log(stringWriter.toString());
        printWriter.close();
    }

    protected void showKeyboardPopup() {
        Point point = this.getSelectionPoint();
        this.showPopup(null, null, point.x, point.y);
    }

    public void showPopup(Action[] actionArray, Lookup lookup, int n, int n2) {
        if (actionArray == null) {
            actionArray = SystemFileSystemSupport.getActions((String)PATH_DESIGNER_ACTIONS);
        }
        if (lookup == null) {
            lookup = this.getLookup();
        }
        JPopupMenu jPopupMenu = Utilities.actionsToPopup((Action[])actionArray, (Lookup)lookup);
        if (this.isShowing()) {
            jPopupMenu.show((Component)((Object)this), n, n2);
        }
    }

    private Point getSelectionPoint() {
        if (this.designer.getSelectedCount() > 0) {
            Element element = this.designer.getPrimarySelection();
            if (element != null) {
                Designer.Box box;
                for (box = this.designer.findBoxForComponentRootElement(element); box != null && (box.getX() == 0x7FFFFFFE || box.getY() == 0x7FFFFFFE || box.getX() == 0x7FFFFFFD || box.getY() == 0x7FFFFFFD); box = box.getParent()) {
                }
                if (box != null) {
                    return new Point(box.getAbsoluteX(), box.getAbsoluteY());
                }
            }
            for (Designer.Box box : this.designer.getSelectedComponents()) {
                Designer.Box box2;
                if (box == null) continue;
                for (box2 = this.designer.findBoxForComponentRootElement((Element)box); box2 != null && (box2.getX() == 0x7FFFFFFE || box2.getY() == 0x7FFFFFFE || box2.getX() == 0x7FFFFFFD || box2.getY() == 0x7FFFFFFD); box2 = box2.getParent()) {
                }
                if (box2 == null) continue;
                return new Point(box2.getAbsoluteX(), box2.getAbsoluteY());
            }
        }
        return new Point(10, 10);
    }

    public Element getPasteParentComponent() {
        Element element = this.designer.getSelectedContainer();
        if (element == null) {
            element = this.jsfForm.getDefaultParentComponent();
        }
        return element;
    }

    public void selectComponents(Element[] elementArray) {
        List<Element> list;
        Element[] elementArray2 = this.designer.getSelectedComponents();
        List<Element> list2 = Arrays.asList(elementArray);
        if (list2.containsAll(list = Arrays.asList(elementArray2)) && list.containsAll(list2)) {
            return;
        }
        this.designer.setSelectedComponents(elementArray, true);
    }

    protected Transferable copy() {
        Node[] nodeArray = this.getActivatedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return null;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node : nodeArray) {
            Element element;
            if (node == null || (element = JsfSupportUtilities.getComponentRootElementFromNode(node)) == null || JsfSupportUtilities.isSpecialComponent(element)) continue;
            arrayList.add(element);
        }
        this.removeChildrenComponents(arrayList);
        Transferable transferable = this.jsfForm.copyComponents(arrayList.toArray(new Element[arrayList.size()]));
        return transferable;
    }

    public void deleteSelection() {
        Element[] elementArray = this.designer.getSelectedComponents();
        if (elementArray.length > 0) {
            this.designer.clearSelection(true);
            this.jsfForm.deleteComponents(elementArray);
        }
    }

    protected void componentDeactivated() {
        if (this.jsfForm.isValid()) {
            this.designerDeactivated();
        }
    }

    public Lookup getLookup() {
        Lookup lookup = (Lookup)this.lookupWRef.get();
        if (lookup == null) {
            Lookup lookup2 = super.getLookup();
            lookup = new ProxyLookup(new Lookup[]{lookup2, Lookups.proxy((Lookup.Provider)this.jsfLookupProvider)});
            this.lookupWRef = new WeakReference<Lookup>(lookup);
        }
        return lookup;
    }

    private static Element[] getComponentsForNodes(Node[] nodeArray) {
        if (nodeArray == null) {
            return new Element[0];
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            Element element = JsfSupportUtilities.getComponentRootElementFromNode(node);
            if (element == null) continue;
            arrayList.add(element);
        }
        return arrayList.toArray(new Element[arrayList.size()]);
    }

    public void modelChanged() {
        this.designer.resetPanePageBox();
    }

    public void modelRefreshed() {
        this.designer.resetAll();
    }

    public void nodeChanged(org.w3c.dom.Node node, org.w3c.dom.Node node2, Element[] elementArray) {
        this.designer.changeNode(node, node2, elementArray);
    }

    public void nodeRemoved(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        this.designer.removeNode(node, node2);
    }

    public void nodeInserted(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        this.designer.insertNode(node, node2);
    }

    public void gridModeUpdated(boolean bl) {
        this.designer.setPaneGrid(bl);
    }

    public void documentReplaced() {
        this.designer.detachDomDocument();
    }

    public void showDropMatch(Element element, Element element2, int n) {
        this.designer.showDropMatch(element, element2, n);
    }

    public void clearDropMatch() {
        this.designer.clearDropMatch();
    }

    public void selectComponent(Element element) {
        this.designer.selectComponentDelayed(element);
    }

    public void inlineEditComponents(Element[] elementArray) {
        this.requestActive();
        this.designer.inlineEditComponents(elementArray);
    }

    TopComponent getMultiViewTopComponent() {
        MultiViewElementCallback multiViewElementCallback = this.multiViewElementCallback;
        if (multiViewElementCallback == null) {
            return null;
        }
        return multiViewElementCallback.getTopComponent();
    }

    void closeMultiView() {
        TopComponent topComponent = this.getMultiViewTopComponent();
        if (topComponent == null) {
            return;
        }
        topComponent.close();
    }

    boolean isSelectedInMultiView() {
        MultiViewElementCallback multiViewElementCallback = this.multiViewElementCallback;
        return multiViewElementCallback == null ? false : multiViewElementCallback.isSelectedElement();
    }

    protected void designerActivated() {
        this.designer.updateSelectedNodes();
        super.designerActivated();
        this.designer.paneRequestFocus();
    }

    protected void designerDeactivated() {
        super.designerDeactivated();
        if (this.designer.getSelectedCount() > 0) {
            this.designer.finishInlineEditing(false);
        }
    }

    private void designerOpened() {
    }

    private void designerClosed() {
        if (!this.needListeners) {
            this.needListeners = true;
        }
        this.jsfForm.clearHtml();
    }

    private void designerShowing() {
        if (this.jsfForm.isFragment()) {
            this.jsfForm.refreshModel(false);
        }
        if (this.jsfForm.isSourceDirty() && this.designer.hasPaneCaret()) {
            this.designer.setPaneCaret(DomProvider.DomPosition.NONE);
        }
        if (this.jsfForm.isModelInSync()) {
            if (this.jsfForm.isFragment() || this.jsfForm.hasCachedExternalFrames() || this.designer.getPageBox() == null) {
                this.resetDesigner();
            }
            this.refreshDesignerPaneAsNeeded();
        } else {
            final JComponent jComponent = this.createReloadingComponent();
            this.panel.add(jComponent, JsfTopComponent.getDefaultGridBagConstraints(), 0);
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        JsfTopComponent.this.jsfForm.syncModel();
                        JsfTopComponent.this.resetDesigner();
                        JsfTopComponent.this.refreshDesignerPaneAsNeeded();
                    }
                    finally {
                        JsfTopComponent.this.panel.remove(jComponent);
                    }
                }
            });
        }
    }

    private void resetDesigner() {
        this.designer.resetPanePageBox();
        this.updateErrors();
    }

    private void refreshDesignerPaneAsNeeded() {
        if (this.jsfForm.isFragment() || this.jsfForm.hasCachedExternalFrames()) {
            this.designer.redoPaneLayout(true);
        }
        this.designer.setPaneGrid(this.jsfForm.isGridMode());
    }

    private void designerHidden() {
    }

    private boolean isActivated() {
        MultiViewElementCallback multiViewElementCallback = this.multiViewElementCallback;
        return multiViewElementCallback == null ? false : multiViewElementCallback.isSelectedElement() && multiViewElementCallback.getTopComponent() == TopComponent.getRegistry().getActivated();
    }

    void modelLoaded() {
        this.initDesigner();
        this.designerOpened();
        this.designerShowing();
        if (this.isActivated()) {
            this.designerActivated();
        }
        this.revalidate();
        this.repaint();
    }

    private void setGridTraceWidth(int n) {
        int n2;
        int n3 = n;
        int n4 = 2;
        while ((n2 = n / n4) >= 8) {
            n3 = n2;
            ++n4;
        }
        this.designer.setGridTraceWidth(n3);
    }

    private void setGridTraceHeight(int n) {
        int n2;
        int n3 = n;
        int n4 = 2;
        while ((n2 = n / n4) >= 8) {
            n3 = n2;
            ++n4;
        }
        this.designer.setGridTraceHeight(n3);
    }

    private static void warn(String string) {
        Logger logger = JsfTopComponent.getLogger();
        logger.log(Level.WARNING, string);
    }

    private static void log(String string) {
        Logger logger = JsfTopComponent.getLogger();
        logger.log(Level.INFO, string);
    }

    private static Logger getLogger() {
        return Logger.getLogger(JsfTopComponent.class.getName());
    }

    private static GridBagConstraints getDefaultGridBagConstraints() {
        return new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
    }

    private static class DesignerNavigatorLookupPanelsPolicy
    implements NavigatorLookupPanelsPolicy {
        private DesignerNavigatorLookupPanelsPolicy() {
        }

        public int getPanelsPolicy() {
            return 1;
        }
    }

    private static class JsfLookupProvider
    implements Lookup.Provider {
        private final Lookup lookup;

        public JsfLookupProvider(JsfTopComponent jsfTopComponent, DataObject dataObject) {
            this.lookup = this.createLookup(jsfTopComponent, dataObject);
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        private Lookup createLookup(JsfTopComponent jsfTopComponent, DataObject dataObject) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(dataObject);
            arrayList.add(NAVIGATOR_HINT);
            arrayList.add(NAVIGATOR_LOOKUP_PANELS_POLICY);
            PaletteController paletteController = jsfTopComponent.getJsfForm().getPaletteController();
            if (paletteController == null) {
                JsfTopComponent.warn("Loaded FacesModel doesn't Project needed to create PaletteController!\nThe Designer lookup won't be fully inited. Palete won't be loaded.\nVariable jsfForm=" + jsfTopComponent.getJsfForm());
            } else {
                arrayList.add(paletteController);
            }
            return Lookups.fixed((Object[])arrayList.toArray());
        }
    }

    private static class DesignerNavigatorLookupHint
    implements NavigatorLookupHint {
        private DesignerNavigatorLookupHint() {
        }

        public String getContentType() {
            return "application/x-designer";
        }
    }

    private static class DumpBoxesAction
    extends JsfTopComponentAction {
        public DumpBoxesAction(JsfTopComponent jsfTopComponent) {
            super(jsfTopComponent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getJsfTopComponent().dumpActivatedComponentCssBoxes();
        }
    }

    private static class DumpHtmlAction
    extends JsfTopComponentAction {
        public DumpHtmlAction(JsfTopComponent jsfTopComponent) {
            super(jsfTopComponent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getJsfTopComponent().dumpActivatedMarkupDesignBeansHtml();
        }
    }

    private static class EditValueAction
    extends JsfTopComponentAction {
        public EditValueAction(JsfTopComponent jsfTopComponent) {
            super(jsfTopComponent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JsfTopComponent jsfTopComponent = this.getJsfTopComponent();
            if (jsfTopComponent.designer.isInlineEditing()) {
                return;
            }
            boolean bl = jsfTopComponent.editValue();
            if (!bl) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)jsfTopComponent));
            }
        }
    }

    private static abstract class JsfTopComponentAction
    extends AbstractAction {
        private final JsfTopComponent jsfTopComponent;

        public JsfTopComponentAction(JsfTopComponent jsfTopComponent) {
            this.jsfTopComponent = jsfTopComponent;
        }

        protected JsfTopComponent getJsfTopComponent() {
            return this.jsfTopComponent;
        }
    }

    private static class ErrorPanelCallbackImpl
    implements JsfForm.ErrorPanelCallback {
        private final JsfTopComponent jsfTC;

        public ErrorPanelCallbackImpl(JsfTopComponent jsfTopComponent) {
            this.jsfTC = jsfTopComponent;
        }

        public void updateTopComponentForErrors() {
            this.jsfTC.updateErrors();
        }

        public void setRenderFailureShown(boolean bl) {
            this.jsfTC.jsfForm.setRenderFailureShown(bl);
        }

        public void handleRefresh(boolean bl) {
            this.jsfTC.showErrors(bl);
            this.jsfTC.jsfForm.refreshModel(true);
        }
    }

    private static class ActivatedNodesListener
    implements PropertyChangeListener {
        private final JsfTopComponent designerTC;

        public ActivatedNodesListener(JsfTopComponent jsfTopComponent) {
            this.designerTC = jsfTopComponent;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("activatedNodes".equals(propertyChangeEvent.getPropertyName())) {
                Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                Element[] elementArray = JsfTopComponent.getComponentsForNodes(nodeArray);
                this.designerTC.selectComponents(elementArray);
            }
        }
    }

    private static class SettingsListener
    implements PreferenceChangeListener {
        private final JsfTopComponent designerTC;

        public SettingsListener(JsfTopComponent jsfTopComponent) {
            this.designerTC = jsfTopComponent;
        }

        public void preferenceChange(final PreferenceChangeEvent preferenceChangeEvent) {
            if (EventQueue.isDispatchThread()) {
                this.doPreferenceChange(preferenceChangeEvent);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SettingsListener.this.doPreferenceChange(preferenceChangeEvent);
                    }
                });
            }
        }

        private void doPreferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string = preferenceChangeEvent.getKey();
            if (!this.designerTC.isShowing()) {
                return;
            }
            JsfDesignerPreferences jsfDesignerPreferences = JsfDesignerPreferences.getInstance();
            if ("pageSize".equals(string)) {
                int n = jsfDesignerPreferences.getPageSizeWidth();
                int n2 = jsfDesignerPreferences.getPageSizeHeight();
                this.designerTC.designer.setPageSize(new Dimension(n, n2));
            } else if ("gridShow".equals(string)) {
                boolean bl = jsfDesignerPreferences.getGridShow();
                this.designerTC.designer.setGridShow(bl);
            } else if ("gridSnap".equals(string)) {
                boolean bl = jsfDesignerPreferences.getGridSnap();
                this.designerTC.designer.setGridSnap(bl);
            } else if ("gridWidth".equals(string)) {
                int n = jsfDesignerPreferences.getGridWidth();
                this.designerTC.designer.setGridWidth(n);
                this.designerTC.setGridTraceWidth(n);
            } else if ("gridHeight".equals(string)) {
                int n = jsfDesignerPreferences.getGridHeight();
                this.designerTC.designer.setGridHeight(n);
                this.designerTC.setGridTraceHeight(n);
            } else if ("defaultFontSize".equals(string)) {
                this.designerTC.designer.setDefaultFontSize(jsfDesignerPreferences.getDefaultFontSize());
            } else if ("showDecorations".equals(string)) {
                this.designerTC.designer.setShowDecorations(jsfDesignerPreferences.isShowDecorations());
            }
        }
    }

    private static class DummyNode
    extends AbstractNode {
        public DummyNode(DataObject dataObject) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{dataObject}));
        }
    }
}

