/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.action;

import com.sun.rave.designtime.DesignBean;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.designer.jsf.JsfForm;
import org.netbeans.modules.visualweb.designer.jsf.JsfSupportUtilities;
import org.netbeans.modules.visualweb.insync.live.LiveUnit;
import org.netbeans.modules.visualweb.spi.designtime.idebridge.action.AbstractDesignBeanAction;
import org.openide.awt.Actions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AlignAction
extends AbstractDesignBeanAction {
    protected String getDisplayName(DesignBean[] designBeanArray) {
        String string = NbBundle.getMessage(AlignAction.class, (String)"LBL_AlignAction");
        if (designBeanArray.length == 0) {
            return string;
        }
        Designer designer = JsfSupportUtilities.findDesignerForDesignContext(designBeanArray[0].getDesignContext());
        if (designer == null) {
            return string;
        }
        if (designer.getSelectedCount() == 1) {
            return AlignMenuModel.SNAP_TO_GRID.getDisplayName();
        }
        return string;
    }

    protected String getIconBase(DesignBean[] designBeanArray) {
        return null;
    }

    protected boolean isEnabled(DesignBean[] designBeanArray) {
        if (designBeanArray.length == 0) {
            return false;
        }
        if (!LiveUnit.isTrayBean((DesignBean)designBeanArray[0])) {
            Designer designer = JsfSupportUtilities.findDesignerForDesignContext(designBeanArray[0].getDesignContext());
            return designer != null && designer.getSelectedCount() > 0;
        }
        return false;
    }

    protected void performAction(DesignBean[] designBeanArray) {
        new AlignMenuModel(designBeanArray).performActionAt(0);
    }

    protected JMenuItem getMenuPresenter(Action action, Lookup.Result result) {
        return new Actions.SubMenu(action, (Actions.SubMenuModel)new AlignMenuModel(AlignAction.getDesignBeans((Lookup.Result)result)), false);
    }

    protected JMenuItem getPopupPresenter(Action action, Lookup.Result result) {
        return new Actions.SubMenu(action, (Actions.SubMenuModel)new AlignMenuModel(AlignAction.getDesignBeans((Lookup.Result)result)), true);
    }

    private static class AlignMenuModel
    implements Actions.SubMenuModel {
        private static final AlignmentAction SNAP_TO_GRID = new SnapToGridAlignment(NbBundle.getMessage(AlignAction.class, (String)"LBL_SnapToGrid"));
        private static final AlignmentAction TOP = new SimpleAlignment(JsfForm.Alignment.TOP, NbBundle.getMessage(AlignAction.class, (String)"LBL_Top"));
        private static final AlignmentAction MIDDLE = new SimpleAlignment(JsfForm.Alignment.MIDDLE, NbBundle.getMessage(AlignAction.class, (String)"LBL_Middle"));
        private static final AlignmentAction BOTTOM = new SimpleAlignment(JsfForm.Alignment.BOTTOM, NbBundle.getMessage(AlignAction.class, (String)"LBL_Bottom"));
        private static final AlignmentAction LEFT = new SimpleAlignment(JsfForm.Alignment.LEFT, NbBundle.getMessage(AlignAction.class, (String)"LBL_Left"));
        private static final AlignmentAction CENTER = new SimpleAlignment(JsfForm.Alignment.CENTER, NbBundle.getMessage(AlignAction.class, (String)"LBL_Center"));
        private static final AlignmentAction RIGHT = new SimpleAlignment(JsfForm.Alignment.RIGHT, NbBundle.getMessage(AlignAction.class, (String)"LBL_Right"));
        private final AlignmentAction[] alignments;
        private final DesignBean[] designBeans;

        public AlignMenuModel(DesignBean[] designBeanArray) {
            this.designBeans = designBeanArray;
            Designer designer = JsfSupportUtilities.findDesignerForDesignContext(designBeanArray[0].getDesignContext());
            this.alignments = designer == null ? new AlignmentAction[0] : (designer.getSelectedCount() == 1 ? new AlignmentAction[]{SNAP_TO_GRID} : new AlignmentAction[]{SNAP_TO_GRID, TOP, MIDDLE, BOTTOM, LEFT, CENTER, RIGHT});
        }

        public int getCount() {
            return this.alignments.length;
        }

        public String getLabel(int n) {
            return this.alignments[n].getDisplayName();
        }

        public HelpCtx getHelpCtx(int n) {
            return null;
        }

        public void performActionAt(int n) {
            if (this.designBeans.length == 0) {
                return;
            }
            JsfForm jsfForm = JsfSupportUtilities.findJsfFormForDesignContext(this.designBeans[0].getDesignContext());
            if (jsfForm == null) {
                return;
            }
            this.alignments[n].performAction(jsfForm);
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        private static class SimpleAlignment
        extends AlignmentAction {
            public SimpleAlignment(JsfForm.Alignment alignment, String string) {
                super(alignment, string);
            }

            protected void performAction(JsfForm jsfForm) {
                Designer designer = JsfSupportUtilities.findDesignerForJsfForm(jsfForm);
                if (designer == null) {
                    return;
                }
                jsfForm.align(designer, this.getAlignment());
            }
        }

        private static class SnapToGridAlignment
        extends AlignmentAction {
            public SnapToGridAlignment(String string) {
                super(JsfForm.Alignment.SNAP_TO_GRID, string);
            }

            protected void performAction(JsfForm jsfForm) {
                Designer designer = JsfSupportUtilities.findDesignerForJsfForm(jsfForm);
                if (designer == null) {
                    return;
                }
                jsfForm.snapToGrid(designer);
            }
        }

        private static abstract class AlignmentAction {
            private final JsfForm.Alignment alignment;
            private final String displayName;

            public AlignmentAction(JsfForm.Alignment alignment, String string) {
                this.alignment = alignment;
                this.displayName = string;
            }

            public String getDisplayName() {
                return this.displayName;
            }

            public JsfForm.Alignment getAlignment() {
                return this.alignment;
            }

            protected abstract void performAction(JsfForm var1);
        }
    }
}

