/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignEvent;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Position;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.netbeans.modules.visualweb.designer.jsf.BeanModifyListener;
import org.netbeans.modules.visualweb.designer.jsf.FacesDndSupport;
import org.netbeans.modules.visualweb.designer.jsf.JsfForm;
import org.netbeans.modules.visualweb.insync.CustomizerDisplayer;
import org.netbeans.modules.visualweb.insync.InSyncServiceProvider;
import org.netbeans.modules.visualweb.insync.markup.MarkupUnit;
import org.openide.ErrorManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DomSynchronizer
implements Runnable,
EventListener,
FacesDndSupport.UpdateSuspender {
    private static final boolean DEBUG = false;
    private static final int TYPE_NONE = 0;
    private static final int TYPE_INSERT = 1;
    private static final int TYPE_CHANGE = 2;
    private static final int TYPE_DELETE = 3;
    private static final int TYPE_REFRESH = 4;
    private MarkupDesignBean pendingBean;
    private JsfForm jsfForm;
    private Document currentDOM;
    private Node deleteParent;
    private boolean suspendUpdates;
    private boolean timeOutPending;
    private int pendingEventType = 0;
    private boolean inlineEditingUpdate;

    public DomSynchronizer(JsfForm jsfForm) {
        this.jsfForm = jsfForm;
        this.currentDOM = jsfForm.getJspDom();
        if (this.currentDOM == null) {
            jsfForm.syncModel();
            this.currentDOM = jsfForm.getJspDom();
        }
        if (this.currentDOM != null) {
            this.registerDomListeners();
        }
    }

    public void instanceNameChanged(DesignBean designBean, String string) {
    }

    public void beanChanged(DesignBean designBean) {
        if (!(designBean instanceof MarkupDesignBean)) {
            if (this.suspendUpdates) {
                this.requestRefresh();
            }
            return;
        }
        MarkupDesignBean markupDesignBean = (MarkupDesignBean)designBean;
        markupDesignBean = this.getRenderTarget(markupDesignBean);
        this.requestChange(markupDesignBean);
    }

    public void beanCreated(DesignBean designBean) {
        if (!(designBean instanceof MarkupDesignBean)) {
            return;
        }
        MarkupDesignBean markupDesignBean = (MarkupDesignBean)designBean;
        if ((markupDesignBean = this.getRenderTarget(markupDesignBean)) != designBean) {
            this.requestChange(markupDesignBean);
            return;
        }
        this.requestInsert(markupDesignBean);
    }

    public void propertyChanged(DesignProperty designProperty, Object object) {
        DesignBean designBean = designProperty.getDesignBean();
        if (!(designBean instanceof MarkupDesignBean)) {
            this.requestRefresh();
            return;
        }
        MarkupDesignBean markupDesignBean = (MarkupDesignBean)designBean;
        if (markupDesignBean.getElement() == null) {
            return;
        }
        markupDesignBean = this.getRenderTarget(markupDesignBean);
        this.requestChange(markupDesignBean);
    }

    public void beanDeleted(DesignBean designBean) {
        if (!(designBean instanceof MarkupDesignBean)) {
            return;
        }
        MarkupDesignBean markupDesignBean = (MarkupDesignBean)designBean;
        if ((markupDesignBean = this.getRenderTarget(markupDesignBean)) != designBean) {
            this.requestChange(markupDesignBean);
        } else {
            this.requestDelete(markupDesignBean);
        }
    }

    public void contextChanged(DesignContext designContext) {
        this.requestRefresh();
    }

    public void beanMoved(DesignBean designBean, DesignBean designBean2, Position position) {
        if (!(designBean instanceof MarkupDesignBean)) {
            return;
        }
        if (!(designBean2 instanceof MarkupDesignBean)) {
            return;
        }
        MarkupDesignBean markupDesignBean = (MarkupDesignBean)designBean;
        if ((markupDesignBean = this.getRenderTarget(markupDesignBean)) == null) {
            this.requestRefresh();
        } else if (!this.isBelow(designBean2, (DesignBean)markupDesignBean)) {
            markupDesignBean = this.isBelow((DesignBean)markupDesignBean, designBean2) ? (MarkupDesignBean)designBean2 : (MarkupDesignBean)this.getCommonAncestor((DesignBean)markupDesignBean, designBean2);
        }
        this.requestChange(markupDesignBean);
    }

    public void contextActivated(DesignContext designContext) {
    }

    public void contextDeactivated(DesignContext designContext) {
    }

    public void eventChanged(DesignEvent designEvent) {
    }

    public void beanContextActivated(DesignBean designBean) {
    }

    public void beanContextDeactivated(DesignBean designBean) {
    }

    public void setUpdatesSuspended(MarkupDesignBean markupDesignBean, boolean bl) {
        if (bl) {
            assert (!this.suspendUpdates);
            this.suspendUpdates = true;
        } else {
            this.suspendUpdates = false;
            markupDesignBean = this.getRenderTarget(markupDesignBean);
            this.requestChange(markupDesignBean);
        }
    }

    private void requestUpdate(final int n, final MarkupDesignBean markupDesignBean) {
        if (!SwingUtilities.isEventDispatchThread()) {
            this.inlineEditingUpdate = this.jsfForm.isInlineEditing();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DomSynchronizer.this.requestUpdate(n, markupDesignBean);
                }
            });
            return;
        }
        switch (n) {
            case 1: {
                this.requestInsert(markupDesignBean);
                break;
            }
            case 3: {
                this.requestDelete(markupDesignBean);
                break;
            }
            case 2: {
                this.requestChange(markupDesignBean);
                break;
            }
            case 4: {
                this.requestRefresh();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean isUpdatePending() {
        return this.pendingEventType != 0;
    }

    public void requestRefresh() {
        if (!SwingUtilities.isEventDispatchThread()) {
            this.requestUpdate(4, null);
            return;
        }
        if (!this.timeOutPending) {
            this.pendingBean = null;
            this.pendingEventType = 4;
            this.timeOutPending = true;
            this.inlineEditingUpdate = this.jsfForm.isInlineEditing();
            SwingUtilities.invokeLater(this);
        } else {
            this.pendingBean = null;
            this.pendingEventType = 4;
        }
    }

    public void requestChange(MarkupDesignBean markupDesignBean) {
        if (markupDesignBean == null) {
            this.requestRefresh();
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            this.requestUpdate(2, markupDesignBean);
            return;
        }
        if (!this.timeOutPending) {
            this.pendingBean = markupDesignBean;
            this.pendingEventType = 2;
            this.timeOutPending = true;
            this.adjustRequestIfRoot();
            this.inlineEditingUpdate = this.jsfForm.isInlineEditing();
            SwingUtilities.invokeLater(this);
        } else {
            if (this.pendingEventType == 4 || markupDesignBean == this.pendingBean || this.isBelow((DesignBean)markupDesignBean, (DesignBean)this.pendingBean)) {
                return;
            }
            if (this.isBelow((DesignBean)this.pendingBean, (DesignBean)markupDesignBean)) {
                this.pendingBean = markupDesignBean;
                this.pendingEventType = 2;
                this.adjustRequestIfRoot();
            } else {
                this.pendingEventType = 2;
                this.pendingBean = (MarkupDesignBean)this.getCommonAncestor((DesignBean)markupDesignBean, (DesignBean)this.pendingBean);
                assert (this.pendingBean != null);
                this.adjustRequestIfRoot();
            }
        }
    }

    private void adjustRequestIfRoot() {
        Element element = this.pendingBean.getElement();
        Element element2 = MarkupService.getRenderedElementForElement((Element)element);
        if (element2 != null) {
            element = element2;
        }
        if (element == null || element.getParentNode() == null || element.getParentNode().getNodeType() != 1 || element.getTagName().equals(HtmlTag.BODY.name)) {
            this.pendingBean = null;
            this.pendingEventType = 4;
        }
    }

    public void requestInsert(MarkupDesignBean markupDesignBean) {
        if (!SwingUtilities.isEventDispatchThread()) {
            this.requestUpdate(1, markupDesignBean);
            return;
        }
        if (!this.timeOutPending) {
            this.pendingBean = markupDesignBean;
            this.pendingEventType = 1;
            this.timeOutPending = true;
            this.adjustRequestIfRoot();
            this.inlineEditingUpdate = this.jsfForm.isInlineEditing();
            SwingUtilities.invokeLater(this);
        } else {
            if (this.pendingEventType == 4 || markupDesignBean == this.pendingBean || this.isBelow((DesignBean)markupDesignBean, (DesignBean)this.pendingBean)) {
                return;
            }
            this.pendingBean = (MarkupDesignBean)this.getCommonAncestor((DesignBean)markupDesignBean, (DesignBean)this.pendingBean);
            this.pendingEventType = 2;
            assert (this.pendingBean != null);
            this.adjustRequestIfRoot();
        }
    }

    public void requestDelete(MarkupDesignBean markupDesignBean) {
        if (!SwingUtilities.isEventDispatchThread()) {
            this.requestUpdate(3, markupDesignBean);
            return;
        }
        if (!this.timeOutPending) {
            this.pendingBean = markupDesignBean;
            this.pendingEventType = 3;
            this.timeOutPending = true;
            this.adjustRequestIfRoot();
            this.inlineEditingUpdate = this.jsfForm.isInlineEditing();
            SwingUtilities.invokeLater(this);
        } else {
            if (this.pendingEventType == 4) {
                return;
            }
            if (markupDesignBean == this.pendingBean) {
                this.pendingEventType = 3;
                return;
            }
            if (this.isBelow((DesignBean)markupDesignBean, (DesignBean)this.pendingBean)) {
                return;
            }
            if (this.isBelow((DesignBean)this.pendingBean, (DesignBean)markupDesignBean)) {
                this.pendingEventType = 3;
                this.pendingBean = markupDesignBean;
                this.adjustRequestIfRoot();
            } else {
                this.pendingBean = (MarkupDesignBean)this.getCommonAncestor((DesignBean)markupDesignBean, (DesignBean)this.pendingBean);
                this.pendingEventType = 2;
                assert (this.pendingBean != null);
                this.adjustRequestIfRoot();
            }
        }
    }

    public void requestTextUpdate(MarkupDesignBean markupDesignBean) {
        this.beanChanged((DesignBean)markupDesignBean);
    }

    @Override
    public void run() {
        this.timeOutPending = false;
        this.processUpdates();
    }

    private void processUpdates() {
        if (this.pendingEventType == 0 || this.suspendUpdates) {
            return;
        }
        if (!this.jsfForm.isModelValid()) {
            return;
        }
        MarkupDesignBean markupDesignBean = this.pendingBean;
        this.pendingBean = null;
        int n = this.pendingEventType;
        this.pendingEventType = 0;
        if (n == 2) {
            Element element = MarkupService.getRenderedElementForElement((Element)markupDesignBean.getElement());
            ArrayList<Element> arrayList = new ArrayList<Element>();
            if (!this.processUpdate(markupDesignBean, arrayList)) {
                this.processRefresh();
                this.jsfForm.modelChanged();
                return;
            }
            this.deleteParent = null;
            Element element2 = MarkupService.getRenderedElementForElement((Element)markupDesignBean.getElement());
            if (element2 != null) {
                Node node = element2.getParentNode();
                if (node != null) {
                    this.jsfForm.nodeChanged(element2, node, arrayList.toArray(new Element[arrayList.size()]));
                }
            } else if (element != null) {
                Node node = element.getParentNode();
                this.jsfForm.nodeRemoved(element, node);
            }
        } else if (n == 1) {
            if (!this.processInsert(markupDesignBean)) {
                this.processRefresh();
                this.jsfForm.modelChanged();
                return;
            }
            Element element = MarkupService.getRenderedElementForElement((Element)markupDesignBean.getElement());
            if (element != null) {
                Node node = element.getParentNode();
                this.jsfForm.nodeInserted(element, node);
            }
        } else if (n == 4) {
            this.processRefresh();
            this.jsfForm.modelChanged();
        } else if (n == 3) {
            if (!this.processDelete(markupDesignBean)) {
                this.processRefresh();
                this.jsfForm.modelChanged();
                return;
            }
            this.deleteParent = null;
            Element element = MarkupService.getRenderedElementForElement((Element)markupDesignBean.getElement());
            if (element != null) {
                Node node = element.getParentNode();
                this.jsfForm.nodeRemoved(element, node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processUpdate(MarkupDesignBean markupDesignBean, List<Element> list) {
        int n;
        Object object;
        Object object2;
        Element element = markupDesignBean.getElement();
        Node node = MarkupService.getRenderedElementForElement((Element)element);
        if (node == null) {
            return false;
        }
        Node node2 = node.getParentNode();
        for (Node node3 = node.getPreviousSibling(); node3 != null; node3 = node3.getPreviousSibling()) {
            if (node3.getNodeType() != 1) continue;
            object2 = (Element)node3;
            if (MarkupUnit.getMarkupDesignBeanForElement((Element)object2) != markupDesignBean) break;
            node = node3;
        }
        this.deleteParent = node2;
        object2 = new ArrayList();
        Node node4 = null;
        while (node != null) {
            node4 = node.getNextSibling();
            object2.add(node);
            if (node4 == null || !this.moreElements(node4, markupDesignBean)) break;
            node = node4;
        }
        DocumentFragment documentFragment = this.jsfForm.renderMarkupDesignBean(markupDesignBean, false);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (documentFragment != null) {
            int n2;
            object = documentFragment.getChildNodes();
            int n3 = object.getLength();
            if (n3 == 0) {
                MarkupService.setRenderedElementForElement((Element)markupDesignBean.getElement(), null);
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Node node5 = (Node)iterator.next();
                    node2.removeChild(node5);
                }
                return true;
            }
            n = object.getLength();
            Node[] nodeArray = new Node[n];
            for (n2 = 0; n2 < n; n2 += 1) {
                nodeArray[n2] = object.item(n2);
            }
            for (n2 = 0; n2 < n; n2 += 1) {
                Node node6 = nodeArray[n2];
                if (node6 == null) continue;
                assert (!this.isJspNode(node6));
                arrayList.add(node6);
            }
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Null DocumentFragment for JsfForm, jsfForm=" + this.jsfForm));
            return false;
        }
        if (object2.size() == 1 && arrayList.size() == 1) {
            object = (Node)object2.get(0);
            Node node7 = (Node)arrayList.get(0);
            try {
                if (!this.inlineEditingUpdate && DomSynchronizer.tryUpdateOriginalNode(object, node7, list)) {
                    n = 1;
                    return n != 0;
                }
                list.clear();
                MarkupService.markRenderedNodes((Node)documentFragment);
                node2.replaceChild(node7, (Node)object);
            }
            finally {
                this.inlineEditingUpdate = false;
            }
        } else {
            MarkupService.markRenderedNodes((Node)documentFragment);
            object = object2.iterator();
            while (object.hasNext()) {
                Node node8 = (Node)object.next();
                node2.removeChild(node8);
            }
            for (Node node9 : arrayList) {
                node2.insertBefore(node9, node4);
            }
        }
        return true;
    }

    private static boolean tryUpdateOriginalNode(Node node, Node node2, List<Element> list) {
        if (node.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (node instanceof Element && DomSynchronizer.isExternalElement((Element)node)) {
            return false;
        }
        if (node.isEqualNode(node2)) {
            return true;
        }
        NodeList nodeList = node.getChildNodes();
        NodeList nodeList2 = node2.getChildNodes();
        if (nodeList == null) {
            if (nodeList2 != null) {
                return false;
            }
        } else {
            int n;
            if (nodeList2 == null) {
                return false;
            }
            int n2 = nodeList.getLength();
            if (n2 != (n = nodeList2.getLength())) {
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                boolean bl = DomSynchronizer.tryUpdateOriginalNode(nodeList.item(i), nodeList2.item(i), list);
                if (bl) continue;
                return false;
            }
        }
        String string = node.getNodeValue();
        String string2 = node2.getNodeValue();
        if (string == null && string2 != null || string != null && !string.equals(string2)) {
            node.setNodeValue(string2);
        }
        if (node instanceof Element && node2 instanceof Element) {
            Element element = (Element)node;
            Element element2 = (Element)node2;
            Map<String, Attr> map = DomSynchronizer.getAttributesMap(element);
            Map<String, Attr> map2 = DomSynchronizer.getAttributesMap(element2);
            for (String string3 : map.keySet()) {
                if (map2.containsKey(string3)) continue;
                element.removeAttribute(string3);
                if (list.contains(element)) continue;
                list.add(element);
            }
            for (String string3 : map2.keySet()) {
                Attr attr = map2.get(string3);
                Attr attr2 = map.get(string3);
                if (attr2 == null) {
                    element.setAttributeNode((Attr)attr.cloneNode(false));
                    if (list.contains(element)) continue;
                    list.add(element);
                    continue;
                }
                String string4 = attr2.getValue();
                String string5 = attr.getValue();
                if (string5 == null) {
                    if (string4 == null) continue;
                    element.removeAttribute(string3);
                    if (list.contains(element)) continue;
                    list.add(element);
                    continue;
                }
                if (string5.equals(string4)) continue;
                element.setAttributeNode((Attr)attr.cloneNode(false));
                if (list.contains(element)) continue;
                list.add(element);
            }
        }
        return true;
    }

    private static boolean isExternalElement(Element element) {
        String string = element.getTagName();
        return HtmlTag.FSUBVIEW.name.equals(string) || HtmlTag.JSPINCLUDE.name.equals(string) || HtmlTag.JSPINCLUDEX.name.equals(string) || HtmlTag.IFRAME.name.equals(string);
    }

    private static Map<String, Attr> getAttributesMap(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        HashMap<String, Attr> hashMap = new HashMap<String, Attr>();
        int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = namedNodeMap.item(i);
            if (!(node instanceof Attr)) continue;
            Attr attr = (Attr)node;
            hashMap.put(attr.getName(), attr);
        }
        return hashMap;
    }

    public boolean isBelow(DesignBean designBean, DesignBean designBean2) {
        while (designBean != null) {
            if (designBean == designBean2) {
                return true;
            }
            designBean = designBean.getBeanParent();
        }
        return false;
    }

    public DesignBean getCommonAncestor(DesignBean designBean, DesignBean designBean2) {
        for (designBean = designBean.getBeanParent(); designBean != null; designBean = designBean.getBeanParent()) {
            if (!this.isBelow(designBean2, designBean)) continue;
            return designBean;
        }
        return null;
    }

    private boolean processInsert(MarkupDesignBean markupDesignBean) {
        Node node;
        Element element = markupDesignBean.getElement();
        Node node2 = element.getParentNode();
        Node node3 = element.getNextSibling();
        if (node3 != null) {
            node3 = MarkupService.getRenderedNodeForNode((Node)node3);
        }
        if (node3 != null) {
            node2 = node3.getParentNode();
        } else if (this.deleteParent != null) {
            node2 = this.deleteParent;
        } else {
            while (node2 != null) {
                node = MarkupService.getRenderedNodeForNode((Node)node2);
                if (node != null) {
                    node2 = node;
                    break;
                }
                node2 = node2.getParentNode();
            }
            if (node2 == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("There is no rendered parent for the bean, insert not possible, bean=" + markupDesignBean));
                return false;
            }
        }
        if (node2 != null && this.isJspNode(node2)) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Parent may not be a jsp node, parent=" + node2));
            return false;
        }
        node = this.jsfForm.renderMarkupDesignBean(markupDesignBean);
        this.jsfForm.updateErrorsInComponent();
        if (node != null) {
            int n;
            NodeList nodeList = node.getChildNodes();
            int n2 = nodeList.getLength();
            if (n2 == 0) {
                MarkupService.setRenderedElementForElement((Element)markupDesignBean.getElement(), null);
                return true;
            }
            int n3 = nodeList.getLength();
            Node[] nodeArray = new Node[n3];
            for (n = 0; n < n3; ++n) {
                nodeArray[n] = nodeList.item(n);
            }
            for (n = 0; n < n3; ++n) {
                Node node4 = nodeArray[n];
                if (node4 == null) continue;
                assert (!this.isJspNode(node4));
                node2.insertBefore(node4, node3);
            }
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Null DocumentFragment for JsfForm, jsfForm=" + this.jsfForm));
            return false;
        }
        return true;
    }

    private boolean isJspNode(Node node) {
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node == this.jsfForm.getJspDom();
    }

    private boolean processDelete(MarkupDesignBean markupDesignBean) {
        Node node;
        Element element = markupDesignBean.getElement();
        Node node2 = MarkupService.getRenderedElementForElement((Element)element);
        if (node2 == null) {
            return false;
        }
        Node node3 = node2.getParentNode();
        for (Node node4 = node2.getPreviousSibling(); node4 != null; node4 = node4.getPreviousSibling()) {
            if (node4.getNodeType() != 1) continue;
            node = (Element)node4;
            if (MarkupUnit.getMarkupDesignBeanForElement((Element)node) != markupDesignBean) break;
            node2 = node4;
        }
        this.deleteParent = node3;
        while (node2 != null) {
            node = node2.getNextSibling();
            node3.removeChild(node2);
            if (node == null || !this.moreElements(node, markupDesignBean)) break;
            node2 = node;
        }
        return true;
    }

    private boolean moreElements(Node node, MarkupDesignBean markupDesignBean) {
        while (node != null) {
            if (node instanceof Element && MarkupUnit.getMarkupDesignBeanForElement((Element)((Element)node)) == markupDesignBean) {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    private void processRefresh() {
        this.jsfForm.clearHtml();
        this.jsfForm.getHtmlBody();
        this.jsfForm.updateGridMode();
    }

    public DocumentFragment createSourceFragment(MarkupDesignBean markupDesignBean) {
        Element element = markupDesignBean.getElement();
        Node node = MarkupService.getRenderedElementForElement((Element)element);
        if (node == null) {
            return null;
        }
        Document document = this.jsfForm.getJspDom();
        DocumentFragment documentFragment = document.createDocumentFragment();
        while (node != null) {
            Node node2;
            Node node3 = node.getNextSibling();
            Node node4 = document.importNode(node, true);
            documentFragment.appendChild(node4);
            MarkupService.setJspxNode((Node)node4, (boolean)false);
            MarkupService.markRendered((Node)node4, (Node)node);
            if (node3 == null || (node2 = MarkupService.getSourceNodeForNode((Node)node3)) != null && node2 != element) break;
            node = node3;
        }
        return documentFragment;
    }

    private MarkupDesignBean getRenderTarget(MarkupDesignBean markupDesignBean) {
        for (MarkupDesignBean markupDesignBean2 = markupDesignBean; markupDesignBean2 != null && markupDesignBean2 instanceof MarkupDesignBean; markupDesignBean2 = markupDesignBean2.getBeanParent()) {
            String string;
            Element element;
            Element element2;
            MarkupDesignBean markupDesignBean3 = markupDesignBean2;
            Object object = markupDesignBean2.getInstance();
            if (object instanceof UIComponent && InSyncServiceProvider.isComponentRendersChildren((DesignBean)markupDesignBean2)) {
                markupDesignBean = markupDesignBean3;
            }
            if ((element2 = MarkupService.getRenderedElementForElement((Element)(element = markupDesignBean3.getElement()))) != null) {
                element = element2;
            }
            if ((string = element.getTagName()).equals(HtmlTag.HEAD.name)) {
                return null;
            }
            if (markupDesignBean2 == markupDesignBean && string.equals(HtmlTag.BODY.name)) {
                return null;
            }
            if (markupDesignBean2 != markupDesignBean || element.getParentNode() != null && element.getParentNode().getNodeType() == 1) continue;
            return null;
        }
        return markupDesignBean;
    }

    @Override
    public void handleEvent(Event event) {
        MarkupDesignBean markupDesignBean;
        if (event.getType().equals("DOMDocumentReplaced")) {
            this.updateDomListeners();
            this.jsfForm.documentReplaced();
            return;
        }
        Node node = (Node)((Object)event.getTarget());
        if ((!(node instanceof Element) || ((Element)node).getTagName().equals(HtmlTag.BR.name)) && (node = node.getParentNode()) instanceof Element && (markupDesignBean = InSyncServiceProvider.get().getMarkupDesignBeanForElement((Element)node)) != null) {
            this.requestTextUpdate(markupDesignBean);
            return;
        }
    }

    private void registerDomListeners() {
        if (this.currentDOM instanceof EventTarget) {
            EventTarget eventTarget = (EventTarget)((Object)this.currentDOM);
            eventTarget.addEventListener("DOMAttrModified", this, false);
            eventTarget.addEventListener("DOMNodeInserted", this, false);
            eventTarget.addEventListener("DOMNodeInsertedIntoDocument", this, false);
            eventTarget.addEventListener("DOMNodeRemoved", this, false);
            eventTarget.addEventListener("DOMNodeRemovedFromDocument", this, false);
            eventTarget.addEventListener("DOMCharacterDataModified", this, false);
            eventTarget.addEventListener("DOMDocumentReplaced", this, false);
        }
    }

    public void unregisterDomListeners() {
        if (this.currentDOM instanceof EventTarget) {
            EventTarget eventTarget = (EventTarget)((Object)this.currentDOM);
            eventTarget.removeEventListener("DOMAttrModified", this, false);
            eventTarget.removeEventListener("DOMNodeInserted", this, false);
            eventTarget.removeEventListener("DOMNodeInsertedIntoDocument", this, false);
            eventTarget.removeEventListener("DOMNodeRemoved", this, false);
            eventTarget.removeEventListener("DOMNodeRemovedFromDocument", this, false);
            eventTarget.removeEventListener("DOMCharacterDataModified", this, false);
            eventTarget.removeEventListener("DOMDocumentReplaced", this, false);
        }
    }

    public void updateDomListeners() {
        boolean bl = false;
        if (this.currentDOM != this.jsfForm.getJspDom()) {
            bl = true;
            if (this.currentDOM != null) {
                this.unregisterDomListeners();
            }
            this.currentDOM = this.jsfForm.getJspDom();
            if (this.currentDOM == null) {
                return;
            }
        }
        if (bl) {
            this.registerDomListeners();
        }
    }

    @Override
    public void setSuspended(MarkupDesignBean markupDesignBean, boolean bl) {
        this.setUpdatesSuspended(markupDesignBean, bl);
    }

    static {
        CustomizerDisplayer.setBatchListener((CustomizerDisplayer.BatchListener)new BeanModifyListener());
    }
}

