/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.ResultItem;
import org.netbeans.modules.web.core.syntax.completion.ResultItemPaintComponent;
import org.netbeans.modules.web.core.syntax.spi.AutoTagImporterProvider;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JspCompletionItem {
    private static final int DIRECTIVE_SORT_PRIORITY = 5;
    private static final int DEFAULT_SORT_PRIORITY = 10;

    private static String constructHelp(URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[1000];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            } while (n > 0);
            inputStream.close();
            String string = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String constructHelp(TagInfo tagInfo) {
        if (tagInfo == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h2>").append(JspCompletionItem.getString("LBL_TagName")).append(" ");
        stringBuffer.append(tagInfo.getTagName()).append("</h2>");
        String string = tagInfo.getDisplayName();
        if (string != null) {
            stringBuffer.append("<p>").append(JspCompletionItem.getString("LBL_DisplayName"));
            stringBuffer.append("<i>").append(string).append("</i>");
        }
        if ((string = tagInfo.getInfoString()) != null) {
            stringBuffer.append("<hr>").append(string).append("<hr>");
        }
        stringBuffer.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"1\">");
        stringBuffer.append("<tr bgcolor=\"#CCCCFF\"><td colspan=\"2\"><font size=\"+2\"><b>");
        stringBuffer.append("Tag Information</b></font></td></tr>");
        stringBuffer.append("<tr><td>Tag Class</td><td>");
        if (tagInfo.getTagClassName() != null && !tagInfo.getClass().equals("")) {
            stringBuffer.append(tagInfo.getTagClassName());
        } else {
            stringBuffer.append("<i>None</i>");
        }
        stringBuffer.append("</td></tr><tr><td>Body Content</td><td>");
        stringBuffer.append(tagInfo.getBodyContent());
        stringBuffer.append("</td></tr><tr><td>Display Name</td><td>");
        if (tagInfo.getDisplayName() != null && !tagInfo.getDisplayName().equals("")) {
            stringBuffer.append(tagInfo.getDisplayName());
        } else {
            stringBuffer.append("<i>None</i>");
        }
        stringBuffer.append("</td></tr></table><br>");
        stringBuffer.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"1\">");
        stringBuffer.append("<tr bgcolor=\"#CCCCFF\"><td colspan=\"3\"><font size=\"+2\"><b>Attributes</b></font></td></tr>");
        TagAttributeInfo[] tagAttributeInfoArray = tagInfo.getAttributes();
        if (tagAttributeInfoArray != null && tagAttributeInfoArray.length > 0) {
            stringBuffer.append("<tr><td><b>Name</b></td><td><b>Required</b></td><td><b>Request-time</b></td></tr>");
            for (int i = 0; i < tagAttributeInfoArray.length; ++i) {
                stringBuffer.append("<tr><td>");
                stringBuffer.append(tagAttributeInfoArray[i].getName());
                stringBuffer.append("</td><td>");
                stringBuffer.append(tagAttributeInfoArray[i].isRequired());
                stringBuffer.append("</td><td>");
                stringBuffer.append(tagAttributeInfoArray[i].canBeRequestTime());
                stringBuffer.append("</td></tr>");
            }
        } else {
            stringBuffer.append("<tr><td colspan=\"3\"><i>No Attributes Defined.</i></td></tr>");
        }
        stringBuffer.append("</table><br>");
        stringBuffer.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"1\">");
        stringBuffer.append("<tr bgcolor=\"#CCCCFF\"><td colspan=\"4\"><font size=\"+2\"><b>Variables</b></font></td></tr>");
        TagVariableInfo[] tagVariableInfoArray = tagInfo.getTagVariableInfos();
        if (tagVariableInfoArray != null && tagVariableInfoArray.length > 0) {
            stringBuffer.append("<tr><td><b>Name</b></td><td><b>Type</b></td><td><b>Declare</b></td><td><b>Scope</b></td></tr>");
            for (int i = 0; i < tagVariableInfoArray.length; ++i) {
                stringBuffer.append("<tr><td>");
                if (tagVariableInfoArray[i].getNameGiven() != null && !tagVariableInfoArray[i].getNameGiven().equals("")) {
                    stringBuffer.append(tagVariableInfoArray[i].getNameGiven());
                } else if (tagVariableInfoArray[i].getNameFromAttribute() != null && !tagVariableInfoArray[i].getNameFromAttribute().equals("")) {
                    stringBuffer.append("<i>From attribute '").append(tagVariableInfoArray[i].getNameFromAttribute()).append("'</i>");
                } else {
                    stringBuffer.append("<i>Unknown</i>");
                }
                stringBuffer.append("</td><td><code>");
                if (tagVariableInfoArray[i].getClassName() == null || tagVariableInfoArray[i].getClassName().equals("")) {
                    stringBuffer.append("java.lang.String");
                } else {
                    stringBuffer.append(tagVariableInfoArray[i].getClassName());
                }
                stringBuffer.append("</code></td></tr>");
                stringBuffer.append("</td><td>");
                stringBuffer.append(tagVariableInfoArray[i].getDeclare());
                stringBuffer.append("</td></tr>");
                stringBuffer.append("</td><td>");
                switch (tagVariableInfoArray[i].getScope()) {
                    case 1: {
                        stringBuffer.append("AT_BEGIN");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("AT_END");
                        break;
                    }
                    default: {
                        stringBuffer.append("NESTED");
                    }
                }
                stringBuffer.append("</td></tr>");
            }
        } else {
            stringBuffer.append("<tr><td colspan=\"4\"><i>No Variables Defined.</i></td></tr>");
        }
        stringBuffer.append("</table><br>");
        return stringBuffer.toString();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(JspCompletionItem.class, (String)string);
    }

    public static class ELFunction
    extends ELBean
    implements ELItem {
        private static ResultItemPaintComponent.ELFunctionPaintComponent paintComponent = null;
        private String prefix;
        private String parameters;

        public ELFunction(String string, String string2, String string3, String string4) {
            super(string2, string3);
            this.prefix = string;
            this.parameters = string4;
        }

        public Component getPaintComponent(boolean bl) {
            if (paintComponent == null) {
                paintComponent = new ResultItemPaintComponent.ELFunctionPaintComponent();
            }
            paintComponent.setString(this.text);
            paintComponent.setTypeName(this.type);
            paintComponent.setPrefix(this.prefix);
            paintComponent.setParameters(this.parameters);
            return paintComponent;
        }

        public int getSortPriority() {
            return 12;
        }

        public String getItemText() {
            return this.prefix + ":" + this.text + "()";
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            return this.substituteText(jTextComponent, n, n2, this.getItemText(), 1);
        }
    }

    public static class ELProperty
    extends ELBean
    implements ELItem {
        private static ResultItemPaintComponent.ELPropertyPaintComponent paintComponent = null;

        public ELProperty(String string, String string2) {
            super(string, string2);
        }

        public Component getPaintComponent(boolean bl) {
            if (paintComponent == null) {
                paintComponent = new ResultItemPaintComponent.ELPropertyPaintComponent();
            }
            paintComponent.setString(this.text);
            paintComponent.setTypeName(this.type);
            return paintComponent;
        }
    }

    public static class ELBean
    extends JspResultItem
    implements ELItem {
        private static ResultItemPaintComponent.ELBeanPaintComponent paintComponent = null;
        protected String type;

        public ELBean(String string, String string2) {
            super(string);
            this.type = string2.lastIndexOf(46) > -1 ? string2.substring(string2.lastIndexOf(46) + 1) : string2;
        }

        public int getSortPriority() {
            return 10;
        }

        public Component getPaintComponent(boolean bl) {
            if (paintComponent == null) {
                paintComponent = new ResultItemPaintComponent.ELBeanPaintComponent();
            }
            paintComponent.setString(this.text);
            paintComponent.setTypeName(this.type);
            return paintComponent;
        }
    }

    public static class ELImplicitObject
    extends JspResultItem
    implements ELItem {
        private static ResultItemPaintComponent.ELImplicitObjectPaintComponent paintComponent = null;
        int type;

        ELImplicitObject(String string, int n) {
            super(string);
            this.type = n;
        }

        public int getSortPriority() {
            return 15;
        }

        public Component getPaintComponent(boolean bl) {
            if (paintComponent == null) {
                paintComponent = new ResultItemPaintComponent.ELImplicitObjectPaintComponent();
            }
            paintComponent.setString(this.text);
            paintComponent.setType(this.type);
            return paintComponent;
        }

        public String getItemText() {
            String string = this.text;
            if (this.type == 1) {
                string = string + "[]";
            }
            return string;
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            if (this.type == 1) {
                return this.substituteText(jTextComponent, n, n2, this.getItemText(), 1);
            }
            return this.substituteText(jTextComponent, n, n2, this.getItemText(), 0);
        }
    }

    public static interface ELItem {
    }

    public static class FileAttributeValue
    extends JspResultItem {
        private ImageIcon icon;
        private Color color;

        FileAttributeValue(String string, Color color) {
            this(string, color, null);
        }

        FileAttributeValue(String string, Color color, ImageIcon imageIcon) {
            super(string);
            this.color = color;
            this.icon = imageIcon;
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            return this.substituteText(jTextComponent, n, n2, this.getItemText(), 0);
        }

        public Component getPaintComponent(final boolean bl) {
            return new ResultItemPaintComponent(){

                public void draw(Graphics graphics) {
                    this.drawIcon(graphics, FileAttributeValue.this.icon);
                    this.drawString(graphics, FileAttributeValue.this.text, FileAttributeValue.this.color);
                }

                public boolean isSelected() {
                    return bl;
                }
            };
        }
    }

    static class AttributeValue
    extends JspResultItem {
        AttributeValue(String string) {
            super(string);
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            return this.substituteText(jTextComponent, n, n2, this.getItemText(), 0);
        }
    }

    public static class Attribute
    extends JspResultItem {
        private TagAttributeInfo tagAttributeInfo;
        private boolean required;
        private static ResultItemPaintComponent.JspTagPaintComponent component = null;
        private static ResultItemPaintComponent.JspTagPaintComponent componentRequired = null;

        Attribute(String string) {
            super(string);
            this.tagAttributeInfo = null;
            this.required = false;
        }

        Attribute(TagAttributeInfo tagAttributeInfo) {
            super(tagAttributeInfo.getName());
            this.required = tagAttributeInfo.isRequired();
            this.tagAttributeInfo = tagAttributeInfo;
            if (tagAttributeInfo.getTypeName() == null && tagAttributeInfo.isFragment()) {
                this.setHelp("fragment");
            } else {
                this.setHelp(tagAttributeInfo.getTypeName());
            }
        }

        public Component getPaintComponent(boolean bl) {
            ResultItemPaintComponent resultItemPaintComponent;
            ResultItemPaintComponent.JspTagPaintComponent jspTagPaintComponent = resultItemPaintComponent = this.required ? componentRequired : component;
            if (resultItemPaintComponent == null) {
                resultItemPaintComponent = new ResultItemPaintComponent.AttributePaintComponent(this.required);
            }
            resultItemPaintComponent.setSelected(bl);
            resultItemPaintComponent.setString(this.getItemText());
            return resultItemPaintComponent;
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            return this.substituteText(jTextComponent, n, n2, this.getItemText() + "=\"\"", 1);
        }

        public String getHelp() {
            URL uRL = super.getHelpURL();
            if (uRL != null) {
                String string;
                int n;
                String string2 = uRL.toString();
                int n2 = string2.indexOf(35) + 1;
                String string3 = n2 < (n = string2.lastIndexOf(35) + 1) ? string2.substring(n2, n - 1) : string2.substring(n2);
                String string4 = JspCompletionItem.constructHelp(this.getHelpURL());
                n2 = string4.indexOf(string3);
                if (n2 > 0 && (n2 = n2 + string3.length() + 2) < string4.length()) {
                    string4 = string4.substring(n2);
                }
                if ((n = string4.indexOf(string = string2.substring(n))) > 0) {
                    string4 = string4.substring(0, n);
                }
                return string4;
            }
            if (this.tagAttributeInfo != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<table border=\"0\"><tr><td><b>Name:</b></td><td>");
                stringBuffer.append(this.tagAttributeInfo.getName());
                stringBuffer.append("</td></tr><tr><td><b>Required:</b></td><td>");
                stringBuffer.append(this.tagAttributeInfo.isRequired());
                stringBuffer.append("</td></tr><tr><td><b>Request-time:</b></td><td>");
                stringBuffer.append(this.tagAttributeInfo.canBeRequestTime());
                stringBuffer.append("</td></tr><tr><td><b>Fragment:</b></td><td>");
                stringBuffer.append(this.tagAttributeInfo.isFragment());
                stringBuffer.append("</td></tr></table>");
                return stringBuffer.toString();
            }
            return super.getHelp();
        }

        public URL getHelpURL() {
            URL uRL = super.getHelpURL();
            if (uRL != null) {
                String string = uRL.toString();
                int n = string.lastIndexOf(35);
                if (n > 0) {
                    string = string.substring(0, n);
                }
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return uRL;
        }
    }

    static class Directive
    extends TagDirective {
        TagInfo tagInfo;

        Directive(String string) {
            super(string);
            this.tagInfo = null;
        }

        Directive(String string, TagInfo tagInfo) {
            super(string);
            this.tagInfo = tagInfo;
            if (tagInfo != null) {
                this.setHelp(tagInfo.getInfoString());
            }
        }

        public int getSortPriority() {
            return 5;
        }

        public String getHelp() {
            String string;
            if (this.getHelpURL() != null && (string = JspCompletionItem.constructHelp(this.getHelpURL())) != null) {
                string = string.substring(string.indexOf("<h2>"));
                string = string.substring(0, string.lastIndexOf("<h4>"));
                return string;
            }
            return JspCompletionItem.constructHelp(this.tagInfo);
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            return this.substituteText(jTextComponent, n, n2, "%@ " + this.getItemText() + "  %>", 3);
        }

        public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
            return super.substituteCommonText(jTextComponent, n += 2, n2 -= 2, n3);
        }

        public Component getPaintComponent(boolean bl) {
            if (component == null) {
                component = new ResultItemPaintComponent.JspDirectivePaintComponent();
            }
            component.setSelected(bl);
            component.setString(this.getItemText());
            return component;
        }
    }

    public static class Tag
    extends JspResultItem {
        protected static ResultItemPaintComponent.JspTagPaintComponent component = null;
        private TagInfo ti = null;

        public Tag(String string) {
            super(string);
        }

        public Tag(String string, TagInfo tagInfo) {
            this(string);
            this.ti = tagInfo;
            if (tagInfo != null) {
                this.setHelp(tagInfo.getInfoString());
            }
        }

        public boolean hasHelp() {
            return true;
        }

        public TagInfo getTagInfo() {
            return this.ti;
        }

        public String getHelp() {
            URL uRL = super.getHelpURL();
            if (uRL != null) {
                String string = uRL.toString();
                int n = string.indexOf(35) + 1;
                String string2 = JspCompletionItem.constructHelp(uRL);
                if (n > 0) {
                    int n2 = string.lastIndexOf(35) + 1;
                    String string3 = string.substring(n, n2 - 1);
                    String string4 = string.substring(n2);
                    n = string2.indexOf(string3);
                    if (n > 0 && (n = n + string3.length() + 2) < string2.length()) {
                        string2 = string2.substring(n);
                    }
                    if ((n2 = string2.indexOf(string4)) > 0) {
                        string2 = string2.substring(0, n2);
                    }
                    return string2;
                }
                string2 = string2.substring(string2.indexOf("<h2>"));
                string2 = string2.substring(0, string2.lastIndexOf("<h4>"));
                return string2;
            }
            return JspCompletionItem.constructHelp(this.ti);
        }

        public Component getPaintComponent(boolean bl) {
            if (component == null) {
                component = new ResultItemPaintComponent.JspTagPaintComponent(false);
            }
            component.setSelected(bl);
            component.setString(this.text);
            return component;
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            if (!this.getItemText().startsWith("/")) {
                return this.substituteText(jTextComponent, n, n2, this.getItemText() + " ", 0);
            }
            return this.substituteText(jTextComponent, n, n2, this.getItemText().substring(1) + ">", 0);
        }

        public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
            if (!this.getItemText().startsWith("/")) {
                return this.substituteText(jTextComponent, n, n2, this.getItemText().substring(n3), 0);
            }
            return this.substituteText(jTextComponent, n, n2, this.getItemText().substring(1, n3), 0);
        }
    }

    public static abstract class TagDirective
    extends JspResultItem {
        protected static ResultItemPaintComponent component = null;

        TagDirective(String string) {
            super(string);
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            return this.substituteText(jTextComponent, n, n2, this.getItemText() + " ", 0);
        }

        public boolean instantSubstitutionEnabled(JTextComponent jTextComponent) {
            return true;
        }

        public Component getPaintComponent(boolean bl) {
            if (component == null) {
                component = new ResultItemPaintComponent.JspTagPaintComponent(false);
            }
            component.setSelected(bl);
            component.setString(this.text);
            return component;
        }
    }

    public static class PrefixTag
    extends JspResultItem {
        private TagInfo tagInfo;
        private boolean isEmpty = false;
        private boolean hasAttributes = false;
        private static ResultItemPaintComponent.JspTagPaintComponent component = null;
        private static ResultItemPaintComponent.JspTagPaintComponent componentEmpty = null;

        PrefixTag(String string) {
            super(string);
        }

        PrefixTag(String string, TagInfo tagInfo, SyntaxElement.Tag tag) {
            this(string + ":" + tagInfo.getTagName());
            this.tagInfo = tagInfo;
            if (this.tagInfo != null && this.tagInfo.getBodyContent().equalsIgnoreCase("empty")) {
                this.isEmpty = true;
            }
            if (this.tagInfo != null) {
                this.setHelp(this.tagInfo.getInfoString());
            }
            if (tag != null) {
                this.hasAttributes = tag.getAttributes().size() != 0;
            }
        }

        PrefixTag(String string, TagInfo tagInfo) {
            this(string, tagInfo, null);
        }

        public boolean hasHelp() {
            return true;
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }

        public String getHelp() {
            URL uRL = super.getHelpURL();
            if (uRL != null) {
                String string = uRL.toString();
                int n = string.indexOf(35) + 1;
                String string2 = JspCompletionItem.constructHelp(uRL);
                if (n > 0) {
                    int n2 = string.lastIndexOf(35) + 1;
                    String string3 = string.substring(n, n2 - 1);
                    String string4 = string.substring(n2);
                    n = string2.indexOf(string3);
                    if (n > 0 && (n = n + string3.length() + 2) < string2.length()) {
                        string2 = string2.substring(n);
                    }
                    if ((n2 = string2.indexOf(string4)) > 0) {
                        string2 = string2.substring(0, n2);
                    }
                    return string2;
                }
                string2 = string2.substring(string2.indexOf("<h2>"));
                string2 = string2.substring(0, string2.lastIndexOf("<h4>"));
                return string2;
            }
            return JspCompletionItem.constructHelp(this.tagInfo);
        }

        public Component getPaintComponent(boolean bl) {
            ResultItemPaintComponent.JspTagPaintComponent jspTagPaintComponent;
            ResultItemPaintComponent.JspTagPaintComponent jspTagPaintComponent2 = jspTagPaintComponent = this.isEmpty ? componentEmpty : component;
            if (jspTagPaintComponent == null) {
                jspTagPaintComponent = new ResultItemPaintComponent.JspTagPaintComponent(this.isEmpty);
            }
            jspTagPaintComponent.setSelected(bl);
            jspTagPaintComponent.setString(this.text);
            return jspTagPaintComponent;
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            String string;
            String string2 = string = this.isEmpty ? "/>" : ">";
            if (this.hasAttributes) {
                string = "";
            }
            if (!this.getItemText().startsWith("/")) {
                if (!bl) {
                    return this.substituteText(jTextComponent, n, n2, this.getItemText(), 0);
                }
                boolean bl2 = true;
                if (this.tagInfo != null) {
                    TagAttributeInfo[] tagAttributeInfoArray = this.tagInfo.getAttributes();
                    boolean bl3 = tagAttributeInfoArray != null ? tagAttributeInfoArray.length > 0 : (bl2 = true);
                }
                if (bl2) {
                    return this.substituteText(jTextComponent, n, n2, this.getItemText() + (this.hasAttributes ? "" : " ") + string, string.length());
                }
                return this.substituteText(jTextComponent, n, n2, this.getItemText() + string, 0);
            }
            return this.substituteText(jTextComponent, n, n2, this.getItemText().substring(1) + ">", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean substituteText(JTextComponent jTextComponent, int n, int n2, String string, int n3) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            boolean bl = super.substituteText(jTextComponent, n, n2, string, n3);
            try {
                baseDocument.atomicLock();
                String string2 = NbEditorUtilities.getFileObject((Document)jTextComponent.getDocument()).getMIMEType();
                Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)string2));
                Collection collection = lookup.lookup(new Lookup.Template(AutoTagImporterProvider.class)).allInstances();
                if (collection != null) {
                    for (AutoTagImporterProvider autoTagImporterProvider : collection) {
                        autoTagImporterProvider.importLibrary(jTextComponent.getDocument(), this.tagInfo.getTagLibrary().getPrefixString(), this.tagInfo.getTagLibrary().getURI());
                    }
                }
            }
            finally {
                baseDocument.atomicUnlock();
            }
            return bl;
        }
    }

    public static abstract class JspResultItem
    extends ResultItem {
        protected String help;
        protected String text;
        private static ResultItemPaintComponent component = null;

        public JspResultItem(String string) {
            this.text = string;
            this.help = null;
        }

        public JspResultItem(String string, String string2) {
            this(string);
            this.help = string2;
        }

        public String getItemText() {
            return this.text;
        }

        protected Object getAssociatedObject() {
            return this.text;
        }

        public int getSortPriority() {
            return 10;
        }

        public CharSequence getInsertPrefix() {
            return this.getItemText();
        }

        public Component getPaintComponent(boolean bl) {
            if (component == null) {
                component = new ResultItemPaintComponent.StringPaintComponent();
            }
            component.setSelected(bl);
            component.setString(this.text);
            return component;
        }

        public URL getHelpURL() {
            if (this.help == null || this.help.equals("")) {
                return null;
            }
            try {
                return new URL(this.help);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public String getHelp() {
            return this.help;
        }

        public boolean hasHelp() {
            return this.help != null && this.help.length() > 0;
        }

        public void setHelp(String string) {
            this.help = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean substituteText(JTextComponent jTextComponent, int n, int n2, String string, int n3) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            try {
                Object object;
                baseDocument.atomicLock();
                try {
                    object = baseDocument.getText(n, baseDocument.getLength() - n < string.length() ? baseDocument.getLength() - n : string.length());
                    if (!string.substring(0, string.length() - 1).equals(object)) {
                        baseDocument.remove(n, n2);
                        baseDocument.insertString(n, string, null);
                    } else {
                        jTextComponent.setCaretPosition(jTextComponent.getCaret().getDot() + string.length() - n2);
                    }
                }
                finally {
                    baseDocument.atomicUnlock();
                }
                this.reformat(jTextComponent);
                if (n3 != 0) {
                    object = jTextComponent.getCaret();
                    int n4 = object.getDot();
                    object.setDot(n4 - n3);
                }
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reformat(JTextComponent jTextComponent) {
            try {
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n = jTextComponent.getCaretPosition();
                Reformat reformat = Reformat.get((Document)baseDocument);
                reformat.lock();
                try {
                    baseDocument.atomicLock();
                    try {
                        int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                        int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                        reformat.reformat(n2, n3);
                    }
                    finally {
                        baseDocument.atomicUnlock();
                    }
                }
                finally {
                    reformat.unlock();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public String getPaintText() {
            return this.getItemText();
        }
    }
}

