/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.java.JavaCompletionProvider;
import org.netbeans.modules.web.core.syntax.SimplifiedJSPServlet;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.filesystems.FileObject;

public class JavaJSPCompletionProvider
implements CompletionProvider {
    private final JavaCompletionProvider javaCompletionProvider = new JavaCompletionProvider();
    private static final Logger logger = Logger.getLogger(JavaJSPCompletionProvider.class.getName());

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        int n2;
        BaseDocument baseDocument;
        if ((n & 1) != 0 && this.isWithinScriptlet((Document)(baseDocument = Utilities.getDocument((JTextComponent)jTextComponent)), n2 = jTextComponent.getCaret().getDot())) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new EmbeddedJavaCompletionQuery(jTextComponent, n), jTextComponent);
        }
        return null;
    }

    private boolean isWithinScriptlet(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            TokenId tokenId = tokenSequence.token().id();
            if (tokenId == JspTokenId.SCRIPTLET) {
                return true;
            }
            if (tokenId == JspTokenId.SYMBOL2) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == JspTokenId.SCRIPTLET) {
                    return true;
                }
            }
        }
        return false;
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        return this.javaCompletionProvider.getAutoQueryTypes(jTextComponent, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompletionQueryDelegatedToJava
    extends SimplifiedJSPServlet.VirtualJavaClass {
        private int caretOffset;
        private int queryType;
        private int shiftedOffset;
        private List<? extends CompletionItem> completionItems;

        CompletionQueryDelegatedToJava(int n, int n2, int n3) {
            this.caretOffset = n;
            this.shiftedOffset = n2;
            this.queryType = n3;
        }

        @Override
        protected void process(FileObject fileObject, JavaSource javaSource) {
            try {
                this.completionItems = JavaCompletionProvider.query((JavaSource)javaSource, (int)this.queryType, (int)this.shiftedOffset, (int)this.caretOffset);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }

        List<? extends CompletionItem> getCompletionItems() {
            return this.completionItems;
        }
    }

    static class EmbeddedJavaCompletionQuery
    extends AsyncCompletionQuery {
        protected int queryType;
        protected JTextComponent component;

        public EmbeddedJavaCompletionQuery(JTextComponent jTextComponent, int n) {
            this.queryType = n;
            this.component = jTextComponent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            SimplifiedJSPServlet simplifiedJSPServlet = new SimplifiedJSPServlet(document);
            try {
                simplifiedJSPServlet.process();
                String string = simplifiedJSPServlet.getVirtualClassBody();
                int n2 = simplifiedJSPServlet.getShiftedOffset(n);
                if (n2 >= 0) {
                    logger.fine("JSP CC: delegating CC query to java file:\n" + string.substring(0, n2) + "|" + string.substring(n2) + "\n");
                    CompletionQueryDelegatedToJava completionQueryDelegatedToJava = new CompletionQueryDelegatedToJava(n, n2, this.queryType);
                    completionQueryDelegatedToJava.create(document, string);
                    List<? extends CompletionItem> list = completionQueryDelegatedToJava.getCompletionItems();
                    completionResultSet.addAllItems(list);
                } else {
                    logger.severe("caretOffset outside of embedded java code");
                }
            }
            catch (BadLocationException badLocationException) {
                logger.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
            finally {
                completionResultSet.finish();
            }
        }
    }
}

