/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.optimizer.Codegen;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptRuntime;

class BodyCodegen {
    private static final int JAVASCRIPT_EXCEPTION = 0;
    private static final int EVALUATOR_EXCEPTION = 1;
    private static final int ECMAERROR_EXCEPTION = 2;
    ClassFileWriter cfw;
    Codegen codegen;
    CompilerEnvirons compilerEnv;
    ScriptOrFnNode scriptOrFn;
    private OptFunctionNode fnCurrent;
    private boolean isTopLevel;
    private static final int MAX_LOCALS = 256;
    private boolean[] locals;
    private short firstFreeLocal;
    private short localsMax;
    private int itsLineNumber;
    private boolean hasVarsInRegs;
    private short[] varRegisters;
    private boolean inDirectCallFunction;
    private boolean itsForcedObjectParameters;
    private int enterAreaStartLabel;
    private int epilogueLabel;
    private short variableObjectLocal;
    private short popvLocal;
    private short contextLocal;
    private short argsLocal;
    private short thisObjLocal;
    private short funObjLocal;
    private short itsZeroArgArray;
    private short itsOneArgArray;
    private short scriptRegexpLocal;

    BodyCodegen() {
    }

    void generateBodyCode() {
        this.initBodyGeneration();
        this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn), this.codegen.getBodyMethodSignature(this.scriptOrFn), (short)10);
        this.generatePrologue();
        Node node = this.fnCurrent != null ? this.scriptOrFn.getLastChild() : this.scriptOrFn;
        this.generateStatement(node);
        this.generateEpilogue();
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void initBodyGeneration() {
        this.isTopLevel = this.scriptOrFn == this.codegen.scriptOrFnNodes[0];
        this.varRegisters = null;
        if (this.scriptOrFn.getType() == 105) {
            int n;
            this.fnCurrent = OptFunctionNode.get(this.scriptOrFn);
            boolean bl = this.hasVarsInRegs = !this.fnCurrent.fnode.requiresActivation();
            if (this.hasVarsInRegs && (n = this.fnCurrent.fnode.getParamAndVarCount()) != 0) {
                this.varRegisters = new short[n];
            }
            this.inDirectCallFunction = this.fnCurrent.isTargetOfDirectCall();
            if (this.inDirectCallFunction && !this.hasVarsInRegs) {
                Codegen.badTree();
            }
        } else {
            this.fnCurrent = null;
            this.hasVarsInRegs = false;
            this.inDirectCallFunction = false;
        }
        this.locals = new boolean[256];
        this.funObjLocal = 0;
        this.contextLocal = 1;
        this.variableObjectLocal = (short)2;
        this.thisObjLocal = (short)3;
        this.localsMax = (short)4;
        this.firstFreeLocal = (short)4;
        this.popvLocal = (short)-1;
        this.argsLocal = (short)-1;
        this.itsZeroArgArray = (short)-1;
        this.itsOneArgArray = (short)-1;
        this.scriptRegexpLocal = (short)-1;
        this.epilogueLabel = -1;
        this.enterAreaStartLabel = -1;
    }

    private void generatePrologue() {
        String string;
        int n;
        int n2;
        int n3;
        if (this.inDirectCallFunction) {
            n3 = this.scriptOrFn.getParamCount();
            if (this.firstFreeLocal != 4) {
                Kit.codeBug();
            }
            for (n2 = 0; n2 != n3; ++n2) {
                this.varRegisters[n2] = this.firstFreeLocal;
                this.firstFreeLocal = (short)(this.firstFreeLocal + 3);
            }
            if (!this.fnCurrent.getParameterNumberContext()) {
                this.itsForcedObjectParameters = true;
                for (n2 = 0; n2 != n3; ++n2) {
                    n = this.varRegisters[n2];
                    this.cfw.addALoad(n);
                    this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n4 = this.cfw.acquireLabel();
                    this.cfw.add(166, n4);
                    this.cfw.addDLoad(n + 1);
                    this.addDoubleWrap();
                    this.cfw.addAStore(n);
                    this.cfw.markLabel(n4);
                }
            }
        }
        if (!(this.fnCurrent == null || this.inDirectCallFunction || this.compilerEnv.isUseDynamicScope() && !this.fnCurrent.fnode.getIgnoreDynamicScope())) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke(185, "org/mozilla/javascript/Scriptable", "getParentScope", "()Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
        }
        short s = this.firstFreeLocal;
        this.firstFreeLocal = (short)(s + 1);
        this.argsLocal = s;
        this.localsMax = this.firstFreeLocal;
        if (this.fnCurrent == null && this.scriptOrFn.getRegexpCount() != 0) {
            this.scriptRegexpLocal = this.getNewWordLocal();
            this.codegen.pushRegExpArray(this.cfw, this.scriptOrFn, this.contextLocal, this.variableObjectLocal);
            this.cfw.addAStore(this.scriptRegexpLocal);
        }
        if (this.hasVarsInRegs) {
            n3 = this.scriptOrFn.getParamCount();
            if (n3 > 0 && !this.inDirectCallFunction) {
                this.cfw.addALoad(this.argsLocal);
                this.cfw.add(190);
                this.cfw.addPush(n3);
                n2 = this.cfw.acquireLabel();
                this.cfw.add(162, n2);
                this.cfw.addALoad(this.argsLocal);
                this.cfw.addPush(n3);
                this.addScriptRuntimeInvoke("padArguments", "([Ljava/lang/Object;I)[Ljava/lang/Object;");
                this.cfw.addAStore(this.argsLocal);
                this.cfw.markLabel(n2);
            }
            n2 = this.fnCurrent.fnode.getParamCount();
            n = this.fnCurrent.fnode.getParamAndVarCount();
            boolean[] blArray = this.fnCurrent.fnode.getParamAndVarConst();
            int n5 = -1;
            for (int i = 0; i != n; ++i) {
                int n6 = -1;
                if (i < n2) {
                    if (!this.inDirectCallFunction) {
                        n6 = this.getNewWordLocal();
                        this.cfw.addALoad(this.argsLocal);
                        this.cfw.addPush(i);
                        this.cfw.add(50);
                        this.cfw.addAStore(n6);
                    }
                } else if (this.fnCurrent.isNumberVar(i)) {
                    n6 = this.getNewWordPairLocal(blArray[i]);
                    this.cfw.addPush(0.0);
                    this.cfw.addDStore(n6);
                } else {
                    n6 = this.getNewWordLocal(blArray[i]);
                    if (n5 == -1) {
                        Codegen.pushUndefined(this.cfw);
                        n5 = n6;
                    } else {
                        this.cfw.addALoad(n5);
                    }
                    this.cfw.addAStore(n6);
                }
                if (n6 >= 0) {
                    if (blArray[i]) {
                        this.cfw.addPush(0);
                        this.cfw.addIStore(n6 + (this.fnCurrent.isNumberVar(i) ? 2 : 1));
                    }
                    this.varRegisters[i] = n6;
                }
                if (!this.compilerEnv.isGenerateDebugInfo()) continue;
                String string2 = this.fnCurrent.fnode.getParamOrVarName(i);
                String string3 = this.fnCurrent.isNumberVar(i) ? "D" : "Ljava/lang/Object;";
                int n7 = this.cfw.getCurrentCodeOffset();
                if (n6 < 0) {
                    n6 = this.varRegisters[i];
                }
                this.cfw.addVariableDescriptor(string2, string3, n7, n6);
            }
            return;
        }
        if (this.fnCurrent != null) {
            string = "activation";
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.argsLocal);
            this.addScriptRuntimeInvoke("createFunctionActivation", "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("enterActivationFunction", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)V");
        } else {
            string = "global";
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addPush(0);
            this.addScriptRuntimeInvoke("initScript", "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Z)V");
        }
        this.enterAreaStartLabel = this.cfw.acquireLabel();
        this.epilogueLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(this.enterAreaStartLabel);
        n2 = this.scriptOrFn.getFunctionCount();
        for (n = 0; n != n2; ++n) {
            OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFn, n);
            if (optFunctionNode.fnode.getFunctionType() != 1) continue;
            this.visitFunction(optFunctionNode, 1);
        }
        if (this.compilerEnv.isGenerateDebugInfo()) {
            this.cfw.addVariableDescriptor(string, "Lorg/mozilla/javascript/Scriptable;", this.cfw.getCurrentCodeOffset(), this.variableObjectLocal);
        }
        if (this.fnCurrent == null) {
            this.popvLocal = this.getNewWordLocal();
            Codegen.pushUndefined(this.cfw);
            this.cfw.addAStore(this.popvLocal);
            n = this.scriptOrFn.getEndLineno();
            if (n != -1) {
                this.cfw.addLineNumberEntry((short)n);
            }
        } else {
            if (this.fnCurrent.itsContainsCalls0) {
                this.itsZeroArgArray = this.getNewWordLocal();
                this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
                this.cfw.addAStore(this.itsZeroArgArray);
            }
            if (this.fnCurrent.itsContainsCalls1) {
                this.itsOneArgArray = this.getNewWordLocal();
                this.cfw.addPush(1);
                this.cfw.add(189, "java/lang/Object");
                this.cfw.addAStore(this.itsOneArgArray);
            }
        }
    }

    private void generateEpilogue() {
        if (this.hasVarsInRegs) {
            if (this.epilogueLabel != -1) {
                this.cfw.markLabel(this.epilogueLabel);
            }
            this.cfw.add(176);
            return;
        }
        this.cfw.markLabel(this.epilogueLabel);
        if (this.fnCurrent == null) {
            this.cfw.addALoad(this.popvLocal);
            this.cfw.add(176);
        } else {
            this.generateActivationExit();
            this.cfw.add(176);
            int n = this.cfw.acquireLabel();
            this.cfw.markHandler(n);
            short s = this.getNewWordLocal();
            this.cfw.addAStore(s);
            this.generateActivationExit();
            this.cfw.addALoad(s);
            this.releaseWordLocal(s);
            this.cfw.add(191);
            this.cfw.addExceptionHandler(this.enterAreaStartLabel, this.epilogueLabel, n, null);
        }
    }

    private void generateActivationExit() {
        if (this.fnCurrent == null || this.hasVarsInRegs) {
            throw Kit.codeBug();
        }
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("exitActivationFunction", "(Lorg/mozilla/javascript/Context;)V");
    }

    private void generateStatement(Node node) {
        this.updateLineNumber(node);
        int n = node.getType();
        switch (n) {
            case 119: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 132: {
                Node node2;
                for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    this.generateStatement(node2);
                }
                break;
            }
            case 137: {
                Node node2;
                short s = this.getNewWordLocal();
                node.putIntProp(2, s);
                while (node2 != null) {
                    this.generateStatement(node2);
                    node2 = node2.getNext();
                }
                this.releaseWordLocal(s);
                node.removeProp(2);
                break;
            }
            case 105: {
                int n2 = node.getExistingIntProp(1);
                OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFn, n2);
                int n3 = optFunctionNode.fnode.getFunctionType();
                if (n3 == 3) {
                    this.visitFunction(optFunctionNode, n3);
                    break;
                }
                if (n3 == 1) break;
                throw Codegen.badTree();
            }
            case 77: {
                Node node2;
                this.visitTryCatchFinally((Node.Jump)node, node2);
                break;
            }
            case 56: {
                Node node2;
                int n4 = this.getLocalBlockRegister(node);
                int n5 = node.getExistingIntProp(14);
                String string = node2.getString();
                node2 = node2.getNext();
                this.generateExpression(node2, node);
                if (n5 == 0) {
                    this.cfw.add(1);
                } else {
                    this.cfw.addALoad(n4);
                }
                this.cfw.addPush(string);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("newCatchScope", "(Ljava/lang/Throwable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
                this.cfw.addAStore(n4);
                break;
            }
            case 49: {
                Node node2;
                this.generateExpression(node2, node);
                this.cfw.add(187, "org/mozilla/javascript/JavaScriptException");
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addPush(this.scriptOrFn.getSourceName());
                this.cfw.addPush(this.itsLineNumber);
                this.cfw.addInvoke(183, "org/mozilla/javascript/JavaScriptException", "<init>", "(Ljava/lang/Object;Ljava/lang/String;I)V");
                this.cfw.add(191);
                break;
            }
            case 50: {
                this.cfw.addALoad(this.getLocalBlockRegister(node));
                this.cfw.add(191);
                break;
            }
            case 4: 
            case 62: {
                Node node2;
                if (node2 != null) {
                    this.generateExpression(node2, node);
                } else if (n == 4) {
                    Codegen.pushUndefined(this.cfw);
                } else {
                    if (this.popvLocal < 0) {
                        throw Codegen.badTree();
                    }
                    this.cfw.addALoad(this.popvLocal);
                }
                if (this.epilogueLabel == -1) {
                    if (!this.hasVarsInRegs) {
                        throw Codegen.badTree();
                    }
                    this.epilogueLabel = this.cfw.acquireLabel();
                }
                this.cfw.add(167, this.epilogueLabel);
                break;
            }
            case 110: {
                Node node2;
                this.visitSwitch((Node.Jump)node, node2);
                break;
            }
            case 2: {
                Node node2;
                this.generateExpression(node2, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("enterWith", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
                this.cfw.addAStore(this.variableObjectLocal);
                break;
            }
            case 3: {
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("leaveWith", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
                this.cfw.addAStore(this.variableObjectLocal);
                break;
            }
            case 57: 
            case 58: {
                Node node2;
                this.generateExpression(node2, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(n == 58);
                this.addScriptRuntimeInvoke("enumInit", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Z)Ljava/lang/Object;");
                this.cfw.addAStore(this.getLocalBlockRegister(node));
                break;
            }
            case 129: {
                Node node2;
                if (node2.getType() == 55) {
                    this.visitSetVar(node2, node2.getFirstChild(), false);
                    break;
                }
                if (node2.getType() == 151) {
                    this.visitSetConstVar(node2, node2.getFirstChild(), false);
                    break;
                }
                this.generateExpression(node2, node);
                if (node.getIntProp(8, -1) != -1) {
                    this.cfw.add(88);
                    break;
                }
                this.cfw.add(87);
                break;
            }
            case 130: {
                Node node2;
                this.generateExpression(node2, node);
                if (this.popvLocal < 0) {
                    this.popvLocal = this.getNewWordLocal();
                }
                this.cfw.addAStore(this.popvLocal);
                break;
            }
            case 127: {
                int n6 = this.getTargetLabel(node);
                this.cfw.markLabel(n6);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 131: {
                Node node2;
                this.visitGOTO((Node.Jump)node, n, node2);
                break;
            }
            case 121: {
                Node node2;
                short s = this.getNewWordLocal();
                this.cfw.addAStore(s);
                while (node2 != null) {
                    this.generateStatement(node2);
                    node2 = node2.getNext();
                }
                this.cfw.add(169, s);
                this.releaseWordLocal(s);
                break;
            }
            default: {
                throw Codegen.badTree();
            }
        }
    }

    private void generateExpression(Node node, Node node2) {
        int n = node.getType();
        block0 : switch (n) {
            case 134: {
                break;
            }
            case 105: {
                if (this.fnCurrent == null && node2.getType() == 132) break;
                int n2 = node.getExistingIntProp(1);
                OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFn, n2);
                int n3 = optFunctionNode.fnode.getFunctionType();
                if (n3 != 2) {
                    throw Codegen.badTree();
                }
                this.visitFunction(optFunctionNode, n3);
                break;
            }
            case 38: {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(node.getString());
                this.addScriptRuntimeInvoke("name", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
                break;
            }
            case 30: 
            case 37: {
                Node node3;
                int n4 = node.getIntProp(10, 0);
                if (n4 == 0) {
                    OptFunctionNode optFunctionNode = (OptFunctionNode)node.getProp(9);
                    if (optFunctionNode != null) {
                        this.visitOptimizedCall(node, optFunctionNode, n, node3);
                        break;
                    }
                    if (n == 37) {
                        this.visitStandardCall(node, node3);
                        break;
                    }
                    this.visitStandardNew(node, node3);
                    break;
                }
                this.visitSpecialCall(node, n, n4, node3);
                break;
            }
            case 68: {
                Node node3;
                this.generateFunctionAndThisObj(node3, node);
                node3 = node3.getNext();
                this.generateCallArgArray(node, node3, false);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("callRef", "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Ref;");
                break;
            }
            case 39: {
                double d = node.getDouble();
                if (node.getIntProp(8, -1) != -1) {
                    this.cfw.addPush(d);
                    break;
                }
                this.codegen.pushNumberAsObject(this.cfw, d);
                break;
            }
            case 40: {
                this.cfw.addPush(node.getString());
                break;
            }
            case 42: {
                this.cfw.addALoad(this.thisObjLocal);
                break;
            }
            case 61: {
                this.cfw.add(42);
                break;
            }
            case 41: {
                this.cfw.add(1);
                break;
            }
            case 44: {
                this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                break;
            }
            case 43: {
                this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                break;
            }
            case 47: {
                int n5 = node.getExistingIntProp(4);
                if (this.fnCurrent == null) {
                    this.cfw.addALoad(this.scriptRegexpLocal);
                } else {
                    this.cfw.addALoad(this.funObjLocal);
                    this.cfw.add(180, this.codegen.mainClassName, "_re", "[Ljava/lang/Object;");
                }
                this.cfw.addPush(n5);
                this.cfw.add(50);
                break;
            }
            case 85: {
                Node node3;
                for (Node node4 = node3.getNext(); node4 != null; node4 = node4.getNext()) {
                    this.generateExpression(node3, node);
                    this.cfw.add(87);
                    node3 = node4;
                }
                this.generateExpression(node3, node);
                break;
            }
            case 59: 
            case 60: {
                int n6 = this.getLocalBlockRegister(node);
                this.cfw.addALoad(n6);
                if (n == 59) {
                    this.addScriptRuntimeInvoke("enumNext", "(Ljava/lang/Object;)Ljava/lang/Boolean;");
                    break;
                }
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("enumId", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 63: {
                Node node3;
                this.visitArrayLiteral(node, node3);
                break;
            }
            case 64: {
                Node node3;
                this.visitObjectLiteral(node, node3);
                break;
            }
            case 26: {
                Node node3;
                int n7 = this.cfw.acquireLabel();
                int n8 = this.cfw.acquireLabel();
                int n9 = this.cfw.acquireLabel();
                this.generateIfJump(node3, node, n7, n8);
                this.cfw.markLabel(n7);
                this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                this.cfw.add(167, n9);
                this.cfw.markLabel(n8);
                this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                this.cfw.markLabel(n9);
                this.cfw.adjustStackTop(-1);
                break;
            }
            case 27: {
                Node node3;
                this.generateExpression(node3, node);
                this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
                this.cfw.addPush(-1);
                this.cfw.add(130);
                this.cfw.add(135);
                this.addDoubleWrap();
                break;
            }
            case 122: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.add(87);
                Codegen.pushUndefined(this.cfw);
                break;
            }
            case 32: {
                Node node3;
                this.generateExpression(node3, node);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
                break;
            }
            case 133: {
                this.visitTypeofname(node);
                break;
            }
            case 102: 
            case 103: {
                this.visitIncDec(node);
                break;
            }
            case 100: 
            case 101: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.add(89);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                int n10 = this.cfw.acquireLabel();
                if (n == 101) {
                    this.cfw.add(153, n10);
                } else {
                    this.cfw.add(154, n10);
                }
                this.cfw.add(87);
                this.generateExpression(node3.getNext(), node);
                this.cfw.markLabel(n10);
                break;
            }
            case 98: {
                Node node3;
                Node node5 = node3.getNext();
                Node node6 = node5.getNext();
                this.generateExpression(node3, node);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                int n11 = this.cfw.acquireLabel();
                this.cfw.add(153, n11);
                short s = this.cfw.getStackTop();
                this.generateExpression(node5, node);
                int n12 = this.cfw.acquireLabel();
                this.cfw.add(167, n12);
                this.cfw.markLabel(n11, s);
                this.generateExpression(node6, node);
                this.cfw.markLabel(n12);
                break;
            }
            case 21: {
                Node node3;
                this.generateExpression(node3, node);
                this.generateExpression(node3.getNext(), node);
                switch (node.getIntProp(8, -1)) {
                    case 0: {
                        this.cfw.add(99);
                        break block0;
                    }
                    case 1: {
                        this.addOptRuntimeInvoke("add", "(DLjava/lang/Object;)Ljava/lang/Object;");
                        break block0;
                    }
                    case 2: {
                        this.addOptRuntimeInvoke("add", "(Ljava/lang/Object;D)Ljava/lang/Object;");
                        break block0;
                    }
                }
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("add", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 23: {
                Node node3;
                this.visitArithmetic(node, 107, node3, node2);
                break;
            }
            case 22: {
                Node node3;
                this.visitArithmetic(node, 103, node3, node2);
                break;
            }
            case 24: 
            case 25: {
                Node node3;
                this.visitArithmetic(node, n == 24 ? 111 : 115, node3, node2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                Node node3;
                this.visitBitOp(node, n, node3);
                break;
            }
            case 28: 
            case 29: {
                Node node3;
                this.generateExpression(node3, node);
                this.addObjectToDouble();
                if (n == 29) {
                    this.cfw.add(119);
                }
                this.addDoubleWrap();
                break;
            }
            case 146: {
                Node node3;
                this.generateExpression(node3, node);
                this.addObjectToDouble();
                break;
            }
            case 145: {
                Node node3;
                int n13 = -1;
                if (node3.getType() == 39) {
                    n13 = node3.getIntProp(8, -1);
                }
                if (n13 != -1) {
                    node3.removeProp(8);
                    this.generateExpression(node3, node);
                    node3.putIntProp(8, n13);
                    break;
                }
                this.generateExpression(node3, node);
                this.addDoubleWrap();
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 51: 
            case 52: {
                Node node3;
                int n14 = this.cfw.acquireLabel();
                int n15 = this.cfw.acquireLabel();
                this.visitIfJumpRelOp(node, node3, n14, n15);
                this.addJumpedBooleanWrap(n14, n15);
                break;
            }
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                Node node3;
                int n16 = this.cfw.acquireLabel();
                int n17 = this.cfw.acquireLabel();
                this.visitIfJumpEqOp(node, node3, n16, n17);
                this.addJumpedBooleanWrap(n16, n17);
                break;
            }
            case 33: {
                Node node3;
                this.visitGetProp(node, node3);
                break;
            }
            case 35: {
                Node node3;
                this.generateExpression(node3, node);
                this.generateExpression(node3.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                if (node.getIntProp(8, -1) != -1) {
                    this.addScriptRuntimeInvoke("getObjectIndex", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                    break;
                }
                this.addScriptRuntimeInvoke("getObjectElem", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 65: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("refGet", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 54: {
                this.visitGetVar(node);
                break;
            }
            case 55: {
                Node node3;
                this.visitSetVar(node, node3, true);
                break;
            }
            case 8: {
                Node node3;
                this.visitSetName(node, node3);
                break;
            }
            case 150: {
                Node node3;
                this.visitSetConst(node, node3);
                break;
            }
            case 151: {
                Node node3;
                this.visitSetConstVar(node, node3, true);
                break;
            }
            case 34: 
            case 135: {
                Node node3;
                this.visitSetProp(n, node, node3);
                break;
            }
            case 36: 
            case 136: {
                Node node3;
                this.visitSetElem(n, node, node3);
                break;
            }
            case 66: 
            case 138: {
                Node node3;
                this.generateExpression(node3, node);
                node3 = node3.getNext();
                if (n == 138) {
                    this.cfw.add(89);
                    this.cfw.addALoad(this.contextLocal);
                    this.addScriptRuntimeInvoke("refGet", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                }
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("refSet", "(Lorg/mozilla/javascript/Ref;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 67: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("refDel", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 31: {
                Node node3;
                this.generateExpression(node3, node);
                node3 = node3.getNext();
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("delete", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 48: {
                Node node3;
                for (node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                    this.generateExpression(node3, node);
                }
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(node.getString());
                this.addScriptRuntimeInvoke("bind", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Lorg/mozilla/javascript/Scriptable;");
                break;
            }
            case 53: {
                this.cfw.addALoad(this.getLocalBlockRegister(node));
                break;
            }
            case 69: {
                Node node3;
                String string = (String)node.getProp(17);
                this.generateExpression(node3, node);
                this.cfw.addPush(string);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("specialRef", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Ref;");
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                String string;
                String string2;
                Node node3;
                int n18 = node.getIntProp(16, 0);
                do {
                    this.generateExpression(node3, node);
                } while ((node3 = node3.getNext()) != null);
                this.cfw.addALoad(this.contextLocal);
                switch (n) {
                    case 73: {
                        string2 = "memberRef";
                        string = "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;I)Lorg/mozilla/javascript/Ref;";
                        break;
                    }
                    case 74: {
                        string2 = "memberRef";
                        string = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;I)Lorg/mozilla/javascript/Ref;";
                        break;
                    }
                    case 75: {
                        string2 = "nameRef";
                        string = "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Lorg/mozilla/javascript/Ref;";
                        this.cfw.addALoad(this.variableObjectLocal);
                        break;
                    }
                    case 76: {
                        string2 = "nameRef";
                        string = "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Lorg/mozilla/javascript/Ref;";
                        this.cfw.addALoad(this.variableObjectLocal);
                        break;
                    }
                    default: {
                        throw Kit.codeBug();
                    }
                }
                this.cfw.addPush(n18);
                this.addScriptRuntimeInvoke(string2, string);
                break;
            }
            case 142: {
                Node node3;
                this.visitDotQuery(node, node3);
                break;
            }
            case 71: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("escapeAttributeValue", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/String;");
                break;
            }
            case 72: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("escapeTextValue", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/String;");
                break;
            }
            case 70: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("setDefaultNamespace", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            default: {
                throw new RuntimeException("Unexpected node type " + n);
            }
        }
    }

    private void generateIfJump(Node node, Node node2, int n, int n2) {
        int n3 = node.getType();
        Node node3 = node.getFirstChild();
        switch (n3) {
            case 26: {
                this.generateIfJump(node3, node, n2, n);
                break;
            }
            case 100: 
            case 101: {
                int n4 = this.cfw.acquireLabel();
                if (n3 == 101) {
                    this.generateIfJump(node3, node, n4, n2);
                } else {
                    this.generateIfJump(node3, node, n, n4);
                }
                this.cfw.markLabel(n4);
                node3 = node3.getNext();
                this.generateIfJump(node3, node, n, n2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 51: 
            case 52: {
                this.visitIfJumpRelOp(node, node3, n, n2);
                break;
            }
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                this.visitIfJumpEqOp(node, node3, n, n2);
                break;
            }
            default: {
                this.generateExpression(node, node2);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                this.cfw.add(154, n);
                this.cfw.add(167, n2);
            }
        }
    }

    private void visitFunction(OptFunctionNode optFunctionNode, int n) {
        int n2 = this.codegen.getIndex(optFunctionNode.fnode);
        this.cfw.add(187, this.codegen.mainClassName);
        this.cfw.add(89);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(n2);
        this.cfw.addInvoke(183, this.codegen.mainClassName, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V");
        this.cfw.add(89);
        if (this.isTopLevel) {
            this.cfw.add(42);
        } else {
            this.cfw.add(42);
            this.cfw.add(180, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
        }
        this.cfw.add(181, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
        int n3 = optFunctionNode.getDirectTargetIndex();
        if (n3 >= 0) {
            this.cfw.add(89);
            if (this.isTopLevel) {
                this.cfw.add(42);
            } else {
                this.cfw.add(42);
                this.cfw.add(180, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
            }
            this.cfw.add(95);
            this.cfw.add(181, this.codegen.mainClassName, Codegen.getDirectTargetFieldName(n3), this.codegen.mainClassSignature);
        }
        if (n == 2) {
            return;
        }
        this.cfw.addPush(n);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.addOptRuntimeInvoke("initFunction", "(Lorg/mozilla/javascript/NativeFunction;ILorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)V");
    }

    private int getTargetLabel(Node node) {
        int n = node.labelId();
        if (n == -1) {
            n = this.cfw.acquireLabel();
            node.labelId(n);
        }
        return n;
    }

    private void visitGOTO(Node.Jump jump, int n, Node node) {
        Node node2 = jump.target;
        if (n == 6 || n == 7) {
            if (node == null) {
                throw Codegen.badTree();
            }
            int n2 = this.getTargetLabel(node2);
            int n3 = this.cfw.acquireLabel();
            if (n == 6) {
                this.generateIfJump(node, jump, n2, n3);
            } else {
                this.generateIfJump(node, jump, n3, n2);
            }
            this.cfw.markLabel(n3);
        } else if (n == 131) {
            this.addGoto(node2, 168);
        } else {
            this.addGoto(node2, 167);
        }
    }

    private void visitArrayLiteral(Node node, Node node2) {
        int n = 0;
        for (Node node3 = node2; node3 != null; node3 = node3.getNext()) {
            ++n;
        }
        this.addNewObjectArray(n);
        for (int i = 0; i != n; ++i) {
            this.cfw.add(89);
            this.cfw.addPush(i);
            this.generateExpression(node2, node);
            this.cfw.add(83);
            node2 = node2.getNext();
        }
        int[] nArray = (int[])node.getProp(11);
        if (nArray == null) {
            this.cfw.add(1);
            this.cfw.add(3);
        } else {
            this.cfw.addPush(OptRuntime.encodeIntArray(nArray));
            this.cfw.addPush(nArray.length);
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke("newArrayLiteral", "([Ljava/lang/Object;Ljava/lang/String;ILorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void visitObjectLiteral(Node node, Node node2) {
        int n;
        int n2;
        Object[] objectArray = (Object[])node.getProp(12);
        int n3 = objectArray.length;
        this.addNewObjectArray(n3);
        for (int i = 0; i != n3; ++i) {
            this.cfw.add(89);
            this.cfw.addPush(i);
            Object object = objectArray[i];
            if (object instanceof String) {
                this.cfw.addPush((String)object);
            } else {
                this.cfw.addPush((Integer)object);
                this.addScriptRuntimeInvoke("wrapInt", "(I)Ljava/lang/Integer;");
            }
            this.cfw.add(83);
        }
        this.addNewObjectArray(n3);
        Node node3 = node2;
        for (n2 = 0; n2 != n3; ++n2) {
            this.cfw.add(89);
            this.cfw.addPush(n2);
            n = node2.getType();
            if (n == 147) {
                this.generateExpression(node2.getFirstChild(), node);
            } else if (n == 148) {
                this.generateExpression(node2.getFirstChild(), node);
            } else {
                this.generateExpression(node2, node);
            }
            this.cfw.add(83);
            node2 = node2.getNext();
        }
        this.cfw.addPush(n3);
        this.cfw.add(188, 10);
        for (n2 = 0; n2 != n3; ++n2) {
            this.cfw.add(89);
            this.cfw.addPush(n2);
            n = node3.getType();
            if (n == 147) {
                this.cfw.add(2);
            } else if (n == 148) {
                this.cfw.add(4);
            } else {
                this.cfw.add(3);
            }
            this.cfw.add(79);
            node3 = node3.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("newObjectLiteral", "([Ljava/lang/Object;[Ljava/lang/Object;[ILorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void visitSpecialCall(Node node, int n, int n2, Node node2) {
        String string;
        String string2;
        this.cfw.addALoad(this.contextLocal);
        if (n == 30) {
            this.generateExpression(node2, node);
        } else {
            this.generateFunctionAndThisObj(node2, node);
        }
        node2 = node2.getNext();
        this.generateCallArgArray(node, node2, false);
        if (n == 30) {
            string2 = "newObjectSpecial";
            string = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;";
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(n2);
        } else {
            string2 = "callSpecial";
            string = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;ILjava/lang/String;I)Ljava/lang/Object;";
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(n2);
            String string3 = this.scriptOrFn.getSourceName();
            this.cfw.addPush(string3 == null ? "" : string3);
            this.cfw.addPush(this.itsLineNumber);
        }
        this.addOptRuntimeInvoke(string2, string);
    }

    private void visitStandardCall(Node node, Node node2) {
        String string;
        String string2;
        if (node.getType() != 37) {
            throw Codegen.badTree();
        }
        Node node3 = node2.getNext();
        int n = node2.getType();
        if (node3 == null) {
            if (n == 38) {
                String string3 = node2.getString();
                this.cfw.addPush(string3);
                string2 = "callName0";
                string = "(Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else if (n == 33) {
                Node node4 = node2.getFirstChild();
                this.generateExpression(node4, node);
                Node node5 = node4.getNext();
                String string4 = node5.getString();
                this.cfw.addPush(string4);
                string2 = "callProp0";
                string = "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else {
                this.generateFunctionAndThisObj(node2, node);
                string2 = "call0";
                string = "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            }
        } else if (n == 38) {
            String string5 = node2.getString();
            this.generateCallArgArray(node, node3, false);
            this.cfw.addPush(string5);
            string2 = "callName";
            string = "([Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
        } else {
            int n2 = 0;
            for (Node node6 = node3; node6 != null; node6 = node6.getNext()) {
                ++n2;
            }
            this.generateFunctionAndThisObj(node2, node);
            if (n2 == 1) {
                this.generateExpression(node3, node);
                string2 = "call1";
                string = "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else if (n2 == 2) {
                this.generateExpression(node3, node);
                this.generateExpression(node3.getNext(), node);
                string2 = "call2";
                string = "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else {
                this.generateCallArgArray(node, node3, false);
                string2 = "callN";
                string = "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            }
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke(string2, string);
    }

    private void visitStandardNew(Node node, Node node2) {
        if (node.getType() != 30) {
            throw Codegen.badTree();
        }
        Node node3 = node2.getNext();
        this.generateExpression(node2, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.generateCallArgArray(node, node3, false);
        this.addScriptRuntimeInvoke("newObject", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void visitOptimizedCall(Node node, OptFunctionNode optFunctionNode, int n, Node node2) {
        Node node3 = node2.getNext();
        short s = 0;
        if (n == 30) {
            this.generateExpression(node2, node);
        } else {
            this.generateFunctionAndThisObj(node2, node);
            s = this.getNewWordLocal();
            this.cfw.addAStore(s);
        }
        int n2 = this.cfw.acquireLabel();
        int n3 = optFunctionNode.getDirectTargetIndex();
        if (this.isTopLevel) {
            this.cfw.add(42);
        } else {
            this.cfw.add(42);
            this.cfw.add(180, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
        }
        this.cfw.add(180, this.codegen.mainClassName, Codegen.getDirectTargetFieldName(n3), this.codegen.mainClassSignature);
        this.cfw.add(92);
        int n4 = this.cfw.acquireLabel();
        this.cfw.add(166, n4);
        short s2 = this.cfw.getStackTop();
        this.cfw.add(95);
        this.cfw.add(87);
        if (this.compilerEnv.isUseDynamicScope()) {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
        } else {
            this.cfw.add(89);
            this.cfw.addInvoke(185, "org/mozilla/javascript/Scriptable", "getParentScope", "()Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addALoad(this.contextLocal);
            this.cfw.add(95);
        }
        if (n == 30) {
            this.cfw.add(1);
        } else {
            this.cfw.addALoad(s);
        }
        for (Node node4 = node3; node4 != null; node4 = node4.getNext()) {
            int n5 = this.nodeIsDirectCallParameter(node4);
            if (n5 >= 0) {
                this.cfw.addALoad(n5);
                this.cfw.addDLoad(n5 + 1);
                continue;
            }
            if (node4.getIntProp(8, -1) == 0) {
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.generateExpression(node4, node);
                continue;
            }
            this.generateExpression(node4, node);
            this.cfw.addPush(0.0);
        }
        this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
        this.cfw.addInvoke(184, this.codegen.mainClassName, n == 30 ? this.codegen.getDirectCtorName(optFunctionNode.fnode) : this.codegen.getBodyMethodName(optFunctionNode.fnode), this.codegen.getBodyMethodSignature(optFunctionNode.fnode));
        this.cfw.add(167, n2);
        this.cfw.markLabel(n4, s2);
        this.cfw.add(87);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (n != 30) {
            this.cfw.addALoad(s);
            this.releaseWordLocal(s);
        }
        this.generateCallArgArray(node, node3, true);
        if (n == 30) {
            this.addScriptRuntimeInvoke("newObject", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        } else {
            this.cfw.addInvoke(185, "org/mozilla/javascript/Callable", "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        }
        this.cfw.markLabel(n2);
    }

    private void generateCallArgArray(Node node, Node node2, boolean bl) {
        int n = 0;
        for (Node node3 = node2; node3 != null; node3 = node3.getNext()) {
            ++n;
        }
        if (n == 1 && this.itsOneArgArray >= 0) {
            this.cfw.addALoad(this.itsOneArgArray);
        } else {
            this.addNewObjectArray(n);
        }
        for (int i = 0; i != n; ++i) {
            this.cfw.add(89);
            this.cfw.addPush(i);
            if (!bl) {
                this.generateExpression(node2, node);
            } else {
                int n2 = this.nodeIsDirectCallParameter(node2);
                if (n2 >= 0) {
                    this.dcpLoadAsObject(n2);
                } else {
                    this.generateExpression(node2, node);
                    int n3 = node2.getIntProp(8, -1);
                    if (n3 == 0) {
                        this.addDoubleWrap();
                    }
                }
            }
            this.cfw.add(83);
            node2 = node2.getNext();
        }
    }

    private void generateFunctionAndThisObj(Node node, Node node2) {
        int n = node.getType();
        switch (node.getType()) {
            case 33: 
            case 35: {
                Node node3 = node.getFirstChild();
                this.generateExpression(node3, node);
                Node node4 = node3.getNext();
                if (n == 33) {
                    String string = node4.getString();
                    this.cfw.addPush(string);
                    this.cfw.addALoad(this.contextLocal);
                    this.addScriptRuntimeInvoke("getPropFunctionAndThis", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Callable;");
                    break;
                }
                if (node.getIntProp(8, -1) != -1) {
                    throw Codegen.badTree();
                }
                this.generateExpression(node4, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getElemFunctionAndThis", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Callable;");
                break;
            }
            case 38: {
                String string = node.getString();
                this.cfw.addPush(string);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getNameFunctionAndThis", "(Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Callable;");
                break;
            }
            default: {
                this.generateExpression(node, node2);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getValueFunctionAndThis", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Callable;");
            }
        }
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("lastStoredScriptable", "(Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void updateLineNumber(Node node) {
        this.itsLineNumber = node.getLineno();
        if (this.itsLineNumber == -1) {
            return;
        }
        this.cfw.addLineNumberEntry((short)this.itsLineNumber);
    }

    private void visitTryCatchFinally(Node.Jump jump, Node node) {
        int n;
        short s = this.getNewWordLocal();
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addAStore(s);
        int n2 = this.cfw.acquireLabel();
        this.cfw.markLabel(n2, (short)1);
        while (node != null) {
            this.generateStatement(node);
            node = node.getNext();
        }
        Node node2 = jump.target;
        Node node3 = jump.getFinally();
        int n3 = this.cfw.acquireLabel();
        this.cfw.add(167, n3);
        int n4 = this.getLocalBlockRegister(jump);
        if (node2 != null) {
            n = node2.labelId();
            this.generateCatchBlock(0, s, n, n2, n4);
            this.generateCatchBlock(1, s, n, n2, n4);
            this.generateCatchBlock(2, s, n, n2, n4);
        }
        if (node3 != null) {
            n = this.cfw.acquireLabel();
            this.cfw.markHandler(n);
            this.cfw.addAStore(n4);
            this.cfw.addALoad(s);
            this.cfw.addAStore(this.variableObjectLocal);
            int n5 = node3.labelId();
            this.cfw.add(168, n5);
            this.cfw.addALoad(n4);
            this.cfw.add(191);
            this.cfw.addExceptionHandler(n2, n5, n, null);
        }
        this.releaseWordLocal(s);
        this.cfw.markLabel(n3);
    }

    private void generateCatchBlock(int n, short s, int n2, int n3, int n4) {
        String string;
        int n5 = this.cfw.acquireLabel();
        this.cfw.markHandler(n5);
        this.cfw.addAStore(n4);
        this.cfw.addALoad(s);
        this.cfw.addAStore(this.variableObjectLocal);
        if (n == 0) {
            string = "org/mozilla/javascript/JavaScriptException";
        } else if (n == 1) {
            string = "org/mozilla/javascript/EvaluatorException";
        } else {
            if (n != 2) {
                Kit.codeBug();
            }
            string = "org/mozilla/javascript/EcmaError";
        }
        this.cfw.addExceptionHandler(n3, n2, n5, string);
        this.cfw.add(167, n2);
    }

    private void visitSwitch(Node.Jump jump, Node node) {
        this.generateExpression(node, jump);
        short s = this.getNewWordLocal();
        this.cfw.addAStore(s);
        for (Node.Jump jump2 = (Node.Jump)node.getNext(); jump2 != null; jump2 = (Node.Jump)jump2.getNext()) {
            if (jump2.getType() != 111) {
                throw Codegen.badTree();
            }
            Node node2 = jump2.getFirstChild();
            this.generateExpression(node2, jump2);
            this.cfw.addALoad(s);
            this.addScriptRuntimeInvoke("shallowEq", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            this.addGoto(jump2.target, 154);
        }
        this.releaseWordLocal(s);
    }

    private void visitTypeofname(Node node) {
        int n;
        String string = node.getString();
        if (this.hasVarsInRegs && (n = this.fnCurrent.fnode.getParamOrVarIndex(string)) >= 0) {
            if (this.fnCurrent.isNumberVar(n)) {
                this.cfw.addPush("number");
            } else if (this.varIsDirectCallParameter(n)) {
                short s = this.varRegisters[n];
                this.cfw.addALoad(s);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int n2 = this.cfw.acquireLabel();
                this.cfw.add(165, n2);
                short s2 = this.cfw.getStackTop();
                this.cfw.addALoad(s);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
                int n3 = this.cfw.acquireLabel();
                this.cfw.add(167, n3);
                this.cfw.markLabel(n2, s2);
                this.cfw.addPush("number");
                this.cfw.markLabel(n3);
            } else {
                this.cfw.addALoad(this.varRegisters[n]);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
            }
            return;
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(string);
        this.addScriptRuntimeInvoke("typeofName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/String;");
    }

    private void visitIncDec(Node node) {
        int n = node.getExistingIntProp(13);
        Node node2 = node.getFirstChild();
        switch (node2.getType()) {
            case 54: {
                if (!this.hasVarsInRegs) {
                    Kit.codeBug();
                }
                if (node.getIntProp(8, -1) != -1) {
                    boolean bl = (n & 2) != 0;
                    int n2 = this.fnCurrent.getVarIndex(node2);
                    short s = this.varRegisters[n2];
                    short s2 = this.varIsDirectCallParameter(n2) ? (short)1 : 0;
                    this.cfw.addDLoad(s + s2);
                    if (bl) {
                        this.cfw.add(92);
                    }
                    this.cfw.addPush(1.0);
                    if ((n & 1) == 0) {
                        this.cfw.add(99);
                    } else {
                        this.cfw.add(103);
                    }
                    if (!bl) {
                        this.cfw.add(92);
                    }
                    this.cfw.addDStore(s + s2);
                    break;
                }
                boolean bl = (n & 2) != 0;
                int n3 = this.fnCurrent.getVarIndex(node2);
                short s = this.varRegisters[n3];
                this.cfw.addALoad(s);
                if (bl) {
                    this.cfw.add(89);
                }
                this.addObjectToDouble();
                this.cfw.addPush(1.0);
                if ((n & 1) == 0) {
                    this.cfw.add(99);
                } else {
                    this.cfw.add(103);
                }
                this.addDoubleWrap();
                if (!bl) {
                    this.cfw.add(89);
                }
                this.cfw.addAStore(s);
                break;
            }
            case 38: {
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(node2.getString());
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(n);
                this.addScriptRuntimeInvoke("nameIncrDecr", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;I)Ljava/lang/Object;");
                break;
            }
            case 33: {
                Node node3 = node2.getFirstChild();
                this.generateExpression(node3, node);
                this.generateExpression(node3.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(n);
                this.addScriptRuntimeInvoke("propIncrDecr", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;I)Ljava/lang/Object;");
                break;
            }
            case 35: {
                Node node4 = node2.getFirstChild();
                this.generateExpression(node4, node);
                this.generateExpression(node4.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(n);
                if (node4.getNext().getIntProp(8, -1) != -1) {
                    this.addOptRuntimeInvoke("elemIncrDecr", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;I)Ljava/lang/Object;");
                    break;
                }
                this.addScriptRuntimeInvoke("elemIncrDecr", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;I)Ljava/lang/Object;");
                break;
            }
            case 65: {
                Node node5 = node2.getFirstChild();
                this.generateExpression(node5, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(n);
                this.addScriptRuntimeInvoke("refIncrDecr", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;I)Ljava/lang/Object;");
                break;
            }
            default: {
                Codegen.badTree();
            }
        }
    }

    private static boolean isArithmeticNode(Node node) {
        int n = node.getType();
        return n == 22 || n == 25 || n == 24 || n == 23;
    }

    private void visitArithmetic(Node node, int n, Node node2, Node node3) {
        int n2 = node.getIntProp(8, -1);
        if (n2 != -1) {
            this.generateExpression(node2, node);
            this.generateExpression(node2.getNext(), node);
            this.cfw.add(n);
        } else {
            boolean bl = BodyCodegen.isArithmeticNode(node3);
            this.generateExpression(node2, node);
            if (!BodyCodegen.isArithmeticNode(node2)) {
                this.addObjectToDouble();
            }
            this.generateExpression(node2.getNext(), node);
            if (!BodyCodegen.isArithmeticNode(node2.getNext())) {
                this.addObjectToDouble();
            }
            this.cfw.add(n);
            if (!bl) {
                this.addDoubleWrap();
            }
        }
    }

    private void visitBitOp(Node node, int n, Node node2) {
        int n2 = node.getIntProp(8, -1);
        this.generateExpression(node2, node);
        if (n == 20) {
            this.addScriptRuntimeInvoke("toUint32", "(Ljava/lang/Object;)J");
            this.generateExpression(node2.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
            this.cfw.addPush(31);
            this.cfw.add(126);
            this.cfw.add(125);
            this.cfw.add(138);
            this.addDoubleWrap();
            return;
        }
        if (n2 == -1) {
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
            this.generateExpression(node2.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
        } else {
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
            this.generateExpression(node2.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
        }
        switch (n) {
            case 9: {
                this.cfw.add(128);
                break;
            }
            case 10: {
                this.cfw.add(130);
                break;
            }
            case 11: {
                this.cfw.add(126);
                break;
            }
            case 19: {
                this.cfw.add(122);
                break;
            }
            case 18: {
                this.cfw.add(120);
                break;
            }
            default: {
                throw Codegen.badTree();
            }
        }
        this.cfw.add(135);
        if (n2 == -1) {
            this.addDoubleWrap();
        }
    }

    private int nodeIsDirectCallParameter(Node node) {
        int n;
        if (node.getType() == 54 && this.inDirectCallFunction && !this.itsForcedObjectParameters && this.fnCurrent.isParameter(n = this.fnCurrent.getVarIndex(node))) {
            return this.varRegisters[n];
        }
        return -1;
    }

    private boolean varIsDirectCallParameter(int n) {
        return this.fnCurrent.isParameter(n) && this.inDirectCallFunction && !this.itsForcedObjectParameters;
    }

    private void genSimpleCompare(int n, int n2, int n3) {
        if (n2 == -1) {
            throw Codegen.badTree();
        }
        switch (n) {
            case 15: {
                this.cfw.add(152);
                this.cfw.add(158, n2);
                break;
            }
            case 17: {
                this.cfw.add(151);
                this.cfw.add(156, n2);
                break;
            }
            case 14: {
                this.cfw.add(152);
                this.cfw.add(155, n2);
                break;
            }
            case 16: {
                this.cfw.add(151);
                this.cfw.add(157, n2);
                break;
            }
            default: {
                throw Codegen.badTree();
            }
        }
        if (n3 != -1) {
            this.cfw.add(167, n3);
        }
    }

    private void visitIfJumpRelOp(Node node, Node node2, int n, int n2) {
        if (n == -1 || n2 == -1) {
            throw Codegen.badTree();
        }
        int n3 = node.getType();
        Node node3 = node2.getNext();
        if (n3 == 52 || n3 == 51) {
            this.generateExpression(node2, node);
            this.generateExpression(node3, node);
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke(n3 == 52 ? "instanceOf" : "in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Z");
            this.cfw.add(154, n);
            this.cfw.add(167, n2);
            return;
        }
        int n4 = node.getIntProp(8, -1);
        int n5 = this.nodeIsDirectCallParameter(node2);
        int n6 = this.nodeIsDirectCallParameter(node3);
        if (n4 != -1) {
            if (n4 != 2) {
                this.generateExpression(node2, node);
            } else if (n5 != -1) {
                this.dcpLoadAsNumber(n5);
            } else {
                this.generateExpression(node2, node);
                this.addObjectToDouble();
            }
            if (n4 != 1) {
                this.generateExpression(node3, node);
            } else if (n6 != -1) {
                this.dcpLoadAsNumber(n6);
            } else {
                this.generateExpression(node3, node);
                this.addObjectToDouble();
            }
            this.genSimpleCompare(n3, n, n2);
        } else {
            if (n5 != -1 && n6 != -1) {
                short s = this.cfw.getStackTop();
                int n7 = this.cfw.acquireLabel();
                this.cfw.addALoad(n5);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.cfw.add(166, n7);
                this.cfw.addDLoad(n5 + 1);
                this.dcpLoadAsNumber(n6);
                this.genSimpleCompare(n3, n, n2);
                if (s != this.cfw.getStackTop()) {
                    throw Codegen.badTree();
                }
                this.cfw.markLabel(n7);
                int n8 = this.cfw.acquireLabel();
                this.cfw.addALoad(n6);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.cfw.add(166, n8);
                this.cfw.addALoad(n5);
                this.addObjectToDouble();
                this.cfw.addDLoad(n6 + 1);
                this.genSimpleCompare(n3, n, n2);
                if (s != this.cfw.getStackTop()) {
                    throw Codegen.badTree();
                }
                this.cfw.markLabel(n8);
                this.cfw.addALoad(n5);
                this.cfw.addALoad(n6);
            } else {
                this.generateExpression(node2, node);
                this.generateExpression(node3, node);
            }
            if (n3 == 17 || n3 == 16) {
                this.cfw.add(95);
            }
            String string = n3 == 14 || n3 == 16 ? "cmp_LT" : "cmp_LE";
            this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            this.cfw.add(154, n);
            this.cfw.add(167, n2);
        }
    }

    private void visitIfJumpEqOp(Node node, Node node2, int n, int n2) {
        if (n == -1 || n2 == -1) {
            throw Codegen.badTree();
        }
        short s = this.cfw.getStackTop();
        int n3 = node.getType();
        Node node3 = node2.getNext();
        if (node2.getType() == 41 || node3.getType() == 41) {
            if (node2.getType() == 41) {
                node2 = node3;
            }
            this.generateExpression(node2, node);
            if (n3 == 45 || n3 == 46) {
                int n4 = n3 == 45 ? 198 : 199;
                this.cfw.add(n4, n);
            } else {
                int n5;
                if (n3 != 12) {
                    if (n3 != 13) {
                        throw Codegen.badTree();
                    }
                    n5 = n;
                    n = n2;
                    n2 = n5;
                }
                this.cfw.add(89);
                n5 = this.cfw.acquireLabel();
                this.cfw.add(199, n5);
                short s2 = this.cfw.getStackTop();
                this.cfw.add(87);
                this.cfw.add(167, n);
                this.cfw.markLabel(n5, s2);
                Codegen.pushUndefined(this.cfw);
                this.cfw.add(165, n);
            }
            this.cfw.add(167, n2);
        } else {
            int n6;
            Object object;
            int n7 = this.nodeIsDirectCallParameter(node2);
            if (n7 != -1 && node3.getType() == 145 && ((Node)(object = node3.getFirstChild())).getType() == 39) {
                this.cfw.addALoad(n7);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                n6 = this.cfw.acquireLabel();
                this.cfw.add(166, n6);
                this.cfw.addDLoad(n7 + 1);
                this.cfw.addPush(((Node)object).getDouble());
                this.cfw.add(151);
                if (n3 == 12) {
                    this.cfw.add(153, n);
                } else {
                    this.cfw.add(154, n);
                }
                this.cfw.add(167, n2);
                this.cfw.markLabel(n6);
            }
            this.generateExpression(node2, node);
            this.generateExpression(node3, node);
            switch (n3) {
                case 12: {
                    object = "eq";
                    n6 = 154;
                    break;
                }
                case 13: {
                    object = "eq";
                    n6 = 153;
                    break;
                }
                case 45: {
                    object = "shallowEq";
                    n6 = 154;
                    break;
                }
                case 46: {
                    object = "shallowEq";
                    n6 = 153;
                    break;
                }
                default: {
                    throw Codegen.badTree();
                }
            }
            this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            this.cfw.add(n6, n);
            this.cfw.add(167, n2);
        }
        if (s != this.cfw.getStackTop()) {
            throw Codegen.badTree();
        }
    }

    private void visitSetName(Node node, Node node2) {
        String string = node.getFirstChild().getString();
        while (node2 != null) {
            this.generateExpression(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(string);
        this.addScriptRuntimeInvoke("setName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitSetConst(Node node, Node node2) {
        String string = node.getFirstChild().getString();
        while (node2 != null) {
            this.generateExpression(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(string);
        this.addScriptRuntimeInvoke("setConst", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitGetVar(Node node) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int n = this.fnCurrent.getVarIndex(node);
        short s = this.varRegisters[n];
        if (this.varIsDirectCallParameter(n)) {
            if (node.getIntProp(8, -1) != -1) {
                this.dcpLoadAsNumber(s);
            } else {
                this.dcpLoadAsObject(s);
            }
        } else if (this.fnCurrent.isNumberVar(n)) {
            this.cfw.addDLoad(s);
        } else {
            this.cfw.addALoad(s);
        }
    }

    private void visitSetVar(Node node, Node node2, boolean bl) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int n = this.fnCurrent.getVarIndex(node);
        this.generateExpression(node2.getNext(), node);
        boolean bl2 = node.getIntProp(8, -1) != -1;
        short s = this.varRegisters[n];
        boolean[] blArray = this.fnCurrent.fnode.getParamAndVarConst();
        if (blArray[n]) {
            if (!bl) {
                if (bl2) {
                    this.cfw.add(88);
                } else {
                    this.cfw.add(87);
                }
            }
        } else if (this.varIsDirectCallParameter(n)) {
            if (bl2) {
                if (bl) {
                    this.cfw.add(92);
                }
                this.cfw.addALoad(s);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int n2 = this.cfw.acquireLabel();
                int n3 = this.cfw.acquireLabel();
                this.cfw.add(165, n2);
                short s2 = this.cfw.getStackTop();
                this.addDoubleWrap();
                this.cfw.addAStore(s);
                this.cfw.add(167, n3);
                this.cfw.markLabel(n2, s2);
                this.cfw.addDStore(s + 1);
                this.cfw.markLabel(n3);
            } else {
                if (bl) {
                    this.cfw.add(89);
                }
                this.cfw.addAStore(s);
            }
        } else if (bl2) {
            this.cfw.addDStore(s);
            if (bl) {
                this.cfw.addDLoad(s);
            }
        } else {
            this.cfw.addAStore(s);
            if (bl) {
                this.cfw.addALoad(s);
            }
        }
    }

    private void visitSetConstVar(Node node, Node node2, boolean bl) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int n = this.fnCurrent.getVarIndex(node);
        this.generateExpression(node2.getNext(), node);
        boolean bl2 = node.getIntProp(8, -1) != -1;
        short s = this.varRegisters[n];
        int n2 = this.cfw.acquireLabel();
        int n3 = this.cfw.acquireLabel();
        if (bl2) {
            this.cfw.addILoad(s + 2);
            this.cfw.add(154, n3);
            short s2 = this.cfw.getStackTop();
            this.cfw.addPush(1);
            this.cfw.addIStore(s + 2);
            this.cfw.addDStore(s);
            if (bl) {
                this.cfw.addDLoad(s);
                this.cfw.markLabel(n3, s2);
            } else {
                this.cfw.add(167, n2);
                this.cfw.markLabel(n3, s2);
                this.cfw.add(88);
            }
        } else {
            this.cfw.addILoad(s + 1);
            this.cfw.add(154, n3);
            short s3 = this.cfw.getStackTop();
            this.cfw.addPush(1);
            this.cfw.addIStore(s + 1);
            this.cfw.addAStore(s);
            if (bl) {
                this.cfw.addALoad(s);
                this.cfw.markLabel(n3, s3);
            } else {
                this.cfw.add(167, n2);
                this.cfw.markLabel(n3, s3);
                this.cfw.add(87);
            }
        }
        this.cfw.markLabel(n2);
    }

    private void visitGetProp(Node node, Node node2) {
        this.generateExpression(node2, node);
        Node node3 = node2.getNext();
        this.generateExpression(node3, node);
        int n = node2.getType();
        if (n == 42 && node3.getType() == 40) {
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke("getObjectProp", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
        } else {
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke("getObjectProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
        }
    }

    private void visitSetProp(int n, Node node, Node node2) {
        Node node3 = node2;
        this.generateExpression(node2, node);
        node2 = node2.getNext();
        if (n == 135) {
            this.cfw.add(89);
        }
        Node node4 = node2;
        this.generateExpression(node2, node);
        node2 = node2.getNext();
        if (n == 135) {
            this.cfw.add(90);
            if (node3.getType() == 42 && node4.getType() == 40) {
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getObjectProp", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
            } else {
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getObjectProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
            }
        }
        this.generateExpression(node2, node);
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("setObjectProp", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
    }

    private void visitSetElem(int n, Node node, Node node2) {
        boolean bl;
        this.generateExpression(node2, node);
        node2 = node2.getNext();
        if (n == 136) {
            this.cfw.add(89);
        }
        this.generateExpression(node2, node);
        node2 = node2.getNext();
        boolean bl2 = bl = node.getIntProp(8, -1) != -1;
        if (n == 136) {
            if (bl) {
                this.cfw.add(93);
                this.cfw.addALoad(this.contextLocal);
                this.addOptRuntimeInvoke("getObjectIndex", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;)Ljava/lang/Object;");
            } else {
                this.cfw.add(90);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getObjectElem", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
            }
        }
        this.generateExpression(node2, node);
        this.cfw.addALoad(this.contextLocal);
        if (bl) {
            this.addScriptRuntimeInvoke("setObjectIndex", "(Ljava/lang/Object;DLjava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
        } else {
            this.addScriptRuntimeInvoke("setObjectElem", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
        }
    }

    private void visitDotQuery(Node node, Node node2) {
        this.updateLineNumber(node);
        this.generateExpression(node2, node);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("enterDotQuery", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.add(1);
        int n = this.cfw.acquireLabel();
        this.cfw.markLabel(n);
        this.cfw.add(87);
        this.generateExpression(node2.getNext(), node);
        this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("updateDotQuery", "(ZLorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        this.cfw.add(89);
        this.cfw.add(198, n);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("leaveDotQuery", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
    }

    private int getLocalBlockRegister(Node node) {
        Node node2 = (Node)node.getProp(3);
        int n = node2.getExistingIntProp(2);
        return n;
    }

    private void dcpLoadAsNumber(int n) {
        this.cfw.addALoad(n);
        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
        int n2 = this.cfw.acquireLabel();
        this.cfw.add(165, n2);
        short s = this.cfw.getStackTop();
        this.cfw.addALoad(n);
        this.addObjectToDouble();
        int n3 = this.cfw.acquireLabel();
        this.cfw.add(167, n3);
        this.cfw.markLabel(n2, s);
        this.cfw.addDLoad(n + 1);
        this.cfw.markLabel(n3);
    }

    private void dcpLoadAsObject(int n) {
        this.cfw.addALoad(n);
        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
        int n2 = this.cfw.acquireLabel();
        this.cfw.add(165, n2);
        short s = this.cfw.getStackTop();
        this.cfw.addALoad(n);
        int n3 = this.cfw.acquireLabel();
        this.cfw.add(167, n3);
        this.cfw.markLabel(n2, s);
        this.cfw.addDLoad(n + 1);
        this.addDoubleWrap();
        this.cfw.markLabel(n3);
    }

    private void addGoto(Node node, int n) {
        int n2 = this.getTargetLabel(node);
        this.cfw.add(n, n2);
    }

    private void addObjectToDouble() {
        this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
    }

    private void addNewObjectArray(int n) {
        if (n == 0) {
            if (this.itsZeroArgArray >= 0) {
                this.cfw.addALoad(this.itsZeroArgArray);
            } else {
                this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
            }
        } else {
            this.cfw.addPush(n);
            this.cfw.add(189, "java/lang/Object");
        }
    }

    private void addScriptRuntimeInvoke(String string, String string2) {
        this.cfw.addInvoke(184, "org.mozilla.javascript.ScriptRuntime", string, string2);
    }

    private void addOptRuntimeInvoke(String string, String string2) {
        this.cfw.addInvoke(184, "org/mozilla/javascript/optimizer/OptRuntime", string, string2);
    }

    private void addJumpedBooleanWrap(int n, int n2) {
        this.cfw.markLabel(n2);
        int n3 = this.cfw.acquireLabel();
        this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
        this.cfw.add(167, n3);
        this.cfw.markLabel(n);
        this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        this.cfw.markLabel(n3);
        this.cfw.adjustStackTop(-1);
    }

    private void addDoubleWrap() {
        this.addOptRuntimeInvoke("wrapDouble", "(D)Ljava/lang/Double;");
    }

    private short getNewWordPairLocal(boolean bl) {
        short s = this.getConsecutiveSlots(2, bl);
        if (s < 255) {
            this.locals[s] = true;
            this.locals[s + 1] = true;
            if (bl) {
                this.locals[s + 2] = true;
            }
            if (s == this.firstFreeLocal) {
                for (int i = this.firstFreeLocal + 2; i < 256; ++i) {
                    if (this.locals[i]) continue;
                    this.firstFreeLocal = (short)i;
                    if (this.localsMax < this.firstFreeLocal) {
                        this.localsMax = this.firstFreeLocal;
                    }
                    return s;
                }
            } else {
                return s;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short getNewWordLocal(boolean bl) {
        short s = this.getConsecutiveSlots(1, bl);
        if (s < 255) {
            this.locals[s] = true;
            if (bl) {
                this.locals[s + 1] = true;
            }
            if (s == this.firstFreeLocal) {
                for (int i = this.firstFreeLocal + 1; i < 256; ++i) {
                    if (this.locals[i]) continue;
                    this.firstFreeLocal = (short)i;
                    if (this.localsMax < this.firstFreeLocal) {
                        this.localsMax = this.firstFreeLocal;
                    }
                    return s;
                }
            } else {
                return s;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short getNewWordLocal() {
        short s = this.firstFreeLocal;
        this.locals[s] = true;
        for (int i = this.firstFreeLocal + 1; i < 256; ++i) {
            if (this.locals[i]) continue;
            this.firstFreeLocal = (short)i;
            if (this.localsMax < this.firstFreeLocal) {
                this.localsMax = this.firstFreeLocal;
            }
            return s;
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short getConsecutiveSlots(int n, boolean bl) {
        short s;
        if (bl) {
            ++n;
        }
        for (s = this.firstFreeLocal; s < 255; s = (short)(s + 1)) {
            int n2;
            for (n2 = 0; n2 < n && !this.locals[s + n2]; ++n2) {
            }
            if (n2 >= n) break;
        }
        return s;
    }

    private void releaseWordLocal(short s) {
        if (s < this.firstFreeLocal) {
            this.firstFreeLocal = s;
        }
        this.locals[s] = false;
    }
}

