/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.IDResolver;
import org.dom4j.IllegalAddException;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.AbstractBranch;
import org.dom4j.tree.DefaultDocument;

public abstract class AbstractDocument
extends AbstractBranch
implements Document {
    private IDResolver mResolver = null;

    public short getNodeType() {
        return 9;
    }

    public String getPath(Element context) {
        return "/";
    }

    public String getUniquePath(Element context) {
        return "/";
    }

    public Document getDocument() {
        return this;
    }

    public String getStringValue() {
        Element root = this.getRootElement();
        return root != null ? root.getStringValue() : "";
    }

    public String asXML() {
        try {
            StringWriter out = new StringWriter();
            XMLWriter writer = new XMLWriter(out, outputFormat);
            writer.write(this);
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Wierd IOException while generating textual representation: " + e.getMessage());
        }
    }

    public void write(Writer out) throws IOException {
        XMLWriter writer = new XMLWriter(out, outputFormat);
        writer.write(this);
    }

    public void accept(Visitor visitor) {
        List content;
        visitor.visit(this);
        DocumentType docType = this.getDocType();
        if (docType != null) {
            visitor.visit(docType);
        }
        if ((content = this.content()) != null) {
            for (Object object : content) {
                if (object instanceof String) {
                    Text text = this.getDocumentFactory().createText((String)object);
                    visitor.visit(text);
                    continue;
                }
                Node node = (Node)object;
                node.accept(visitor);
            }
        }
    }

    public String toString() {
        return super.toString() + " [Document: name " + this.getName() + "]";
    }

    public void normalize() {
        Element element = this.getRootElement();
        if (element != null) {
            element.normalize();
        }
    }

    public Document addComment(String comment) {
        Comment node = this.getDocumentFactory().createComment(comment);
        this.add(node);
        return this;
    }

    public Document addProcessingInstruction(String target, String data) {
        ProcessingInstruction node = this.getDocumentFactory().createProcessingInstruction(target, data);
        this.add(node);
        return this;
    }

    public Document addProcessingInstruction(String target, Map data) {
        ProcessingInstruction node = this.getDocumentFactory().createProcessingInstruction(target, data);
        this.add(node);
        return this;
    }

    public Element addElement(String name) {
        this.checkAddElementAllowed();
        Element node = super.addElement(name);
        this.rootElementAdded(node);
        return node;
    }

    public Element addElement(String qualifiedName, String namespaceURI) {
        this.checkAddElementAllowed();
        Element node = super.addElement(qualifiedName, namespaceURI);
        this.rootElementAdded(node);
        return node;
    }

    public Element addElement(QName qName) {
        this.checkAddElementAllowed();
        Element node = super.addElement(qName);
        this.rootElementAdded(node);
        return node;
    }

    public void setRootElement(Element rootElement) {
        this.clearContent();
        if (rootElement != null) {
            super.add(rootElement);
            this.rootElementAdded(rootElement);
        }
    }

    public void add(Element element) {
        this.checkAddElementAllowed();
        super.add(element);
        this.rootElementAdded(element);
    }

    public boolean remove(Element element) {
        boolean answer = super.remove(element);
        Element root = this.getRootElement();
        if (root != null && answer) {
            this.setRootElement(null);
        }
        element.setDocument(null);
        return answer;
    }

    public Node asXPathResult(Element parent) {
        return this;
    }

    public void setIDResolver(IDResolver resolver) {
        this.mResolver = resolver;
    }

    public IDResolver getIDResolver() {
        return this.mResolver;
    }

    protected void childAdded(Node node) {
        if (node != null) {
            node.setDocument(this);
            if (node instanceof Element) {
                Document doc;
                String value;
                Element element = (Element)node;
                IDResolver resolver = this.getIDResolver();
                if (resolver != null && (value = resolver.getIdValue(element)) != null && value.length() > 0 && (doc = this.getDocument()) instanceof DefaultDocument) {
                    DefaultDocument abstractDoc = (DefaultDocument)doc;
                    abstractDoc.addIDtoTable(value, element);
                }
            }
        }
    }

    protected void childRemoved(Node node) {
        if (node != null) {
            if (node instanceof Element) {
                String value;
                DefaultDocument parentDoc = (DefaultDocument)this.getDocument();
                Element element = (Element)node;
                IDResolver resolver = this.getIDResolver();
                if (resolver != null && (value = resolver.getIdValue(element)) != null && value.length() > 0) {
                    parentDoc.removeIDFromTable(value);
                }
            }
            node.setDocument(null);
        }
    }

    protected void checkAddElementAllowed() {
        Element root = this.getRootElement();
        if (root != null) {
            throw new IllegalAddException(this, (Node)root, "Cannot add another element to this Document as it already has  a root element of: " + root.getQualifiedName());
        }
    }

    protected abstract void rootElementAdded(Element var1);
}

