/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.dom;

import java.util.ArrayList;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.dom.DOMElement;
import org.dom4j.dom.DOMNodeHelper;
import org.dom4j.tree.DefaultDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMDocument
extends DefaultDocument
implements Document {
    private static final DOMDocumentFactory DOCUMENT_FACTORY = (DOMDocumentFactory)DOMDocumentFactory.getInstance();

    public DOMDocument() {
        this.init();
    }

    public DOMDocument(String name) {
        super(name);
        this.init();
    }

    public DOMDocument(DOMElement rootElement) {
        super(rootElement);
        this.init();
    }

    public DOMDocument(DOMDocumentType docType) {
        super(docType);
        this.init();
    }

    public DOMDocument(DOMElement rootElement, DOMDocumentType docType) {
        super(rootElement, docType);
        this.init();
    }

    public DOMDocument(String name, DOMElement rootElement, DOMDocumentType docType) {
        super(name, rootElement, docType);
        this.init();
    }

    private void init() {
        this.setDocumentFactory(DOCUMENT_FACTORY);
    }

    public boolean supports(String feature, String version) {
        return DOMNodeHelper.supports(this, feature, version);
    }

    public String getNamespaceURI() {
        return DOMNodeHelper.getNamespaceURI(this);
    }

    public String getPrefix() {
        return DOMNodeHelper.getPrefix(this);
    }

    public void setPrefix(String prefix) throws DOMException {
        DOMNodeHelper.setPrefix(this, prefix);
    }

    public String getLocalName() {
        return DOMNodeHelper.getLocalName(this);
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeValue() throws DOMException {
        return DOMNodeHelper.getNodeValue(this);
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        DOMNodeHelper.setNodeValue(this, nodeValue);
    }

    public Node getParentNode() {
        return DOMNodeHelper.getParentNode(this);
    }

    public NodeList getChildNodes() {
        return DOMNodeHelper.createNodeList(this.content());
    }

    public Node getFirstChild() {
        return DOMNodeHelper.asDOMNode(this.node(0));
    }

    public Node getLastChild() {
        return DOMNodeHelper.asDOMNode(this.node(this.nodeCount() - 1));
    }

    public Node getPreviousSibling() {
        return DOMNodeHelper.getPreviousSibling(this);
    }

    public Node getNextSibling() {
        return DOMNodeHelper.getNextSibling(this);
    }

    public NamedNodeMap getAttributes() {
        return DOMNodeHelper.getAttributes(this);
    }

    public Document getOwnerDocument() {
        return DOMNodeHelper.getOwnerDocument(this);
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return DOMNodeHelper.insertBefore(this, newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return DOMNodeHelper.replaceChild(this, newChild, oldChild);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return DOMNodeHelper.removeChild(this, oldChild);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return DOMNodeHelper.appendChild(this, newChild);
    }

    public boolean hasChildNodes() {
        return this.nodeCount() > 0;
    }

    public Node cloneNode(boolean deep) {
        return DOMNodeHelper.cloneNode(this, deep);
    }

    public boolean isSupported(String feature, String version) {
        return DOMNodeHelper.isSupported(this, feature, version);
    }

    public boolean hasAttributes() {
        return DOMNodeHelper.hasAttributes(this);
    }

    public NodeList getElementsByTagName(String name) {
        ArrayList list = new ArrayList();
        DOMNodeHelper.appendElementsByTagName(list, this, name);
        return DOMNodeHelper.createNodeList(list);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        ArrayList list = new ArrayList();
        DOMNodeHelper.appendElementsByTagNameNS(list, this, namespaceURI, localName);
        return DOMNodeHelper.createNodeList(list);
    }

    public DocumentType getDoctype() {
        return DOMNodeHelper.asDOMDocumentType(this.getDocType());
    }

    public DOMImplementation getImplementation() {
        if (this.getDocumentFactory() instanceof DOMImplementation) {
            return (DOMImplementation)((Object)this.getDocumentFactory());
        }
        return DOCUMENT_FACTORY;
    }

    public org.w3c.dom.Element getDocumentElement() {
        return DOMNodeHelper.asDOMElement(this.getRootElement());
    }

    public org.w3c.dom.Element createElement(String tagName) throws DOMException {
        return (org.w3c.dom.Element)((Object)this.getDocumentFactory().createElement(tagName));
    }

    public DocumentFragment createDocumentFragment() {
        DOMNodeHelper.notSupported();
        return null;
    }

    public Text createTextNode(String data) {
        return (Text)((Object)this.getDocumentFactory().createText(data));
    }

    public Comment createComment(String data) {
        return (Comment)((Object)this.getDocumentFactory().createComment(data));
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return (CDATASection)((Object)this.getDocumentFactory().createCDATA(data));
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return (ProcessingInstruction)((Object)this.getDocumentFactory().createProcessingInstruction(target, data));
    }

    public Attr createAttribute(String name) throws DOMException {
        QName qname = this.getDocumentFactory().createQName(name);
        return (Attr)((Object)this.getDocumentFactory().createAttribute(null, qname, null));
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return (EntityReference)((Object)((DOMDocumentFactory)this.getDocumentFactory()).createEntity(name));
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        DOMNodeHelper.notSupported();
        return null;
    }

    public org.w3c.dom.Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        QName qname = this.getDocumentFactory().createQName(qualifiedName, namespaceURI);
        return (org.w3c.dom.Element)((Object)this.getDocumentFactory().createElement(qname));
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        QName qname = this.getDocumentFactory().createQName(qualifiedName, namespaceURI);
        return (Attr)((Object)this.getDocumentFactory().createAttribute(null, qname, null));
    }

    public org.w3c.dom.Element getElementById(String elementId) {
        org.w3c.dom.Element retVal = null;
        Element result = this.elementByID(elementId);
        if (result instanceof org.w3c.dom.Element) {
            retVal = (org.w3c.dom.Element)((Object)result);
        }
        return retVal;
    }

    protected DocumentFactory getDocumentFactory() {
        if (super.getDocumentFactory() == null) {
            return DOCUMENT_FACTORY;
        }
        return super.getDocumentFactory();
    }
}

